<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ShowByEvents StructType
 * @subpackage Structs
 */
class Ticketing_ShowByEvents extends Ticketing_Show
{
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Event
     */
    public $Events;
    /**
     * The EventsCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventsCount;
    /**
     * The EventsFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsFrom;
    /**
     * The EventsFromFormattedDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsFromFormattedDate;
    /**
     * The EventsUntil
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsUntil;
    /**
     * The EventsUntilFormattedDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsUntilFormattedDate;
    /**
     * The FirstEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_FirstEvent
     */
    public $FirstEvent;
    /**
     * The SeriesRelatedEventKind
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesRelatedEventKind;
    /**
     * The SingleEventRepresentation
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SingleEventRepresentation;
    /**
     * Constructor method for Ticketing.ShowByEvents
     * @uses Ticketing_ShowByEvents::setEvents()
     * @uses Ticketing_ShowByEvents::setEventsCount()
     * @uses Ticketing_ShowByEvents::setEventsFrom()
     * @uses Ticketing_ShowByEvents::setEventsFromFormattedDate()
     * @uses Ticketing_ShowByEvents::setEventsUntil()
     * @uses Ticketing_ShowByEvents::setEventsUntilFormattedDate()
     * @uses Ticketing_ShowByEvents::setFirstEvent()
     * @uses Ticketing_ShowByEvents::setSeriesRelatedEventKind()
     * @uses Ticketing_ShowByEvents::setSingleEventRepresentation()
     * @param \patest\StructType\RecordSetOfTicketing_Event $events
     * @param int $eventsCount
     * @param string $eventsFrom
     * @param string $eventsFromFormattedDate
     * @param string $eventsUntil
     * @param string $eventsUntilFormattedDate
     * @param \patest\StructType\Ticketing_FirstEvent $firstEvent
     * @param string $seriesRelatedEventKind
     * @param string $singleEventRepresentation
     */
    public function __construct(\patest\StructType\RecordSetOfTicketing_Event $events = null, $eventsCount = null, $eventsFrom = null, $eventsFromFormattedDate = null, $eventsUntil = null, $eventsUntilFormattedDate = null, \patest\StructType\Ticketing_FirstEvent $firstEvent = null, $seriesRelatedEventKind = null, $singleEventRepresentation = null)
    {
        $this
            ->setEvents($events)
            ->setEventsCount($eventsCount)
            ->setEventsFrom($eventsFrom)
            ->setEventsFromFormattedDate($eventsFromFormattedDate)
            ->setEventsUntil($eventsUntil)
            ->setEventsUntilFormattedDate($eventsUntilFormattedDate)
            ->setFirstEvent($firstEvent)
            ->setSeriesRelatedEventKind($seriesRelatedEventKind)
            ->setSingleEventRepresentation($singleEventRepresentation);
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Event|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Event $events
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setEvents(\patest\StructType\RecordSetOfTicketing_Event $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get EventsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventsCount()
    {
        return isset($this->EventsCount) ? $this->EventsCount : null;
    }
    /**
     * Set EventsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventsCount
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setEventsCount($eventsCount = null)
    {
        // validation for constraint: int
        if (!is_null($eventsCount) && !(is_int($eventsCount) || ctype_digit($eventsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventsCount, true), gettype($eventsCount)), __LINE__);
        }
        if (is_null($eventsCount) || (is_array($eventsCount) && empty($eventsCount))) {
            unset($this->EventsCount);
        } else {
            $this->EventsCount = $eventsCount;
        }
        return $this;
    }
    /**
     * Get EventsFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsFrom()
    {
        return isset($this->EventsFrom) ? $this->EventsFrom : null;
    }
    /**
     * Set EventsFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsFrom
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setEventsFrom($eventsFrom = null)
    {
        // validation for constraint: string
        if (!is_null($eventsFrom) && !is_string($eventsFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsFrom, true), gettype($eventsFrom)), __LINE__);
        }
        if (is_null($eventsFrom) || (is_array($eventsFrom) && empty($eventsFrom))) {
            unset($this->EventsFrom);
        } else {
            $this->EventsFrom = $eventsFrom;
        }
        return $this;
    }
    /**
     * Get EventsFromFormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsFromFormattedDate()
    {
        return isset($this->EventsFromFormattedDate) ? $this->EventsFromFormattedDate : null;
    }
    /**
     * Set EventsFromFormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsFromFormattedDate
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setEventsFromFormattedDate($eventsFromFormattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventsFromFormattedDate) && !is_string($eventsFromFormattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsFromFormattedDate, true), gettype($eventsFromFormattedDate)), __LINE__);
        }
        if (is_null($eventsFromFormattedDate) || (is_array($eventsFromFormattedDate) && empty($eventsFromFormattedDate))) {
            unset($this->EventsFromFormattedDate);
        } else {
            $this->EventsFromFormattedDate = $eventsFromFormattedDate;
        }
        return $this;
    }
    /**
     * Get EventsUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsUntil()
    {
        return isset($this->EventsUntil) ? $this->EventsUntil : null;
    }
    /**
     * Set EventsUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsUntil
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setEventsUntil($eventsUntil = null)
    {
        // validation for constraint: string
        if (!is_null($eventsUntil) && !is_string($eventsUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsUntil, true), gettype($eventsUntil)), __LINE__);
        }
        if (is_null($eventsUntil) || (is_array($eventsUntil) && empty($eventsUntil))) {
            unset($this->EventsUntil);
        } else {
            $this->EventsUntil = $eventsUntil;
        }
        return $this;
    }
    /**
     * Get EventsUntilFormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsUntilFormattedDate()
    {
        return isset($this->EventsUntilFormattedDate) ? $this->EventsUntilFormattedDate : null;
    }
    /**
     * Set EventsUntilFormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsUntilFormattedDate
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setEventsUntilFormattedDate($eventsUntilFormattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventsUntilFormattedDate) && !is_string($eventsUntilFormattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsUntilFormattedDate, true), gettype($eventsUntilFormattedDate)), __LINE__);
        }
        if (is_null($eventsUntilFormattedDate) || (is_array($eventsUntilFormattedDate) && empty($eventsUntilFormattedDate))) {
            unset($this->EventsUntilFormattedDate);
        } else {
            $this->EventsUntilFormattedDate = $eventsUntilFormattedDate;
        }
        return $this;
    }
    /**
     * Get FirstEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_FirstEvent|null
     */
    public function getFirstEvent()
    {
        return isset($this->FirstEvent) ? $this->FirstEvent : null;
    }
    /**
     * Set FirstEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_FirstEvent $firstEvent
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setFirstEvent(\patest\StructType\Ticketing_FirstEvent $firstEvent = null)
    {
        if (is_null($firstEvent) || (is_array($firstEvent) && empty($firstEvent))) {
            unset($this->FirstEvent);
        } else {
            $this->FirstEvent = $firstEvent;
        }
        return $this;
    }
    /**
     * Get SeriesRelatedEventKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesRelatedEventKind()
    {
        return isset($this->SeriesRelatedEventKind) ? $this->SeriesRelatedEventKind : null;
    }
    /**
     * Set SeriesRelatedEventKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesRelatedEventKind::valueIsValid()
     * @uses \patest\EnumType\SeriesRelatedEventKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seriesRelatedEventKind
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setSeriesRelatedEventKind($seriesRelatedEventKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesRelatedEventKind::valueIsValid($seriesRelatedEventKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesRelatedEventKind', is_array($seriesRelatedEventKind) ? implode(', ', $seriesRelatedEventKind) : var_export($seriesRelatedEventKind, true), implode(', ', \patest\EnumType\SeriesRelatedEventKind::getValidValues())), __LINE__);
        }
        if (is_null($seriesRelatedEventKind) || (is_array($seriesRelatedEventKind) && empty($seriesRelatedEventKind))) {
            unset($this->SeriesRelatedEventKind);
        } else {
            $this->SeriesRelatedEventKind = $seriesRelatedEventKind;
        }
        return $this;
    }
    /**
     * Get SingleEventRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSingleEventRepresentation()
    {
        return isset($this->SingleEventRepresentation) ? $this->SingleEventRepresentation : null;
    }
    /**
     * Set SingleEventRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $singleEventRepresentation
     * @return \patest\StructType\Ticketing_ShowByEvents
     */
    public function setSingleEventRepresentation($singleEventRepresentation = null)
    {
        // validation for constraint: string
        if (!is_null($singleEventRepresentation) && !is_string($singleEventRepresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($singleEventRepresentation, true), gettype($singleEventRepresentation)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($singleEventRepresentation) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $singleEventRepresentation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($singleEventRepresentation, true)), __LINE__);
        }
        if (is_null($singleEventRepresentation) || (is_array($singleEventRepresentation) && empty($singleEventRepresentation))) {
            unset($this->SingleEventRepresentation);
        } else {
            $this->SingleEventRepresentation = $singleEventRepresentation;
        }
        return $this;
    }
}
