<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Series StructType
 * @subpackage Structs
 */
class Ticketing_Series extends Ticketing_Base
{
    /**
     * The AccessControlData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_EntityAccessControlData
     */
    public $AccessControlData;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AgeCalculationMethodForRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgeCalculationMethodForRenew;
    /**
     * The AllowedBookingRequestTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllowedBookingRequestTypes
     */
    public $AllowedBookingRequestTypes;
    /**
     * The AreasIdsToExcludeOnInternet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreasIdsToExcludeOnInternet
     */
    public $AreasIdsToExcludeOnInternet;
    /**
     * The Buckets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BucketInSeries
     */
    public $Buckets;
    /**
     * The CanAutoRenew
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanAutoRenew;
    /**
     * The CanUserSelectEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanUserSelectEvents;
    /**
     * The ContinuationSubscriptionPrintingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContinuationSubscriptionPrintingPolicy;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The DefaultSeatgeekAllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSeatgeekAllocationTypeId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DurationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DurationType;
    /**
     * The EffectiveEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveEndDate;
    /**
     * The EffectiveStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveStartDate;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExtendTillEndOfMonthStartingFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ExtendTillEndOfMonthStartingFrom;
    /**
     * The HallHasConstructionProblems
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HallHasConstructionProblems;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The HallVersionStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallVersionStatus;
    /**
     * The HasSubseries
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasSubseries;
    /**
     * The HoldSeatsForRenewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HoldSeatsForRenewStatus;
    /**
     * The HospitalityInRegularSaleApplicationChannels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HospitalityInRegularSaleApplicationChannels;
    /**
     * The HospitalityMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Subscription_Media
     */
    public $HospitalityMedia;
    /**
     * The InheritAllowedBookingRequestsOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InheritAllowedBookingRequestsOptions;
    /**
     * The IsAccessCardNotDedicated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccessCardNotDedicated;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsAllocatedSeatsAssignedByDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllocatedSeatsAssignedByDefault;
    /**
     * The IsAllowedTicketExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllowedTicketExchanges;
    /**
     * The IsAssignAllEventsOnSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAssignAllEventsOnSale;
    /**
     * The IsHospitalityAvailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHospitalityAvailable;
    /**
     * The IsHospitalityPromptRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHospitalityPromptRequired;
    /**
     * The IsLeagueReportable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLeagueReportable;
    /**
     * The IsOnlyAllowSalesInAllocatedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOnlyAllowSalesInAllocatedSeats;
    /**
     * The IsPartialEventBased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartialEventBased;
    /**
     * The IsPrepaiedWaitingListAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrepaiedWaitingListAllowed;
    /**
     * The IsPriceLevelEnforcedOnEventTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPriceLevelEnforcedOnEventTickets;
    /**
     * The IsPricingPerSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPricingPerSeries;
    /**
     * The IsPTTAForForSeriesEnabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPTTAForForSeriesEnabled;
    /**
     * The IsSellOnlyAsPartOfGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSellOnlyAsPartOfGroup;
    /**
     * The IsSeriesAllocated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSeriesAllocated;
    /**
     * The IsSinglePerClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSinglePerClient;
    /**
     * The IsTransferBonusBalanceOnRenewal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTransferBonusBalanceOnRenewal;
    /**
     * The IsTransferTicketBalanceOnRenewal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTransferTicketBalanceOnRenewal;
    /**
     * The IsWaitingListAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsWaitingListAllowed;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The MasterHospitalitySeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterHospitalitySeriesId;
    /**
     * The MasterSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MasterSeriesId;
    /**
     * The MaxAllowedFullStackExchanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAllowedFullStackExchanges;
    /**
     * The MaxNumberOfTicketsPerShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberOfTicketsPerShow;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Subscription_Media
     */
    public $Media;
    /**
     * The MinQuantityOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinQuantityOfEvents;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NumberOfBonusEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfBonusEvents;
    /**
     * The OnlineMoveAllowedUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineMoveAllowedUntil;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OrganizerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizerId;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The PeriodDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PeriodDescription;
    /**
     * The PeriodType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:SubscriptionPeriodCalculation
     * @var string
     */
    public $PeriodType;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The QuantityOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantityOfEvents;
    /**
     * The RelatedPriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SeriesPriceLevelRelation
     */
    public $RelatedPriceLevels;
    /**
     * The RelatedPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_SeriesPriceTypeRelation
     */
    public $RelatedPriceTypes;
    /**
     * The RelatedSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedSeriesId;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * The Seasonality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seasonality;
    /**
     * The SeasonHoldPolicy
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeasonHoldPolicy;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SellOnlyAsPartOfPrompt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SellOnlyAsPartOfPrompt;
    /**
     * The SendToApp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendToApp;
    /**
     * The ShowTimeGenerateNfcPass
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowTimeGenerateNfcPass;
    /**
     * The SpecificAgeCalculationReferenceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecificAgeCalculationReferenceDate;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The SubscriptionPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubscriptionPeriod;
    /**
     * The SubscriptionPrintingPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionPrintingPolicy;
    /**
     * The SubseriesCouldShareSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SubseriesCouldShareSeats;
    /**
     * The TicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketType;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * The WarningsText
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WarningsText;
    /**
     * Constructor method for Ticketing.Series
     * @uses Ticketing_Series::setAccessControlData()
     * @uses Ticketing_Series::setAclSchemeId()
     * @uses Ticketing_Series::setAgeCalculationMethodForRenew()
     * @uses Ticketing_Series::setAllowedBookingRequestTypes()
     * @uses Ticketing_Series::setAreasIdsToExcludeOnInternet()
     * @uses Ticketing_Series::setBuckets()
     * @uses Ticketing_Series::setCanAutoRenew()
     * @uses Ticketing_Series::setCanUserSelectEvents()
     * @uses Ticketing_Series::setContinuationSubscriptionPrintingPolicy()
     * @uses Ticketing_Series::setCreationDate()
     * @uses Ticketing_Series::setCrossOrgUnitsAclSchemeId()
     * @uses Ticketing_Series::setDefaultSeatgeekAllocationTypeId()
     * @uses Ticketing_Series::setDescription()
     * @uses Ticketing_Series::setDurationType()
     * @uses Ticketing_Series::setEffectiveEndDate()
     * @uses Ticketing_Series::setEffectiveStartDate()
     * @uses Ticketing_Series::setEndDate()
     * @uses Ticketing_Series::setExtendTillEndOfMonthStartingFrom()
     * @uses Ticketing_Series::setHallHasConstructionProblems()
     * @uses Ticketing_Series::setHallId()
     * @uses Ticketing_Series::setHallVersionId()
     * @uses Ticketing_Series::setHallVersionStatus()
     * @uses Ticketing_Series::setHasSubseries()
     * @uses Ticketing_Series::setHoldSeatsForRenewStatus()
     * @uses Ticketing_Series::setHospitalityInRegularSaleApplicationChannels()
     * @uses Ticketing_Series::setHospitalityMedia()
     * @uses Ticketing_Series::setInheritAllowedBookingRequestsOptions()
     * @uses Ticketing_Series::setIsAccessCardNotDedicated()
     * @uses Ticketing_Series::setIsActive()
     * @uses Ticketing_Series::setIsAllocatedSeatsAssignedByDefault()
     * @uses Ticketing_Series::setIsAllowedTicketExchanges()
     * @uses Ticketing_Series::setIsAssignAllEventsOnSale()
     * @uses Ticketing_Series::setIsHospitalityAvailable()
     * @uses Ticketing_Series::setIsHospitalityPromptRequired()
     * @uses Ticketing_Series::setIsLeagueReportable()
     * @uses Ticketing_Series::setIsOnlyAllowSalesInAllocatedSeats()
     * @uses Ticketing_Series::setIsPartialEventBased()
     * @uses Ticketing_Series::setIsPrepaiedWaitingListAllowed()
     * @uses Ticketing_Series::setIsPriceLevelEnforcedOnEventTickets()
     * @uses Ticketing_Series::setIsPricingPerSeries()
     * @uses Ticketing_Series::setIsPTTAForForSeriesEnabled()
     * @uses Ticketing_Series::setIsSellOnlyAsPartOfGroup()
     * @uses Ticketing_Series::setIsSeriesAllocated()
     * @uses Ticketing_Series::setIsSinglePerClient()
     * @uses Ticketing_Series::setIsTransferBonusBalanceOnRenewal()
     * @uses Ticketing_Series::setIsTransferTicketBalanceOnRenewal()
     * @uses Ticketing_Series::setIsWaitingListAllowed()
     * @uses Ticketing_Series::setLastUpdateDateTime()
     * @uses Ticketing_Series::setLedgerId()
     * @uses Ticketing_Series::setMasterHospitalitySeriesId()
     * @uses Ticketing_Series::setMasterSeriesId()
     * @uses Ticketing_Series::setMaxAllowedFullStackExchanges()
     * @uses Ticketing_Series::setMaxNumberOfTicketsPerShow()
     * @uses Ticketing_Series::setMedia()
     * @uses Ticketing_Series::setMinQuantityOfEvents()
     * @uses Ticketing_Series::setName()
     * @uses Ticketing_Series::setNumberOfBonusEvents()
     * @uses Ticketing_Series::setOnlineMoveAllowedUntil()
     * @uses Ticketing_Series::setOrganizationUnitId()
     * @uses Ticketing_Series::setOrganizerId()
     * @uses Ticketing_Series::setOwnerId()
     * @uses Ticketing_Series::setPeriodDescription()
     * @uses Ticketing_Series::setPeriodType()
     * @uses Ticketing_Series::setProjectIdentifierId()
     * @uses Ticketing_Series::setQuantityOfEvents()
     * @uses Ticketing_Series::setRelatedPriceLevels()
     * @uses Ticketing_Series::setRelatedPriceTypes()
     * @uses Ticketing_Series::setRelatedSeriesId()
     * @uses Ticketing_Series::setSchemeId()
     * @uses Ticketing_Series::setSeasonality()
     * @uses Ticketing_Series::setSeasonHoldPolicy()
     * @uses Ticketing_Series::setSeasonId()
     * @uses Ticketing_Series::setSellOnlyAsPartOfPrompt()
     * @uses Ticketing_Series::setSendToApp()
     * @uses Ticketing_Series::setShowTimeGenerateNfcPass()
     * @uses Ticketing_Series::setSpecificAgeCalculationReferenceDate()
     * @uses Ticketing_Series::setStartDate()
     * @uses Ticketing_Series::setSubscriptionPeriod()
     * @uses Ticketing_Series::setSubscriptionPrintingPolicy()
     * @uses Ticketing_Series::setSubseriesCouldShareSeats()
     * @uses Ticketing_Series::setTicketType()
     * @uses Ticketing_Series::setVisibleBySubordinates()
     * @uses Ticketing_Series::setWarningsText()
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @param int $aclSchemeId
     * @param string $ageCalculationMethodForRenew
     * @param \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes
     * @param \patest\StructType\AreasIdsToExcludeOnInternet $areasIdsToExcludeOnInternet
     * @param \patest\StructType\RecordSetOfTicketing_BucketInSeries $buckets
     * @param bool $canAutoRenew
     * @param bool $canUserSelectEvents
     * @param string $continuationSubscriptionPrintingPolicy
     * @param string $creationDate
     * @param int $crossOrgUnitsAclSchemeId
     * @param string $defaultSeatgeekAllocationTypeId
     * @param \patest\StructType\GlobalString $description
     * @param string $durationType
     * @param string $effectiveEndDate
     * @param string $effectiveStartDate
     * @param string $endDate
     * @param int $extendTillEndOfMonthStartingFrom
     * @param bool $hallHasConstructionProblems
     * @param string $hallId
     * @param string $hallVersionId
     * @param string $hallVersionStatus
     * @param bool $hasSubseries
     * @param string $holdSeatsForRenewStatus
     * @param string $hospitalityInRegularSaleApplicationChannels
     * @param \patest\StructType\Subscription_Media $hospitalityMedia
     * @param bool $inheritAllowedBookingRequestsOptions
     * @param bool $isAccessCardNotDedicated
     * @param bool $isActive
     * @param bool $isAllocatedSeatsAssignedByDefault
     * @param bool $isAllowedTicketExchanges
     * @param bool $isAssignAllEventsOnSale
     * @param bool $isHospitalityAvailable
     * @param bool $isHospitalityPromptRequired
     * @param bool $isLeagueReportable
     * @param bool $isOnlyAllowSalesInAllocatedSeats
     * @param bool $isPartialEventBased
     * @param bool $isPrepaiedWaitingListAllowed
     * @param bool $isPriceLevelEnforcedOnEventTickets
     * @param bool $isPricingPerSeries
     * @param bool $isPTTAForForSeriesEnabled
     * @param bool $isSellOnlyAsPartOfGroup
     * @param bool $isSeriesAllocated
     * @param bool $isSinglePerClient
     * @param bool $isTransferBonusBalanceOnRenewal
     * @param bool $isTransferTicketBalanceOnRenewal
     * @param bool $isWaitingListAllowed
     * @param string $lastUpdateDateTime
     * @param string $ledgerId
     * @param string $masterHospitalitySeriesId
     * @param string $masterSeriesId
     * @param int $maxAllowedFullStackExchanges
     * @param int $maxNumberOfTicketsPerShow
     * @param \patest\StructType\Subscription_Media $media
     * @param int $minQuantityOfEvents
     * @param \patest\StructType\GlobalString $name
     * @param int $numberOfBonusEvents
     * @param string $onlineMoveAllowedUntil
     * @param string $organizationUnitId
     * @param string $organizerId
     * @param string $ownerId
     * @param string $periodDescription
     * @param string $periodType
     * @param string $projectIdentifierId
     * @param int $quantityOfEvents
     * @param \patest\StructType\RecordSetOfTicketing_SeriesPriceLevelRelation $relatedPriceLevels
     * @param \patest\StructType\RecordSetOfTicketing_SeriesPriceTypeRelation $relatedPriceTypes
     * @param string $relatedSeriesId
     * @param string $schemeId
     * @param string $seasonality
     * @param string $seasonHoldPolicy
     * @param string $seasonId
     * @param bool $sellOnlyAsPartOfPrompt
     * @param bool $sendToApp
     * @param bool $showTimeGenerateNfcPass
     * @param string $specificAgeCalculationReferenceDate
     * @param string $startDate
     * @param int $subscriptionPeriod
     * @param string $subscriptionPrintingPolicy
     * @param bool $subseriesCouldShareSeats
     * @param string $ticketType
     * @param bool $visibleBySubordinates
     * @param string $warningsText
     */
    public function __construct(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null, $aclSchemeId = null, $ageCalculationMethodForRenew = null, \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes = null, \patest\StructType\AreasIdsToExcludeOnInternet $areasIdsToExcludeOnInternet = null, \patest\StructType\RecordSetOfTicketing_BucketInSeries $buckets = null, $canAutoRenew = null, $canUserSelectEvents = null, $continuationSubscriptionPrintingPolicy = null, $creationDate = null, $crossOrgUnitsAclSchemeId = null, $defaultSeatgeekAllocationTypeId = null, \patest\StructType\GlobalString $description = null, $durationType = null, $effectiveEndDate = null, $effectiveStartDate = null, $endDate = null, $extendTillEndOfMonthStartingFrom = null, $hallHasConstructionProblems = null, $hallId = null, $hallVersionId = null, $hallVersionStatus = null, $hasSubseries = null, $holdSeatsForRenewStatus = null, $hospitalityInRegularSaleApplicationChannels = null, \patest\StructType\Subscription_Media $hospitalityMedia = null, $inheritAllowedBookingRequestsOptions = null, $isAccessCardNotDedicated = null, $isActive = null, $isAllocatedSeatsAssignedByDefault = null, $isAllowedTicketExchanges = null, $isAssignAllEventsOnSale = null, $isHospitalityAvailable = null, $isHospitalityPromptRequired = null, $isLeagueReportable = null, $isOnlyAllowSalesInAllocatedSeats = null, $isPartialEventBased = null, $isPrepaiedWaitingListAllowed = null, $isPriceLevelEnforcedOnEventTickets = null, $isPricingPerSeries = null, $isPTTAForForSeriesEnabled = null, $isSellOnlyAsPartOfGroup = null, $isSeriesAllocated = null, $isSinglePerClient = null, $isTransferBonusBalanceOnRenewal = null, $isTransferTicketBalanceOnRenewal = null, $isWaitingListAllowed = null, $lastUpdateDateTime = null, $ledgerId = null, $masterHospitalitySeriesId = null, $masterSeriesId = null, $maxAllowedFullStackExchanges = null, $maxNumberOfTicketsPerShow = null, \patest\StructType\Subscription_Media $media = null, $minQuantityOfEvents = null, \patest\StructType\GlobalString $name = null, $numberOfBonusEvents = null, $onlineMoveAllowedUntil = null, $organizationUnitId = null, $organizerId = null, $ownerId = null, $periodDescription = null, $periodType = null, $projectIdentifierId = null, $quantityOfEvents = null, \patest\StructType\RecordSetOfTicketing_SeriesPriceLevelRelation $relatedPriceLevels = null, \patest\StructType\RecordSetOfTicketing_SeriesPriceTypeRelation $relatedPriceTypes = null, $relatedSeriesId = null, $schemeId = null, $seasonality = null, $seasonHoldPolicy = null, $seasonId = null, $sellOnlyAsPartOfPrompt = null, $sendToApp = null, $showTimeGenerateNfcPass = null, $specificAgeCalculationReferenceDate = null, $startDate = null, $subscriptionPeriod = null, $subscriptionPrintingPolicy = null, $subseriesCouldShareSeats = null, $ticketType = null, $visibleBySubordinates = null, $warningsText = null)
    {
        $this
            ->setAccessControlData($accessControlData)
            ->setAclSchemeId($aclSchemeId)
            ->setAgeCalculationMethodForRenew($ageCalculationMethodForRenew)
            ->setAllowedBookingRequestTypes($allowedBookingRequestTypes)
            ->setAreasIdsToExcludeOnInternet($areasIdsToExcludeOnInternet)
            ->setBuckets($buckets)
            ->setCanAutoRenew($canAutoRenew)
            ->setCanUserSelectEvents($canUserSelectEvents)
            ->setContinuationSubscriptionPrintingPolicy($continuationSubscriptionPrintingPolicy)
            ->setCreationDate($creationDate)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setDefaultSeatgeekAllocationTypeId($defaultSeatgeekAllocationTypeId)
            ->setDescription($description)
            ->setDurationType($durationType)
            ->setEffectiveEndDate($effectiveEndDate)
            ->setEffectiveStartDate($effectiveStartDate)
            ->setEndDate($endDate)
            ->setExtendTillEndOfMonthStartingFrom($extendTillEndOfMonthStartingFrom)
            ->setHallHasConstructionProblems($hallHasConstructionProblems)
            ->setHallId($hallId)
            ->setHallVersionId($hallVersionId)
            ->setHallVersionStatus($hallVersionStatus)
            ->setHasSubseries($hasSubseries)
            ->setHoldSeatsForRenewStatus($holdSeatsForRenewStatus)
            ->setHospitalityInRegularSaleApplicationChannels($hospitalityInRegularSaleApplicationChannels)
            ->setHospitalityMedia($hospitalityMedia)
            ->setInheritAllowedBookingRequestsOptions($inheritAllowedBookingRequestsOptions)
            ->setIsAccessCardNotDedicated($isAccessCardNotDedicated)
            ->setIsActive($isActive)
            ->setIsAllocatedSeatsAssignedByDefault($isAllocatedSeatsAssignedByDefault)
            ->setIsAllowedTicketExchanges($isAllowedTicketExchanges)
            ->setIsAssignAllEventsOnSale($isAssignAllEventsOnSale)
            ->setIsHospitalityAvailable($isHospitalityAvailable)
            ->setIsHospitalityPromptRequired($isHospitalityPromptRequired)
            ->setIsLeagueReportable($isLeagueReportable)
            ->setIsOnlyAllowSalesInAllocatedSeats($isOnlyAllowSalesInAllocatedSeats)
            ->setIsPartialEventBased($isPartialEventBased)
            ->setIsPrepaiedWaitingListAllowed($isPrepaiedWaitingListAllowed)
            ->setIsPriceLevelEnforcedOnEventTickets($isPriceLevelEnforcedOnEventTickets)
            ->setIsPricingPerSeries($isPricingPerSeries)
            ->setIsPTTAForForSeriesEnabled($isPTTAForForSeriesEnabled)
            ->setIsSellOnlyAsPartOfGroup($isSellOnlyAsPartOfGroup)
            ->setIsSeriesAllocated($isSeriesAllocated)
            ->setIsSinglePerClient($isSinglePerClient)
            ->setIsTransferBonusBalanceOnRenewal($isTransferBonusBalanceOnRenewal)
            ->setIsTransferTicketBalanceOnRenewal($isTransferTicketBalanceOnRenewal)
            ->setIsWaitingListAllowed($isWaitingListAllowed)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setLedgerId($ledgerId)
            ->setMasterHospitalitySeriesId($masterHospitalitySeriesId)
            ->setMasterSeriesId($masterSeriesId)
            ->setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges)
            ->setMaxNumberOfTicketsPerShow($maxNumberOfTicketsPerShow)
            ->setMedia($media)
            ->setMinQuantityOfEvents($minQuantityOfEvents)
            ->setName($name)
            ->setNumberOfBonusEvents($numberOfBonusEvents)
            ->setOnlineMoveAllowedUntil($onlineMoveAllowedUntil)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOrganizerId($organizerId)
            ->setOwnerId($ownerId)
            ->setPeriodDescription($periodDescription)
            ->setPeriodType($periodType)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setQuantityOfEvents($quantityOfEvents)
            ->setRelatedPriceLevels($relatedPriceLevels)
            ->setRelatedPriceTypes($relatedPriceTypes)
            ->setRelatedSeriesId($relatedSeriesId)
            ->setSchemeId($schemeId)
            ->setSeasonality($seasonality)
            ->setSeasonHoldPolicy($seasonHoldPolicy)
            ->setSeasonId($seasonId)
            ->setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt)
            ->setSendToApp($sendToApp)
            ->setShowTimeGenerateNfcPass($showTimeGenerateNfcPass)
            ->setSpecificAgeCalculationReferenceDate($specificAgeCalculationReferenceDate)
            ->setStartDate($startDate)
            ->setSubscriptionPeriod($subscriptionPeriod)
            ->setSubscriptionPrintingPolicy($subscriptionPrintingPolicy)
            ->setSubseriesCouldShareSeats($subseriesCouldShareSeats)
            ->setTicketType($ticketType)
            ->setVisibleBySubordinates($visibleBySubordinates)
            ->setWarningsText($warningsText);
    }
    /**
     * Get AccessControlData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_EntityAccessControlData|null
     */
    public function getAccessControlData()
    {
        return isset($this->AccessControlData) ? $this->AccessControlData : null;
    }
    /**
     * Set AccessControlData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccessControl_EntityAccessControlData $accessControlData
     * @return \patest\StructType\Ticketing_Series
     */
    public function setAccessControlData(\patest\StructType\AccessControl_EntityAccessControlData $accessControlData = null)
    {
        if (is_null($accessControlData) || (is_array($accessControlData) && empty($accessControlData))) {
            unset($this->AccessControlData);
        } else {
            $this->AccessControlData = $accessControlData;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AgeCalculationMethodForRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgeCalculationMethodForRenew()
    {
        return isset($this->AgeCalculationMethodForRenew) ? $this->AgeCalculationMethodForRenew : null;
    }
    /**
     * Set AgeCalculationMethodForRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AgeCalculationMethod::valueIsValid()
     * @uses \patest\EnumType\AgeCalculationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageCalculationMethodForRenew
     * @return \patest\StructType\Ticketing_Series
     */
    public function setAgeCalculationMethodForRenew($ageCalculationMethodForRenew = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AgeCalculationMethod::valueIsValid($ageCalculationMethodForRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AgeCalculationMethod', is_array($ageCalculationMethodForRenew) ? implode(', ', $ageCalculationMethodForRenew) : var_export($ageCalculationMethodForRenew, true), implode(', ', \patest\EnumType\AgeCalculationMethod::getValidValues())), __LINE__);
        }
        if (is_null($ageCalculationMethodForRenew) || (is_array($ageCalculationMethodForRenew) && empty($ageCalculationMethodForRenew))) {
            unset($this->AgeCalculationMethodForRenew);
        } else {
            $this->AgeCalculationMethodForRenew = $ageCalculationMethodForRenew;
        }
        return $this;
    }
    /**
     * Get AllowedBookingRequestTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllowedBookingRequestTypes|null
     */
    public function getAllowedBookingRequestTypes()
    {
        return isset($this->AllowedBookingRequestTypes) ? $this->AllowedBookingRequestTypes : null;
    }
    /**
     * Set AllowedBookingRequestTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes
     * @return \patest\StructType\Ticketing_Series
     */
    public function setAllowedBookingRequestTypes(\patest\StructType\AllowedBookingRequestTypes $allowedBookingRequestTypes = null)
    {
        if (is_null($allowedBookingRequestTypes) || (is_array($allowedBookingRequestTypes) && empty($allowedBookingRequestTypes))) {
            unset($this->AllowedBookingRequestTypes);
        } else {
            $this->AllowedBookingRequestTypes = $allowedBookingRequestTypes;
        }
        return $this;
    }
    /**
     * Get AreasIdsToExcludeOnInternet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreasIdsToExcludeOnInternet|null
     */
    public function getAreasIdsToExcludeOnInternet()
    {
        return isset($this->AreasIdsToExcludeOnInternet) ? $this->AreasIdsToExcludeOnInternet : null;
    }
    /**
     * Set AreasIdsToExcludeOnInternet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreasIdsToExcludeOnInternet $areasIdsToExcludeOnInternet
     * @return \patest\StructType\Ticketing_Series
     */
    public function setAreasIdsToExcludeOnInternet(\patest\StructType\AreasIdsToExcludeOnInternet $areasIdsToExcludeOnInternet = null)
    {
        if (is_null($areasIdsToExcludeOnInternet) || (is_array($areasIdsToExcludeOnInternet) && empty($areasIdsToExcludeOnInternet))) {
            unset($this->AreasIdsToExcludeOnInternet);
        } else {
            $this->AreasIdsToExcludeOnInternet = $areasIdsToExcludeOnInternet;
        }
        return $this;
    }
    /**
     * Get Buckets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BucketInSeries|null
     */
    public function getBuckets()
    {
        return isset($this->Buckets) ? $this->Buckets : null;
    }
    /**
     * Set Buckets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BucketInSeries $buckets
     * @return \patest\StructType\Ticketing_Series
     */
    public function setBuckets(\patest\StructType\RecordSetOfTicketing_BucketInSeries $buckets = null)
    {
        if (is_null($buckets) || (is_array($buckets) && empty($buckets))) {
            unset($this->Buckets);
        } else {
            $this->Buckets = $buckets;
        }
        return $this;
    }
    /**
     * Get CanAutoRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanAutoRenew()
    {
        return isset($this->CanAutoRenew) ? $this->CanAutoRenew : null;
    }
    /**
     * Set CanAutoRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canAutoRenew
     * @return \patest\StructType\Ticketing_Series
     */
    public function setCanAutoRenew($canAutoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAutoRenew) && !is_bool($canAutoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAutoRenew, true), gettype($canAutoRenew)), __LINE__);
        }
        if (is_null($canAutoRenew) || (is_array($canAutoRenew) && empty($canAutoRenew))) {
            unset($this->CanAutoRenew);
        } else {
            $this->CanAutoRenew = $canAutoRenew;
        }
        return $this;
    }
    /**
     * Get CanUserSelectEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanUserSelectEvents()
    {
        return isset($this->CanUserSelectEvents) ? $this->CanUserSelectEvents : null;
    }
    /**
     * Set CanUserSelectEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canUserSelectEvents
     * @return \patest\StructType\Ticketing_Series
     */
    public function setCanUserSelectEvents($canUserSelectEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($canUserSelectEvents) && !is_bool($canUserSelectEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canUserSelectEvents, true), gettype($canUserSelectEvents)), __LINE__);
        }
        if (is_null($canUserSelectEvents) || (is_array($canUserSelectEvents) && empty($canUserSelectEvents))) {
            unset($this->CanUserSelectEvents);
        } else {
            $this->CanUserSelectEvents = $canUserSelectEvents;
        }
        return $this;
    }
    /**
     * Get ContinuationSubscriptionPrintingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuationSubscriptionPrintingPolicy()
    {
        return isset($this->ContinuationSubscriptionPrintingPolicy) ? $this->ContinuationSubscriptionPrintingPolicy : null;
    }
    /**
     * Set ContinuationSubscriptionPrintingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionPrintingPolicy::valueIsValid()
     * @uses \patest\EnumType\SubscriptionPrintingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $continuationSubscriptionPrintingPolicy
     * @return \patest\StructType\Ticketing_Series
     */
    public function setContinuationSubscriptionPrintingPolicy($continuationSubscriptionPrintingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionPrintingPolicy::valueIsValid($continuationSubscriptionPrintingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionPrintingPolicy', is_array($continuationSubscriptionPrintingPolicy) ? implode(', ', $continuationSubscriptionPrintingPolicy) : var_export($continuationSubscriptionPrintingPolicy, true), implode(', ', \patest\EnumType\SubscriptionPrintingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($continuationSubscriptionPrintingPolicy) || (is_array($continuationSubscriptionPrintingPolicy) && empty($continuationSubscriptionPrintingPolicy))) {
            unset($this->ContinuationSubscriptionPrintingPolicy);
        } else {
            $this->ContinuationSubscriptionPrintingPolicy = $continuationSubscriptionPrintingPolicy;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Ticketing_Series
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get DefaultSeatgeekAllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSeatgeekAllocationTypeId()
    {
        return isset($this->DefaultSeatgeekAllocationTypeId) ? $this->DefaultSeatgeekAllocationTypeId : null;
    }
    /**
     * Set DefaultSeatgeekAllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSeatgeekAllocationTypeId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setDefaultSeatgeekAllocationTypeId($defaultSeatgeekAllocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSeatgeekAllocationTypeId) && !is_string($defaultSeatgeekAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSeatgeekAllocationTypeId, true), gettype($defaultSeatgeekAllocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSeatgeekAllocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSeatgeekAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSeatgeekAllocationTypeId, true)), __LINE__);
        }
        if (is_null($defaultSeatgeekAllocationTypeId) || (is_array($defaultSeatgeekAllocationTypeId) && empty($defaultSeatgeekAllocationTypeId))) {
            unset($this->DefaultSeatgeekAllocationTypeId);
        } else {
            $this->DefaultSeatgeekAllocationTypeId = $defaultSeatgeekAllocationTypeId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_Series
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DurationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDurationType()
    {
        return isset($this->DurationType) ? $this->DurationType : null;
    }
    /**
     * Set DurationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesDurationType::valueIsValid()
     * @uses \patest\EnumType\SeriesDurationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $durationType
     * @return \patest\StructType\Ticketing_Series
     */
    public function setDurationType($durationType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesDurationType::valueIsValid($durationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesDurationType', is_array($durationType) ? implode(', ', $durationType) : var_export($durationType, true), implode(', ', \patest\EnumType\SeriesDurationType::getValidValues())), __LINE__);
        }
        if (is_null($durationType) || (is_array($durationType) && empty($durationType))) {
            unset($this->DurationType);
        } else {
            $this->DurationType = $durationType;
        }
        return $this;
    }
    /**
     * Get EffectiveEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveEndDate()
    {
        return isset($this->EffectiveEndDate) ? $this->EffectiveEndDate : null;
    }
    /**
     * Set EffectiveEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveEndDate
     * @return \patest\StructType\Ticketing_Series
     */
    public function setEffectiveEndDate($effectiveEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveEndDate) && !is_string($effectiveEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveEndDate, true), gettype($effectiveEndDate)), __LINE__);
        }
        if (is_null($effectiveEndDate) || (is_array($effectiveEndDate) && empty($effectiveEndDate))) {
            unset($this->EffectiveEndDate);
        } else {
            $this->EffectiveEndDate = $effectiveEndDate;
        }
        return $this;
    }
    /**
     * Get EffectiveStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveStartDate()
    {
        return isset($this->EffectiveStartDate) ? $this->EffectiveStartDate : null;
    }
    /**
     * Set EffectiveStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveStartDate
     * @return \patest\StructType\Ticketing_Series
     */
    public function setEffectiveStartDate($effectiveStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveStartDate) && !is_string($effectiveStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveStartDate, true), gettype($effectiveStartDate)), __LINE__);
        }
        if (is_null($effectiveStartDate) || (is_array($effectiveStartDate) && empty($effectiveStartDate))) {
            unset($this->EffectiveStartDate);
        } else {
            $this->EffectiveStartDate = $effectiveStartDate;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Ticketing_Series
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get ExtendTillEndOfMonthStartingFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getExtendTillEndOfMonthStartingFrom()
    {
        return isset($this->ExtendTillEndOfMonthStartingFrom) ? $this->ExtendTillEndOfMonthStartingFrom : null;
    }
    /**
     * Set ExtendTillEndOfMonthStartingFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $extendTillEndOfMonthStartingFrom
     * @return \patest\StructType\Ticketing_Series
     */
    public function setExtendTillEndOfMonthStartingFrom($extendTillEndOfMonthStartingFrom = null)
    {
        // validation for constraint: int
        if (!is_null($extendTillEndOfMonthStartingFrom) && !(is_int($extendTillEndOfMonthStartingFrom) || ctype_digit($extendTillEndOfMonthStartingFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extendTillEndOfMonthStartingFrom, true), gettype($extendTillEndOfMonthStartingFrom)), __LINE__);
        }
        if (is_null($extendTillEndOfMonthStartingFrom) || (is_array($extendTillEndOfMonthStartingFrom) && empty($extendTillEndOfMonthStartingFrom))) {
            unset($this->ExtendTillEndOfMonthStartingFrom);
        } else {
            $this->ExtendTillEndOfMonthStartingFrom = $extendTillEndOfMonthStartingFrom;
        }
        return $this;
    }
    /**
     * Get HallHasConstructionProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHallHasConstructionProblems()
    {
        return isset($this->HallHasConstructionProblems) ? $this->HallHasConstructionProblems : null;
    }
    /**
     * Set HallHasConstructionProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hallHasConstructionProblems
     * @return \patest\StructType\Ticketing_Series
     */
    public function setHallHasConstructionProblems($hallHasConstructionProblems = null)
    {
        // validation for constraint: boolean
        if (!is_null($hallHasConstructionProblems) && !is_bool($hallHasConstructionProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hallHasConstructionProblems, true), gettype($hallHasConstructionProblems)), __LINE__);
        }
        if (is_null($hallHasConstructionProblems) || (is_array($hallHasConstructionProblems) && empty($hallHasConstructionProblems))) {
            unset($this->HallHasConstructionProblems);
        } else {
            $this->HallHasConstructionProblems = $hallHasConstructionProblems;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get HallVersionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionStatus()
    {
        return isset($this->HallVersionStatus) ? $this->HallVersionStatus : null;
    }
    /**
     * Set HallVersionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HallVersionStatus::valueIsValid()
     * @uses \patest\EnumType\HallVersionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $hallVersionStatus
     * @return \patest\StructType\Ticketing_Series
     */
    public function setHallVersionStatus($hallVersionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallVersionStatus::valueIsValid($hallVersionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallVersionStatus', is_array($hallVersionStatus) ? implode(', ', $hallVersionStatus) : var_export($hallVersionStatus, true), implode(', ', \patest\EnumType\HallVersionStatus::getValidValues())), __LINE__);
        }
        if (is_null($hallVersionStatus) || (is_array($hallVersionStatus) && empty($hallVersionStatus))) {
            unset($this->HallVersionStatus);
        } else {
            $this->HallVersionStatus = $hallVersionStatus;
        }
        return $this;
    }
    /**
     * Get HasSubseries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasSubseries()
    {
        return isset($this->HasSubseries) ? $this->HasSubseries : null;
    }
    /**
     * Set HasSubseries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasSubseries
     * @return \patest\StructType\Ticketing_Series
     */
    public function setHasSubseries($hasSubseries = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasSubseries) && !is_bool($hasSubseries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasSubseries, true), gettype($hasSubseries)), __LINE__);
        }
        if (is_null($hasSubseries) || (is_array($hasSubseries) && empty($hasSubseries))) {
            unset($this->HasSubseries);
        } else {
            $this->HasSubseries = $hasSubseries;
        }
        return $this;
    }
    /**
     * Get HoldSeatsForRenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldSeatsForRenewStatus()
    {
        return isset($this->HoldSeatsForRenewStatus) ? $this->HoldSeatsForRenewStatus : null;
    }
    /**
     * Set HoldSeatsForRenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::valueIsValid()
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holdSeatsForRenewStatus
     * @return \patest\StructType\Ticketing_Series
     */
    public function setHoldSeatsForRenewStatus($holdSeatsForRenewStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HoldSeatsForRenewStatus::valueIsValid($holdSeatsForRenewStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HoldSeatsForRenewStatus', is_array($holdSeatsForRenewStatus) ? implode(', ', $holdSeatsForRenewStatus) : var_export($holdSeatsForRenewStatus, true), implode(', ', \patest\EnumType\HoldSeatsForRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($holdSeatsForRenewStatus) || (is_array($holdSeatsForRenewStatus) && empty($holdSeatsForRenewStatus))) {
            unset($this->HoldSeatsForRenewStatus);
        } else {
            $this->HoldSeatsForRenewStatus = $holdSeatsForRenewStatus;
        }
        return $this;
    }
    /**
     * Get HospitalityInRegularSaleApplicationChannels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHospitalityInRegularSaleApplicationChannels()
    {
        return isset($this->HospitalityInRegularSaleApplicationChannels) ? $this->HospitalityInRegularSaleApplicationChannels : null;
    }
    /**
     * Set HospitalityInRegularSaleApplicationChannels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hospitalityInRegularSaleApplicationChannels
     * @return \patest\StructType\Ticketing_Series
     */
    public function setHospitalityInRegularSaleApplicationChannels($hospitalityInRegularSaleApplicationChannels = null)
    {
        // validation for constraint: string
        if (!is_null($hospitalityInRegularSaleApplicationChannels) && !is_string($hospitalityInRegularSaleApplicationChannels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hospitalityInRegularSaleApplicationChannels, true), gettype($hospitalityInRegularSaleApplicationChannels)), __LINE__);
        }
        if (is_null($hospitalityInRegularSaleApplicationChannels) || (is_array($hospitalityInRegularSaleApplicationChannels) && empty($hospitalityInRegularSaleApplicationChannels))) {
            unset($this->HospitalityInRegularSaleApplicationChannels);
        } else {
            $this->HospitalityInRegularSaleApplicationChannels = $hospitalityInRegularSaleApplicationChannels;
        }
        return $this;
    }
    /**
     * Get HospitalityMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Subscription_Media|null
     */
    public function getHospitalityMedia()
    {
        return isset($this->HospitalityMedia) ? $this->HospitalityMedia : null;
    }
    /**
     * Set HospitalityMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Subscription_Media $hospitalityMedia
     * @return \patest\StructType\Ticketing_Series
     */
    public function setHospitalityMedia(\patest\StructType\Subscription_Media $hospitalityMedia = null)
    {
        if (is_null($hospitalityMedia) || (is_array($hospitalityMedia) && empty($hospitalityMedia))) {
            unset($this->HospitalityMedia);
        } else {
            $this->HospitalityMedia = $hospitalityMedia;
        }
        return $this;
    }
    /**
     * Get InheritAllowedBookingRequestsOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInheritAllowedBookingRequestsOptions()
    {
        return isset($this->InheritAllowedBookingRequestsOptions) ? $this->InheritAllowedBookingRequestsOptions : null;
    }
    /**
     * Set InheritAllowedBookingRequestsOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $inheritAllowedBookingRequestsOptions
     * @return \patest\StructType\Ticketing_Series
     */
    public function setInheritAllowedBookingRequestsOptions($inheritAllowedBookingRequestsOptions = null)
    {
        // validation for constraint: boolean
        if (!is_null($inheritAllowedBookingRequestsOptions) && !is_bool($inheritAllowedBookingRequestsOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inheritAllowedBookingRequestsOptions, true), gettype($inheritAllowedBookingRequestsOptions)), __LINE__);
        }
        if (is_null($inheritAllowedBookingRequestsOptions) || (is_array($inheritAllowedBookingRequestsOptions) && empty($inheritAllowedBookingRequestsOptions))) {
            unset($this->InheritAllowedBookingRequestsOptions);
        } else {
            $this->InheritAllowedBookingRequestsOptions = $inheritAllowedBookingRequestsOptions;
        }
        return $this;
    }
    /**
     * Get IsAccessCardNotDedicated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccessCardNotDedicated()
    {
        return isset($this->IsAccessCardNotDedicated) ? $this->IsAccessCardNotDedicated : null;
    }
    /**
     * Set IsAccessCardNotDedicated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccessCardNotDedicated
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsAccessCardNotDedicated($isAccessCardNotDedicated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessCardNotDedicated) && !is_bool($isAccessCardNotDedicated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessCardNotDedicated, true), gettype($isAccessCardNotDedicated)), __LINE__);
        }
        if (is_null($isAccessCardNotDedicated) || (is_array($isAccessCardNotDedicated) && empty($isAccessCardNotDedicated))) {
            unset($this->IsAccessCardNotDedicated);
        } else {
            $this->IsAccessCardNotDedicated = $isAccessCardNotDedicated;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsAllocatedSeatsAssignedByDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllocatedSeatsAssignedByDefault()
    {
        return isset($this->IsAllocatedSeatsAssignedByDefault) ? $this->IsAllocatedSeatsAssignedByDefault : null;
    }
    /**
     * Set IsAllocatedSeatsAssignedByDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllocatedSeatsAssignedByDefault
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsAllocatedSeatsAssignedByDefault($isAllocatedSeatsAssignedByDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllocatedSeatsAssignedByDefault) && !is_bool($isAllocatedSeatsAssignedByDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllocatedSeatsAssignedByDefault, true), gettype($isAllocatedSeatsAssignedByDefault)), __LINE__);
        }
        if (is_null($isAllocatedSeatsAssignedByDefault) || (is_array($isAllocatedSeatsAssignedByDefault) && empty($isAllocatedSeatsAssignedByDefault))) {
            unset($this->IsAllocatedSeatsAssignedByDefault);
        } else {
            $this->IsAllocatedSeatsAssignedByDefault = $isAllocatedSeatsAssignedByDefault;
        }
        return $this;
    }
    /**
     * Get IsAllowedTicketExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllowedTicketExchanges()
    {
        return isset($this->IsAllowedTicketExchanges) ? $this->IsAllowedTicketExchanges : null;
    }
    /**
     * Set IsAllowedTicketExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllowedTicketExchanges
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsAllowedTicketExchanges($isAllowedTicketExchanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowedTicketExchanges) && !is_bool($isAllowedTicketExchanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllowedTicketExchanges, true), gettype($isAllowedTicketExchanges)), __LINE__);
        }
        if (is_null($isAllowedTicketExchanges) || (is_array($isAllowedTicketExchanges) && empty($isAllowedTicketExchanges))) {
            unset($this->IsAllowedTicketExchanges);
        } else {
            $this->IsAllowedTicketExchanges = $isAllowedTicketExchanges;
        }
        return $this;
    }
    /**
     * Get IsAssignAllEventsOnSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAssignAllEventsOnSale()
    {
        return isset($this->IsAssignAllEventsOnSale) ? $this->IsAssignAllEventsOnSale : null;
    }
    /**
     * Set IsAssignAllEventsOnSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAssignAllEventsOnSale
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsAssignAllEventsOnSale($isAssignAllEventsOnSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAssignAllEventsOnSale) && !is_bool($isAssignAllEventsOnSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAssignAllEventsOnSale, true), gettype($isAssignAllEventsOnSale)), __LINE__);
        }
        if (is_null($isAssignAllEventsOnSale) || (is_array($isAssignAllEventsOnSale) && empty($isAssignAllEventsOnSale))) {
            unset($this->IsAssignAllEventsOnSale);
        } else {
            $this->IsAssignAllEventsOnSale = $isAssignAllEventsOnSale;
        }
        return $this;
    }
    /**
     * Get IsHospitalityAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHospitalityAvailable()
    {
        return isset($this->IsHospitalityAvailable) ? $this->IsHospitalityAvailable : null;
    }
    /**
     * Set IsHospitalityAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHospitalityAvailable
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsHospitalityAvailable($isHospitalityAvailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitalityAvailable) && !is_bool($isHospitalityAvailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitalityAvailable, true), gettype($isHospitalityAvailable)), __LINE__);
        }
        if (is_null($isHospitalityAvailable) || (is_array($isHospitalityAvailable) && empty($isHospitalityAvailable))) {
            unset($this->IsHospitalityAvailable);
        } else {
            $this->IsHospitalityAvailable = $isHospitalityAvailable;
        }
        return $this;
    }
    /**
     * Get IsHospitalityPromptRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHospitalityPromptRequired()
    {
        return isset($this->IsHospitalityPromptRequired) ? $this->IsHospitalityPromptRequired : null;
    }
    /**
     * Set IsHospitalityPromptRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHospitalityPromptRequired
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsHospitalityPromptRequired($isHospitalityPromptRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitalityPromptRequired) && !is_bool($isHospitalityPromptRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitalityPromptRequired, true), gettype($isHospitalityPromptRequired)), __LINE__);
        }
        if (is_null($isHospitalityPromptRequired) || (is_array($isHospitalityPromptRequired) && empty($isHospitalityPromptRequired))) {
            unset($this->IsHospitalityPromptRequired);
        } else {
            $this->IsHospitalityPromptRequired = $isHospitalityPromptRequired;
        }
        return $this;
    }
    /**
     * Get IsLeagueReportable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLeagueReportable()
    {
        return isset($this->IsLeagueReportable) ? $this->IsLeagueReportable : null;
    }
    /**
     * Set IsLeagueReportable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLeagueReportable
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsLeagueReportable($isLeagueReportable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLeagueReportable) && !is_bool($isLeagueReportable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLeagueReportable, true), gettype($isLeagueReportable)), __LINE__);
        }
        if (is_null($isLeagueReportable) || (is_array($isLeagueReportable) && empty($isLeagueReportable))) {
            unset($this->IsLeagueReportable);
        } else {
            $this->IsLeagueReportable = $isLeagueReportable;
        }
        return $this;
    }
    /**
     * Get IsOnlyAllowSalesInAllocatedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOnlyAllowSalesInAllocatedSeats()
    {
        return isset($this->IsOnlyAllowSalesInAllocatedSeats) ? $this->IsOnlyAllowSalesInAllocatedSeats : null;
    }
    /**
     * Set IsOnlyAllowSalesInAllocatedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOnlyAllowSalesInAllocatedSeats
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsOnlyAllowSalesInAllocatedSeats($isOnlyAllowSalesInAllocatedSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnlyAllowSalesInAllocatedSeats) && !is_bool($isOnlyAllowSalesInAllocatedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnlyAllowSalesInAllocatedSeats, true), gettype($isOnlyAllowSalesInAllocatedSeats)), __LINE__);
        }
        if (is_null($isOnlyAllowSalesInAllocatedSeats) || (is_array($isOnlyAllowSalesInAllocatedSeats) && empty($isOnlyAllowSalesInAllocatedSeats))) {
            unset($this->IsOnlyAllowSalesInAllocatedSeats);
        } else {
            $this->IsOnlyAllowSalesInAllocatedSeats = $isOnlyAllowSalesInAllocatedSeats;
        }
        return $this;
    }
    /**
     * Get IsPartialEventBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartialEventBased()
    {
        return isset($this->IsPartialEventBased) ? $this->IsPartialEventBased : null;
    }
    /**
     * Set IsPartialEventBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartialEventBased
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsPartialEventBased($isPartialEventBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialEventBased) && !is_bool($isPartialEventBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialEventBased, true), gettype($isPartialEventBased)), __LINE__);
        }
        if (is_null($isPartialEventBased) || (is_array($isPartialEventBased) && empty($isPartialEventBased))) {
            unset($this->IsPartialEventBased);
        } else {
            $this->IsPartialEventBased = $isPartialEventBased;
        }
        return $this;
    }
    /**
     * Get IsPrepaiedWaitingListAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrepaiedWaitingListAllowed()
    {
        return isset($this->IsPrepaiedWaitingListAllowed) ? $this->IsPrepaiedWaitingListAllowed : null;
    }
    /**
     * Set IsPrepaiedWaitingListAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrepaiedWaitingListAllowed
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsPrepaiedWaitingListAllowed($isPrepaiedWaitingListAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrepaiedWaitingListAllowed) && !is_bool($isPrepaiedWaitingListAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrepaiedWaitingListAllowed, true), gettype($isPrepaiedWaitingListAllowed)), __LINE__);
        }
        if (is_null($isPrepaiedWaitingListAllowed) || (is_array($isPrepaiedWaitingListAllowed) && empty($isPrepaiedWaitingListAllowed))) {
            unset($this->IsPrepaiedWaitingListAllowed);
        } else {
            $this->IsPrepaiedWaitingListAllowed = $isPrepaiedWaitingListAllowed;
        }
        return $this;
    }
    /**
     * Get IsPriceLevelEnforcedOnEventTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPriceLevelEnforcedOnEventTickets()
    {
        return isset($this->IsPriceLevelEnforcedOnEventTickets) ? $this->IsPriceLevelEnforcedOnEventTickets : null;
    }
    /**
     * Set IsPriceLevelEnforcedOnEventTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPriceLevelEnforcedOnEventTickets
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsPriceLevelEnforcedOnEventTickets($isPriceLevelEnforcedOnEventTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPriceLevelEnforcedOnEventTickets) && !is_bool($isPriceLevelEnforcedOnEventTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPriceLevelEnforcedOnEventTickets, true), gettype($isPriceLevelEnforcedOnEventTickets)), __LINE__);
        }
        if (is_null($isPriceLevelEnforcedOnEventTickets) || (is_array($isPriceLevelEnforcedOnEventTickets) && empty($isPriceLevelEnforcedOnEventTickets))) {
            unset($this->IsPriceLevelEnforcedOnEventTickets);
        } else {
            $this->IsPriceLevelEnforcedOnEventTickets = $isPriceLevelEnforcedOnEventTickets;
        }
        return $this;
    }
    /**
     * Get IsPricingPerSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPricingPerSeries()
    {
        return isset($this->IsPricingPerSeries) ? $this->IsPricingPerSeries : null;
    }
    /**
     * Set IsPricingPerSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPricingPerSeries
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsPricingPerSeries($isPricingPerSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPricingPerSeries) && !is_bool($isPricingPerSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPricingPerSeries, true), gettype($isPricingPerSeries)), __LINE__);
        }
        if (is_null($isPricingPerSeries) || (is_array($isPricingPerSeries) && empty($isPricingPerSeries))) {
            unset($this->IsPricingPerSeries);
        } else {
            $this->IsPricingPerSeries = $isPricingPerSeries;
        }
        return $this;
    }
    /**
     * Get IsPTTAForForSeriesEnabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPTTAForForSeriesEnabled()
    {
        return isset($this->IsPTTAForForSeriesEnabled) ? $this->IsPTTAForForSeriesEnabled : null;
    }
    /**
     * Set IsPTTAForForSeriesEnabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPTTAForForSeriesEnabled
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsPTTAForForSeriesEnabled($isPTTAForForSeriesEnabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPTTAForForSeriesEnabled) && !is_bool($isPTTAForForSeriesEnabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPTTAForForSeriesEnabled, true), gettype($isPTTAForForSeriesEnabled)), __LINE__);
        }
        if (is_null($isPTTAForForSeriesEnabled) || (is_array($isPTTAForForSeriesEnabled) && empty($isPTTAForForSeriesEnabled))) {
            unset($this->IsPTTAForForSeriesEnabled);
        } else {
            $this->IsPTTAForForSeriesEnabled = $isPTTAForForSeriesEnabled;
        }
        return $this;
    }
    /**
     * Get IsSellOnlyAsPartOfGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSellOnlyAsPartOfGroup()
    {
        return isset($this->IsSellOnlyAsPartOfGroup) ? $this->IsSellOnlyAsPartOfGroup : null;
    }
    /**
     * Set IsSellOnlyAsPartOfGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSellOnlyAsPartOfGroup
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsSellOnlyAsPartOfGroup($isSellOnlyAsPartOfGroup = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSellOnlyAsPartOfGroup) && !is_bool($isSellOnlyAsPartOfGroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSellOnlyAsPartOfGroup, true), gettype($isSellOnlyAsPartOfGroup)), __LINE__);
        }
        if (is_null($isSellOnlyAsPartOfGroup) || (is_array($isSellOnlyAsPartOfGroup) && empty($isSellOnlyAsPartOfGroup))) {
            unset($this->IsSellOnlyAsPartOfGroup);
        } else {
            $this->IsSellOnlyAsPartOfGroup = $isSellOnlyAsPartOfGroup;
        }
        return $this;
    }
    /**
     * Get IsSeriesAllocated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSeriesAllocated()
    {
        return isset($this->IsSeriesAllocated) ? $this->IsSeriesAllocated : null;
    }
    /**
     * Set IsSeriesAllocated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSeriesAllocated
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsSeriesAllocated($isSeriesAllocated = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSeriesAllocated) && !is_bool($isSeriesAllocated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSeriesAllocated, true), gettype($isSeriesAllocated)), __LINE__);
        }
        if (is_null($isSeriesAllocated) || (is_array($isSeriesAllocated) && empty($isSeriesAllocated))) {
            unset($this->IsSeriesAllocated);
        } else {
            $this->IsSeriesAllocated = $isSeriesAllocated;
        }
        return $this;
    }
    /**
     * Get IsSinglePerClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSinglePerClient()
    {
        return isset($this->IsSinglePerClient) ? $this->IsSinglePerClient : null;
    }
    /**
     * Set IsSinglePerClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSinglePerClient
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsSinglePerClient($isSinglePerClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSinglePerClient) && !is_bool($isSinglePerClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSinglePerClient, true), gettype($isSinglePerClient)), __LINE__);
        }
        if (is_null($isSinglePerClient) || (is_array($isSinglePerClient) && empty($isSinglePerClient))) {
            unset($this->IsSinglePerClient);
        } else {
            $this->IsSinglePerClient = $isSinglePerClient;
        }
        return $this;
    }
    /**
     * Get IsTransferBonusBalanceOnRenewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTransferBonusBalanceOnRenewal()
    {
        return isset($this->IsTransferBonusBalanceOnRenewal) ? $this->IsTransferBonusBalanceOnRenewal : null;
    }
    /**
     * Set IsTransferBonusBalanceOnRenewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTransferBonusBalanceOnRenewal
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsTransferBonusBalanceOnRenewal($isTransferBonusBalanceOnRenewal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransferBonusBalanceOnRenewal) && !is_bool($isTransferBonusBalanceOnRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransferBonusBalanceOnRenewal, true), gettype($isTransferBonusBalanceOnRenewal)), __LINE__);
        }
        if (is_null($isTransferBonusBalanceOnRenewal) || (is_array($isTransferBonusBalanceOnRenewal) && empty($isTransferBonusBalanceOnRenewal))) {
            unset($this->IsTransferBonusBalanceOnRenewal);
        } else {
            $this->IsTransferBonusBalanceOnRenewal = $isTransferBonusBalanceOnRenewal;
        }
        return $this;
    }
    /**
     * Get IsTransferTicketBalanceOnRenewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTransferTicketBalanceOnRenewal()
    {
        return isset($this->IsTransferTicketBalanceOnRenewal) ? $this->IsTransferTicketBalanceOnRenewal : null;
    }
    /**
     * Set IsTransferTicketBalanceOnRenewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTransferTicketBalanceOnRenewal
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsTransferTicketBalanceOnRenewal($isTransferTicketBalanceOnRenewal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTransferTicketBalanceOnRenewal) && !is_bool($isTransferTicketBalanceOnRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTransferTicketBalanceOnRenewal, true), gettype($isTransferTicketBalanceOnRenewal)), __LINE__);
        }
        if (is_null($isTransferTicketBalanceOnRenewal) || (is_array($isTransferTicketBalanceOnRenewal) && empty($isTransferTicketBalanceOnRenewal))) {
            unset($this->IsTransferTicketBalanceOnRenewal);
        } else {
            $this->IsTransferTicketBalanceOnRenewal = $isTransferTicketBalanceOnRenewal;
        }
        return $this;
    }
    /**
     * Get IsWaitingListAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsWaitingListAllowed()
    {
        return isset($this->IsWaitingListAllowed) ? $this->IsWaitingListAllowed : null;
    }
    /**
     * Set IsWaitingListAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isWaitingListAllowed
     * @return \patest\StructType\Ticketing_Series
     */
    public function setIsWaitingListAllowed($isWaitingListAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWaitingListAllowed) && !is_bool($isWaitingListAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWaitingListAllowed, true), gettype($isWaitingListAllowed)), __LINE__);
        }
        if (is_null($isWaitingListAllowed) || (is_array($isWaitingListAllowed) && empty($isWaitingListAllowed))) {
            unset($this->IsWaitingListAllowed);
        } else {
            $this->IsWaitingListAllowed = $isWaitingListAllowed;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Ticketing_Series
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get MasterHospitalitySeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterHospitalitySeriesId()
    {
        return isset($this->MasterHospitalitySeriesId) ? $this->MasterHospitalitySeriesId : null;
    }
    /**
     * Set MasterHospitalitySeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterHospitalitySeriesId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setMasterHospitalitySeriesId($masterHospitalitySeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($masterHospitalitySeriesId) && !is_string($masterHospitalitySeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterHospitalitySeriesId, true), gettype($masterHospitalitySeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterHospitalitySeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterHospitalitySeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterHospitalitySeriesId, true)), __LINE__);
        }
        if (is_null($masterHospitalitySeriesId) || (is_array($masterHospitalitySeriesId) && empty($masterHospitalitySeriesId))) {
            unset($this->MasterHospitalitySeriesId);
        } else {
            $this->MasterHospitalitySeriesId = $masterHospitalitySeriesId;
        }
        return $this;
    }
    /**
     * Get MasterSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMasterSeriesId()
    {
        return isset($this->MasterSeriesId) ? $this->MasterSeriesId : null;
    }
    /**
     * Set MasterSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $masterSeriesId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setMasterSeriesId($masterSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($masterSeriesId) && !is_string($masterSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($masterSeriesId, true), gettype($masterSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($masterSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $masterSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($masterSeriesId, true)), __LINE__);
        }
        if (is_null($masterSeriesId) || (is_array($masterSeriesId) && empty($masterSeriesId))) {
            unset($this->MasterSeriesId);
        } else {
            $this->MasterSeriesId = $masterSeriesId;
        }
        return $this;
    }
    /**
     * Get MaxAllowedFullStackExchanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAllowedFullStackExchanges()
    {
        return isset($this->MaxAllowedFullStackExchanges) ? $this->MaxAllowedFullStackExchanges : null;
    }
    /**
     * Set MaxAllowedFullStackExchanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAllowedFullStackExchanges
     * @return \patest\StructType\Ticketing_Series
     */
    public function setMaxAllowedFullStackExchanges($maxAllowedFullStackExchanges = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedFullStackExchanges) && !(is_int($maxAllowedFullStackExchanges) || ctype_digit($maxAllowedFullStackExchanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowedFullStackExchanges, true), gettype($maxAllowedFullStackExchanges)), __LINE__);
        }
        if (is_null($maxAllowedFullStackExchanges) || (is_array($maxAllowedFullStackExchanges) && empty($maxAllowedFullStackExchanges))) {
            unset($this->MaxAllowedFullStackExchanges);
        } else {
            $this->MaxAllowedFullStackExchanges = $maxAllowedFullStackExchanges;
        }
        return $this;
    }
    /**
     * Get MaxNumberOfTicketsPerShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberOfTicketsPerShow()
    {
        return isset($this->MaxNumberOfTicketsPerShow) ? $this->MaxNumberOfTicketsPerShow : null;
    }
    /**
     * Set MaxNumberOfTicketsPerShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberOfTicketsPerShow
     * @return \patest\StructType\Ticketing_Series
     */
    public function setMaxNumberOfTicketsPerShow($maxNumberOfTicketsPerShow = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfTicketsPerShow) && !(is_int($maxNumberOfTicketsPerShow) || ctype_digit($maxNumberOfTicketsPerShow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfTicketsPerShow, true), gettype($maxNumberOfTicketsPerShow)), __LINE__);
        }
        if (is_null($maxNumberOfTicketsPerShow) || (is_array($maxNumberOfTicketsPerShow) && empty($maxNumberOfTicketsPerShow))) {
            unset($this->MaxNumberOfTicketsPerShow);
        } else {
            $this->MaxNumberOfTicketsPerShow = $maxNumberOfTicketsPerShow;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Subscription_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Subscription_Media $media
     * @return \patest\StructType\Ticketing_Series
     */
    public function setMedia(\patest\StructType\Subscription_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MinQuantityOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinQuantityOfEvents()
    {
        return isset($this->MinQuantityOfEvents) ? $this->MinQuantityOfEvents : null;
    }
    /**
     * Set MinQuantityOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minQuantityOfEvents
     * @return \patest\StructType\Ticketing_Series
     */
    public function setMinQuantityOfEvents($minQuantityOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($minQuantityOfEvents) && !(is_int($minQuantityOfEvents) || ctype_digit($minQuantityOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minQuantityOfEvents, true), gettype($minQuantityOfEvents)), __LINE__);
        }
        if (is_null($minQuantityOfEvents) || (is_array($minQuantityOfEvents) && empty($minQuantityOfEvents))) {
            unset($this->MinQuantityOfEvents);
        } else {
            $this->MinQuantityOfEvents = $minQuantityOfEvents;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Series
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumberOfBonusEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfBonusEvents()
    {
        return isset($this->NumberOfBonusEvents) ? $this->NumberOfBonusEvents : null;
    }
    /**
     * Set NumberOfBonusEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfBonusEvents
     * @return \patest\StructType\Ticketing_Series
     */
    public function setNumberOfBonusEvents($numberOfBonusEvents = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfBonusEvents) && !(is_int($numberOfBonusEvents) || ctype_digit($numberOfBonusEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfBonusEvents, true), gettype($numberOfBonusEvents)), __LINE__);
        }
        if (is_null($numberOfBonusEvents) || (is_array($numberOfBonusEvents) && empty($numberOfBonusEvents))) {
            unset($this->NumberOfBonusEvents);
        } else {
            $this->NumberOfBonusEvents = $numberOfBonusEvents;
        }
        return $this;
    }
    /**
     * Get OnlineMoveAllowedUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineMoveAllowedUntil()
    {
        return isset($this->OnlineMoveAllowedUntil) ? $this->OnlineMoveAllowedUntil : null;
    }
    /**
     * Set OnlineMoveAllowedUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineMoveAllowedUntil
     * @return \patest\StructType\Ticketing_Series
     */
    public function setOnlineMoveAllowedUntil($onlineMoveAllowedUntil = null)
    {
        // validation for constraint: string
        if (!is_null($onlineMoveAllowedUntil) && !is_string($onlineMoveAllowedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineMoveAllowedUntil, true), gettype($onlineMoveAllowedUntil)), __LINE__);
        }
        if (is_null($onlineMoveAllowedUntil) || (is_array($onlineMoveAllowedUntil) && empty($onlineMoveAllowedUntil))) {
            unset($this->OnlineMoveAllowedUntil);
        } else {
            $this->OnlineMoveAllowedUntil = $onlineMoveAllowedUntil;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OrganizerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizerId()
    {
        return isset($this->OrganizerId) ? $this->OrganizerId : null;
    }
    /**
     * Set OrganizerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizerId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setOrganizerId($organizerId = null)
    {
        // validation for constraint: string
        if (!is_null($organizerId) && !is_string($organizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizerId, true), gettype($organizerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizerId, true)), __LINE__);
        }
        if (is_null($organizerId) || (is_array($organizerId) && empty($organizerId))) {
            unset($this->OrganizerId);
        } else {
            $this->OrganizerId = $organizerId;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get PeriodDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodDescription()
    {
        return isset($this->PeriodDescription) ? $this->PeriodDescription : null;
    }
    /**
     * Set PeriodDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodDescription
     * @return \patest\StructType\Ticketing_Series
     */
    public function setPeriodDescription($periodDescription = null)
    {
        // validation for constraint: string
        if (!is_null($periodDescription) && !is_string($periodDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodDescription, true), gettype($periodDescription)), __LINE__);
        }
        if (is_null($periodDescription) || (is_array($periodDescription) && empty($periodDescription))) {
            unset($this->PeriodDescription);
        } else {
            $this->PeriodDescription = $periodDescription;
        }
        return $this;
    }
    /**
     * Get PeriodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPeriodType()
    {
        return isset($this->PeriodType) ? $this->PeriodType : null;
    }
    /**
     * Set PeriodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $periodType
     * @return \patest\StructType\Ticketing_Series
     */
    public function setPeriodType($periodType = null)
    {
        // validation for constraint: string
        if (!is_null($periodType) && !is_string($periodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodType, true), gettype($periodType)), __LINE__);
        }
        if (is_null($periodType) || (is_array($periodType) && empty($periodType))) {
            unset($this->PeriodType);
        } else {
            $this->PeriodType = $periodType;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get QuantityOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantityOfEvents()
    {
        return isset($this->QuantityOfEvents) ? $this->QuantityOfEvents : null;
    }
    /**
     * Set QuantityOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantityOfEvents
     * @return \patest\StructType\Ticketing_Series
     */
    public function setQuantityOfEvents($quantityOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($quantityOfEvents) && !(is_int($quantityOfEvents) || ctype_digit($quantityOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantityOfEvents, true), gettype($quantityOfEvents)), __LINE__);
        }
        if (is_null($quantityOfEvents) || (is_array($quantityOfEvents) && empty($quantityOfEvents))) {
            unset($this->QuantityOfEvents);
        } else {
            $this->QuantityOfEvents = $quantityOfEvents;
        }
        return $this;
    }
    /**
     * Get RelatedPriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SeriesPriceLevelRelation|null
     */
    public function getRelatedPriceLevels()
    {
        return isset($this->RelatedPriceLevels) ? $this->RelatedPriceLevels : null;
    }
    /**
     * Set RelatedPriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SeriesPriceLevelRelation $relatedPriceLevels
     * @return \patest\StructType\Ticketing_Series
     */
    public function setRelatedPriceLevels(\patest\StructType\RecordSetOfTicketing_SeriesPriceLevelRelation $relatedPriceLevels = null)
    {
        if (is_null($relatedPriceLevels) || (is_array($relatedPriceLevels) && empty($relatedPriceLevels))) {
            unset($this->RelatedPriceLevels);
        } else {
            $this->RelatedPriceLevels = $relatedPriceLevels;
        }
        return $this;
    }
    /**
     * Get RelatedPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_SeriesPriceTypeRelation|null
     */
    public function getRelatedPriceTypes()
    {
        return isset($this->RelatedPriceTypes) ? $this->RelatedPriceTypes : null;
    }
    /**
     * Set RelatedPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_SeriesPriceTypeRelation $relatedPriceTypes
     * @return \patest\StructType\Ticketing_Series
     */
    public function setRelatedPriceTypes(\patest\StructType\RecordSetOfTicketing_SeriesPriceTypeRelation $relatedPriceTypes = null)
    {
        if (is_null($relatedPriceTypes) || (is_array($relatedPriceTypes) && empty($relatedPriceTypes))) {
            unset($this->RelatedPriceTypes);
        } else {
            $this->RelatedPriceTypes = $relatedPriceTypes;
        }
        return $this;
    }
    /**
     * Get RelatedSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedSeriesId()
    {
        return isset($this->RelatedSeriesId) ? $this->RelatedSeriesId : null;
    }
    /**
     * Set RelatedSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedSeriesId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setRelatedSeriesId($relatedSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedSeriesId) && !is_string($relatedSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedSeriesId, true), gettype($relatedSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedSeriesId, true)), __LINE__);
        }
        if (is_null($relatedSeriesId) || (is_array($relatedSeriesId) && empty($relatedSeriesId))) {
            unset($this->RelatedSeriesId);
        } else {
            $this->RelatedSeriesId = $relatedSeriesId;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
    /**
     * Get Seasonality value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonality()
    {
        return isset($this->Seasonality) ? $this->Seasonality : null;
    }
    /**
     * Set Seasonality value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesSeasonality::valueIsValid()
     * @uses \patest\EnumType\SeriesSeasonality::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasonality
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSeasonality($seasonality = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesSeasonality::valueIsValid($seasonality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesSeasonality', is_array($seasonality) ? implode(', ', $seasonality) : var_export($seasonality, true), implode(', ', \patest\EnumType\SeriesSeasonality::getValidValues())), __LINE__);
        }
        if (is_null($seasonality) || (is_array($seasonality) && empty($seasonality))) {
            unset($this->Seasonality);
        } else {
            $this->Seasonality = $seasonality;
        }
        return $this;
    }
    /**
     * Get SeasonHoldPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonHoldPolicy()
    {
        return isset($this->SeasonHoldPolicy) ? $this->SeasonHoldPolicy : null;
    }
    /**
     * Set SeasonHoldPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::valueIsValid()
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seasonHoldPolicy
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSeasonHoldPolicy($seasonHoldPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HoldSeatsForRenewStatus::valueIsValid($seasonHoldPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HoldSeatsForRenewStatus', is_array($seasonHoldPolicy) ? implode(', ', $seasonHoldPolicy) : var_export($seasonHoldPolicy, true), implode(', ', \patest\EnumType\HoldSeatsForRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($seasonHoldPolicy) || (is_array($seasonHoldPolicy) && empty($seasonHoldPolicy))) {
            unset($this->SeasonHoldPolicy);
        } else {
            $this->SeasonHoldPolicy = $seasonHoldPolicy;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SellOnlyAsPartOfPrompt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSellOnlyAsPartOfPrompt()
    {
        return isset($this->SellOnlyAsPartOfPrompt) ? $this->SellOnlyAsPartOfPrompt : null;
    }
    /**
     * Set SellOnlyAsPartOfPrompt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sellOnlyAsPartOfPrompt
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSellOnlyAsPartOfPrompt($sellOnlyAsPartOfPrompt = null)
    {
        // validation for constraint: boolean
        if (!is_null($sellOnlyAsPartOfPrompt) && !is_bool($sellOnlyAsPartOfPrompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sellOnlyAsPartOfPrompt, true), gettype($sellOnlyAsPartOfPrompt)), __LINE__);
        }
        if (is_null($sellOnlyAsPartOfPrompt) || (is_array($sellOnlyAsPartOfPrompt) && empty($sellOnlyAsPartOfPrompt))) {
            unset($this->SellOnlyAsPartOfPrompt);
        } else {
            $this->SellOnlyAsPartOfPrompt = $sellOnlyAsPartOfPrompt;
        }
        return $this;
    }
    /**
     * Get SendToApp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendToApp()
    {
        return isset($this->SendToApp) ? $this->SendToApp : null;
    }
    /**
     * Set SendToApp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendToApp
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSendToApp($sendToApp = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendToApp) && !is_bool($sendToApp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendToApp, true), gettype($sendToApp)), __LINE__);
        }
        if (is_null($sendToApp) || (is_array($sendToApp) && empty($sendToApp))) {
            unset($this->SendToApp);
        } else {
            $this->SendToApp = $sendToApp;
        }
        return $this;
    }
    /**
     * Get ShowTimeGenerateNfcPass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowTimeGenerateNfcPass()
    {
        return isset($this->ShowTimeGenerateNfcPass) ? $this->ShowTimeGenerateNfcPass : null;
    }
    /**
     * Set ShowTimeGenerateNfcPass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showTimeGenerateNfcPass
     * @return \patest\StructType\Ticketing_Series
     */
    public function setShowTimeGenerateNfcPass($showTimeGenerateNfcPass = null)
    {
        // validation for constraint: boolean
        if (!is_null($showTimeGenerateNfcPass) && !is_bool($showTimeGenerateNfcPass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showTimeGenerateNfcPass, true), gettype($showTimeGenerateNfcPass)), __LINE__);
        }
        if (is_null($showTimeGenerateNfcPass) || (is_array($showTimeGenerateNfcPass) && empty($showTimeGenerateNfcPass))) {
            unset($this->ShowTimeGenerateNfcPass);
        } else {
            $this->ShowTimeGenerateNfcPass = $showTimeGenerateNfcPass;
        }
        return $this;
    }
    /**
     * Get SpecificAgeCalculationReferenceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificAgeCalculationReferenceDate()
    {
        return isset($this->SpecificAgeCalculationReferenceDate) ? $this->SpecificAgeCalculationReferenceDate : null;
    }
    /**
     * Set SpecificAgeCalculationReferenceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificAgeCalculationReferenceDate
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSpecificAgeCalculationReferenceDate($specificAgeCalculationReferenceDate = null)
    {
        // validation for constraint: string
        if (!is_null($specificAgeCalculationReferenceDate) && !is_string($specificAgeCalculationReferenceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificAgeCalculationReferenceDate, true), gettype($specificAgeCalculationReferenceDate)), __LINE__);
        }
        if (is_null($specificAgeCalculationReferenceDate) || (is_array($specificAgeCalculationReferenceDate) && empty($specificAgeCalculationReferenceDate))) {
            unset($this->SpecificAgeCalculationReferenceDate);
        } else {
            $this->SpecificAgeCalculationReferenceDate = $specificAgeCalculationReferenceDate;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Ticketing_Series
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get SubscriptionPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubscriptionPeriod()
    {
        return isset($this->SubscriptionPeriod) ? $this->SubscriptionPeriod : null;
    }
    /**
     * Set SubscriptionPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subscriptionPeriod
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSubscriptionPeriod($subscriptionPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionPeriod) && !(is_int($subscriptionPeriod) || ctype_digit($subscriptionPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriptionPeriod, true), gettype($subscriptionPeriod)), __LINE__);
        }
        if (is_null($subscriptionPeriod) || (is_array($subscriptionPeriod) && empty($subscriptionPeriod))) {
            unset($this->SubscriptionPeriod);
        } else {
            $this->SubscriptionPeriod = $subscriptionPeriod;
        }
        return $this;
    }
    /**
     * Get SubscriptionPrintingPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionPrintingPolicy()
    {
        return isset($this->SubscriptionPrintingPolicy) ? $this->SubscriptionPrintingPolicy : null;
    }
    /**
     * Set SubscriptionPrintingPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionPrintingPolicy::valueIsValid()
     * @uses \patest\EnumType\SubscriptionPrintingPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriptionPrintingPolicy
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSubscriptionPrintingPolicy($subscriptionPrintingPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionPrintingPolicy::valueIsValid($subscriptionPrintingPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionPrintingPolicy', is_array($subscriptionPrintingPolicy) ? implode(', ', $subscriptionPrintingPolicy) : var_export($subscriptionPrintingPolicy, true), implode(', ', \patest\EnumType\SubscriptionPrintingPolicy::getValidValues())), __LINE__);
        }
        if (is_null($subscriptionPrintingPolicy) || (is_array($subscriptionPrintingPolicy) && empty($subscriptionPrintingPolicy))) {
            unset($this->SubscriptionPrintingPolicy);
        } else {
            $this->SubscriptionPrintingPolicy = $subscriptionPrintingPolicy;
        }
        return $this;
    }
    /**
     * Get SubseriesCouldShareSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSubseriesCouldShareSeats()
    {
        return isset($this->SubseriesCouldShareSeats) ? $this->SubseriesCouldShareSeats : null;
    }
    /**
     * Set SubseriesCouldShareSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $subseriesCouldShareSeats
     * @return \patest\StructType\Ticketing_Series
     */
    public function setSubseriesCouldShareSeats($subseriesCouldShareSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($subseriesCouldShareSeats) && !is_bool($subseriesCouldShareSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($subseriesCouldShareSeats, true), gettype($subseriesCouldShareSeats)), __LINE__);
        }
        if (is_null($subseriesCouldShareSeats) || (is_array($subseriesCouldShareSeats) && empty($subseriesCouldShareSeats))) {
            unset($this->SubseriesCouldShareSeats);
        } else {
            $this->SubseriesCouldShareSeats = $subseriesCouldShareSeats;
        }
        return $this;
    }
    /**
     * Get TicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketType()
    {
        return isset($this->TicketType) ? $this->TicketType : null;
    }
    /**
     * Set TicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeriesTicketType::valueIsValid()
     * @uses \patest\EnumType\SeriesTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketType
     * @return \patest\StructType\Ticketing_Series
     */
    public function setTicketType($ticketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeriesTicketType::valueIsValid($ticketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeriesTicketType', is_array($ticketType) ? implode(', ', $ticketType) : var_export($ticketType, true), implode(', ', \patest\EnumType\SeriesTicketType::getValidValues())), __LINE__);
        }
        if (is_null($ticketType) || (is_array($ticketType) && empty($ticketType))) {
            unset($this->TicketType);
        } else {
            $this->TicketType = $ticketType;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_Series
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
    /**
     * Get WarningsText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWarningsText()
    {
        return isset($this->WarningsText) ? $this->WarningsText : null;
    }
    /**
     * Set WarningsText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $warningsText
     * @return \patest\StructType\Ticketing_Series
     */
    public function setWarningsText($warningsText = null)
    {
        // validation for constraint: string
        if (!is_null($warningsText) && !is_string($warningsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($warningsText, true), gettype($warningsText)), __LINE__);
        }
        if (is_null($warningsText) || (is_array($warningsText) && empty($warningsText))) {
            unset($this->WarningsText);
        } else {
            $this->WarningsText = $warningsText;
        }
        return $this;
    }
}
