<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatingPlanManagerSession StructType
 * @subpackage Structs
 */
class Ticketing_SeatingPlanManagerSession extends AnyEntity
{
    /**
     * The AllocatedResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllocatedResources;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The ClientDisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientDisplayName;
    /**
     * The ContextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextId;
    /**
     * The CreatedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedAt;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The HeldSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HeldSeatCount;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The InactivityDurationStr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InactivityDurationStr;
    /**
     * The IsOnHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOnHold;
    /**
     * The LastActivityAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastActivityAt;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The SeatsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatsDescription;
    /**
     * The SeatsDescriptionShort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatsDescriptionShort;
    /**
     * The SeatsDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatsDetails;
    /**
     * The ToBeFreedResources
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToBeFreedResources;
    /**
     * The TranLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TranLevel;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for Ticketing.SeatingPlanManagerSession
     * @uses Ticketing_SeatingPlanManagerSession::setAllocatedResources()
     * @uses Ticketing_SeatingPlanManagerSession::setApplicationChannel()
     * @uses Ticketing_SeatingPlanManagerSession::setClientDisplayName()
     * @uses Ticketing_SeatingPlanManagerSession::setContextId()
     * @uses Ticketing_SeatingPlanManagerSession::setCreatedAt()
     * @uses Ticketing_SeatingPlanManagerSession::setCrmId()
     * @uses Ticketing_SeatingPlanManagerSession::setHeldSeatCount()
     * @uses Ticketing_SeatingPlanManagerSession::setId()
     * @uses Ticketing_SeatingPlanManagerSession::setInactivityDurationStr()
     * @uses Ticketing_SeatingPlanManagerSession::setIsOnHold()
     * @uses Ticketing_SeatingPlanManagerSession::setLastActivityAt()
     * @uses Ticketing_SeatingPlanManagerSession::setSalePointId()
     * @uses Ticketing_SeatingPlanManagerSession::setSeatingPlanId()
     * @uses Ticketing_SeatingPlanManagerSession::setSeatsDescription()
     * @uses Ticketing_SeatingPlanManagerSession::setSeatsDescriptionShort()
     * @uses Ticketing_SeatingPlanManagerSession::setSeatsDetails()
     * @uses Ticketing_SeatingPlanManagerSession::setToBeFreedResources()
     * @uses Ticketing_SeatingPlanManagerSession::setTranLevel()
     * @uses Ticketing_SeatingPlanManagerSession::setUserId()
     * @uses Ticketing_SeatingPlanManagerSession::setUserName()
     * @param string $allocatedResources
     * @param string $applicationChannel
     * @param string $clientDisplayName
     * @param string $contextId
     * @param string $createdAt
     * @param string $crmId
     * @param int $heldSeatCount
     * @param string $id
     * @param string $inactivityDurationStr
     * @param bool $isOnHold
     * @param string $lastActivityAt
     * @param string $salePointId
     * @param string $seatingPlanId
     * @param string $seatsDescription
     * @param string $seatsDescriptionShort
     * @param string $seatsDetails
     * @param string $toBeFreedResources
     * @param int $tranLevel
     * @param string $userId
     * @param string $userName
     */
    public function __construct($allocatedResources = null, $applicationChannel = null, $clientDisplayName = null, $contextId = null, $createdAt = null, $crmId = null, $heldSeatCount = null, $id = null, $inactivityDurationStr = null, $isOnHold = null, $lastActivityAt = null, $salePointId = null, $seatingPlanId = null, $seatsDescription = null, $seatsDescriptionShort = null, $seatsDetails = null, $toBeFreedResources = null, $tranLevel = null, $userId = null, $userName = null)
    {
        $this
            ->setAllocatedResources($allocatedResources)
            ->setApplicationChannel($applicationChannel)
            ->setClientDisplayName($clientDisplayName)
            ->setContextId($contextId)
            ->setCreatedAt($createdAt)
            ->setCrmId($crmId)
            ->setHeldSeatCount($heldSeatCount)
            ->setId($id)
            ->setInactivityDurationStr($inactivityDurationStr)
            ->setIsOnHold($isOnHold)
            ->setLastActivityAt($lastActivityAt)
            ->setSalePointId($salePointId)
            ->setSeatingPlanId($seatingPlanId)
            ->setSeatsDescription($seatsDescription)
            ->setSeatsDescriptionShort($seatsDescriptionShort)
            ->setSeatsDetails($seatsDetails)
            ->setToBeFreedResources($toBeFreedResources)
            ->setTranLevel($tranLevel)
            ->setUserId($userId)
            ->setUserName($userName);
    }
    /**
     * Get AllocatedResources value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllocatedResources()
    {
        return isset($this->AllocatedResources) ? $this->AllocatedResources : null;
    }
    /**
     * Set AllocatedResources value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allocatedResources
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setAllocatedResources($allocatedResources = null)
    {
        // validation for constraint: string
        if (!is_null($allocatedResources) && !is_string($allocatedResources)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allocatedResources, true), gettype($allocatedResources)), __LINE__);
        }
        if (is_null($allocatedResources) || (is_array($allocatedResources) && empty($allocatedResources))) {
            unset($this->AllocatedResources);
        } else {
            $this->AllocatedResources = $allocatedResources;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get ClientDisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientDisplayName()
    {
        return isset($this->ClientDisplayName) ? $this->ClientDisplayName : null;
    }
    /**
     * Set ClientDisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientDisplayName
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setClientDisplayName($clientDisplayName = null)
    {
        // validation for constraint: string
        if (!is_null($clientDisplayName) && !is_string($clientDisplayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientDisplayName, true), gettype($clientDisplayName)), __LINE__);
        }
        if (is_null($clientDisplayName) || (is_array($clientDisplayName) && empty($clientDisplayName))) {
            unset($this->ClientDisplayName);
        } else {
            $this->ClientDisplayName = $clientDisplayName;
        }
        return $this;
    }
    /**
     * Get ContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextId()
    {
        return isset($this->ContextId) ? $this->ContextId : null;
    }
    /**
     * Set ContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextId
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setContextId($contextId = null)
    {
        // validation for constraint: string
        if (!is_null($contextId) && !is_string($contextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextId, true), gettype($contextId)), __LINE__);
        }
        if (is_null($contextId) || (is_array($contextId) && empty($contextId))) {
            unset($this->ContextId);
        } else {
            $this->ContextId = $contextId;
        }
        return $this;
    }
    /**
     * Get CreatedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedAt()
    {
        return isset($this->CreatedAt) ? $this->CreatedAt : null;
    }
    /**
     * Set CreatedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdAt
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setCreatedAt($createdAt = null)
    {
        // validation for constraint: string
        if (!is_null($createdAt) && !is_string($createdAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAt, true), gettype($createdAt)), __LINE__);
        }
        if (is_null($createdAt) || (is_array($createdAt) && empty($createdAt))) {
            unset($this->CreatedAt);
        } else {
            $this->CreatedAt = $createdAt;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get HeldSeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHeldSeatCount()
    {
        return isset($this->HeldSeatCount) ? $this->HeldSeatCount : null;
    }
    /**
     * Set HeldSeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $heldSeatCount
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setHeldSeatCount($heldSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($heldSeatCount) && !(is_int($heldSeatCount) || ctype_digit($heldSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heldSeatCount, true), gettype($heldSeatCount)), __LINE__);
        }
        if (is_null($heldSeatCount) || (is_array($heldSeatCount) && empty($heldSeatCount))) {
            unset($this->HeldSeatCount);
        } else {
            $this->HeldSeatCount = $heldSeatCount;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get InactivityDurationStr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInactivityDurationStr()
    {
        return isset($this->InactivityDurationStr) ? $this->InactivityDurationStr : null;
    }
    /**
     * Set InactivityDurationStr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inactivityDurationStr
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setInactivityDurationStr($inactivityDurationStr = null)
    {
        // validation for constraint: string
        if (!is_null($inactivityDurationStr) && !is_string($inactivityDurationStr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inactivityDurationStr, true), gettype($inactivityDurationStr)), __LINE__);
        }
        if (is_null($inactivityDurationStr) || (is_array($inactivityDurationStr) && empty($inactivityDurationStr))) {
            unset($this->InactivityDurationStr);
        } else {
            $this->InactivityDurationStr = $inactivityDurationStr;
        }
        return $this;
    }
    /**
     * Get IsOnHold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOnHold()
    {
        return isset($this->IsOnHold) ? $this->IsOnHold : null;
    }
    /**
     * Set IsOnHold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOnHold
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setIsOnHold($isOnHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnHold) && !is_bool($isOnHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnHold, true), gettype($isOnHold)), __LINE__);
        }
        if (is_null($isOnHold) || (is_array($isOnHold) && empty($isOnHold))) {
            unset($this->IsOnHold);
        } else {
            $this->IsOnHold = $isOnHold;
        }
        return $this;
    }
    /**
     * Get LastActivityAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastActivityAt()
    {
        return isset($this->LastActivityAt) ? $this->LastActivityAt : null;
    }
    /**
     * Set LastActivityAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastActivityAt
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setLastActivityAt($lastActivityAt = null)
    {
        // validation for constraint: string
        if (!is_null($lastActivityAt) && !is_string($lastActivityAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActivityAt, true), gettype($lastActivityAt)), __LINE__);
        }
        if (is_null($lastActivityAt) || (is_array($lastActivityAt) && empty($lastActivityAt))) {
            unset($this->LastActivityAt);
        } else {
            $this->LastActivityAt = $lastActivityAt;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get SeatsDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatsDescription()
    {
        return isset($this->SeatsDescription) ? $this->SeatsDescription : null;
    }
    /**
     * Set SeatsDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatsDescription
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setSeatsDescription($seatsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($seatsDescription) && !is_string($seatsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatsDescription, true), gettype($seatsDescription)), __LINE__);
        }
        if (is_null($seatsDescription) || (is_array($seatsDescription) && empty($seatsDescription))) {
            unset($this->SeatsDescription);
        } else {
            $this->SeatsDescription = $seatsDescription;
        }
        return $this;
    }
    /**
     * Get SeatsDescriptionShort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatsDescriptionShort()
    {
        return isset($this->SeatsDescriptionShort) ? $this->SeatsDescriptionShort : null;
    }
    /**
     * Set SeatsDescriptionShort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatsDescriptionShort
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setSeatsDescriptionShort($seatsDescriptionShort = null)
    {
        // validation for constraint: string
        if (!is_null($seatsDescriptionShort) && !is_string($seatsDescriptionShort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatsDescriptionShort, true), gettype($seatsDescriptionShort)), __LINE__);
        }
        if (is_null($seatsDescriptionShort) || (is_array($seatsDescriptionShort) && empty($seatsDescriptionShort))) {
            unset($this->SeatsDescriptionShort);
        } else {
            $this->SeatsDescriptionShort = $seatsDescriptionShort;
        }
        return $this;
    }
    /**
     * Get SeatsDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatsDetails()
    {
        return isset($this->SeatsDetails) ? $this->SeatsDetails : null;
    }
    /**
     * Set SeatsDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatsDetails
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setSeatsDetails($seatsDetails = null)
    {
        // validation for constraint: string
        if (!is_null($seatsDetails) && !is_string($seatsDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatsDetails, true), gettype($seatsDetails)), __LINE__);
        }
        if (is_null($seatsDetails) || (is_array($seatsDetails) && empty($seatsDetails))) {
            unset($this->SeatsDetails);
        } else {
            $this->SeatsDetails = $seatsDetails;
        }
        return $this;
    }
    /**
     * Get ToBeFreedResources value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToBeFreedResources()
    {
        return isset($this->ToBeFreedResources) ? $this->ToBeFreedResources : null;
    }
    /**
     * Set ToBeFreedResources value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toBeFreedResources
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setToBeFreedResources($toBeFreedResources = null)
    {
        // validation for constraint: string
        if (!is_null($toBeFreedResources) && !is_string($toBeFreedResources)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toBeFreedResources, true), gettype($toBeFreedResources)), __LINE__);
        }
        if (is_null($toBeFreedResources) || (is_array($toBeFreedResources) && empty($toBeFreedResources))) {
            unset($this->ToBeFreedResources);
        } else {
            $this->ToBeFreedResources = $toBeFreedResources;
        }
        return $this;
    }
    /**
     * Get TranLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTranLevel()
    {
        return isset($this->TranLevel) ? $this->TranLevel : null;
    }
    /**
     * Set TranLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tranLevel
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setTranLevel($tranLevel = null)
    {
        // validation for constraint: int
        if (!is_null($tranLevel) && !(is_int($tranLevel) || ctype_digit($tranLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tranLevel, true), gettype($tranLevel)), __LINE__);
        }
        if (is_null($tranLevel) || (is_array($tranLevel) && empty($tranLevel))) {
            unset($this->TranLevel);
        } else {
            $this->TranLevel = $tranLevel;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Ticketing_SeatingPlanManagerSession
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
