<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatingPlanAreaRuntimeInfo StructType
 * @subpackage Structs
 */
class Ticketing_SeatingPlanAreaRuntimeInfo extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The CapacityCounters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_SeatingPlanCapacityCounters
     */
    public $CapacityCounters;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The ScannedTicketCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScannedTicketCount;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatingType;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Ticketing.SeatingPlanAreaRuntimeInfo
     * @uses Ticketing_SeatingPlanAreaRuntimeInfo::setAreaId()
     * @uses Ticketing_SeatingPlanAreaRuntimeInfo::setCapacityCounters()
     * @uses Ticketing_SeatingPlanAreaRuntimeInfo::setName()
     * @uses Ticketing_SeatingPlanAreaRuntimeInfo::setScannedTicketCount()
     * @uses Ticketing_SeatingPlanAreaRuntimeInfo::setSeatingPlanId()
     * @uses Ticketing_SeatingPlanAreaRuntimeInfo::setSeatingType()
     * @uses Ticketing_SeatingPlanAreaRuntimeInfo::setStatus()
     * @param string $areaId
     * @param \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters
     * @param string $name
     * @param int $scannedTicketCount
     * @param string $seatingPlanId
     * @param string $seatingType
     * @param string $status
     */
    public function __construct($areaId = null, \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters = null, $name = null, $scannedTicketCount = null, $seatingPlanId = null, $seatingType = null, $status = null)
    {
        $this
            ->setAreaId($areaId)
            ->setCapacityCounters($capacityCounters)
            ->setName($name)
            ->setScannedTicketCount($scannedTicketCount)
            ->setSeatingPlanId($seatingPlanId)
            ->setSeatingType($seatingType)
            ->setStatus($status);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SeatingPlanAreaRuntimeInfo
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get CapacityCounters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_SeatingPlanCapacityCounters|null
     */
    public function getCapacityCounters()
    {
        return isset($this->CapacityCounters) ? $this->CapacityCounters : null;
    }
    /**
     * Set CapacityCounters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters
     * @return \patest\StructType\Ticketing_SeatingPlanAreaRuntimeInfo
     */
    public function setCapacityCounters(\patest\StructType\Ticketing_SeatingPlanCapacityCounters $capacityCounters = null)
    {
        if (is_null($capacityCounters) || (is_array($capacityCounters) && empty($capacityCounters))) {
            unset($this->CapacityCounters);
        } else {
            $this->CapacityCounters = $capacityCounters;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_SeatingPlanAreaRuntimeInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get ScannedTicketCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScannedTicketCount()
    {
        return isset($this->ScannedTicketCount) ? $this->ScannedTicketCount : null;
    }
    /**
     * Set ScannedTicketCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scannedTicketCount
     * @return \patest\StructType\Ticketing_SeatingPlanAreaRuntimeInfo
     */
    public function setScannedTicketCount($scannedTicketCount = null)
    {
        // validation for constraint: int
        if (!is_null($scannedTicketCount) && !(is_int($scannedTicketCount) || ctype_digit($scannedTicketCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scannedTicketCount, true), gettype($scannedTicketCount)), __LINE__);
        }
        if (is_null($scannedTicketCount) || (is_array($scannedTicketCount) && empty($scannedTicketCount))) {
            unset($this->ScannedTicketCount);
        } else {
            $this->ScannedTicketCount = $scannedTicketCount;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\Ticketing_SeatingPlanAreaRuntimeInfo
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get SeatingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingType()
    {
        return isset($this->SeatingType) ? $this->SeatingType : null;
    }
    /**
     * Set SeatingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\Ticketing_SeatingPlanAreaRuntimeInfo
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($seatingType) || (is_array($seatingType) && empty($seatingType))) {
            unset($this->SeatingType);
        } else {
            $this->SeatingType = $seatingType;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaMapStatus::valueIsValid()
     * @uses \patest\EnumType\AreaMapStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_SeatingPlanAreaRuntimeInfo
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaMapStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaMapStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\AreaMapStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
