<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatType StructType
 * @subpackage Structs
 */
class Ticketing_SeatType extends Ticketing_Base
{
    /**
     * The CssClassForOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CssClassForOnline;
    /**
     * The GraphicRepresentation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Graphics_GraphicRepresentation
     */
    public $GraphicRepresentation;
    /**
     * The IsAccessible
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccessible;
    /**
     * The IsInfillSeating
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInfillSeating;
    /**
     * The IsObstructedView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObstructedView;
    /**
     * The IsStandingRoomOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStandingRoomOnly;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.SeatType
     * @uses Ticketing_SeatType::setCssClassForOnline()
     * @uses Ticketing_SeatType::setGraphicRepresentation()
     * @uses Ticketing_SeatType::setIsAccessible()
     * @uses Ticketing_SeatType::setIsInfillSeating()
     * @uses Ticketing_SeatType::setIsObstructedView()
     * @uses Ticketing_SeatType::setIsStandingRoomOnly()
     * @uses Ticketing_SeatType::setName()
     * @uses Ticketing_SeatType::setNote()
     * @uses Ticketing_SeatType::setOrganizationUnitId()
     * @uses Ticketing_SeatType::setVisibleBySubordinates()
     * @param string $cssClassForOnline
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @param bool $isAccessible
     * @param bool $isInfillSeating
     * @param bool $isObstructedView
     * @param bool $isStandingRoomOnly
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\GlobalString $note
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($cssClassForOnline = null, \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null, $isAccessible = null, $isInfillSeating = null, $isObstructedView = null, $isStandingRoomOnly = null, \patest\StructType\GlobalString $name = null, \patest\StructType\GlobalString $note = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setCssClassForOnline($cssClassForOnline)
            ->setGraphicRepresentation($graphicRepresentation)
            ->setIsAccessible($isAccessible)
            ->setIsInfillSeating($isInfillSeating)
            ->setIsObstructedView($isObstructedView)
            ->setIsStandingRoomOnly($isStandingRoomOnly)
            ->setName($name)
            ->setNote($note)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get CssClassForOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCssClassForOnline()
    {
        return isset($this->CssClassForOnline) ? $this->CssClassForOnline : null;
    }
    /**
     * Set CssClassForOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cssClassForOnline
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setCssClassForOnline($cssClassForOnline = null)
    {
        // validation for constraint: string
        if (!is_null($cssClassForOnline) && !is_string($cssClassForOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cssClassForOnline, true), gettype($cssClassForOnline)), __LINE__);
        }
        if (is_null($cssClassForOnline) || (is_array($cssClassForOnline) && empty($cssClassForOnline))) {
            unset($this->CssClassForOnline);
        } else {
            $this->CssClassForOnline = $cssClassForOnline;
        }
        return $this;
    }
    /**
     * Get GraphicRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Graphics_GraphicRepresentation|null
     */
    public function getGraphicRepresentation()
    {
        return isset($this->GraphicRepresentation) ? $this->GraphicRepresentation : null;
    }
    /**
     * Set GraphicRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setGraphicRepresentation(\patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null)
    {
        if (is_null($graphicRepresentation) || (is_array($graphicRepresentation) && empty($graphicRepresentation))) {
            unset($this->GraphicRepresentation);
        } else {
            $this->GraphicRepresentation = $graphicRepresentation;
        }
        return $this;
    }
    /**
     * Get IsAccessible value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccessible()
    {
        return isset($this->IsAccessible) ? $this->IsAccessible : null;
    }
    /**
     * Set IsAccessible value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccessible
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setIsAccessible($isAccessible = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccessible) && !is_bool($isAccessible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccessible, true), gettype($isAccessible)), __LINE__);
        }
        if (is_null($isAccessible) || (is_array($isAccessible) && empty($isAccessible))) {
            unset($this->IsAccessible);
        } else {
            $this->IsAccessible = $isAccessible;
        }
        return $this;
    }
    /**
     * Get IsInfillSeating value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInfillSeating()
    {
        return isset($this->IsInfillSeating) ? $this->IsInfillSeating : null;
    }
    /**
     * Set IsInfillSeating value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInfillSeating
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setIsInfillSeating($isInfillSeating = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInfillSeating) && !is_bool($isInfillSeating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInfillSeating, true), gettype($isInfillSeating)), __LINE__);
        }
        if (is_null($isInfillSeating) || (is_array($isInfillSeating) && empty($isInfillSeating))) {
            unset($this->IsInfillSeating);
        } else {
            $this->IsInfillSeating = $isInfillSeating;
        }
        return $this;
    }
    /**
     * Get IsObstructedView value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObstructedView()
    {
        return isset($this->IsObstructedView) ? $this->IsObstructedView : null;
    }
    /**
     * Set IsObstructedView value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObstructedView
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setIsObstructedView($isObstructedView = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObstructedView) && !is_bool($isObstructedView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObstructedView, true), gettype($isObstructedView)), __LINE__);
        }
        if (is_null($isObstructedView) || (is_array($isObstructedView) && empty($isObstructedView))) {
            unset($this->IsObstructedView);
        } else {
            $this->IsObstructedView = $isObstructedView;
        }
        return $this;
    }
    /**
     * Get IsStandingRoomOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStandingRoomOnly()
    {
        return isset($this->IsStandingRoomOnly) ? $this->IsStandingRoomOnly : null;
    }
    /**
     * Set IsStandingRoomOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStandingRoomOnly
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setIsStandingRoomOnly($isStandingRoomOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStandingRoomOnly) && !is_bool($isStandingRoomOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStandingRoomOnly, true), gettype($isStandingRoomOnly)), __LINE__);
        }
        if (is_null($isStandingRoomOnly) || (is_array($isStandingRoomOnly) && empty($isStandingRoomOnly))) {
            unset($this->IsStandingRoomOnly);
        } else {
            $this->IsStandingRoomOnly = $isStandingRoomOnly;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_SeatType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
