<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SeatHistory StructType
 * @subpackage Structs
 */
class Ticketing_SeatHistory extends VolatileEntity
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditId;
    /**
     * The BinaryData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BinaryData;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Details;
    /**
     * The GuidPropertyNewValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidPropertyNewValue;
    /**
     * The GuidPropertyOldValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidPropertyOldValue;
    /**
     * The LayerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LayerId;
    /**
     * The LayerLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LayerLevel;
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ListPrice;
    /**
     * The OldBinaryData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldBinaryData;
    /**
     * The OperationDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationDescription;
    /**
     * The OperationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OperationId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeName;
    /**
     * The SeatActivity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatActivity;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The ServiceSpecificHandle
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificHandle;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalPrice;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for Ticketing.SeatHistory
     * @uses Ticketing_SeatHistory::setApplicationChannel()
     * @uses Ticketing_SeatHistory::setAreaId()
     * @uses Ticketing_SeatHistory::setAuditId()
     * @uses Ticketing_SeatHistory::setBinaryData()
     * @uses Ticketing_SeatHistory::setClientId()
     * @uses Ticketing_SeatHistory::setClientName()
     * @uses Ticketing_SeatHistory::setCrmId()
     * @uses Ticketing_SeatHistory::setDate()
     * @uses Ticketing_SeatHistory::setDetails()
     * @uses Ticketing_SeatHistory::setGuidPropertyNewValue()
     * @uses Ticketing_SeatHistory::setGuidPropertyOldValue()
     * @uses Ticketing_SeatHistory::setLayerId()
     * @uses Ticketing_SeatHistory::setLayerLevel()
     * @uses Ticketing_SeatHistory::setListPrice()
     * @uses Ticketing_SeatHistory::setOldBinaryData()
     * @uses Ticketing_SeatHistory::setOperationDescription()
     * @uses Ticketing_SeatHistory::setOperationId()
     * @uses Ticketing_SeatHistory::setPriceTypeName()
     * @uses Ticketing_SeatHistory::setSeatActivity()
     * @uses Ticketing_SeatHistory::setSeatIdInAreaMap()
     * @uses Ticketing_SeatHistory::setServiceSpecificHandle()
     * @uses Ticketing_SeatHistory::setTotalPrice()
     * @uses Ticketing_SeatHistory::setTransactionId()
     * @uses Ticketing_SeatHistory::setTransactionNumber()
     * @uses Ticketing_SeatHistory::setUserName()
     * @param string $applicationChannel
     * @param string $areaId
     * @param int $auditId
     * @param string $binaryData
     * @param string $clientId
     * @param string $clientName
     * @param string $crmId
     * @param string $date
     * @param string $details
     * @param string $guidPropertyNewValue
     * @param string $guidPropertyOldValue
     * @param string $layerId
     * @param string $layerLevel
     * @param float $listPrice
     * @param string $oldBinaryData
     * @param string $operationDescription
     * @param string $operationId
     * @param string $priceTypeName
     * @param string $seatActivity
     * @param int $seatIdInAreaMap
     * @param string $serviceSpecificHandle
     * @param float $totalPrice
     * @param string $transactionId
     * @param int $transactionNumber
     * @param string $userName
     */
    public function __construct($applicationChannel = null, $areaId = null, $auditId = null, $binaryData = null, $clientId = null, $clientName = null, $crmId = null, $date = null, $details = null, $guidPropertyNewValue = null, $guidPropertyOldValue = null, $layerId = null, $layerLevel = null, $listPrice = null, $oldBinaryData = null, $operationDescription = null, $operationId = null, $priceTypeName = null, $seatActivity = null, $seatIdInAreaMap = null, $serviceSpecificHandle = null, $totalPrice = null, $transactionId = null, $transactionNumber = null, $userName = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setAreaId($areaId)
            ->setAuditId($auditId)
            ->setBinaryData($binaryData)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setCrmId($crmId)
            ->setDate($date)
            ->setDetails($details)
            ->setGuidPropertyNewValue($guidPropertyNewValue)
            ->setGuidPropertyOldValue($guidPropertyOldValue)
            ->setLayerId($layerId)
            ->setLayerLevel($layerLevel)
            ->setListPrice($listPrice)
            ->setOldBinaryData($oldBinaryData)
            ->setOperationDescription($operationDescription)
            ->setOperationId($operationId)
            ->setPriceTypeName($priceTypeName)
            ->setSeatActivity($seatActivity)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setServiceSpecificHandle($serviceSpecificHandle)
            ->setTotalPrice($totalPrice)
            ->setTransactionId($transactionId)
            ->setTransactionNumber($transactionNumber)
            ->setUserName($userName);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditId()
    {
        return isset($this->AuditId) ? $this->AuditId : null;
    }
    /**
     * Set AuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditId
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        if (is_null($auditId) || (is_array($auditId) && empty($auditId))) {
            unset($this->AuditId);
        } else {
            $this->AuditId = $auditId;
        }
        return $this;
    }
    /**
     * Get BinaryData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBinaryData()
    {
        return isset($this->BinaryData) ? $this->BinaryData : null;
    }
    /**
     * Set BinaryData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $binaryData
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setBinaryData($binaryData = null)
    {
        // validation for constraint: string
        if (!is_null($binaryData) && !is_string($binaryData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($binaryData, true), gettype($binaryData)), __LINE__);
        }
        if (is_null($binaryData) || (is_array($binaryData) && empty($binaryData))) {
            unset($this->BinaryData);
        } else {
            $this->BinaryData = $binaryData;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $details
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setDetails($details = null)
    {
        // validation for constraint: string
        if (!is_null($details) && !is_string($details)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($details, true), gettype($details)), __LINE__);
        }
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get GuidPropertyNewValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidPropertyNewValue()
    {
        return isset($this->GuidPropertyNewValue) ? $this->GuidPropertyNewValue : null;
    }
    /**
     * Set GuidPropertyNewValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidPropertyNewValue
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setGuidPropertyNewValue($guidPropertyNewValue = null)
    {
        // validation for constraint: string
        if (!is_null($guidPropertyNewValue) && !is_string($guidPropertyNewValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidPropertyNewValue, true), gettype($guidPropertyNewValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidPropertyNewValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidPropertyNewValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidPropertyNewValue, true)), __LINE__);
        }
        if (is_null($guidPropertyNewValue) || (is_array($guidPropertyNewValue) && empty($guidPropertyNewValue))) {
            unset($this->GuidPropertyNewValue);
        } else {
            $this->GuidPropertyNewValue = $guidPropertyNewValue;
        }
        return $this;
    }
    /**
     * Get GuidPropertyOldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidPropertyOldValue()
    {
        return isset($this->GuidPropertyOldValue) ? $this->GuidPropertyOldValue : null;
    }
    /**
     * Set GuidPropertyOldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidPropertyOldValue
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setGuidPropertyOldValue($guidPropertyOldValue = null)
    {
        // validation for constraint: string
        if (!is_null($guidPropertyOldValue) && !is_string($guidPropertyOldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidPropertyOldValue, true), gettype($guidPropertyOldValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidPropertyOldValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidPropertyOldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidPropertyOldValue, true)), __LINE__);
        }
        if (is_null($guidPropertyOldValue) || (is_array($guidPropertyOldValue) && empty($guidPropertyOldValue))) {
            unset($this->GuidPropertyOldValue);
        } else {
            $this->GuidPropertyOldValue = $guidPropertyOldValue;
        }
        return $this;
    }
    /**
     * Get LayerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerId()
    {
        return isset($this->LayerId) ? $this->LayerId : null;
    }
    /**
     * Set LayerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $layerId
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setLayerId($layerId = null)
    {
        // validation for constraint: string
        if (!is_null($layerId) && !is_string($layerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layerId, true), gettype($layerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($layerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $layerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($layerId, true)), __LINE__);
        }
        if (is_null($layerId) || (is_array($layerId) && empty($layerId))) {
            unset($this->LayerId);
        } else {
            $this->LayerId = $layerId;
        }
        return $this;
    }
    /**
     * Get LayerLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLayerLevel()
    {
        return isset($this->LayerLevel) ? $this->LayerLevel : null;
    }
    /**
     * Set LayerLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LayerLevel::valueIsValid()
     * @uses \patest\EnumType\LayerLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layerLevel
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setLayerLevel($layerLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerLevel::valueIsValid($layerLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerLevel', is_array($layerLevel) ? implode(', ', $layerLevel) : var_export($layerLevel, true), implode(', ', \patest\EnumType\LayerLevel::getValidValues())), __LINE__);
        }
        if (is_null($layerLevel) || (is_array($layerLevel) && empty($layerLevel))) {
            unset($this->LayerLevel);
        } else {
            $this->LayerLevel = $layerLevel;
        }
        return $this;
    }
    /**
     * Get ListPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getListPrice()
    {
        return isset($this->ListPrice) ? $this->ListPrice : null;
    }
    /**
     * Set ListPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $listPrice
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setListPrice($listPrice = null)
    {
        // validation for constraint: float
        if (!is_null($listPrice) && !(is_float($listPrice) || is_numeric($listPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($listPrice, true), gettype($listPrice)), __LINE__);
        }
        if (is_null($listPrice) || (is_array($listPrice) && empty($listPrice))) {
            unset($this->ListPrice);
        } else {
            $this->ListPrice = $listPrice;
        }
        return $this;
    }
    /**
     * Get OldBinaryData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldBinaryData()
    {
        return isset($this->OldBinaryData) ? $this->OldBinaryData : null;
    }
    /**
     * Set OldBinaryData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldBinaryData
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setOldBinaryData($oldBinaryData = null)
    {
        // validation for constraint: string
        if (!is_null($oldBinaryData) && !is_string($oldBinaryData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldBinaryData, true), gettype($oldBinaryData)), __LINE__);
        }
        if (is_null($oldBinaryData) || (is_array($oldBinaryData) && empty($oldBinaryData))) {
            unset($this->OldBinaryData);
        } else {
            $this->OldBinaryData = $oldBinaryData;
        }
        return $this;
    }
    /**
     * Get OperationDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationDescription()
    {
        return isset($this->OperationDescription) ? $this->OperationDescription : null;
    }
    /**
     * Set OperationDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationDescription
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setOperationDescription($operationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($operationDescription) && !is_string($operationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationDescription, true), gettype($operationDescription)), __LINE__);
        }
        if (is_null($operationDescription) || (is_array($operationDescription) && empty($operationDescription))) {
            unset($this->OperationDescription);
        } else {
            $this->OperationDescription = $operationDescription;
        }
        return $this;
    }
    /**
     * Get OperationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationId()
    {
        return isset($this->OperationId) ? $this->OperationId : null;
    }
    /**
     * Set OperationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationId
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setOperationId($operationId = null)
    {
        // validation for constraint: string
        if (!is_null($operationId) && !is_string($operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationId, true), gettype($operationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($operationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $operationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($operationId, true)), __LINE__);
        }
        if (is_null($operationId) || (is_array($operationId) && empty($operationId))) {
            unset($this->OperationId);
        } else {
            $this->OperationId = $operationId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeName
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setPriceTypeName($priceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeName) && !is_string($priceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeName, true), gettype($priceTypeName)), __LINE__);
        }
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get SeatActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatActivity()
    {
        return isset($this->SeatActivity) ? $this->SeatActivity : null;
    }
    /**
     * Set SeatActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatActivity::valueIsValid()
     * @uses \patest\EnumType\SeatActivity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatActivity
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setSeatActivity($seatActivity = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatActivity::valueIsValid($seatActivity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatActivity', is_array($seatActivity) ? implode(', ', $seatActivity) : var_export($seatActivity, true), implode(', ', \patest\EnumType\SeatActivity::getValidValues())), __LINE__);
        }
        if (is_null($seatActivity) || (is_array($seatActivity) && empty($seatActivity))) {
            unset($this->SeatActivity);
        } else {
            $this->SeatActivity = $seatActivity;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificHandle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificHandle()
    {
        return isset($this->ServiceSpecificHandle) ? $this->ServiceSpecificHandle : null;
    }
    /**
     * Set ServiceSpecificHandle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificHandle
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setServiceSpecificHandle($serviceSpecificHandle = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificHandle) && !is_string($serviceSpecificHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificHandle, true), gettype($serviceSpecificHandle)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificHandle) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificHandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificHandle, true)), __LINE__);
        }
        if (is_null($serviceSpecificHandle) || (is_array($serviceSpecificHandle) && empty($serviceSpecificHandle))) {
            unset($this->ServiceSpecificHandle);
        } else {
            $this->ServiceSpecificHandle = $serviceSpecificHandle;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalPrice
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Ticketing_SeatHistory
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
