<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.SalesSeriesEventFilter StructType
 * @subpackage Structs
 */
class Ticketing_SalesSeriesEventFilter extends FilterEntity
{
    /**
     * The DayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DayOfWeek;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $SaleStatus;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for Ticketing.SalesSeriesEventFilter
     * @uses Ticketing_SalesSeriesEventFilter::setDayOfWeek()
     * @uses Ticketing_SalesSeriesEventFilter::setFromDate()
     * @uses Ticketing_SalesSeriesEventFilter::setId()
     * @uses Ticketing_SalesSeriesEventFilter::setSaleStatus()
     * @uses Ticketing_SalesSeriesEventFilter::setShowId()
     * @uses Ticketing_SalesSeriesEventFilter::setToDate()
     * @param string $dayOfWeek
     * @param string $fromDate
     * @param string $id
     * @param string[] $saleStatus
     * @param string $showId
     * @param string $toDate
     */
    public function __construct($dayOfWeek = null, $fromDate = null, $id = null, array $saleStatus = array(), $showId = null, $toDate = null)
    {
        $this
            ->setDayOfWeek($dayOfWeek)
            ->setFromDate($fromDate)
            ->setId($id)
            ->setSaleStatus($saleStatus)
            ->setShowId($showId)
            ->setToDate($toDate);
    }
    /**
     * Get DayOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return isset($this->DayOfWeek) ? $this->DayOfWeek : null;
    }
    /**
     * Set DayOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dayOfWeek
     * @return \patest\StructType\Ticketing_SalesSeriesEventFilter
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($dayOfWeek) && !is_string($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayOfWeek, true), gettype($dayOfWeek)), __LINE__);
        }
        if (is_null($dayOfWeek) || (is_array($dayOfWeek) && empty($dayOfWeek))) {
            unset($this->DayOfWeek);
        } else {
            $this->DayOfWeek = $dayOfWeek;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Ticketing_SalesSeriesEventFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_SalesSeriesEventFilter
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getSaleStatus()
    {
        return isset($this->SaleStatus) ? $this->SaleStatus : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSaleStatus method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSaleStatus method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSaleStatusForArrayConstraintsFromSetSaleStatus(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ticketing_SalesSeriesEventFilterSaleStatusItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EventSaleStatus::valueIsValid($ticketing_SalesSeriesEventFilterSaleStatusItem)) {
                $invalidValues[] = is_object($ticketing_SalesSeriesEventFilterSaleStatusItem) ? get_class($ticketing_SalesSeriesEventFilterSaleStatusItem) : sprintf('%s(%s)', gettype($ticketing_SalesSeriesEventFilterSaleStatusItem), var_export($ticketing_SalesSeriesEventFilterSaleStatusItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventSaleStatus', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EventSaleStatus::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventSaleStatus::valueIsValid()
     * @uses \patest\EnumType\EventSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $saleStatus
     * @return \patest\StructType\Ticketing_SalesSeriesEventFilter
     */
    public function setSaleStatus(array $saleStatus = array())
    {
        // validation for constraint: list
        if ('' !== ($saleStatusArrayErrorMessage = self::validateSaleStatusForArrayConstraintsFromSetSaleStatus($saleStatus))) {
            throw new \InvalidArgumentException($saleStatusArrayErrorMessage, __LINE__);
        }
        if (is_null($saleStatus) || (is_array($saleStatus) && empty($saleStatus))) {
            unset($this->SaleStatus);
        } else {
            $this->SaleStatus = is_array($saleStatus) ? implode(' ', $saleStatus) : null;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showId
     * @return \patest\StructType\Ticketing_SalesSeriesEventFilter
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Ticketing_SalesSeriesEventFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
