<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.RestrictionExpiryDefinition StructType
 * @subpackage Structs
 */
class Ticketing_RestrictionExpiryDefinition extends PersistableEntity
{
    /**
     * The ExpiresAtDisplayString
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiresAtDisplayString;
    /**
     * The HourAtSpecificDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HourAtSpecificDay;
    /**
     * The NumDaysBeforeEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumDaysBeforeEvent;
    /**
     * The RestrictionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionId;
    /**
     * The RestrictionType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionType;
    /**
     * The ScopeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScopeId;
    /**
     * The ScopeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScopeNumber;
    /**
     * The ScopeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScopeType;
    /**
     * The SpecificDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecificDate;
    /**
     * The TimeDelta
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $TimeDelta;
    /**
     * The When
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $When;
    /**
     * Constructor method for Ticketing.RestrictionExpiryDefinition
     * @uses Ticketing_RestrictionExpiryDefinition::setExpiresAtDisplayString()
     * @uses Ticketing_RestrictionExpiryDefinition::setHourAtSpecificDay()
     * @uses Ticketing_RestrictionExpiryDefinition::setNumDaysBeforeEvent()
     * @uses Ticketing_RestrictionExpiryDefinition::setRestrictionId()
     * @uses Ticketing_RestrictionExpiryDefinition::setRestrictionType()
     * @uses Ticketing_RestrictionExpiryDefinition::setScopeId()
     * @uses Ticketing_RestrictionExpiryDefinition::setScopeNumber()
     * @uses Ticketing_RestrictionExpiryDefinition::setScopeType()
     * @uses Ticketing_RestrictionExpiryDefinition::setSpecificDate()
     * @uses Ticketing_RestrictionExpiryDefinition::setTimeDelta()
     * @uses Ticketing_RestrictionExpiryDefinition::setWhen()
     * @param string $expiresAtDisplayString
     * @param string $hourAtSpecificDay
     * @param int $numDaysBeforeEvent
     * @param string $restrictionId
     * @param string $restrictionType
     * @param string $scopeId
     * @param int $scopeNumber
     * @param string $scopeType
     * @param string $specificDate
     * @param string $timeDelta
     * @param string $when
     */
    public function __construct($expiresAtDisplayString = null, $hourAtSpecificDay = null, $numDaysBeforeEvent = null, $restrictionId = null, $restrictionType = null, $scopeId = null, $scopeNumber = null, $scopeType = null, $specificDate = null, $timeDelta = null, $when = null)
    {
        $this
            ->setExpiresAtDisplayString($expiresAtDisplayString)
            ->setHourAtSpecificDay($hourAtSpecificDay)
            ->setNumDaysBeforeEvent($numDaysBeforeEvent)
            ->setRestrictionId($restrictionId)
            ->setRestrictionType($restrictionType)
            ->setScopeId($scopeId)
            ->setScopeNumber($scopeNumber)
            ->setScopeType($scopeType)
            ->setSpecificDate($specificDate)
            ->setTimeDelta($timeDelta)
            ->setWhen($when);
    }
    /**
     * Get ExpiresAtDisplayString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiresAtDisplayString()
    {
        return isset($this->ExpiresAtDisplayString) ? $this->ExpiresAtDisplayString : null;
    }
    /**
     * Set ExpiresAtDisplayString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiresAtDisplayString
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setExpiresAtDisplayString($expiresAtDisplayString = null)
    {
        // validation for constraint: string
        if (!is_null($expiresAtDisplayString) && !is_string($expiresAtDisplayString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiresAtDisplayString, true), gettype($expiresAtDisplayString)), __LINE__);
        }
        if (is_null($expiresAtDisplayString) || (is_array($expiresAtDisplayString) && empty($expiresAtDisplayString))) {
            unset($this->ExpiresAtDisplayString);
        } else {
            $this->ExpiresAtDisplayString = $expiresAtDisplayString;
        }
        return $this;
    }
    /**
     * Get HourAtSpecificDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHourAtSpecificDay()
    {
        return isset($this->HourAtSpecificDay) ? $this->HourAtSpecificDay : null;
    }
    /**
     * Set HourAtSpecificDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hourAtSpecificDay
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setHourAtSpecificDay($hourAtSpecificDay = null)
    {
        // validation for constraint: string
        if (!is_null($hourAtSpecificDay) && !is_string($hourAtSpecificDay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hourAtSpecificDay, true), gettype($hourAtSpecificDay)), __LINE__);
        }
        if (is_null($hourAtSpecificDay) || (is_array($hourAtSpecificDay) && empty($hourAtSpecificDay))) {
            unset($this->HourAtSpecificDay);
        } else {
            $this->HourAtSpecificDay = $hourAtSpecificDay;
        }
        return $this;
    }
    /**
     * Get NumDaysBeforeEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumDaysBeforeEvent()
    {
        return isset($this->NumDaysBeforeEvent) ? $this->NumDaysBeforeEvent : null;
    }
    /**
     * Set NumDaysBeforeEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numDaysBeforeEvent
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setNumDaysBeforeEvent($numDaysBeforeEvent = null)
    {
        // validation for constraint: int
        if (!is_null($numDaysBeforeEvent) && !(is_int($numDaysBeforeEvent) || ctype_digit($numDaysBeforeEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numDaysBeforeEvent, true), gettype($numDaysBeforeEvent)), __LINE__);
        }
        if (is_null($numDaysBeforeEvent) || (is_array($numDaysBeforeEvent) && empty($numDaysBeforeEvent))) {
            unset($this->NumDaysBeforeEvent);
        } else {
            $this->NumDaysBeforeEvent = $numDaysBeforeEvent;
        }
        return $this;
    }
    /**
     * Get RestrictionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionId()
    {
        return isset($this->RestrictionId) ? $this->RestrictionId : null;
    }
    /**
     * Set RestrictionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionId
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setRestrictionId($restrictionId = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionId) && !is_string($restrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionId, true), gettype($restrictionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionId, true)), __LINE__);
        }
        if (is_null($restrictionId) || (is_array($restrictionId) && empty($restrictionId))) {
            unset($this->RestrictionId);
        } else {
            $this->RestrictionId = $restrictionId;
        }
        return $this;
    }
    /**
     * Get RestrictionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionType()
    {
        return isset($this->RestrictionType) ? $this->RestrictionType : null;
    }
    /**
     * Set RestrictionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RestrictionType::valueIsValid()
     * @uses \patest\EnumType\RestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionType
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setRestrictionType($restrictionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionType::valueIsValid($restrictionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionType', is_array($restrictionType) ? implode(', ', $restrictionType) : var_export($restrictionType, true), implode(', ', \patest\EnumType\RestrictionType::getValidValues())), __LINE__);
        }
        if (is_null($restrictionType) || (is_array($restrictionType) && empty($restrictionType))) {
            unset($this->RestrictionType);
        } else {
            $this->RestrictionType = $restrictionType;
        }
        return $this;
    }
    /**
     * Get ScopeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScopeId()
    {
        return isset($this->ScopeId) ? $this->ScopeId : null;
    }
    /**
     * Set ScopeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scopeId
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setScopeId($scopeId = null)
    {
        // validation for constraint: string
        if (!is_null($scopeId) && !is_string($scopeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scopeId, true), gettype($scopeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scopeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scopeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scopeId, true)), __LINE__);
        }
        if (is_null($scopeId) || (is_array($scopeId) && empty($scopeId))) {
            unset($this->ScopeId);
        } else {
            $this->ScopeId = $scopeId;
        }
        return $this;
    }
    /**
     * Get ScopeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScopeNumber()
    {
        return isset($this->ScopeNumber) ? $this->ScopeNumber : null;
    }
    /**
     * Set ScopeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scopeNumber
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setScopeNumber($scopeNumber = null)
    {
        // validation for constraint: int
        if (!is_null($scopeNumber) && !(is_int($scopeNumber) || ctype_digit($scopeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scopeNumber, true), gettype($scopeNumber)), __LINE__);
        }
        if (is_null($scopeNumber) || (is_array($scopeNumber) && empty($scopeNumber))) {
            unset($this->ScopeNumber);
        } else {
            $this->ScopeNumber = $scopeNumber;
        }
        return $this;
    }
    /**
     * Get ScopeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScopeType()
    {
        return isset($this->ScopeType) ? $this->ScopeType : null;
    }
    /**
     * Set ScopeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LimitationScopeType::valueIsValid()
     * @uses \patest\EnumType\LimitationScopeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scopeType
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setScopeType($scopeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LimitationScopeType::valueIsValid($scopeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LimitationScopeType', is_array($scopeType) ? implode(', ', $scopeType) : var_export($scopeType, true), implode(', ', \patest\EnumType\LimitationScopeType::getValidValues())), __LINE__);
        }
        if (is_null($scopeType) || (is_array($scopeType) && empty($scopeType))) {
            unset($this->ScopeType);
        } else {
            $this->ScopeType = $scopeType;
        }
        return $this;
    }
    /**
     * Get SpecificDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificDate()
    {
        return isset($this->SpecificDate) ? $this->SpecificDate : null;
    }
    /**
     * Set SpecificDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificDate
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setSpecificDate($specificDate = null)
    {
        // validation for constraint: string
        if (!is_null($specificDate) && !is_string($specificDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificDate, true), gettype($specificDate)), __LINE__);
        }
        if (is_null($specificDate) || (is_array($specificDate) && empty($specificDate))) {
            unset($this->SpecificDate);
        } else {
            $this->SpecificDate = $specificDate;
        }
        return $this;
    }
    /**
     * Get TimeDelta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeDelta()
    {
        return isset($this->TimeDelta) ? $this->TimeDelta : null;
    }
    /**
     * Set TimeDelta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeDelta
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setTimeDelta($timeDelta = null)
    {
        // validation for constraint: string
        if (!is_null($timeDelta) && !is_string($timeDelta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDelta, true), gettype($timeDelta)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($timeDelta) && false === mb_strpos($timeDelta, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $timeDelta)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($timeDelta, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($timeDelta) && false !== mb_strpos($timeDelta, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $timeDelta)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($timeDelta, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($timeDelta) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $timeDelta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($timeDelta, true)), __LINE__);
        }
        if (is_null($timeDelta) || (is_array($timeDelta) && empty($timeDelta))) {
            unset($this->TimeDelta);
        } else {
            $this->TimeDelta = $timeDelta;
        }
        return $this;
    }
    /**
     * Get When value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWhen()
    {
        return isset($this->When) ? $this->When : null;
    }
    /**
     * Set When value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ActionDateTypes::valueIsValid()
     * @uses \patest\EnumType\ActionDateTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $when
     * @return \patest\StructType\Ticketing_RestrictionExpiryDefinition
     */
    public function setWhen($when = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ActionDateTypes::valueIsValid($when)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ActionDateTypes', is_array($when) ? implode(', ', $when) : var_export($when, true), implode(', ', \patest\EnumType\ActionDateTypes::getValidValues())), __LINE__);
        }
        if (is_null($when) || (is_array($when) && empty($when))) {
            unset($this->When);
        } else {
            $this->When = $when;
        }
        return $this;
    }
}
