<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Restriction StructType
 * @subpackage Structs
 */
class Ticketing_Restriction extends Ticketing_Base
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CountWithAvailableSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CountWithAvailableSeats;
    /**
     * The ExcludeLockFromCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExcludeLockFromCapacity;
    /**
     * The Exclusive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Exclusive;
    /**
     * The GraphicRepresentation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Graphics_GraphicRepresentation
     */
    public $GraphicRepresentation;
    /**
     * The Identification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Identification;
    /**
     * The IsFullBlockSaleOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullBlockSaleOnly;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The QualifiedClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QualifiedClientTypeIds
     */
    public $QualifiedClientTypeIds;
    /**
     * The QualifiedOrganizationUnitIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QualifiedOrganizationUnitIds
     */
    public $QualifiedOrganizationUnitIds;
    /**
     * The QualifiedPriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QualifiedPriceTypeIds
     */
    public $QualifiedPriceTypeIds;
    /**
     * The QualifiedSeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QualifiedSeriesIds
     */
    public $QualifiedSeriesIds;
    /**
     * The QualifiedUserGroupIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QualifiedUserGroupIds
     */
    public $QualifiedUserGroupIds;
    /**
     * The QualifiedWorkflowTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QualifiedWorkflowTypes;
    /**
     * The RestrictionGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RestrictionGroupId;
    /**
     * The RestrictionTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionTarget;
    /**
     * The RestrictionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RestrictionType;
    /**
     * The SkipPreservedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipPreservedSeats;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.Restriction
     * @uses Ticketing_Restriction::setAclSchemeId()
     * @uses Ticketing_Restriction::setCountWithAvailableSeats()
     * @uses Ticketing_Restriction::setExcludeLockFromCapacity()
     * @uses Ticketing_Restriction::setExclusive()
     * @uses Ticketing_Restriction::setGraphicRepresentation()
     * @uses Ticketing_Restriction::setIdentification()
     * @uses Ticketing_Restriction::setIsFullBlockSaleOnly()
     * @uses Ticketing_Restriction::setName()
     * @uses Ticketing_Restriction::setOrganizationUnitId()
     * @uses Ticketing_Restriction::setQualifiedClientTypeIds()
     * @uses Ticketing_Restriction::setQualifiedOrganizationUnitIds()
     * @uses Ticketing_Restriction::setQualifiedPriceTypeIds()
     * @uses Ticketing_Restriction::setQualifiedSeriesIds()
     * @uses Ticketing_Restriction::setQualifiedUserGroupIds()
     * @uses Ticketing_Restriction::setQualifiedWorkflowTypes()
     * @uses Ticketing_Restriction::setRestrictionGroupId()
     * @uses Ticketing_Restriction::setRestrictionTarget()
     * @uses Ticketing_Restriction::setRestrictionType()
     * @uses Ticketing_Restriction::setSkipPreservedSeats()
     * @uses Ticketing_Restriction::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param bool $countWithAvailableSeats
     * @param bool $excludeLockFromCapacity
     * @param bool $exclusive
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @param string $identification
     * @param bool $isFullBlockSaleOnly
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param \patest\StructType\QualifiedClientTypeIds $qualifiedClientTypeIds
     * @param \patest\StructType\QualifiedOrganizationUnitIds $qualifiedOrganizationUnitIds
     * @param \patest\StructType\QualifiedPriceTypeIds $qualifiedPriceTypeIds
     * @param \patest\StructType\QualifiedSeriesIds $qualifiedSeriesIds
     * @param \patest\StructType\QualifiedUserGroupIds $qualifiedUserGroupIds
     * @param string $qualifiedWorkflowTypes
     * @param string $restrictionGroupId
     * @param string $restrictionTarget
     * @param string $restrictionType
     * @param bool $skipPreservedSeats
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, $countWithAvailableSeats = null, $excludeLockFromCapacity = null, $exclusive = null, \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null, $identification = null, $isFullBlockSaleOnly = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, \patest\StructType\QualifiedClientTypeIds $qualifiedClientTypeIds = null, \patest\StructType\QualifiedOrganizationUnitIds $qualifiedOrganizationUnitIds = null, \patest\StructType\QualifiedPriceTypeIds $qualifiedPriceTypeIds = null, \patest\StructType\QualifiedSeriesIds $qualifiedSeriesIds = null, \patest\StructType\QualifiedUserGroupIds $qualifiedUserGroupIds = null, $qualifiedWorkflowTypes = null, $restrictionGroupId = null, $restrictionTarget = null, $restrictionType = null, $skipPreservedSeats = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setCountWithAvailableSeats($countWithAvailableSeats)
            ->setExcludeLockFromCapacity($excludeLockFromCapacity)
            ->setExclusive($exclusive)
            ->setGraphicRepresentation($graphicRepresentation)
            ->setIdentification($identification)
            ->setIsFullBlockSaleOnly($isFullBlockSaleOnly)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setQualifiedClientTypeIds($qualifiedClientTypeIds)
            ->setQualifiedOrganizationUnitIds($qualifiedOrganizationUnitIds)
            ->setQualifiedPriceTypeIds($qualifiedPriceTypeIds)
            ->setQualifiedSeriesIds($qualifiedSeriesIds)
            ->setQualifiedUserGroupIds($qualifiedUserGroupIds)
            ->setQualifiedWorkflowTypes($qualifiedWorkflowTypes)
            ->setRestrictionGroupId($restrictionGroupId)
            ->setRestrictionTarget($restrictionTarget)
            ->setRestrictionType($restrictionType)
            ->setSkipPreservedSeats($skipPreservedSeats)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CountWithAvailableSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCountWithAvailableSeats()
    {
        return isset($this->CountWithAvailableSeats) ? $this->CountWithAvailableSeats : null;
    }
    /**
     * Set CountWithAvailableSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $countWithAvailableSeats
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setCountWithAvailableSeats($countWithAvailableSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($countWithAvailableSeats) && !is_bool($countWithAvailableSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($countWithAvailableSeats, true), gettype($countWithAvailableSeats)), __LINE__);
        }
        if (is_null($countWithAvailableSeats) || (is_array($countWithAvailableSeats) && empty($countWithAvailableSeats))) {
            unset($this->CountWithAvailableSeats);
        } else {
            $this->CountWithAvailableSeats = $countWithAvailableSeats;
        }
        return $this;
    }
    /**
     * Get ExcludeLockFromCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExcludeLockFromCapacity()
    {
        return isset($this->ExcludeLockFromCapacity) ? $this->ExcludeLockFromCapacity : null;
    }
    /**
     * Set ExcludeLockFromCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $excludeLockFromCapacity
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setExcludeLockFromCapacity($excludeLockFromCapacity = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeLockFromCapacity) && !is_bool($excludeLockFromCapacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeLockFromCapacity, true), gettype($excludeLockFromCapacity)), __LINE__);
        }
        if (is_null($excludeLockFromCapacity) || (is_array($excludeLockFromCapacity) && empty($excludeLockFromCapacity))) {
            unset($this->ExcludeLockFromCapacity);
        } else {
            $this->ExcludeLockFromCapacity = $excludeLockFromCapacity;
        }
        return $this;
    }
    /**
     * Get Exclusive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclusive()
    {
        return isset($this->Exclusive) ? $this->Exclusive : null;
    }
    /**
     * Set Exclusive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclusive
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setExclusive($exclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclusive) && !is_bool($exclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($exclusive, true), gettype($exclusive)), __LINE__);
        }
        if (is_null($exclusive) || (is_array($exclusive) && empty($exclusive))) {
            unset($this->Exclusive);
        } else {
            $this->Exclusive = $exclusive;
        }
        return $this;
    }
    /**
     * Get GraphicRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Graphics_GraphicRepresentation|null
     */
    public function getGraphicRepresentation()
    {
        return isset($this->GraphicRepresentation) ? $this->GraphicRepresentation : null;
    }
    /**
     * Set GraphicRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setGraphicRepresentation(\patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null)
    {
        if (is_null($graphicRepresentation) || (is_array($graphicRepresentation) && empty($graphicRepresentation))) {
            unset($this->GraphicRepresentation);
        } else {
            $this->GraphicRepresentation = $graphicRepresentation;
        }
        return $this;
    }
    /**
     * Get Identification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentification()
    {
        return isset($this->Identification) ? $this->Identification : null;
    }
    /**
     * Set Identification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RestrictionIdentification::valueIsValid()
     * @uses \patest\EnumType\RestrictionIdentification::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identification
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setIdentification($identification = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionIdentification::valueIsValid($identification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionIdentification', is_array($identification) ? implode(', ', $identification) : var_export($identification, true), implode(', ', \patest\EnumType\RestrictionIdentification::getValidValues())), __LINE__);
        }
        if (is_null($identification) || (is_array($identification) && empty($identification))) {
            unset($this->Identification);
        } else {
            $this->Identification = $identification;
        }
        return $this;
    }
    /**
     * Get IsFullBlockSaleOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullBlockSaleOnly()
    {
        return isset($this->IsFullBlockSaleOnly) ? $this->IsFullBlockSaleOnly : null;
    }
    /**
     * Set IsFullBlockSaleOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullBlockSaleOnly
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setIsFullBlockSaleOnly($isFullBlockSaleOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullBlockSaleOnly) && !is_bool($isFullBlockSaleOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullBlockSaleOnly, true), gettype($isFullBlockSaleOnly)), __LINE__);
        }
        if (is_null($isFullBlockSaleOnly) || (is_array($isFullBlockSaleOnly) && empty($isFullBlockSaleOnly))) {
            unset($this->IsFullBlockSaleOnly);
        } else {
            $this->IsFullBlockSaleOnly = $isFullBlockSaleOnly;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get QualifiedClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QualifiedClientTypeIds|null
     */
    public function getQualifiedClientTypeIds()
    {
        return isset($this->QualifiedClientTypeIds) ? $this->QualifiedClientTypeIds : null;
    }
    /**
     * Set QualifiedClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QualifiedClientTypeIds $qualifiedClientTypeIds
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setQualifiedClientTypeIds(\patest\StructType\QualifiedClientTypeIds $qualifiedClientTypeIds = null)
    {
        if (is_null($qualifiedClientTypeIds) || (is_array($qualifiedClientTypeIds) && empty($qualifiedClientTypeIds))) {
            unset($this->QualifiedClientTypeIds);
        } else {
            $this->QualifiedClientTypeIds = $qualifiedClientTypeIds;
        }
        return $this;
    }
    /**
     * Get QualifiedOrganizationUnitIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QualifiedOrganizationUnitIds|null
     */
    public function getQualifiedOrganizationUnitIds()
    {
        return isset($this->QualifiedOrganizationUnitIds) ? $this->QualifiedOrganizationUnitIds : null;
    }
    /**
     * Set QualifiedOrganizationUnitIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QualifiedOrganizationUnitIds $qualifiedOrganizationUnitIds
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setQualifiedOrganizationUnitIds(\patest\StructType\QualifiedOrganizationUnitIds $qualifiedOrganizationUnitIds = null)
    {
        if (is_null($qualifiedOrganizationUnitIds) || (is_array($qualifiedOrganizationUnitIds) && empty($qualifiedOrganizationUnitIds))) {
            unset($this->QualifiedOrganizationUnitIds);
        } else {
            $this->QualifiedOrganizationUnitIds = $qualifiedOrganizationUnitIds;
        }
        return $this;
    }
    /**
     * Get QualifiedPriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QualifiedPriceTypeIds|null
     */
    public function getQualifiedPriceTypeIds()
    {
        return isset($this->QualifiedPriceTypeIds) ? $this->QualifiedPriceTypeIds : null;
    }
    /**
     * Set QualifiedPriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QualifiedPriceTypeIds $qualifiedPriceTypeIds
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setQualifiedPriceTypeIds(\patest\StructType\QualifiedPriceTypeIds $qualifiedPriceTypeIds = null)
    {
        if (is_null($qualifiedPriceTypeIds) || (is_array($qualifiedPriceTypeIds) && empty($qualifiedPriceTypeIds))) {
            unset($this->QualifiedPriceTypeIds);
        } else {
            $this->QualifiedPriceTypeIds = $qualifiedPriceTypeIds;
        }
        return $this;
    }
    /**
     * Get QualifiedSeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QualifiedSeriesIds|null
     */
    public function getQualifiedSeriesIds()
    {
        return isset($this->QualifiedSeriesIds) ? $this->QualifiedSeriesIds : null;
    }
    /**
     * Set QualifiedSeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QualifiedSeriesIds $qualifiedSeriesIds
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setQualifiedSeriesIds(\patest\StructType\QualifiedSeriesIds $qualifiedSeriesIds = null)
    {
        if (is_null($qualifiedSeriesIds) || (is_array($qualifiedSeriesIds) && empty($qualifiedSeriesIds))) {
            unset($this->QualifiedSeriesIds);
        } else {
            $this->QualifiedSeriesIds = $qualifiedSeriesIds;
        }
        return $this;
    }
    /**
     * Get QualifiedUserGroupIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QualifiedUserGroupIds|null
     */
    public function getQualifiedUserGroupIds()
    {
        return isset($this->QualifiedUserGroupIds) ? $this->QualifiedUserGroupIds : null;
    }
    /**
     * Set QualifiedUserGroupIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QualifiedUserGroupIds $qualifiedUserGroupIds
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setQualifiedUserGroupIds(\patest\StructType\QualifiedUserGroupIds $qualifiedUserGroupIds = null)
    {
        if (is_null($qualifiedUserGroupIds) || (is_array($qualifiedUserGroupIds) && empty($qualifiedUserGroupIds))) {
            unset($this->QualifiedUserGroupIds);
        } else {
            $this->QualifiedUserGroupIds = $qualifiedUserGroupIds;
        }
        return $this;
    }
    /**
     * Get QualifiedWorkflowTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQualifiedWorkflowTypes()
    {
        return isset($this->QualifiedWorkflowTypes) ? $this->QualifiedWorkflowTypes : null;
    }
    /**
     * Set QualifiedWorkflowTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $qualifiedWorkflowTypes
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setQualifiedWorkflowTypes($qualifiedWorkflowTypes = null)
    {
        // validation for constraint: string
        if (!is_null($qualifiedWorkflowTypes) && !is_string($qualifiedWorkflowTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qualifiedWorkflowTypes, true), gettype($qualifiedWorkflowTypes)), __LINE__);
        }
        if (is_null($qualifiedWorkflowTypes) || (is_array($qualifiedWorkflowTypes) && empty($qualifiedWorkflowTypes))) {
            unset($this->QualifiedWorkflowTypes);
        } else {
            $this->QualifiedWorkflowTypes = $qualifiedWorkflowTypes;
        }
        return $this;
    }
    /**
     * Get RestrictionGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionGroupId()
    {
        return isset($this->RestrictionGroupId) ? $this->RestrictionGroupId : null;
    }
    /**
     * Set RestrictionGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restrictionGroupId
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setRestrictionGroupId($restrictionGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($restrictionGroupId) && !is_string($restrictionGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restrictionGroupId, true), gettype($restrictionGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restrictionGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restrictionGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restrictionGroupId, true)), __LINE__);
        }
        if (is_null($restrictionGroupId) || (is_array($restrictionGroupId) && empty($restrictionGroupId))) {
            unset($this->RestrictionGroupId);
        } else {
            $this->RestrictionGroupId = $restrictionGroupId;
        }
        return $this;
    }
    /**
     * Get RestrictionTarget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionTarget()
    {
        return isset($this->RestrictionTarget) ? $this->RestrictionTarget : null;
    }
    /**
     * Set RestrictionTarget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RestrictionTarget::valueIsValid()
     * @uses \patest\EnumType\RestrictionTarget::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionTarget
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setRestrictionTarget($restrictionTarget = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionTarget::valueIsValid($restrictionTarget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionTarget', is_array($restrictionTarget) ? implode(', ', $restrictionTarget) : var_export($restrictionTarget, true), implode(', ', \patest\EnumType\RestrictionTarget::getValidValues())), __LINE__);
        }
        if (is_null($restrictionTarget) || (is_array($restrictionTarget) && empty($restrictionTarget))) {
            unset($this->RestrictionTarget);
        } else {
            $this->RestrictionTarget = $restrictionTarget;
        }
        return $this;
    }
    /**
     * Get RestrictionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestrictionType()
    {
        return isset($this->RestrictionType) ? $this->RestrictionType : null;
    }
    /**
     * Set RestrictionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RestrictionType::valueIsValid()
     * @uses \patest\EnumType\RestrictionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $restrictionType
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setRestrictionType($restrictionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RestrictionType::valueIsValid($restrictionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RestrictionType', is_array($restrictionType) ? implode(', ', $restrictionType) : var_export($restrictionType, true), implode(', ', \patest\EnumType\RestrictionType::getValidValues())), __LINE__);
        }
        if (is_null($restrictionType) || (is_array($restrictionType) && empty($restrictionType))) {
            unset($this->RestrictionType);
        } else {
            $this->RestrictionType = $restrictionType;
        }
        return $this;
    }
    /**
     * Get SkipPreservedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipPreservedSeats()
    {
        return isset($this->SkipPreservedSeats) ? $this->SkipPreservedSeats : null;
    }
    /**
     * Set SkipPreservedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipPreservedSeats
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setSkipPreservedSeats($skipPreservedSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipPreservedSeats) && !is_bool($skipPreservedSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipPreservedSeats, true), gettype($skipPreservedSeats)), __LINE__);
        }
        if (is_null($skipPreservedSeats) || (is_array($skipPreservedSeats) && empty($skipPreservedSeats))) {
            unset($this->SkipPreservedSeats);
        } else {
            $this->SkipPreservedSeats = $skipPreservedSeats;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_Restriction
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
