<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ResolvedHallDataPriceLevelInfo StructType
 * @subpackage Structs
 */
class Ticketing_ResolvedHallDataPriceLevelInfo extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The ResolutionLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResolutionLevel;
    /**
     * The ResolutionObjectId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ResolutionObjectId;
    /**
     * Constructor method for Ticketing.ResolvedHallDataPriceLevelInfo
     * @uses Ticketing_ResolvedHallDataPriceLevelInfo::setAreaId()
     * @uses Ticketing_ResolvedHallDataPriceLevelInfo::setAreaName()
     * @uses Ticketing_ResolvedHallDataPriceLevelInfo::setPriceLevelId()
     * @uses Ticketing_ResolvedHallDataPriceLevelInfo::setPriceLevelName()
     * @uses Ticketing_ResolvedHallDataPriceLevelInfo::setResolutionLevel()
     * @uses Ticketing_ResolvedHallDataPriceLevelInfo::setResolutionObjectId()
     * @param string $areaId
     * @param string $areaName
     * @param string $priceLevelId
     * @param string $priceLevelName
     * @param string $resolutionLevel
     * @param string $resolutionObjectId
     */
    public function __construct($areaId = null, $areaName = null, $priceLevelId = null, $priceLevelName = null, $resolutionLevel = null, $resolutionObjectId = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelName($priceLevelName)
            ->setResolutionLevel($resolutionLevel)
            ->setResolutionObjectId($resolutionObjectId);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_ResolvedHallDataPriceLevelInfo
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\Ticketing_ResolvedHallDataPriceLevelInfo
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Ticketing_ResolvedHallDataPriceLevelInfo
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\Ticketing_ResolvedHallDataPriceLevelInfo
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get ResolutionLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResolutionLevel()
    {
        return isset($this->ResolutionLevel) ? $this->ResolutionLevel : null;
    }
    /**
     * Set ResolutionLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HallDataResolutionLevel::valueIsValid()
     * @uses \patest\EnumType\HallDataResolutionLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resolutionLevel
     * @return \patest\StructType\Ticketing_ResolvedHallDataPriceLevelInfo
     */
    public function setResolutionLevel($resolutionLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HallDataResolutionLevel::valueIsValid($resolutionLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HallDataResolutionLevel', is_array($resolutionLevel) ? implode(', ', $resolutionLevel) : var_export($resolutionLevel, true), implode(', ', \patest\EnumType\HallDataResolutionLevel::getValidValues())), __LINE__);
        }
        if (is_null($resolutionLevel) || (is_array($resolutionLevel) && empty($resolutionLevel))) {
            unset($this->ResolutionLevel);
        } else {
            $this->ResolutionLevel = $resolutionLevel;
        }
        return $this;
    }
    /**
     * Get ResolutionObjectId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResolutionObjectId()
    {
        return isset($this->ResolutionObjectId) ? $this->ResolutionObjectId : null;
    }
    /**
     * Set ResolutionObjectId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resolutionObjectId
     * @return \patest\StructType\Ticketing_ResolvedHallDataPriceLevelInfo
     */
    public function setResolutionObjectId($resolutionObjectId = null)
    {
        // validation for constraint: string
        if (!is_null($resolutionObjectId) && !is_string($resolutionObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolutionObjectId, true), gettype($resolutionObjectId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($resolutionObjectId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $resolutionObjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($resolutionObjectId, true)), __LINE__);
        }
        if (is_null($resolutionObjectId) || (is_array($resolutionObjectId) && empty($resolutionObjectId))) {
            unset($this->ResolutionObjectId);
        } else {
            $this->ResolutionObjectId = $resolutionObjectId;
        }
        return $this;
    }
}
