<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PrintingStatus StructType
 * @subpackage Structs
 */
class Ticketing_PrintingStatus extends Ticketing_Base
{
    /**
     * The GraphicRepresentation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Graphics_GraphicRepresentation
     */
    public $GraphicRepresentation;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ValueEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ValueEnum;
    /**
     * Constructor method for Ticketing.PrintingStatus
     * @uses Ticketing_PrintingStatus::setGraphicRepresentation()
     * @uses Ticketing_PrintingStatus::setName()
     * @uses Ticketing_PrintingStatus::setOrganizationUnitId()
     * @uses Ticketing_PrintingStatus::setValueEnum()
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param int $valueEnum
     */
    public function __construct(\patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $valueEnum = null)
    {
        $this
            ->setGraphicRepresentation($graphicRepresentation)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setValueEnum($valueEnum);
    }
    /**
     * Get GraphicRepresentation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Graphics_GraphicRepresentation|null
     */
    public function getGraphicRepresentation()
    {
        return isset($this->GraphicRepresentation) ? $this->GraphicRepresentation : null;
    }
    /**
     * Set GraphicRepresentation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation
     * @return \patest\StructType\Ticketing_PrintingStatus
     */
    public function setGraphicRepresentation(\patest\StructType\Graphics_GraphicRepresentation $graphicRepresentation = null)
    {
        if (is_null($graphicRepresentation) || (is_array($graphicRepresentation) && empty($graphicRepresentation))) {
            unset($this->GraphicRepresentation);
        } else {
            $this->GraphicRepresentation = $graphicRepresentation;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_PrintingStatus
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_PrintingStatus
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ValueEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getValueEnum()
    {
        return isset($this->ValueEnum) ? $this->ValueEnum : null;
    }
    /**
     * Set ValueEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $valueEnum
     * @return \patest\StructType\Ticketing_PrintingStatus
     */
    public function setValueEnum($valueEnum = null)
    {
        // validation for constraint: int
        if (!is_null($valueEnum) && !(is_int($valueEnum) || ctype_digit($valueEnum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($valueEnum, true), gettype($valueEnum)), __LINE__);
        }
        if (is_null($valueEnum) || (is_array($valueEnum) && empty($valueEnum))) {
            unset($this->ValueEnum);
        } else {
            $this->ValueEnum = $valueEnum;
        }
        return $this;
    }
}
