<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Performer StructType
 * @subpackage Structs
 */
class Ticketing_Performer extends PersistableEntity
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SgoPerformerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SgoPerformerId;
    /**
     * The SgoTaxonomyId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SgoTaxonomyId;
    /**
     * The TaxonomyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TaxonomyId;
    /**
     * The TaxonomyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxonomyName;
    /**
     * Constructor method for Ticketing.Performer
     * @uses Ticketing_Performer::setName()
     * @uses Ticketing_Performer::setSgoPerformerId()
     * @uses Ticketing_Performer::setSgoTaxonomyId()
     * @uses Ticketing_Performer::setTaxonomyId()
     * @uses Ticketing_Performer::setTaxonomyName()
     * @param string $name
     * @param int $sgoPerformerId
     * @param int $sgoTaxonomyId
     * @param string $taxonomyId
     * @param string $taxonomyName
     */
    public function __construct($name = null, $sgoPerformerId = null, $sgoTaxonomyId = null, $taxonomyId = null, $taxonomyName = null)
    {
        $this
            ->setName($name)
            ->setSgoPerformerId($sgoPerformerId)
            ->setSgoTaxonomyId($sgoTaxonomyId)
            ->setTaxonomyId($taxonomyId)
            ->setTaxonomyName($taxonomyName);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_Performer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SgoPerformerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSgoPerformerId()
    {
        return isset($this->SgoPerformerId) ? $this->SgoPerformerId : null;
    }
    /**
     * Set SgoPerformerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sgoPerformerId
     * @return \patest\StructType\Ticketing_Performer
     */
    public function setSgoPerformerId($sgoPerformerId = null)
    {
        // validation for constraint: int
        if (!is_null($sgoPerformerId) && !(is_int($sgoPerformerId) || ctype_digit($sgoPerformerId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sgoPerformerId, true), gettype($sgoPerformerId)), __LINE__);
        }
        if (is_null($sgoPerformerId) || (is_array($sgoPerformerId) && empty($sgoPerformerId))) {
            unset($this->SgoPerformerId);
        } else {
            $this->SgoPerformerId = $sgoPerformerId;
        }
        return $this;
    }
    /**
     * Get SgoTaxonomyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSgoTaxonomyId()
    {
        return isset($this->SgoTaxonomyId) ? $this->SgoTaxonomyId : null;
    }
    /**
     * Set SgoTaxonomyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sgoTaxonomyId
     * @return \patest\StructType\Ticketing_Performer
     */
    public function setSgoTaxonomyId($sgoTaxonomyId = null)
    {
        // validation for constraint: int
        if (!is_null($sgoTaxonomyId) && !(is_int($sgoTaxonomyId) || ctype_digit($sgoTaxonomyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sgoTaxonomyId, true), gettype($sgoTaxonomyId)), __LINE__);
        }
        if (is_null($sgoTaxonomyId) || (is_array($sgoTaxonomyId) && empty($sgoTaxonomyId))) {
            unset($this->SgoTaxonomyId);
        } else {
            $this->SgoTaxonomyId = $sgoTaxonomyId;
        }
        return $this;
    }
    /**
     * Get TaxonomyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyId()
    {
        return isset($this->TaxonomyId) ? $this->TaxonomyId : null;
    }
    /**
     * Set TaxonomyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxonomyId
     * @return \patest\StructType\Ticketing_Performer
     */
    public function setTaxonomyId($taxonomyId = null)
    {
        // validation for constraint: string
        if (!is_null($taxonomyId) && !is_string($taxonomyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxonomyId, true), gettype($taxonomyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($taxonomyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $taxonomyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($taxonomyId, true)), __LINE__);
        }
        if (is_null($taxonomyId) || (is_array($taxonomyId) && empty($taxonomyId))) {
            unset($this->TaxonomyId);
        } else {
            $this->TaxonomyId = $taxonomyId;
        }
        return $this;
    }
    /**
     * Get TaxonomyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxonomyName()
    {
        return isset($this->TaxonomyName) ? $this->TaxonomyName : null;
    }
    /**
     * Set TaxonomyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxonomyName
     * @return \patest\StructType\Ticketing_Performer
     */
    public function setTaxonomyName($taxonomyName = null)
    {
        // validation for constraint: string
        if (!is_null($taxonomyName) && !is_string($taxonomyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxonomyName, true), gettype($taxonomyName)), __LINE__);
        }
        if (is_null($taxonomyName) || (is_array($taxonomyName) && empty($taxonomyName))) {
            unset($this->TaxonomyName);
        } else {
            $this->TaxonomyName = $taxonomyName;
        }
        return $this;
    }
}
