<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.PartyTicketHistory StructType
 * @subpackage Structs
 */
class Ticketing_PartyTicketHistory extends PersistableEntity
{
    /**
     * The ActingClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActingClientId;
    /**
     * The CanAnyonePartyClaim
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanAnyonePartyClaim;
    /**
     * The ClaimType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClaimType;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The NewOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwnerId;
    /**
     * The OriginalTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTicketId;
    /**
     * The PartyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartyId;
    /**
     * The TicketForwardInfoId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketForwardInfoId;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for Ticketing.PartyTicketHistory
     * @uses Ticketing_PartyTicketHistory::setActingClientId()
     * @uses Ticketing_PartyTicketHistory::setCanAnyonePartyClaim()
     * @uses Ticketing_PartyTicketHistory::setClaimType()
     * @uses Ticketing_PartyTicketHistory::setCreationDateTime()
     * @uses Ticketing_PartyTicketHistory::setNewOwnerId()
     * @uses Ticketing_PartyTicketHistory::setOriginalTicketId()
     * @uses Ticketing_PartyTicketHistory::setPartyId()
     * @uses Ticketing_PartyTicketHistory::setTicketForwardInfoId()
     * @uses Ticketing_PartyTicketHistory::setTicketId()
     * @param string $actingClientId
     * @param bool $canAnyonePartyClaim
     * @param string $claimType
     * @param string $creationDateTime
     * @param string $newOwnerId
     * @param string $originalTicketId
     * @param string $partyId
     * @param string $ticketForwardInfoId
     * @param string $ticketId
     */
    public function __construct($actingClientId = null, $canAnyonePartyClaim = null, $claimType = null, $creationDateTime = null, $newOwnerId = null, $originalTicketId = null, $partyId = null, $ticketForwardInfoId = null, $ticketId = null)
    {
        $this
            ->setActingClientId($actingClientId)
            ->setCanAnyonePartyClaim($canAnyonePartyClaim)
            ->setClaimType($claimType)
            ->setCreationDateTime($creationDateTime)
            ->setNewOwnerId($newOwnerId)
            ->setOriginalTicketId($originalTicketId)
            ->setPartyId($partyId)
            ->setTicketForwardInfoId($ticketForwardInfoId)
            ->setTicketId($ticketId);
    }
    /**
     * Get ActingClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActingClientId()
    {
        return isset($this->ActingClientId) ? $this->ActingClientId : null;
    }
    /**
     * Set ActingClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actingClientId
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setActingClientId($actingClientId = null)
    {
        // validation for constraint: string
        if (!is_null($actingClientId) && !is_string($actingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actingClientId, true), gettype($actingClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($actingClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $actingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($actingClientId, true)), __LINE__);
        }
        if (is_null($actingClientId) || (is_array($actingClientId) && empty($actingClientId))) {
            unset($this->ActingClientId);
        } else {
            $this->ActingClientId = $actingClientId;
        }
        return $this;
    }
    /**
     * Get CanAnyonePartyClaim value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanAnyonePartyClaim()
    {
        return isset($this->CanAnyonePartyClaim) ? $this->CanAnyonePartyClaim : null;
    }
    /**
     * Set CanAnyonePartyClaim value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canAnyonePartyClaim
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setCanAnyonePartyClaim($canAnyonePartyClaim = null)
    {
        // validation for constraint: boolean
        if (!is_null($canAnyonePartyClaim) && !is_bool($canAnyonePartyClaim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canAnyonePartyClaim, true), gettype($canAnyonePartyClaim)), __LINE__);
        }
        if (is_null($canAnyonePartyClaim) || (is_array($canAnyonePartyClaim) && empty($canAnyonePartyClaim))) {
            unset($this->CanAnyonePartyClaim);
        } else {
            $this->CanAnyonePartyClaim = $canAnyonePartyClaim;
        }
        return $this;
    }
    /**
     * Get ClaimType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClaimType()
    {
        return isset($this->ClaimType) ? $this->ClaimType : null;
    }
    /**
     * Set ClaimType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PartyTicketClaimType::valueIsValid()
     * @uses \patest\EnumType\PartyTicketClaimType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $claimType
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setClaimType($claimType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PartyTicketClaimType::valueIsValid($claimType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PartyTicketClaimType', is_array($claimType) ? implode(', ', $claimType) : var_export($claimType, true), implode(', ', \patest\EnumType\PartyTicketClaimType::getValidValues())), __LINE__);
        }
        if (is_null($claimType) || (is_array($claimType) && empty($claimType))) {
            unset($this->ClaimType);
        } else {
            $this->ClaimType = $claimType;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get NewOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewOwnerId()
    {
        return isset($this->NewOwnerId) ? $this->NewOwnerId : null;
    }
    /**
     * Set NewOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newOwnerId
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setNewOwnerId($newOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($newOwnerId) && !is_string($newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwnerId, true), gettype($newOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwnerId, true)), __LINE__);
        }
        if (is_null($newOwnerId) || (is_array($newOwnerId) && empty($newOwnerId))) {
            unset($this->NewOwnerId);
        } else {
            $this->NewOwnerId = $newOwnerId;
        }
        return $this;
    }
    /**
     * Get OriginalTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTicketId()
    {
        return isset($this->OriginalTicketId) ? $this->OriginalTicketId : null;
    }
    /**
     * Set OriginalTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTicketId
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setOriginalTicketId($originalTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketId) && !is_string($originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketId, true), gettype($originalTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTicketId, true)), __LINE__);
        }
        if (is_null($originalTicketId) || (is_array($originalTicketId) && empty($originalTicketId))) {
            unset($this->OriginalTicketId);
        } else {
            $this->OriginalTicketId = $originalTicketId;
        }
        return $this;
    }
    /**
     * Get PartyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyId()
    {
        return isset($this->PartyId) ? $this->PartyId : null;
    }
    /**
     * Set PartyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyId
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setPartyId($partyId = null)
    {
        // validation for constraint: string
        if (!is_null($partyId) && !is_string($partyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyId, true), gettype($partyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partyId, true)), __LINE__);
        }
        if (is_null($partyId) || (is_array($partyId) && empty($partyId))) {
            unset($this->PartyId);
        } else {
            $this->PartyId = $partyId;
        }
        return $this;
    }
    /**
     * Get TicketForwardInfoId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketForwardInfoId()
    {
        return isset($this->TicketForwardInfoId) ? $this->TicketForwardInfoId : null;
    }
    /**
     * Set TicketForwardInfoId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketForwardInfoId
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setTicketForwardInfoId($ticketForwardInfoId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketForwardInfoId) && !is_string($ticketForwardInfoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketForwardInfoId, true), gettype($ticketForwardInfoId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketForwardInfoId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketForwardInfoId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketForwardInfoId, true)), __LINE__);
        }
        if (is_null($ticketForwardInfoId) || (is_array($ticketForwardInfoId) && empty($ticketForwardInfoId))) {
            unset($this->TicketForwardInfoId);
        } else {
            $this->TicketForwardInfoId = $ticketForwardInfoId;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\Ticketing_PartyTicketHistory
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
}
