<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.HallVersionAreaMap StructType
 * @subpackage Structs
 */
class Ticketing_HallVersionAreaMap extends PersistableEntity
{
    /**
     * The AreaGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaGuid;
    /**
     * The AreaMapGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaMapGuid;
    /**
     * The ConstructionProblems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConstructionProblems;
    /**
     * The GACapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GACapacity;
    /**
     * The GAMaxCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GAMaxCapacity;
    /**
     * The GAPriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GAPriceLevelId;
    /**
     * The GAPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GAPriority;
    /**
     * The GlobalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GlobalName;
    /**
     * The HallLevelViewXaml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallLevelViewXaml;
    /**
     * The HallVersionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionGuid;
    /**
     * The IsDefaultAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefaultAreaMap;
    /**
     * The IsUsingBestAvailableReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUsingBestAvailableReservation;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The RSCapacity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RSCapacity;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatingType;
    /**
     * The ViewFromAreaImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ViewFromAreaImageId;
    /**
     * Constructor method for Ticketing.HallVersionAreaMap
     * @uses Ticketing_HallVersionAreaMap::setAreaGuid()
     * @uses Ticketing_HallVersionAreaMap::setAreaMapGuid()
     * @uses Ticketing_HallVersionAreaMap::setConstructionProblems()
     * @uses Ticketing_HallVersionAreaMap::setGACapacity()
     * @uses Ticketing_HallVersionAreaMap::setGAMaxCapacity()
     * @uses Ticketing_HallVersionAreaMap::setGAPriceLevelId()
     * @uses Ticketing_HallVersionAreaMap::setGAPriority()
     * @uses Ticketing_HallVersionAreaMap::setGlobalName()
     * @uses Ticketing_HallVersionAreaMap::setHallLevelViewXaml()
     * @uses Ticketing_HallVersionAreaMap::setHallVersionGuid()
     * @uses Ticketing_HallVersionAreaMap::setIsDefaultAreaMap()
     * @uses Ticketing_HallVersionAreaMap::setIsUsingBestAvailableReservation()
     * @uses Ticketing_HallVersionAreaMap::setOrdinal()
     * @uses Ticketing_HallVersionAreaMap::setRSCapacity()
     * @uses Ticketing_HallVersionAreaMap::setSeatingType()
     * @uses Ticketing_HallVersionAreaMap::setViewFromAreaImageId()
     * @param string $areaGuid
     * @param string $areaMapGuid
     * @param string $constructionProblems
     * @param int $gACapacity
     * @param int $gAMaxCapacity
     * @param string $gAPriceLevelId
     * @param int $gAPriority
     * @param \patest\StructType\GlobalString $globalName
     * @param string $hallLevelViewXaml
     * @param string $hallVersionGuid
     * @param bool $isDefaultAreaMap
     * @param bool $isUsingBestAvailableReservation
     * @param int $ordinal
     * @param int $rSCapacity
     * @param string $seatingType
     * @param int $viewFromAreaImageId
     */
    public function __construct($areaGuid = null, $areaMapGuid = null, $constructionProblems = null, $gACapacity = null, $gAMaxCapacity = null, $gAPriceLevelId = null, $gAPriority = null, \patest\StructType\GlobalString $globalName = null, $hallLevelViewXaml = null, $hallVersionGuid = null, $isDefaultAreaMap = null, $isUsingBestAvailableReservation = null, $ordinal = null, $rSCapacity = null, $seatingType = null, $viewFromAreaImageId = null)
    {
        $this
            ->setAreaGuid($areaGuid)
            ->setAreaMapGuid($areaMapGuid)
            ->setConstructionProblems($constructionProblems)
            ->setGACapacity($gACapacity)
            ->setGAMaxCapacity($gAMaxCapacity)
            ->setGAPriceLevelId($gAPriceLevelId)
            ->setGAPriority($gAPriority)
            ->setGlobalName($globalName)
            ->setHallLevelViewXaml($hallLevelViewXaml)
            ->setHallVersionGuid($hallVersionGuid)
            ->setIsDefaultAreaMap($isDefaultAreaMap)
            ->setIsUsingBestAvailableReservation($isUsingBestAvailableReservation)
            ->setOrdinal($ordinal)
            ->setRSCapacity($rSCapacity)
            ->setSeatingType($seatingType)
            ->setViewFromAreaImageId($viewFromAreaImageId);
    }
    /**
     * Get AreaGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaGuid()
    {
        return isset($this->AreaGuid) ? $this->AreaGuid : null;
    }
    /**
     * Set AreaGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaGuid
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setAreaGuid($areaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaGuid) && !is_string($areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaGuid, true), gettype($areaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaGuid, true)), __LINE__);
        }
        if (is_null($areaGuid) || (is_array($areaGuid) && empty($areaGuid))) {
            unset($this->AreaGuid);
        } else {
            $this->AreaGuid = $areaGuid;
        }
        return $this;
    }
    /**
     * Get AreaMapGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaMapGuid()
    {
        return isset($this->AreaMapGuid) ? $this->AreaMapGuid : null;
    }
    /**
     * Set AreaMapGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaMapGuid
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setAreaMapGuid($areaMapGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaMapGuid) && !is_string($areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaMapGuid, true), gettype($areaMapGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaMapGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaMapGuid, true)), __LINE__);
        }
        if (is_null($areaMapGuid) || (is_array($areaMapGuid) && empty($areaMapGuid))) {
            unset($this->AreaMapGuid);
        } else {
            $this->AreaMapGuid = $areaMapGuid;
        }
        return $this;
    }
    /**
     * Get ConstructionProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConstructionProblems()
    {
        return isset($this->ConstructionProblems) ? $this->ConstructionProblems : null;
    }
    /**
     * Set ConstructionProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $constructionProblems
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setConstructionProblems($constructionProblems = null)
    {
        // validation for constraint: string
        if (!is_null($constructionProblems) && !is_string($constructionProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($constructionProblems, true), gettype($constructionProblems)), __LINE__);
        }
        if (is_null($constructionProblems) || (is_array($constructionProblems) && empty($constructionProblems))) {
            unset($this->ConstructionProblems);
        } else {
            $this->ConstructionProblems = $constructionProblems;
        }
        return $this;
    }
    /**
     * Get GACapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGACapacity()
    {
        return isset($this->GACapacity) ? $this->GACapacity : null;
    }
    /**
     * Set GACapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gACapacity
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setGACapacity($gACapacity = null)
    {
        // validation for constraint: int
        if (!is_null($gACapacity) && !(is_int($gACapacity) || ctype_digit($gACapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gACapacity, true), gettype($gACapacity)), __LINE__);
        }
        if (is_null($gACapacity) || (is_array($gACapacity) && empty($gACapacity))) {
            unset($this->GACapacity);
        } else {
            $this->GACapacity = $gACapacity;
        }
        return $this;
    }
    /**
     * Get GAMaxCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGAMaxCapacity()
    {
        return isset($this->GAMaxCapacity) ? $this->GAMaxCapacity : null;
    }
    /**
     * Set GAMaxCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gAMaxCapacity
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setGAMaxCapacity($gAMaxCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($gAMaxCapacity) && !(is_int($gAMaxCapacity) || ctype_digit($gAMaxCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gAMaxCapacity, true), gettype($gAMaxCapacity)), __LINE__);
        }
        if (is_null($gAMaxCapacity) || (is_array($gAMaxCapacity) && empty($gAMaxCapacity))) {
            unset($this->GAMaxCapacity);
        } else {
            $this->GAMaxCapacity = $gAMaxCapacity;
        }
        return $this;
    }
    /**
     * Get GAPriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGAPriceLevelId()
    {
        return isset($this->GAPriceLevelId) ? $this->GAPriceLevelId : null;
    }
    /**
     * Set GAPriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gAPriceLevelId
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setGAPriceLevelId($gAPriceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($gAPriceLevelId) && !is_string($gAPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gAPriceLevelId, true), gettype($gAPriceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gAPriceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gAPriceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gAPriceLevelId, true)), __LINE__);
        }
        if (is_null($gAPriceLevelId) || (is_array($gAPriceLevelId) && empty($gAPriceLevelId))) {
            unset($this->GAPriceLevelId);
        } else {
            $this->GAPriceLevelId = $gAPriceLevelId;
        }
        return $this;
    }
    /**
     * Get GAPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGAPriority()
    {
        return isset($this->GAPriority) ? $this->GAPriority : null;
    }
    /**
     * Set GAPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $gAPriority
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setGAPriority($gAPriority = null)
    {
        // validation for constraint: int
        if (!is_null($gAPriority) && !(is_int($gAPriority) || ctype_digit($gAPriority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gAPriority, true), gettype($gAPriority)), __LINE__);
        }
        if (is_null($gAPriority) || (is_array($gAPriority) && empty($gAPriority))) {
            unset($this->GAPriority);
        } else {
            $this->GAPriority = $gAPriority;
        }
        return $this;
    }
    /**
     * Get GlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGlobalName()
    {
        return isset($this->GlobalName) ? $this->GlobalName : null;
    }
    /**
     * Set GlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $globalName
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setGlobalName(\patest\StructType\GlobalString $globalName = null)
    {
        if (is_null($globalName) || (is_array($globalName) && empty($globalName))) {
            unset($this->GlobalName);
        } else {
            $this->GlobalName = $globalName;
        }
        return $this;
    }
    /**
     * Get HallLevelViewXaml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallLevelViewXaml()
    {
        return isset($this->HallLevelViewXaml) ? $this->HallLevelViewXaml : null;
    }
    /**
     * Set HallLevelViewXaml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallLevelViewXaml
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setHallLevelViewXaml($hallLevelViewXaml = null)
    {
        // validation for constraint: string
        if (!is_null($hallLevelViewXaml) && !is_string($hallLevelViewXaml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallLevelViewXaml, true), gettype($hallLevelViewXaml)), __LINE__);
        }
        if (is_null($hallLevelViewXaml) || (is_array($hallLevelViewXaml) && empty($hallLevelViewXaml))) {
            unset($this->HallLevelViewXaml);
        } else {
            $this->HallLevelViewXaml = $hallLevelViewXaml;
        }
        return $this;
    }
    /**
     * Get HallVersionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionGuid()
    {
        return isset($this->HallVersionGuid) ? $this->HallVersionGuid : null;
    }
    /**
     * Set HallVersionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionGuid
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setHallVersionGuid($hallVersionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionGuid) && !is_string($hallVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionGuid, true), gettype($hallVersionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionGuid, true)), __LINE__);
        }
        if (is_null($hallVersionGuid) || (is_array($hallVersionGuid) && empty($hallVersionGuid))) {
            unset($this->HallVersionGuid);
        } else {
            $this->HallVersionGuid = $hallVersionGuid;
        }
        return $this;
    }
    /**
     * Get IsDefaultAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefaultAreaMap()
    {
        return isset($this->IsDefaultAreaMap) ? $this->IsDefaultAreaMap : null;
    }
    /**
     * Set IsDefaultAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefaultAreaMap
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setIsDefaultAreaMap($isDefaultAreaMap = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefaultAreaMap) && !is_bool($isDefaultAreaMap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefaultAreaMap, true), gettype($isDefaultAreaMap)), __LINE__);
        }
        if (is_null($isDefaultAreaMap) || (is_array($isDefaultAreaMap) && empty($isDefaultAreaMap))) {
            unset($this->IsDefaultAreaMap);
        } else {
            $this->IsDefaultAreaMap = $isDefaultAreaMap;
        }
        return $this;
    }
    /**
     * Get IsUsingBestAvailableReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUsingBestAvailableReservation()
    {
        return isset($this->IsUsingBestAvailableReservation) ? $this->IsUsingBestAvailableReservation : null;
    }
    /**
     * Set IsUsingBestAvailableReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUsingBestAvailableReservation
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setIsUsingBestAvailableReservation($isUsingBestAvailableReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUsingBestAvailableReservation) && !is_bool($isUsingBestAvailableReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUsingBestAvailableReservation, true), gettype($isUsingBestAvailableReservation)), __LINE__);
        }
        if (is_null($isUsingBestAvailableReservation) || (is_array($isUsingBestAvailableReservation) && empty($isUsingBestAvailableReservation))) {
            unset($this->IsUsingBestAvailableReservation);
        } else {
            $this->IsUsingBestAvailableReservation = $isUsingBestAvailableReservation;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get RSCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRSCapacity()
    {
        return isset($this->RSCapacity) ? $this->RSCapacity : null;
    }
    /**
     * Set RSCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rSCapacity
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setRSCapacity($rSCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($rSCapacity) && !(is_int($rSCapacity) || ctype_digit($rSCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rSCapacity, true), gettype($rSCapacity)), __LINE__);
        }
        if (is_null($rSCapacity) || (is_array($rSCapacity) && empty($rSCapacity))) {
            unset($this->RSCapacity);
        } else {
            $this->RSCapacity = $rSCapacity;
        }
        return $this;
    }
    /**
     * Get SeatingType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingType()
    {
        return isset($this->SeatingType) ? $this->SeatingType : null;
    }
    /**
     * Set SeatingType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($seatingType) || (is_array($seatingType) && empty($seatingType))) {
            unset($this->SeatingType);
        } else {
            $this->SeatingType = $seatingType;
        }
        return $this;
    }
    /**
     * Get ViewFromAreaImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getViewFromAreaImageId()
    {
        return isset($this->ViewFromAreaImageId) ? $this->ViewFromAreaImageId : null;
    }
    /**
     * Set ViewFromAreaImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $viewFromAreaImageId
     * @return \patest\StructType\Ticketing_HallVersionAreaMap
     */
    public function setViewFromAreaImageId($viewFromAreaImageId = null)
    {
        // validation for constraint: int
        if (!is_null($viewFromAreaImageId) && !(is_int($viewFromAreaImageId) || ctype_digit($viewFromAreaImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewFromAreaImageId, true), gettype($viewFromAreaImageId)), __LINE__);
        }
        if (is_null($viewFromAreaImageId) || (is_array($viewFromAreaImageId) && empty($viewFromAreaImageId))) {
            unset($this->ViewFromAreaImageId);
        } else {
            $this->ViewFromAreaImageId = $viewFromAreaImageId;
        }
        return $this;
    }
}
