<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EventTicketSchemeRelationExtended StructType
 * @subpackage Structs
 */
class Ticketing_EventTicketSchemeRelationExtended extends Ticketing_EventTicketSchemeRelation
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EventName;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The HallVersionName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallVersionName;
    /**
     * Constructor method for Ticketing.EventTicketSchemeRelationExtended
     * @uses Ticketing_EventTicketSchemeRelationExtended::setEventDate()
     * @uses Ticketing_EventTicketSchemeRelationExtended::setEventName()
     * @uses Ticketing_EventTicketSchemeRelationExtended::setHallName()
     * @uses Ticketing_EventTicketSchemeRelationExtended::setHallVersionName()
     * @param string $eventDate
     * @param \patest\StructType\GlobalString $eventName
     * @param \patest\StructType\GlobalString $hallName
     * @param \patest\StructType\GlobalString $hallVersionName
     */
    public function __construct($eventDate = null, \patest\StructType\GlobalString $eventName = null, \patest\StructType\GlobalString $hallName = null, \patest\StructType\GlobalString $hallVersionName = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setEventName($eventName)
            ->setHallName($hallName)
            ->setHallVersionName($hallVersionName);
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelationExtended
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $eventName
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelationExtended
     */
    public function setEventName(\patest\StructType\GlobalString $eventName = null)
    {
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelationExtended
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get HallVersionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallVersionName()
    {
        return isset($this->HallVersionName) ? $this->HallVersionName : null;
    }
    /**
     * Set HallVersionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallVersionName
     * @return \patest\StructType\Ticketing_EventTicketSchemeRelationExtended
     */
    public function setHallVersionName(\patest\StructType\GlobalString $hallVersionName = null)
    {
        if (is_null($hallVersionName) || (is_array($hallVersionName) && empty($hallVersionName))) {
            unset($this->HallVersionName);
        } else {
            $this->HallVersionName = $hallVersionName;
        }
        return $this;
    }
}
