<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EntityUrl StructType
 * @subpackage Structs
 */
class Ticketing_EntityUrl extends PersistableEntity
{
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The EntityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityType;
    /**
     * The LastUpdateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateTime;
    /**
     * The LocalCultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalCultureId;
    /**
     * The Suffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Suffix;
    /**
     * The TokenString
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokenString;
    /**
     * The TokenStringHash
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokenStringHash;
    /**
     * Constructor method for Ticketing.EntityUrl
     * @uses Ticketing_EntityUrl::setEntityId()
     * @uses Ticketing_EntityUrl::setEntityType()
     * @uses Ticketing_EntityUrl::setLastUpdateTime()
     * @uses Ticketing_EntityUrl::setLocalCultureId()
     * @uses Ticketing_EntityUrl::setSuffix()
     * @uses Ticketing_EntityUrl::setTokenString()
     * @uses Ticketing_EntityUrl::setTokenStringHash()
     * @param string $entityId
     * @param string $entityType
     * @param string $lastUpdateTime
     * @param int $localCultureId
     * @param int $suffix
     * @param string $tokenString
     * @param string $tokenStringHash
     */
    public function __construct($entityId = null, $entityType = null, $lastUpdateTime = null, $localCultureId = null, $suffix = null, $tokenString = null, $tokenStringHash = null)
    {
        $this
            ->setEntityId($entityId)
            ->setEntityType($entityType)
            ->setLastUpdateTime($lastUpdateTime)
            ->setLocalCultureId($localCultureId)
            ->setSuffix($suffix)
            ->setTokenString($tokenString)
            ->setTokenStringHash($tokenStringHash);
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\Ticketing_EntityUrl
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get EntityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityType()
    {
        return isset($this->EntityType) ? $this->EntityType : null;
    }
    /**
     * Set EntityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityType
     * @return \patest\StructType\Ticketing_EntityUrl
     */
    public function setEntityType($entityType = null)
    {
        // validation for constraint: string
        if (!is_null($entityType) && !is_string($entityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityType, true), gettype($entityType)), __LINE__);
        }
        if (is_null($entityType) || (is_array($entityType) && empty($entityType))) {
            unset($this->EntityType);
        } else {
            $this->EntityType = $entityType;
        }
        return $this;
    }
    /**
     * Get LastUpdateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateTime()
    {
        return isset($this->LastUpdateTime) ? $this->LastUpdateTime : null;
    }
    /**
     * Set LastUpdateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateTime
     * @return \patest\StructType\Ticketing_EntityUrl
     */
    public function setLastUpdateTime($lastUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateTime) && !is_string($lastUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateTime, true), gettype($lastUpdateTime)), __LINE__);
        }
        if (is_null($lastUpdateTime) || (is_array($lastUpdateTime) && empty($lastUpdateTime))) {
            unset($this->LastUpdateTime);
        } else {
            $this->LastUpdateTime = $lastUpdateTime;
        }
        return $this;
    }
    /**
     * Get LocalCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalCultureId()
    {
        return isset($this->LocalCultureId) ? $this->LocalCultureId : null;
    }
    /**
     * Set LocalCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localCultureId
     * @return \patest\StructType\Ticketing_EntityUrl
     */
    public function setLocalCultureId($localCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($localCultureId) && !(is_int($localCultureId) || ctype_digit($localCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localCultureId, true), gettype($localCultureId)), __LINE__);
        }
        if (is_null($localCultureId) || (is_array($localCultureId) && empty($localCultureId))) {
            unset($this->LocalCultureId);
        } else {
            $this->LocalCultureId = $localCultureId;
        }
        return $this;
    }
    /**
     * Get Suffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuffix()
    {
        return isset($this->Suffix) ? $this->Suffix : null;
    }
    /**
     * Set Suffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $suffix
     * @return \patest\StructType\Ticketing_EntityUrl
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: int
        if (!is_null($suffix) && !(is_int($suffix) || ctype_digit($suffix))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        if (is_null($suffix) || (is_array($suffix) && empty($suffix))) {
            unset($this->Suffix);
        } else {
            $this->Suffix = $suffix;
        }
        return $this;
    }
    /**
     * Get TokenString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokenString()
    {
        return isset($this->TokenString) ? $this->TokenString : null;
    }
    /**
     * Set TokenString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokenString
     * @return \patest\StructType\Ticketing_EntityUrl
     */
    public function setTokenString($tokenString = null)
    {
        // validation for constraint: string
        if (!is_null($tokenString) && !is_string($tokenString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenString, true), gettype($tokenString)), __LINE__);
        }
        if (is_null($tokenString) || (is_array($tokenString) && empty($tokenString))) {
            unset($this->TokenString);
        } else {
            $this->TokenString = $tokenString;
        }
        return $this;
    }
    /**
     * Get TokenStringHash value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokenStringHash()
    {
        return isset($this->TokenStringHash) ? $this->TokenStringHash : null;
    }
    /**
     * Set TokenStringHash value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokenStringHash
     * @return \patest\StructType\Ticketing_EntityUrl
     */
    public function setTokenStringHash($tokenStringHash = null)
    {
        // validation for constraint: string
        if (!is_null($tokenStringHash) && !is_string($tokenStringHash)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenStringHash, true), gettype($tokenStringHash)), __LINE__);
        }
        if (is_null($tokenStringHash) || (is_array($tokenStringHash) && empty($tokenStringHash))) {
            unset($this->TokenStringHash);
        } else {
            $this->TokenStringHash = $tokenStringHash;
        }
        return $this;
    }
}
