<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ClientTicketsEnhancedFilter StructType
 * @subpackage Structs
 */
class Ticketing_ClientTicketsEnhancedFilter extends FilterEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaId
     */
    public $AreaId;
    /**
     * The ClientTicketSaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTicketSaleStatus;
    /**
     * The ClientTicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTicketType;
    /**
     * The DayOfWeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DayOfWeek;
    /**
     * The EventDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateFrom;
    /**
     * The EventDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateTo;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ExternalTicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalTicketNumber;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The PackageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PackageId;
    /**
     * The PriceLevelTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelTypeId
     */
    public $PriceLevelTypeId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeId
     */
    public $PriceTypeId;
    /**
     * The PrintedStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedStatus;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The ScanStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScanStatus;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeatAllocationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatAllocationId
     */
    public $SeatAllocationId;
    /**
     * The SeatLockId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatLockId
     */
    public $SeatLockId;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeatTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatTypeId
     */
    public $SeatTypeId;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowId
     */
    public $ShowId;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\StandId
     */
    public $StandId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The TicketBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketBarcode;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The TransactionDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateFrom;
    /**
     * The TransactionDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDateTo;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Ticketing.ClientTicketsEnhancedFilter
     * @uses Ticketing_ClientTicketsEnhancedFilter::setAreaId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setClientTicketSaleStatus()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setClientTicketType()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setDayOfWeek()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setEventDateFrom()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setEventDateTo()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setEventId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setExternalTicketNumber()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setPackageId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setPriceLevelTypeId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setPriceTypeId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setPrintedStatus()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setRowName()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setScanStatus()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setSeasonId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setSeatAllocationId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setSeatLockId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setSeatName()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setSeatTypeId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setSectorName()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setSeriesId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setShowId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setStandId()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setSubscriptionNumber()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setTicketBarcode()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setTicketNumber()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setTransactionDateFrom()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setTransactionDateTo()
     * @uses Ticketing_ClientTicketsEnhancedFilter::setTransactionNumber()
     * @param \patest\StructType\AreaId $areaId
     * @param string $clientTicketSaleStatus
     * @param string $clientTicketType
     * @param string $dayOfWeek
     * @param string $eventDateFrom
     * @param string $eventDateTo
     * @param string $eventId
     * @param string $externalTicketNumber
     * @param string $id
     * @param string $packageId
     * @param \patest\StructType\PriceLevelTypeId $priceLevelTypeId
     * @param \patest\StructType\PriceTypeId $priceTypeId
     * @param string $printedStatus
     * @param string $rowName
     * @param string $scanStatus
     * @param string $seasonId
     * @param \patest\StructType\SeatAllocationId $seatAllocationId
     * @param \patest\StructType\SeatLockId $seatLockId
     * @param string $seatName
     * @param \patest\StructType\SeatTypeId $seatTypeId
     * @param \patest\StructType\GlobalString $sectorName
     * @param string $seriesId
     * @param \patest\StructType\ShowId $showId
     * @param \patest\StructType\StandId $standId
     * @param string $subscriptionNumber
     * @param string $ticketBarcode
     * @param int $ticketNumber
     * @param string $transactionDateFrom
     * @param string $transactionDateTo
     * @param int $transactionNumber
     */
    public function __construct(\patest\StructType\AreaId $areaId = null, $clientTicketSaleStatus = null, $clientTicketType = null, $dayOfWeek = null, $eventDateFrom = null, $eventDateTo = null, $eventId = null, $externalTicketNumber = null, $id = null, $packageId = null, \patest\StructType\PriceLevelTypeId $priceLevelTypeId = null, \patest\StructType\PriceTypeId $priceTypeId = null, $printedStatus = null, $rowName = null, $scanStatus = null, $seasonId = null, \patest\StructType\SeatAllocationId $seatAllocationId = null, \patest\StructType\SeatLockId $seatLockId = null, $seatName = null, \patest\StructType\SeatTypeId $seatTypeId = null, \patest\StructType\GlobalString $sectorName = null, $seriesId = null, \patest\StructType\ShowId $showId = null, \patest\StructType\StandId $standId = null, $subscriptionNumber = null, $ticketBarcode = null, $ticketNumber = null, $transactionDateFrom = null, $transactionDateTo = null, $transactionNumber = null)
    {
        $this
            ->setAreaId($areaId)
            ->setClientTicketSaleStatus($clientTicketSaleStatus)
            ->setClientTicketType($clientTicketType)
            ->setDayOfWeek($dayOfWeek)
            ->setEventDateFrom($eventDateFrom)
            ->setEventDateTo($eventDateTo)
            ->setEventId($eventId)
            ->setExternalTicketNumber($externalTicketNumber)
            ->setId($id)
            ->setPackageId($packageId)
            ->setPriceLevelTypeId($priceLevelTypeId)
            ->setPriceTypeId($priceTypeId)
            ->setPrintedStatus($printedStatus)
            ->setRowName($rowName)
            ->setScanStatus($scanStatus)
            ->setSeasonId($seasonId)
            ->setSeatAllocationId($seatAllocationId)
            ->setSeatLockId($seatLockId)
            ->setSeatName($seatName)
            ->setSeatTypeId($seatTypeId)
            ->setSectorName($sectorName)
            ->setSeriesId($seriesId)
            ->setShowId($showId)
            ->setStandId($standId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTicketBarcode($ticketBarcode)
            ->setTicketNumber($ticketNumber)
            ->setTransactionDateFrom($transactionDateFrom)
            ->setTransactionDateTo($transactionDateTo)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaId|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaId $areaId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setAreaId(\patest\StructType\AreaId $areaId = null)
    {
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get ClientTicketSaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTicketSaleStatus()
    {
        return isset($this->ClientTicketSaleStatus) ? $this->ClientTicketSaleStatus : null;
    }
    /**
     * Set ClientTicketSaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSaleStatus::valueIsValid()
     * @uses \patest\EnumType\TicketSaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientTicketSaleStatus
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setClientTicketSaleStatus($clientTicketSaleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSaleStatus::valueIsValid($clientTicketSaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSaleStatus', is_array($clientTicketSaleStatus) ? implode(', ', $clientTicketSaleStatus) : var_export($clientTicketSaleStatus, true), implode(', ', \patest\EnumType\TicketSaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($clientTicketSaleStatus) || (is_array($clientTicketSaleStatus) && empty($clientTicketSaleStatus))) {
            unset($this->ClientTicketSaleStatus);
        } else {
            $this->ClientTicketSaleStatus = $clientTicketSaleStatus;
        }
        return $this;
    }
    /**
     * Get ClientTicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTicketType()
    {
        return isset($this->ClientTicketType) ? $this->ClientTicketType : null;
    }
    /**
     * Set ClientTicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientTicketType::valueIsValid()
     * @uses \patest\EnumType\ClientTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $clientTicketType
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setClientTicketType($clientTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientTicketType::valueIsValid($clientTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientTicketType', is_array($clientTicketType) ? implode(', ', $clientTicketType) : var_export($clientTicketType, true), implode(', ', \patest\EnumType\ClientTicketType::getValidValues())), __LINE__);
        }
        if (is_null($clientTicketType) || (is_array($clientTicketType) && empty($clientTicketType))) {
            unset($this->ClientTicketType);
        } else {
            $this->ClientTicketType = $clientTicketType;
        }
        return $this;
    }
    /**
     * Get DayOfWeek value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDayOfWeek()
    {
        return isset($this->DayOfWeek) ? $this->DayOfWeek : null;
    }
    /**
     * Set DayOfWeek value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dayOfWeek
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setDayOfWeek($dayOfWeek = null)
    {
        // validation for constraint: string
        if (!is_null($dayOfWeek) && !is_string($dayOfWeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dayOfWeek, true), gettype($dayOfWeek)), __LINE__);
        }
        if (is_null($dayOfWeek) || (is_array($dayOfWeek) && empty($dayOfWeek))) {
            unset($this->DayOfWeek);
        } else {
            $this->DayOfWeek = $dayOfWeek;
        }
        return $this;
    }
    /**
     * Get EventDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateFrom()
    {
        return isset($this->EventDateFrom) ? $this->EventDateFrom : null;
    }
    /**
     * Set EventDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateFrom
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setEventDateFrom($eventDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateFrom) && !is_string($eventDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateFrom, true), gettype($eventDateFrom)), __LINE__);
        }
        if (is_null($eventDateFrom) || (is_array($eventDateFrom) && empty($eventDateFrom))) {
            unset($this->EventDateFrom);
        } else {
            $this->EventDateFrom = $eventDateFrom;
        }
        return $this;
    }
    /**
     * Get EventDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateTo()
    {
        return isset($this->EventDateTo) ? $this->EventDateTo : null;
    }
    /**
     * Set EventDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateTo
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setEventDateTo($eventDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateTo) && !is_string($eventDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateTo, true), gettype($eventDateTo)), __LINE__);
        }
        if (is_null($eventDateTo) || (is_array($eventDateTo) && empty($eventDateTo))) {
            unset($this->EventDateTo);
        } else {
            $this->EventDateTo = $eventDateTo;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get ExternalTicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalTicketNumber()
    {
        return isset($this->ExternalTicketNumber) ? $this->ExternalTicketNumber : null;
    }
    /**
     * Set ExternalTicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalTicketNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setExternalTicketNumber($externalTicketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalTicketNumber) && !is_string($externalTicketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalTicketNumber, true), gettype($externalTicketNumber)), __LINE__);
        }
        if (is_null($externalTicketNumber) || (is_array($externalTicketNumber) && empty($externalTicketNumber))) {
            unset($this->ExternalTicketNumber);
        } else {
            $this->ExternalTicketNumber = $externalTicketNumber;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get PackageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageId()
    {
        return isset($this->PackageId) ? $this->PackageId : null;
    }
    /**
     * Set PackageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setPackageId($packageId = null)
    {
        // validation for constraint: string
        if (!is_null($packageId) && !is_string($packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageId, true), gettype($packageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($packageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $packageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($packageId, true)), __LINE__);
        }
        if (is_null($packageId) || (is_array($packageId) && empty($packageId))) {
            unset($this->PackageId);
        } else {
            $this->PackageId = $packageId;
        }
        return $this;
    }
    /**
     * Get PriceLevelTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelTypeId|null
     */
    public function getPriceLevelTypeId()
    {
        return isset($this->PriceLevelTypeId) ? $this->PriceLevelTypeId : null;
    }
    /**
     * Set PriceLevelTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelTypeId $priceLevelTypeId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setPriceLevelTypeId(\patest\StructType\PriceLevelTypeId $priceLevelTypeId = null)
    {
        if (is_null($priceLevelTypeId) || (is_array($priceLevelTypeId) && empty($priceLevelTypeId))) {
            unset($this->PriceLevelTypeId);
        } else {
            $this->PriceLevelTypeId = $priceLevelTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeId|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeId $priceTypeId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setPriceTypeId(\patest\StructType\PriceTypeId $priceTypeId = null)
    {
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PrintedStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedStatus()
    {
        return isset($this->PrintedStatus) ? $this->PrintedStatus : null;
    }
    /**
     * Set PrintedStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintStatus::valueIsValid()
     * @uses \patest\EnumType\PrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printedStatus
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setPrintedStatus($printedStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintStatus::valueIsValid($printedStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintStatus', is_array($printedStatus) ? implode(', ', $printedStatus) : var_export($printedStatus, true), implode(', ', \patest\EnumType\PrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($printedStatus) || (is_array($printedStatus) && empty($printedStatus))) {
            unset($this->PrintedStatus);
        } else {
            $this->PrintedStatus = $printedStatus;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get ScanStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScanStatus()
    {
        return isset($this->ScanStatus) ? $this->ScanStatus : null;
    }
    /**
     * Set ScanStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScanStatus::valueIsValid()
     * @uses \patest\EnumType\ScanStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $scanStatus
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setScanStatus($scanStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScanStatus::valueIsValid($scanStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScanStatus', is_array($scanStatus) ? implode(', ', $scanStatus) : var_export($scanStatus, true), implode(', ', \patest\EnumType\ScanStatus::getValidValues())), __LINE__);
        }
        if (is_null($scanStatus) || (is_array($scanStatus) && empty($scanStatus))) {
            unset($this->ScanStatus);
        } else {
            $this->ScanStatus = $scanStatus;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeatAllocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatAllocationId|null
     */
    public function getSeatAllocationId()
    {
        return isset($this->SeatAllocationId) ? $this->SeatAllocationId : null;
    }
    /**
     * Set SeatAllocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatAllocationId $seatAllocationId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setSeatAllocationId(\patest\StructType\SeatAllocationId $seatAllocationId = null)
    {
        if (is_null($seatAllocationId) || (is_array($seatAllocationId) && empty($seatAllocationId))) {
            unset($this->SeatAllocationId);
        } else {
            $this->SeatAllocationId = $seatAllocationId;
        }
        return $this;
    }
    /**
     * Get SeatLockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatLockId|null
     */
    public function getSeatLockId()
    {
        return isset($this->SeatLockId) ? $this->SeatLockId : null;
    }
    /**
     * Set SeatLockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatLockId $seatLockId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setSeatLockId(\patest\StructType\SeatLockId $seatLockId = null)
    {
        if (is_null($seatLockId) || (is_array($seatLockId) && empty($seatLockId))) {
            unset($this->SeatLockId);
        } else {
            $this->SeatLockId = $seatLockId;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeatTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatTypeId|null
     */
    public function getSeatTypeId()
    {
        return isset($this->SeatTypeId) ? $this->SeatTypeId : null;
    }
    /**
     * Set SeatTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatTypeId $seatTypeId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setSeatTypeId(\patest\StructType\SeatTypeId $seatTypeId = null)
    {
        if (is_null($seatTypeId) || (is_array($seatTypeId) && empty($seatTypeId))) {
            unset($this->SeatTypeId);
        } else {
            $this->SeatTypeId = $seatTypeId;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorName
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setSectorName(\patest\StructType\GlobalString $sectorName = null)
    {
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowId|null
     */
    public function getShowId()
    {
        return isset($this->ShowId) ? $this->ShowId : null;
    }
    /**
     * Set ShowId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowId $showId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setShowId(\patest\StructType\ShowId $showId = null)
    {
        if (is_null($showId) || (is_array($showId) && empty($showId))) {
            unset($this->ShowId);
        } else {
            $this->ShowId = $showId;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\StandId|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\StandId $standId
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setStandId(\patest\StructType\StandId $standId = null)
    {
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get TicketBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketBarcode()
    {
        return isset($this->TicketBarcode) ? $this->TicketBarcode : null;
    }
    /**
     * Set TicketBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketBarcode
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setTicketBarcode($ticketBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketBarcode) && !is_string($ticketBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketBarcode, true), gettype($ticketBarcode)), __LINE__);
        }
        if (is_null($ticketBarcode) || (is_array($ticketBarcode) && empty($ticketBarcode))) {
            unset($this->TicketBarcode);
        } else {
            $this->TicketBarcode = $ticketBarcode;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get TransactionDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateFrom()
    {
        return isset($this->TransactionDateFrom) ? $this->TransactionDateFrom : null;
    }
    /**
     * Set TransactionDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateFrom
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setTransactionDateFrom($transactionDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateFrom) && !is_string($transactionDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateFrom, true), gettype($transactionDateFrom)), __LINE__);
        }
        if (is_null($transactionDateFrom) || (is_array($transactionDateFrom) && empty($transactionDateFrom))) {
            unset($this->TransactionDateFrom);
        } else {
            $this->TransactionDateFrom = $transactionDateFrom;
        }
        return $this;
    }
    /**
     * Get TransactionDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDateTo()
    {
        return isset($this->TransactionDateTo) ? $this->TransactionDateTo : null;
    }
    /**
     * Set TransactionDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDateTo
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setTransactionDateTo($transactionDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDateTo) && !is_string($transactionDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDateTo, true), gettype($transactionDateTo)), __LINE__);
        }
        if (is_null($transactionDateTo) || (is_array($transactionDateTo) && empty($transactionDateTo))) {
            unset($this->TransactionDateTo);
        } else {
            $this->TransactionDateTo = $transactionDateTo;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_ClientTicketsEnhancedFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
