<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ClientSubscriptionsGroup StructType
 * @subpackage Structs
 */
class Ticketing_ClientSubscriptionsGroup extends AnyEntity
{
    /**
     * The HoldSeatsForRenewStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HoldSeatsForRenewStatus;
    /**
     * The IsObsolete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObsolete;
    /**
     * The OwnerGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerGuid;
    /**
     * The PurchaserGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserGuid;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The RenewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewStatus;
    /**
     * The SeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeasonId;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Ticketing.ClientSubscriptionsGroup
     * @uses Ticketing_ClientSubscriptionsGroup::setHoldSeatsForRenewStatus()
     * @uses Ticketing_ClientSubscriptionsGroup::setIsObsolete()
     * @uses Ticketing_ClientSubscriptionsGroup::setOwnerGuid()
     * @uses Ticketing_ClientSubscriptionsGroup::setPurchaserGuid()
     * @uses Ticketing_ClientSubscriptionsGroup::setQuantity()
     * @uses Ticketing_ClientSubscriptionsGroup::setRenewStatus()
     * @uses Ticketing_ClientSubscriptionsGroup::setSeasonId()
     * @uses Ticketing_ClientSubscriptionsGroup::setSeriesId()
     * @uses Ticketing_ClientSubscriptionsGroup::setStatus()
     * @uses Ticketing_ClientSubscriptionsGroup::setTransactionDate()
     * @uses Ticketing_ClientSubscriptionsGroup::setTransactionNumber()
     * @param string $holdSeatsForRenewStatus
     * @param bool $isObsolete
     * @param string $ownerGuid
     * @param string $purchaserGuid
     * @param int $quantity
     * @param string $renewStatus
     * @param string $seasonId
     * @param string $seriesId
     * @param string $status
     * @param string $transactionDate
     * @param int $transactionNumber
     */
    public function __construct($holdSeatsForRenewStatus = null, $isObsolete = null, $ownerGuid = null, $purchaserGuid = null, $quantity = null, $renewStatus = null, $seasonId = null, $seriesId = null, $status = null, $transactionDate = null, $transactionNumber = null)
    {
        $this
            ->setHoldSeatsForRenewStatus($holdSeatsForRenewStatus)
            ->setIsObsolete($isObsolete)
            ->setOwnerGuid($ownerGuid)
            ->setPurchaserGuid($purchaserGuid)
            ->setQuantity($quantity)
            ->setRenewStatus($renewStatus)
            ->setSeasonId($seasonId)
            ->setSeriesId($seriesId)
            ->setStatus($status)
            ->setTransactionDate($transactionDate)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get HoldSeatsForRenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldSeatsForRenewStatus()
    {
        return isset($this->HoldSeatsForRenewStatus) ? $this->HoldSeatsForRenewStatus : null;
    }
    /**
     * Set HoldSeatsForRenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::valueIsValid()
     * @uses \patest\EnumType\HoldSeatsForRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $holdSeatsForRenewStatus
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setHoldSeatsForRenewStatus($holdSeatsForRenewStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HoldSeatsForRenewStatus::valueIsValid($holdSeatsForRenewStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HoldSeatsForRenewStatus', is_array($holdSeatsForRenewStatus) ? implode(', ', $holdSeatsForRenewStatus) : var_export($holdSeatsForRenewStatus, true), implode(', ', \patest\EnumType\HoldSeatsForRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($holdSeatsForRenewStatus) || (is_array($holdSeatsForRenewStatus) && empty($holdSeatsForRenewStatus))) {
            unset($this->HoldSeatsForRenewStatus);
        } else {
            $this->HoldSeatsForRenewStatus = $holdSeatsForRenewStatus;
        }
        return $this;
    }
    /**
     * Get IsObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObsolete()
    {
        return isset($this->IsObsolete) ? $this->IsObsolete : null;
    }
    /**
     * Set IsObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObsolete
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setIsObsolete($isObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObsolete) && !is_bool($isObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObsolete, true), gettype($isObsolete)), __LINE__);
        }
        if (is_null($isObsolete) || (is_array($isObsolete) && empty($isObsolete))) {
            unset($this->IsObsolete);
        } else {
            $this->IsObsolete = $isObsolete;
        }
        return $this;
    }
    /**
     * Get OwnerGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerGuid()
    {
        return isset($this->OwnerGuid) ? $this->OwnerGuid : null;
    }
    /**
     * Set OwnerGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerGuid
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setOwnerGuid($ownerGuid = null)
    {
        // validation for constraint: string
        if (!is_null($ownerGuid) && !is_string($ownerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerGuid, true), gettype($ownerGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerGuid, true)), __LINE__);
        }
        if (is_null($ownerGuid) || (is_array($ownerGuid) && empty($ownerGuid))) {
            unset($this->OwnerGuid);
        } else {
            $this->OwnerGuid = $ownerGuid;
        }
        return $this;
    }
    /**
     * Get PurchaserGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserGuid()
    {
        return isset($this->PurchaserGuid) ? $this->PurchaserGuid : null;
    }
    /**
     * Set PurchaserGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserGuid
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setPurchaserGuid($purchaserGuid = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserGuid) && !is_string($purchaserGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserGuid, true), gettype($purchaserGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserGuid, true)), __LINE__);
        }
        if (is_null($purchaserGuid) || (is_array($purchaserGuid) && empty($purchaserGuid))) {
            unset($this->PurchaserGuid);
        } else {
            $this->PurchaserGuid = $purchaserGuid;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewStatus()
    {
        return isset($this->RenewStatus) ? $this->RenewStatus : null;
    }
    /**
     * Set RenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionRenewStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewStatus
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setRenewStatus($renewStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionRenewStatus::valueIsValid($renewStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionRenewStatus', is_array($renewStatus) ? implode(', ', $renewStatus) : var_export($renewStatus, true), implode(', ', \patest\EnumType\SubscriptionRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($renewStatus) || (is_array($renewStatus) && empty($renewStatus))) {
            unset($this->RenewStatus);
        } else {
            $this->RenewStatus = $renewStatus;
        }
        return $this;
    }
    /**
     * Get SeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeasonId()
    {
        return isset($this->SeasonId) ? $this->SeasonId : null;
    }
    /**
     * Set SeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seasonId
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setSeasonId($seasonId = null)
    {
        // validation for constraint: string
        if (!is_null($seasonId) && !is_string($seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seasonId, true), gettype($seasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seasonId, true)), __LINE__);
        }
        if (is_null($seasonId) || (is_array($seasonId) && empty($seasonId))) {
            unset($this->SeasonId);
        } else {
            $this->SeasonId = $seasonId;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\SubscriptionStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_ClientSubscriptionsGroup
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
