<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ChecklistItem StructType
 * @subpackage Structs
 */
class Ticketing_ChecklistItem extends PersistableEntity
{
    /**
     * The ChecklistGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChecklistGroupId;
    /**
     * The CheckListTemplateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CheckListTemplateId;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The GroupOrdinal
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupOrdinal;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The RelatedPropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedPropertyName;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Required;
    /**
     * Constructor method for Ticketing.ChecklistItem
     * @uses Ticketing_ChecklistItem::setChecklistGroupId()
     * @uses Ticketing_ChecklistItem::setCheckListTemplateId()
     * @uses Ticketing_ChecklistItem::setGroupName()
     * @uses Ticketing_ChecklistItem::setGroupOrdinal()
     * @uses Ticketing_ChecklistItem::setName()
     * @uses Ticketing_ChecklistItem::setRelatedPropertyName()
     * @uses Ticketing_ChecklistItem::setRequired()
     * @param string $checklistGroupId
     * @param string $checkListTemplateId
     * @param string $groupName
     * @param int $groupOrdinal
     * @param string $name
     * @param string $relatedPropertyName
     * @param bool $required
     */
    public function __construct($checklistGroupId = null, $checkListTemplateId = null, $groupName = null, $groupOrdinal = null, $name = null, $relatedPropertyName = null, $required = null)
    {
        $this
            ->setChecklistGroupId($checklistGroupId)
            ->setCheckListTemplateId($checkListTemplateId)
            ->setGroupName($groupName)
            ->setGroupOrdinal($groupOrdinal)
            ->setName($name)
            ->setRelatedPropertyName($relatedPropertyName)
            ->setRequired($required);
    }
    /**
     * Get ChecklistGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChecklistGroupId()
    {
        return isset($this->ChecklistGroupId) ? $this->ChecklistGroupId : null;
    }
    /**
     * Set ChecklistGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checklistGroupId
     * @return \patest\StructType\Ticketing_ChecklistItem
     */
    public function setChecklistGroupId($checklistGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($checklistGroupId) && !is_string($checklistGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checklistGroupId, true), gettype($checklistGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($checklistGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $checklistGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($checklistGroupId, true)), __LINE__);
        }
        if (is_null($checklistGroupId) || (is_array($checklistGroupId) && empty($checklistGroupId))) {
            unset($this->ChecklistGroupId);
        } else {
            $this->ChecklistGroupId = $checklistGroupId;
        }
        return $this;
    }
    /**
     * Get CheckListTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckListTemplateId()
    {
        return isset($this->CheckListTemplateId) ? $this->CheckListTemplateId : null;
    }
    /**
     * Set CheckListTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkListTemplateId
     * @return \patest\StructType\Ticketing_ChecklistItem
     */
    public function setCheckListTemplateId($checkListTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($checkListTemplateId) && !is_string($checkListTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkListTemplateId, true), gettype($checkListTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($checkListTemplateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $checkListTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($checkListTemplateId, true)), __LINE__);
        }
        if (is_null($checkListTemplateId) || (is_array($checkListTemplateId) && empty($checkListTemplateId))) {
            unset($this->CheckListTemplateId);
        } else {
            $this->CheckListTemplateId = $checkListTemplateId;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \patest\StructType\Ticketing_ChecklistItem
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get GroupOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupOrdinal()
    {
        return isset($this->GroupOrdinal) ? $this->GroupOrdinal : null;
    }
    /**
     * Set GroupOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupOrdinal
     * @return \patest\StructType\Ticketing_ChecklistItem
     */
    public function setGroupOrdinal($groupOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($groupOrdinal) && !(is_int($groupOrdinal) || ctype_digit($groupOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupOrdinal, true), gettype($groupOrdinal)), __LINE__);
        }
        if (is_null($groupOrdinal) || (is_array($groupOrdinal) && empty($groupOrdinal))) {
            unset($this->GroupOrdinal);
        } else {
            $this->GroupOrdinal = $groupOrdinal;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Ticketing_ChecklistItem
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RelatedPropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedPropertyName()
    {
        return isset($this->RelatedPropertyName) ? $this->RelatedPropertyName : null;
    }
    /**
     * Set RelatedPropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedPropertyName
     * @return \patest\StructType\Ticketing_ChecklistItem
     */
    public function setRelatedPropertyName($relatedPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedPropertyName) && !is_string($relatedPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedPropertyName, true), gettype($relatedPropertyName)), __LINE__);
        }
        if (is_null($relatedPropertyName) || (is_array($relatedPropertyName) && empty($relatedPropertyName))) {
            unset($this->RelatedPropertyName);
        } else {
            $this->RelatedPropertyName = $relatedPropertyName;
        }
        return $this;
    }
    /**
     * Get Required value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequired()
    {
        return isset($this->Required) ? $this->Required : null;
    }
    /**
     * Set Required value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $required
     * @return \patest\StructType\Ticketing_ChecklistItem
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        if (is_null($required) || (is_array($required) && empty($required))) {
            unset($this->Required);
        } else {
            $this->Required = $required;
        }
        return $this;
    }
}
