<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.Ballot StructType
 * @subpackage Structs
 */
class Ticketing_Ballot extends DistributableEntity
{
    /**
     * The AgeVerificationClientTypeExceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AgeVerificationClientTypeExceptions
     */
    public $AgeVerificationClientTypeExceptions;
    /**
     * The AgeVerificationPriceTypeExceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AgeVerificationPriceTypeExceptions
     */
    public $AgeVerificationPriceTypeExceptions;
    /**
     * The AgeVerificationVirtualPriceTypeExceptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AgeVerificationVirtualPriceTypeExceptions
     */
    public $AgeVerificationVirtualPriceTypeExceptions;
    /**
     * The BallotVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotVersion;
    /**
     * The BaseVirtualPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BaseVirtualPriceTypeId;
    /**
     * The CheckoutDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CheckoutDescription;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientTypeIds
     */
    public $ClientTypeIds;
    /**
     * The CollectCCData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CollectCCData;
    /**
     * The DoAgeVerificationBeforeEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoAgeVerificationBeforeEntry;
    /**
     * The DoesAssignRelatedClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoesAssignRelatedClients;
    /**
     * The DrawDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DrawDate;
    /**
     * The EndActiveDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndActiveDateTime;
    /**
     * The EndOpenDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndOpenDateTime;
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotEvent
     */
    public $Events;
    /**
     * The FooterText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FooterText;
    /**
     * The GlobalDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GlobalDescription;
    /**
     * The GlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalNumber;
    /**
     * The HeaderText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HeaderText;
    /**
     * The HidePriceSlider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HidePriceSlider;
    /**
     * The HideSecondaryPreference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HideSecondaryPreference;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsOpenedToApplication
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOpenedToApplication;
    /**
     * The IsOpenedToDisplay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOpenedToDisplay;
    /**
     * The MaxSeatsPerClientType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats
     */
    public $MaxSeatsPerClientType;
    /**
     * The MaxSeatsPerPersonPerEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSeatsPerPersonPerEvent;
    /**
     * The MaxWins
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxWins;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Media
     */
    public $Media;
    /**
     * The MultiEventDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MultiEventDescription;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OnlineDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OnlineDescription;
    /**
     * The Operational
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Operational;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The SaleModeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeId;
    /**
     * The ScaledModeExposedToFans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ScaledModeExposedToFans;
    /**
     * The SecondaryPreferenceDefaultState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SecondaryPreferenceDefaultState;
    /**
     * The StartActiveDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartActiveDateTime;
    /**
     * The StartOpenDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartOpenDateTime;
    /**
     * The StartShowingResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartShowingResults;
    /**
     * The VirtualPriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotVirtualPriceType
     */
    public $VirtualPriceTypes;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Ticketing.Ballot
     * @uses Ticketing_Ballot::setAgeVerificationClientTypeExceptions()
     * @uses Ticketing_Ballot::setAgeVerificationPriceTypeExceptions()
     * @uses Ticketing_Ballot::setAgeVerificationVirtualPriceTypeExceptions()
     * @uses Ticketing_Ballot::setBallotVersion()
     * @uses Ticketing_Ballot::setBaseVirtualPriceTypeId()
     * @uses Ticketing_Ballot::setCheckoutDescription()
     * @uses Ticketing_Ballot::setClientTypeIds()
     * @uses Ticketing_Ballot::setCollectCCData()
     * @uses Ticketing_Ballot::setDoAgeVerificationBeforeEntry()
     * @uses Ticketing_Ballot::setDoesAssignRelatedClients()
     * @uses Ticketing_Ballot::setDrawDate()
     * @uses Ticketing_Ballot::setEndActiveDateTime()
     * @uses Ticketing_Ballot::setEndOpenDateTime()
     * @uses Ticketing_Ballot::setEvents()
     * @uses Ticketing_Ballot::setFooterText()
     * @uses Ticketing_Ballot::setGlobalDescription()
     * @uses Ticketing_Ballot::setGlobalNumber()
     * @uses Ticketing_Ballot::setHeaderText()
     * @uses Ticketing_Ballot::setHidePriceSlider()
     * @uses Ticketing_Ballot::setHideSecondaryPreference()
     * @uses Ticketing_Ballot::setIsActive()
     * @uses Ticketing_Ballot::setIsOpenedToApplication()
     * @uses Ticketing_Ballot::setIsOpenedToDisplay()
     * @uses Ticketing_Ballot::setMaxSeatsPerClientType()
     * @uses Ticketing_Ballot::setMaxSeatsPerPersonPerEvent()
     * @uses Ticketing_Ballot::setMaxWins()
     * @uses Ticketing_Ballot::setMedia()
     * @uses Ticketing_Ballot::setMultiEventDescription()
     * @uses Ticketing_Ballot::setName()
     * @uses Ticketing_Ballot::setOnlineDescription()
     * @uses Ticketing_Ballot::setOperational()
     * @uses Ticketing_Ballot::setOrganizationUnitId()
     * @uses Ticketing_Ballot::setSaleModeId()
     * @uses Ticketing_Ballot::setScaledModeExposedToFans()
     * @uses Ticketing_Ballot::setSecondaryPreferenceDefaultState()
     * @uses Ticketing_Ballot::setStartActiveDateTime()
     * @uses Ticketing_Ballot::setStartOpenDateTime()
     * @uses Ticketing_Ballot::setStartShowingResults()
     * @uses Ticketing_Ballot::setVirtualPriceTypes()
     * @uses Ticketing_Ballot::setVisibleBySubordinates()
     * @param \patest\StructType\AgeVerificationClientTypeExceptions $ageVerificationClientTypeExceptions
     * @param \patest\StructType\AgeVerificationPriceTypeExceptions $ageVerificationPriceTypeExceptions
     * @param \patest\StructType\AgeVerificationVirtualPriceTypeExceptions $ageVerificationVirtualPriceTypeExceptions
     * @param string $ballotVersion
     * @param string $baseVirtualPriceTypeId
     * @param \patest\StructType\GlobalString $checkoutDescription
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @param bool $collectCCData
     * @param bool $doAgeVerificationBeforeEntry
     * @param bool $doesAssignRelatedClients
     * @param string $drawDate
     * @param string $endActiveDateTime
     * @param string $endOpenDateTime
     * @param \patest\StructType\RecordSetOfTicketing_BallotEvent $events
     * @param string $footerText
     * @param \patest\StructType\GlobalString $globalDescription
     * @param int $globalNumber
     * @param string $headerText
     * @param bool $hidePriceSlider
     * @param bool $hideSecondaryPreference
     * @param bool $isActive
     * @param bool $isOpenedToApplication
     * @param bool $isOpenedToDisplay
     * @param \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats $maxSeatsPerClientType
     * @param int $maxSeatsPerPersonPerEvent
     * @param int $maxWins
     * @param \patest\StructType\Ticketing_Media $media
     * @param \patest\StructType\GlobalString $multiEventDescription
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\GlobalString $onlineDescription
     * @param bool $operational
     * @param string $organizationUnitId
     * @param string $saleModeId
     * @param bool $scaledModeExposedToFans
     * @param bool $secondaryPreferenceDefaultState
     * @param string $startActiveDateTime
     * @param string $startOpenDateTime
     * @param string $startShowingResults
     * @param \patest\StructType\RecordSetOfTicketing_BallotVirtualPriceType $virtualPriceTypes
     * @param bool $visibleBySubordinates
     */
    public function __construct(\patest\StructType\AgeVerificationClientTypeExceptions $ageVerificationClientTypeExceptions = null, \patest\StructType\AgeVerificationPriceTypeExceptions $ageVerificationPriceTypeExceptions = null, \patest\StructType\AgeVerificationVirtualPriceTypeExceptions $ageVerificationVirtualPriceTypeExceptions = null, $ballotVersion = null, $baseVirtualPriceTypeId = null, \patest\StructType\GlobalString $checkoutDescription = null, \patest\StructType\ClientTypeIds $clientTypeIds = null, $collectCCData = null, $doAgeVerificationBeforeEntry = null, $doesAssignRelatedClients = null, $drawDate = null, $endActiveDateTime = null, $endOpenDateTime = null, \patest\StructType\RecordSetOfTicketing_BallotEvent $events = null, $footerText = null, \patest\StructType\GlobalString $globalDescription = null, $globalNumber = null, $headerText = null, $hidePriceSlider = null, $hideSecondaryPreference = null, $isActive = null, $isOpenedToApplication = null, $isOpenedToDisplay = null, \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats $maxSeatsPerClientType = null, $maxSeatsPerPersonPerEvent = null, $maxWins = null, \patest\StructType\Ticketing_Media $media = null, \patest\StructType\GlobalString $multiEventDescription = null, \patest\StructType\GlobalString $name = null, \patest\StructType\GlobalString $onlineDescription = null, $operational = null, $organizationUnitId = null, $saleModeId = null, $scaledModeExposedToFans = null, $secondaryPreferenceDefaultState = null, $startActiveDateTime = null, $startOpenDateTime = null, $startShowingResults = null, \patest\StructType\RecordSetOfTicketing_BallotVirtualPriceType $virtualPriceTypes = null, $visibleBySubordinates = null)
    {
        $this
            ->setAgeVerificationClientTypeExceptions($ageVerificationClientTypeExceptions)
            ->setAgeVerificationPriceTypeExceptions($ageVerificationPriceTypeExceptions)
            ->setAgeVerificationVirtualPriceTypeExceptions($ageVerificationVirtualPriceTypeExceptions)
            ->setBallotVersion($ballotVersion)
            ->setBaseVirtualPriceTypeId($baseVirtualPriceTypeId)
            ->setCheckoutDescription($checkoutDescription)
            ->setClientTypeIds($clientTypeIds)
            ->setCollectCCData($collectCCData)
            ->setDoAgeVerificationBeforeEntry($doAgeVerificationBeforeEntry)
            ->setDoesAssignRelatedClients($doesAssignRelatedClients)
            ->setDrawDate($drawDate)
            ->setEndActiveDateTime($endActiveDateTime)
            ->setEndOpenDateTime($endOpenDateTime)
            ->setEvents($events)
            ->setFooterText($footerText)
            ->setGlobalDescription($globalDescription)
            ->setGlobalNumber($globalNumber)
            ->setHeaderText($headerText)
            ->setHidePriceSlider($hidePriceSlider)
            ->setHideSecondaryPreference($hideSecondaryPreference)
            ->setIsActive($isActive)
            ->setIsOpenedToApplication($isOpenedToApplication)
            ->setIsOpenedToDisplay($isOpenedToDisplay)
            ->setMaxSeatsPerClientType($maxSeatsPerClientType)
            ->setMaxSeatsPerPersonPerEvent($maxSeatsPerPersonPerEvent)
            ->setMaxWins($maxWins)
            ->setMedia($media)
            ->setMultiEventDescription($multiEventDescription)
            ->setName($name)
            ->setOnlineDescription($onlineDescription)
            ->setOperational($operational)
            ->setOrganizationUnitId($organizationUnitId)
            ->setSaleModeId($saleModeId)
            ->setScaledModeExposedToFans($scaledModeExposedToFans)
            ->setSecondaryPreferenceDefaultState($secondaryPreferenceDefaultState)
            ->setStartActiveDateTime($startActiveDateTime)
            ->setStartOpenDateTime($startOpenDateTime)
            ->setStartShowingResults($startShowingResults)
            ->setVirtualPriceTypes($virtualPriceTypes)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AgeVerificationClientTypeExceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AgeVerificationClientTypeExceptions|null
     */
    public function getAgeVerificationClientTypeExceptions()
    {
        return isset($this->AgeVerificationClientTypeExceptions) ? $this->AgeVerificationClientTypeExceptions : null;
    }
    /**
     * Set AgeVerificationClientTypeExceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AgeVerificationClientTypeExceptions $ageVerificationClientTypeExceptions
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setAgeVerificationClientTypeExceptions(\patest\StructType\AgeVerificationClientTypeExceptions $ageVerificationClientTypeExceptions = null)
    {
        if (is_null($ageVerificationClientTypeExceptions) || (is_array($ageVerificationClientTypeExceptions) && empty($ageVerificationClientTypeExceptions))) {
            unset($this->AgeVerificationClientTypeExceptions);
        } else {
            $this->AgeVerificationClientTypeExceptions = $ageVerificationClientTypeExceptions;
        }
        return $this;
    }
    /**
     * Get AgeVerificationPriceTypeExceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AgeVerificationPriceTypeExceptions|null
     */
    public function getAgeVerificationPriceTypeExceptions()
    {
        return isset($this->AgeVerificationPriceTypeExceptions) ? $this->AgeVerificationPriceTypeExceptions : null;
    }
    /**
     * Set AgeVerificationPriceTypeExceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AgeVerificationPriceTypeExceptions $ageVerificationPriceTypeExceptions
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setAgeVerificationPriceTypeExceptions(\patest\StructType\AgeVerificationPriceTypeExceptions $ageVerificationPriceTypeExceptions = null)
    {
        if (is_null($ageVerificationPriceTypeExceptions) || (is_array($ageVerificationPriceTypeExceptions) && empty($ageVerificationPriceTypeExceptions))) {
            unset($this->AgeVerificationPriceTypeExceptions);
        } else {
            $this->AgeVerificationPriceTypeExceptions = $ageVerificationPriceTypeExceptions;
        }
        return $this;
    }
    /**
     * Get AgeVerificationVirtualPriceTypeExceptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AgeVerificationVirtualPriceTypeExceptions|null
     */
    public function getAgeVerificationVirtualPriceTypeExceptions()
    {
        return isset($this->AgeVerificationVirtualPriceTypeExceptions) ? $this->AgeVerificationVirtualPriceTypeExceptions : null;
    }
    /**
     * Set AgeVerificationVirtualPriceTypeExceptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AgeVerificationVirtualPriceTypeExceptions $ageVerificationVirtualPriceTypeExceptions
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setAgeVerificationVirtualPriceTypeExceptions(\patest\StructType\AgeVerificationVirtualPriceTypeExceptions $ageVerificationVirtualPriceTypeExceptions = null)
    {
        if (is_null($ageVerificationVirtualPriceTypeExceptions) || (is_array($ageVerificationVirtualPriceTypeExceptions) && empty($ageVerificationVirtualPriceTypeExceptions))) {
            unset($this->AgeVerificationVirtualPriceTypeExceptions);
        } else {
            $this->AgeVerificationVirtualPriceTypeExceptions = $ageVerificationVirtualPriceTypeExceptions;
        }
        return $this;
    }
    /**
     * Get BallotVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotVersion()
    {
        return isset($this->BallotVersion) ? $this->BallotVersion : null;
    }
    /**
     * Set BallotVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotVersion::valueIsValid()
     * @uses \patest\EnumType\BallotVersion::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ballotVersion
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setBallotVersion($ballotVersion = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotVersion::valueIsValid($ballotVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotVersion', is_array($ballotVersion) ? implode(', ', $ballotVersion) : var_export($ballotVersion, true), implode(', ', \patest\EnumType\BallotVersion::getValidValues())), __LINE__);
        }
        if (is_null($ballotVersion) || (is_array($ballotVersion) && empty($ballotVersion))) {
            unset($this->BallotVersion);
        } else {
            $this->BallotVersion = $ballotVersion;
        }
        return $this;
    }
    /**
     * Get BaseVirtualPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaseVirtualPriceTypeId()
    {
        return isset($this->BaseVirtualPriceTypeId) ? $this->BaseVirtualPriceTypeId : null;
    }
    /**
     * Set BaseVirtualPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baseVirtualPriceTypeId
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setBaseVirtualPriceTypeId($baseVirtualPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($baseVirtualPriceTypeId) && !is_string($baseVirtualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baseVirtualPriceTypeId, true), gettype($baseVirtualPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($baseVirtualPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $baseVirtualPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($baseVirtualPriceTypeId, true)), __LINE__);
        }
        if (is_null($baseVirtualPriceTypeId) || (is_array($baseVirtualPriceTypeId) && empty($baseVirtualPriceTypeId))) {
            unset($this->BaseVirtualPriceTypeId);
        } else {
            $this->BaseVirtualPriceTypeId = $baseVirtualPriceTypeId;
        }
        return $this;
    }
    /**
     * Get CheckoutDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCheckoutDescription()
    {
        return isset($this->CheckoutDescription) ? $this->CheckoutDescription : null;
    }
    /**
     * Set CheckoutDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $checkoutDescription
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setCheckoutDescription(\patest\StructType\GlobalString $checkoutDescription = null)
    {
        if (is_null($checkoutDescription) || (is_array($checkoutDescription) && empty($checkoutDescription))) {
            unset($this->CheckoutDescription);
        } else {
            $this->CheckoutDescription = $checkoutDescription;
        }
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientTypeIds|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientTypeIds $clientTypeIds
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setClientTypeIds(\patest\StructType\ClientTypeIds $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get CollectCCData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCollectCCData()
    {
        return isset($this->CollectCCData) ? $this->CollectCCData : null;
    }
    /**
     * Set CollectCCData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $collectCCData
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setCollectCCData($collectCCData = null)
    {
        // validation for constraint: boolean
        if (!is_null($collectCCData) && !is_bool($collectCCData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($collectCCData, true), gettype($collectCCData)), __LINE__);
        }
        if (is_null($collectCCData) || (is_array($collectCCData) && empty($collectCCData))) {
            unset($this->CollectCCData);
        } else {
            $this->CollectCCData = $collectCCData;
        }
        return $this;
    }
    /**
     * Get DoAgeVerificationBeforeEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoAgeVerificationBeforeEntry()
    {
        return isset($this->DoAgeVerificationBeforeEntry) ? $this->DoAgeVerificationBeforeEntry : null;
    }
    /**
     * Set DoAgeVerificationBeforeEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doAgeVerificationBeforeEntry
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setDoAgeVerificationBeforeEntry($doAgeVerificationBeforeEntry = null)
    {
        // validation for constraint: boolean
        if (!is_null($doAgeVerificationBeforeEntry) && !is_bool($doAgeVerificationBeforeEntry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doAgeVerificationBeforeEntry, true), gettype($doAgeVerificationBeforeEntry)), __LINE__);
        }
        if (is_null($doAgeVerificationBeforeEntry) || (is_array($doAgeVerificationBeforeEntry) && empty($doAgeVerificationBeforeEntry))) {
            unset($this->DoAgeVerificationBeforeEntry);
        } else {
            $this->DoAgeVerificationBeforeEntry = $doAgeVerificationBeforeEntry;
        }
        return $this;
    }
    /**
     * Get DoesAssignRelatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoesAssignRelatedClients()
    {
        return isset($this->DoesAssignRelatedClients) ? $this->DoesAssignRelatedClients : null;
    }
    /**
     * Set DoesAssignRelatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doesAssignRelatedClients
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setDoesAssignRelatedClients($doesAssignRelatedClients = null)
    {
        // validation for constraint: boolean
        if (!is_null($doesAssignRelatedClients) && !is_bool($doesAssignRelatedClients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doesAssignRelatedClients, true), gettype($doesAssignRelatedClients)), __LINE__);
        }
        if (is_null($doesAssignRelatedClients) || (is_array($doesAssignRelatedClients) && empty($doesAssignRelatedClients))) {
            unset($this->DoesAssignRelatedClients);
        } else {
            $this->DoesAssignRelatedClients = $doesAssignRelatedClients;
        }
        return $this;
    }
    /**
     * Get DrawDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDrawDate()
    {
        return isset($this->DrawDate) ? $this->DrawDate : null;
    }
    /**
     * Set DrawDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $drawDate
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setDrawDate($drawDate = null)
    {
        // validation for constraint: string
        if (!is_null($drawDate) && !is_string($drawDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($drawDate, true), gettype($drawDate)), __LINE__);
        }
        if (is_null($drawDate) || (is_array($drawDate) && empty($drawDate))) {
            unset($this->DrawDate);
        } else {
            $this->DrawDate = $drawDate;
        }
        return $this;
    }
    /**
     * Get EndActiveDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndActiveDateTime()
    {
        return isset($this->EndActiveDateTime) ? $this->EndActiveDateTime : null;
    }
    /**
     * Set EndActiveDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endActiveDateTime
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setEndActiveDateTime($endActiveDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endActiveDateTime) && !is_string($endActiveDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endActiveDateTime, true), gettype($endActiveDateTime)), __LINE__);
        }
        if (is_null($endActiveDateTime) || (is_array($endActiveDateTime) && empty($endActiveDateTime))) {
            unset($this->EndActiveDateTime);
        } else {
            $this->EndActiveDateTime = $endActiveDateTime;
        }
        return $this;
    }
    /**
     * Get EndOpenDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndOpenDateTime()
    {
        return isset($this->EndOpenDateTime) ? $this->EndOpenDateTime : null;
    }
    /**
     * Set EndOpenDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endOpenDateTime
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setEndOpenDateTime($endOpenDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($endOpenDateTime) && !is_string($endOpenDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endOpenDateTime, true), gettype($endOpenDateTime)), __LINE__);
        }
        if (is_null($endOpenDateTime) || (is_array($endOpenDateTime) && empty($endOpenDateTime))) {
            unset($this->EndOpenDateTime);
        } else {
            $this->EndOpenDateTime = $endOpenDateTime;
        }
        return $this;
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotEvent|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotEvent $events
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setEvents(\patest\StructType\RecordSetOfTicketing_BallotEvent $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get FooterText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFooterText()
    {
        return isset($this->FooterText) ? $this->FooterText : null;
    }
    /**
     * Set FooterText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $footerText
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setFooterText($footerText = null)
    {
        // validation for constraint: string
        if (!is_null($footerText) && !is_string($footerText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($footerText, true), gettype($footerText)), __LINE__);
        }
        if (is_null($footerText) || (is_array($footerText) && empty($footerText))) {
            unset($this->FooterText);
        } else {
            $this->FooterText = $footerText;
        }
        return $this;
    }
    /**
     * Get GlobalDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGlobalDescription()
    {
        return isset($this->GlobalDescription) ? $this->GlobalDescription : null;
    }
    /**
     * Set GlobalDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $globalDescription
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setGlobalDescription(\patest\StructType\GlobalString $globalDescription = null)
    {
        if (is_null($globalDescription) || (is_array($globalDescription) && empty($globalDescription))) {
            unset($this->GlobalDescription);
        } else {
            $this->GlobalDescription = $globalDescription;
        }
        return $this;
    }
    /**
     * Get GlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalNumber()
    {
        return isset($this->GlobalNumber) ? $this->GlobalNumber : null;
    }
    /**
     * Set GlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalNumber
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setGlobalNumber($globalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($globalNumber) && !(is_int($globalNumber) || ctype_digit($globalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalNumber, true), gettype($globalNumber)), __LINE__);
        }
        if (is_null($globalNumber) || (is_array($globalNumber) && empty($globalNumber))) {
            unset($this->GlobalNumber);
        } else {
            $this->GlobalNumber = $globalNumber;
        }
        return $this;
    }
    /**
     * Get HeaderText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeaderText()
    {
        return isset($this->HeaderText) ? $this->HeaderText : null;
    }
    /**
     * Set HeaderText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $headerText
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setHeaderText($headerText = null)
    {
        // validation for constraint: string
        if (!is_null($headerText) && !is_string($headerText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($headerText, true), gettype($headerText)), __LINE__);
        }
        if (is_null($headerText) || (is_array($headerText) && empty($headerText))) {
            unset($this->HeaderText);
        } else {
            $this->HeaderText = $headerText;
        }
        return $this;
    }
    /**
     * Get HidePriceSlider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHidePriceSlider()
    {
        return isset($this->HidePriceSlider) ? $this->HidePriceSlider : null;
    }
    /**
     * Set HidePriceSlider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hidePriceSlider
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setHidePriceSlider($hidePriceSlider = null)
    {
        // validation for constraint: boolean
        if (!is_null($hidePriceSlider) && !is_bool($hidePriceSlider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hidePriceSlider, true), gettype($hidePriceSlider)), __LINE__);
        }
        if (is_null($hidePriceSlider) || (is_array($hidePriceSlider) && empty($hidePriceSlider))) {
            unset($this->HidePriceSlider);
        } else {
            $this->HidePriceSlider = $hidePriceSlider;
        }
        return $this;
    }
    /**
     * Get HideSecondaryPreference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHideSecondaryPreference()
    {
        return isset($this->HideSecondaryPreference) ? $this->HideSecondaryPreference : null;
    }
    /**
     * Set HideSecondaryPreference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hideSecondaryPreference
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setHideSecondaryPreference($hideSecondaryPreference = null)
    {
        // validation for constraint: boolean
        if (!is_null($hideSecondaryPreference) && !is_bool($hideSecondaryPreference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hideSecondaryPreference, true), gettype($hideSecondaryPreference)), __LINE__);
        }
        if (is_null($hideSecondaryPreference) || (is_array($hideSecondaryPreference) && empty($hideSecondaryPreference))) {
            unset($this->HideSecondaryPreference);
        } else {
            $this->HideSecondaryPreference = $hideSecondaryPreference;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsOpenedToApplication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOpenedToApplication()
    {
        return isset($this->IsOpenedToApplication) ? $this->IsOpenedToApplication : null;
    }
    /**
     * Set IsOpenedToApplication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOpenedToApplication
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setIsOpenedToApplication($isOpenedToApplication = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOpenedToApplication) && !is_bool($isOpenedToApplication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOpenedToApplication, true), gettype($isOpenedToApplication)), __LINE__);
        }
        if (is_null($isOpenedToApplication) || (is_array($isOpenedToApplication) && empty($isOpenedToApplication))) {
            unset($this->IsOpenedToApplication);
        } else {
            $this->IsOpenedToApplication = $isOpenedToApplication;
        }
        return $this;
    }
    /**
     * Get IsOpenedToDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOpenedToDisplay()
    {
        return isset($this->IsOpenedToDisplay) ? $this->IsOpenedToDisplay : null;
    }
    /**
     * Set IsOpenedToDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOpenedToDisplay
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setIsOpenedToDisplay($isOpenedToDisplay = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOpenedToDisplay) && !is_bool($isOpenedToDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOpenedToDisplay, true), gettype($isOpenedToDisplay)), __LINE__);
        }
        if (is_null($isOpenedToDisplay) || (is_array($isOpenedToDisplay) && empty($isOpenedToDisplay))) {
            unset($this->IsOpenedToDisplay);
        } else {
            $this->IsOpenedToDisplay = $isOpenedToDisplay;
        }
        return $this;
    }
    /**
     * Get MaxSeatsPerClientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats|null
     */
    public function getMaxSeatsPerClientType()
    {
        return isset($this->MaxSeatsPerClientType) ? $this->MaxSeatsPerClientType : null;
    }
    /**
     * Set MaxSeatsPerClientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats $maxSeatsPerClientType
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setMaxSeatsPerClientType(\patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats $maxSeatsPerClientType = null)
    {
        if (is_null($maxSeatsPerClientType) || (is_array($maxSeatsPerClientType) && empty($maxSeatsPerClientType))) {
            unset($this->MaxSeatsPerClientType);
        } else {
            $this->MaxSeatsPerClientType = $maxSeatsPerClientType;
        }
        return $this;
    }
    /**
     * Get MaxSeatsPerPersonPerEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSeatsPerPersonPerEvent()
    {
        return isset($this->MaxSeatsPerPersonPerEvent) ? $this->MaxSeatsPerPersonPerEvent : null;
    }
    /**
     * Set MaxSeatsPerPersonPerEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSeatsPerPersonPerEvent
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setMaxSeatsPerPersonPerEvent($maxSeatsPerPersonPerEvent = null)
    {
        // validation for constraint: int
        if (!is_null($maxSeatsPerPersonPerEvent) && !(is_int($maxSeatsPerPersonPerEvent) || ctype_digit($maxSeatsPerPersonPerEvent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSeatsPerPersonPerEvent, true), gettype($maxSeatsPerPersonPerEvent)), __LINE__);
        }
        if (is_null($maxSeatsPerPersonPerEvent) || (is_array($maxSeatsPerPersonPerEvent) && empty($maxSeatsPerPersonPerEvent))) {
            unset($this->MaxSeatsPerPersonPerEvent);
        } else {
            $this->MaxSeatsPerPersonPerEvent = $maxSeatsPerPersonPerEvent;
        }
        return $this;
    }
    /**
     * Get MaxWins value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxWins()
    {
        return isset($this->MaxWins) ? $this->MaxWins : null;
    }
    /**
     * Set MaxWins value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxWins
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setMaxWins($maxWins = null)
    {
        // validation for constraint: int
        if (!is_null($maxWins) && !(is_int($maxWins) || ctype_digit($maxWins))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxWins, true), gettype($maxWins)), __LINE__);
        }
        if (is_null($maxWins) || (is_array($maxWins) && empty($maxWins))) {
            unset($this->MaxWins);
        } else {
            $this->MaxWins = $maxWins;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Media $media
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setMedia(\patest\StructType\Ticketing_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MultiEventDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMultiEventDescription()
    {
        return isset($this->MultiEventDescription) ? $this->MultiEventDescription : null;
    }
    /**
     * Set MultiEventDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $multiEventDescription
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setMultiEventDescription(\patest\StructType\GlobalString $multiEventDescription = null)
    {
        if (is_null($multiEventDescription) || (is_array($multiEventDescription) && empty($multiEventDescription))) {
            unset($this->MultiEventDescription);
        } else {
            $this->MultiEventDescription = $multiEventDescription;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OnlineDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOnlineDescription()
    {
        return isset($this->OnlineDescription) ? $this->OnlineDescription : null;
    }
    /**
     * Set OnlineDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $onlineDescription
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setOnlineDescription(\patest\StructType\GlobalString $onlineDescription = null)
    {
        if (is_null($onlineDescription) || (is_array($onlineDescription) && empty($onlineDescription))) {
            unset($this->OnlineDescription);
        } else {
            $this->OnlineDescription = $onlineDescription;
        }
        return $this;
    }
    /**
     * Get Operational value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOperational()
    {
        return isset($this->Operational) ? $this->Operational : null;
    }
    /**
     * Set Operational value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $operational
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setOperational($operational = null)
    {
        // validation for constraint: boolean
        if (!is_null($operational) && !is_bool($operational)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($operational, true), gettype($operational)), __LINE__);
        }
        if (is_null($operational) || (is_array($operational) && empty($operational))) {
            unset($this->Operational);
        } else {
            $this->Operational = $operational;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get SaleModeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeId()
    {
        return isset($this->SaleModeId) ? $this->SaleModeId : null;
    }
    /**
     * Set SaleModeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeId
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setSaleModeId($saleModeId = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeId) && !is_string($saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeId, true), gettype($saleModeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeId, true)), __LINE__);
        }
        if (is_null($saleModeId) || (is_array($saleModeId) && empty($saleModeId))) {
            unset($this->SaleModeId);
        } else {
            $this->SaleModeId = $saleModeId;
        }
        return $this;
    }
    /**
     * Get ScaledModeExposedToFans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getScaledModeExposedToFans()
    {
        return isset($this->ScaledModeExposedToFans) ? $this->ScaledModeExposedToFans : null;
    }
    /**
     * Set ScaledModeExposedToFans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $scaledModeExposedToFans
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setScaledModeExposedToFans($scaledModeExposedToFans = null)
    {
        // validation for constraint: boolean
        if (!is_null($scaledModeExposedToFans) && !is_bool($scaledModeExposedToFans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scaledModeExposedToFans, true), gettype($scaledModeExposedToFans)), __LINE__);
        }
        if (is_null($scaledModeExposedToFans) || (is_array($scaledModeExposedToFans) && empty($scaledModeExposedToFans))) {
            unset($this->ScaledModeExposedToFans);
        } else {
            $this->ScaledModeExposedToFans = $scaledModeExposedToFans;
        }
        return $this;
    }
    /**
     * Get SecondaryPreferenceDefaultState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSecondaryPreferenceDefaultState()
    {
        return isset($this->SecondaryPreferenceDefaultState) ? $this->SecondaryPreferenceDefaultState : null;
    }
    /**
     * Set SecondaryPreferenceDefaultState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $secondaryPreferenceDefaultState
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setSecondaryPreferenceDefaultState($secondaryPreferenceDefaultState = null)
    {
        // validation for constraint: boolean
        if (!is_null($secondaryPreferenceDefaultState) && !is_bool($secondaryPreferenceDefaultState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($secondaryPreferenceDefaultState, true), gettype($secondaryPreferenceDefaultState)), __LINE__);
        }
        if (is_null($secondaryPreferenceDefaultState) || (is_array($secondaryPreferenceDefaultState) && empty($secondaryPreferenceDefaultState))) {
            unset($this->SecondaryPreferenceDefaultState);
        } else {
            $this->SecondaryPreferenceDefaultState = $secondaryPreferenceDefaultState;
        }
        return $this;
    }
    /**
     * Get StartActiveDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartActiveDateTime()
    {
        return isset($this->StartActiveDateTime) ? $this->StartActiveDateTime : null;
    }
    /**
     * Set StartActiveDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startActiveDateTime
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setStartActiveDateTime($startActiveDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startActiveDateTime) && !is_string($startActiveDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startActiveDateTime, true), gettype($startActiveDateTime)), __LINE__);
        }
        if (is_null($startActiveDateTime) || (is_array($startActiveDateTime) && empty($startActiveDateTime))) {
            unset($this->StartActiveDateTime);
        } else {
            $this->StartActiveDateTime = $startActiveDateTime;
        }
        return $this;
    }
    /**
     * Get StartOpenDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartOpenDateTime()
    {
        return isset($this->StartOpenDateTime) ? $this->StartOpenDateTime : null;
    }
    /**
     * Set StartOpenDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startOpenDateTime
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setStartOpenDateTime($startOpenDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($startOpenDateTime) && !is_string($startOpenDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startOpenDateTime, true), gettype($startOpenDateTime)), __LINE__);
        }
        if (is_null($startOpenDateTime) || (is_array($startOpenDateTime) && empty($startOpenDateTime))) {
            unset($this->StartOpenDateTime);
        } else {
            $this->StartOpenDateTime = $startOpenDateTime;
        }
        return $this;
    }
    /**
     * Get StartShowingResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartShowingResults()
    {
        return isset($this->StartShowingResults) ? $this->StartShowingResults : null;
    }
    /**
     * Set StartShowingResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startShowingResults
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setStartShowingResults($startShowingResults = null)
    {
        // validation for constraint: string
        if (!is_null($startShowingResults) && !is_string($startShowingResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startShowingResults, true), gettype($startShowingResults)), __LINE__);
        }
        if (is_null($startShowingResults) || (is_array($startShowingResults) && empty($startShowingResults))) {
            unset($this->StartShowingResults);
        } else {
            $this->StartShowingResults = $startShowingResults;
        }
        return $this;
    }
    /**
     * Get VirtualPriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotVirtualPriceType|null
     */
    public function getVirtualPriceTypes()
    {
        return isset($this->VirtualPriceTypes) ? $this->VirtualPriceTypes : null;
    }
    /**
     * Set VirtualPriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotVirtualPriceType $virtualPriceTypes
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setVirtualPriceTypes(\patest\StructType\RecordSetOfTicketing_BallotVirtualPriceType $virtualPriceTypes = null)
    {
        if (is_null($virtualPriceTypes) || (is_array($virtualPriceTypes) && empty($virtualPriceTypes))) {
            unset($this->VirtualPriceTypes);
        } else {
            $this->VirtualPriceTypes = $virtualPriceTypes;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Ticketing_Ballot
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
