<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewEventConfiguration StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewEventConfiguration
 * @subpackage Structs
 */
class TicketViewEventConfiguration extends ExtensibleDataContract
{
    /**
     * The ConfigurationsProcessed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ConfigurationsProcessed;
    /**
     * The EventLevelImageConfiguration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventLevelImageConfiguration
     */
    public $EventLevelImageConfiguration;
    /**
     * The MyTicketsCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MyTicketsCardWithUrlsAndAdditionalNote
     */
    public $MyTicketsCard;
    /**
     * Constructor method for TicketViewEventConfiguration
     * @uses TicketViewEventConfiguration::setConfigurationsProcessed()
     * @uses TicketViewEventConfiguration::setEventLevelImageConfiguration()
     * @uses TicketViewEventConfiguration::setMyTicketsCard()
     * @param bool $configurationsProcessed
     * @param \patest\StructType\EventLevelImageConfiguration $eventLevelImageConfiguration
     * @param \patest\StructType\MyTicketsCardWithUrlsAndAdditionalNote $myTicketsCard
     */
    public function __construct($configurationsProcessed = null, \patest\StructType\EventLevelImageConfiguration $eventLevelImageConfiguration = null, \patest\StructType\MyTicketsCardWithUrlsAndAdditionalNote $myTicketsCard = null)
    {
        $this
            ->setConfigurationsProcessed($configurationsProcessed)
            ->setEventLevelImageConfiguration($eventLevelImageConfiguration)
            ->setMyTicketsCard($myTicketsCard);
    }
    /**
     * Get ConfigurationsProcessed value
     * @return bool|null
     */
    public function getConfigurationsProcessed()
    {
        return $this->ConfigurationsProcessed;
    }
    /**
     * Set ConfigurationsProcessed value
     * @param bool $configurationsProcessed
     * @return \patest\StructType\TicketViewEventConfiguration
     */
    public function setConfigurationsProcessed($configurationsProcessed = null)
    {
        // validation for constraint: boolean
        if (!is_null($configurationsProcessed) && !is_bool($configurationsProcessed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($configurationsProcessed, true), gettype($configurationsProcessed)), __LINE__);
        }
        $this->ConfigurationsProcessed = $configurationsProcessed;
        return $this;
    }
    /**
     * Get EventLevelImageConfiguration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventLevelImageConfiguration|null
     */
    public function getEventLevelImageConfiguration()
    {
        return isset($this->EventLevelImageConfiguration) ? $this->EventLevelImageConfiguration : null;
    }
    /**
     * Set EventLevelImageConfiguration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventLevelImageConfiguration $eventLevelImageConfiguration
     * @return \patest\StructType\TicketViewEventConfiguration
     */
    public function setEventLevelImageConfiguration(\patest\StructType\EventLevelImageConfiguration $eventLevelImageConfiguration = null)
    {
        if (is_null($eventLevelImageConfiguration) || (is_array($eventLevelImageConfiguration) && empty($eventLevelImageConfiguration))) {
            unset($this->EventLevelImageConfiguration);
        } else {
            $this->EventLevelImageConfiguration = $eventLevelImageConfiguration;
        }
        return $this;
    }
    /**
     * Get MyTicketsCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MyTicketsCardWithUrlsAndAdditionalNote|null
     */
    public function getMyTicketsCard()
    {
        return isset($this->MyTicketsCard) ? $this->MyTicketsCard : null;
    }
    /**
     * Set MyTicketsCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\MyTicketsCardWithUrlsAndAdditionalNote $myTicketsCard
     * @return \patest\StructType\TicketViewEventConfiguration
     */
    public function setMyTicketsCard(\patest\StructType\MyTicketsCardWithUrlsAndAdditionalNote $myTicketsCard = null)
    {
        if (is_null($myTicketsCard) || (is_array($myTicketsCard) && empty($myTicketsCard))) {
            unset($this->MyTicketsCard);
        } else {
            $this->MyTicketsCard = $myTicketsCard;
        }
        return $this;
    }
}
