<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewAssociationCriteriaBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewAssociationCriteriaBase
 * @subpackage Structs
 */
class TicketViewAssociationCriteriaBase extends ExtensibleDataContract
{
    /**
     * The CriteriaAttribute
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CriteriaAttribute;
    /**
     * The CriteriaOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CriteriaOperation;
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Invert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Invert;
    /**
     * Constructor method for TicketViewAssociationCriteriaBase
     * @uses TicketViewAssociationCriteriaBase::setCriteriaAttribute()
     * @uses TicketViewAssociationCriteriaBase::setCriteriaOperation()
     * @uses TicketViewAssociationCriteriaBase::setHallVersionId()
     * @uses TicketViewAssociationCriteriaBase::setId()
     * @uses TicketViewAssociationCriteriaBase::setInvert()
     * @param string $criteriaAttribute
     * @param string $criteriaOperation
     * @param string $hallVersionId
     * @param string $id
     * @param bool $invert
     */
    public function __construct($criteriaAttribute = null, $criteriaOperation = null, $hallVersionId = null, $id = null, $invert = null)
    {
        $this
            ->setCriteriaAttribute($criteriaAttribute)
            ->setCriteriaOperation($criteriaOperation)
            ->setHallVersionId($hallVersionId)
            ->setId($id)
            ->setInvert($invert);
    }
    /**
     * Get CriteriaAttribute value
     * @return string|null
     */
    public function getCriteriaAttribute()
    {
        return $this->CriteriaAttribute;
    }
    /**
     * Set CriteriaAttribute value
     * @uses \patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute::valueIsValid()
     * @uses \patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $criteriaAttribute
     * @return \patest\StructType\TicketViewAssociationCriteriaBase
     */
    public function setCriteriaAttribute($criteriaAttribute = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute::valueIsValid($criteriaAttribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute', is_array($criteriaAttribute) ? implode(', ', $criteriaAttribute) : var_export($criteriaAttribute, true), implode(', ', \patest\EnumType\TicketViewTemplateAssociationCriteriaAttribute::getValidValues())), __LINE__);
        }
        $this->CriteriaAttribute = $criteriaAttribute;
        return $this;
    }
    /**
     * Get CriteriaOperation value
     * @return string|null
     */
    public function getCriteriaOperation()
    {
        return $this->CriteriaOperation;
    }
    /**
     * Set CriteriaOperation value
     * @uses \patest\EnumType\TicketViewTemplateAssociationCriteriaOperation::valueIsValid()
     * @uses \patest\EnumType\TicketViewTemplateAssociationCriteriaOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $criteriaOperation
     * @return \patest\StructType\TicketViewAssociationCriteriaBase
     */
    public function setCriteriaOperation($criteriaOperation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewTemplateAssociationCriteriaOperation::valueIsValid($criteriaOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewTemplateAssociationCriteriaOperation', is_array($criteriaOperation) ? implode(', ', $criteriaOperation) : var_export($criteriaOperation, true), implode(', ', \patest\EnumType\TicketViewTemplateAssociationCriteriaOperation::getValidValues())), __LINE__);
        }
        $this->CriteriaOperation = $criteriaOperation;
        return $this;
    }
    /**
     * Get HallVersionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallVersionId()
    {
        return isset($this->HallVersionId) ? $this->HallVersionId : null;
    }
    /**
     * Set HallVersionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallVersionId
     * @return \patest\StructType\TicketViewAssociationCriteriaBase
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        if (is_null($hallVersionId) || (is_array($hallVersionId) && empty($hallVersionId))) {
            unset($this->HallVersionId);
        } else {
            $this->HallVersionId = $hallVersionId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\TicketViewAssociationCriteriaBase
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Invert value
     * @return bool|null
     */
    public function getInvert()
    {
        return $this->Invert;
    }
    /**
     * Set Invert value
     * @param bool $invert
     * @return \patest\StructType\TicketViewAssociationCriteriaBase
     */
    public function setInvert($invert = null)
    {
        // validation for constraint: boolean
        if (!is_null($invert) && !is_bool($invert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invert, true), gettype($invert)), __LINE__);
        }
        $this->Invert = $invert;
        return $this;
    }
}
