<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketSchemeEnrollmentData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketSchemeEnrollmentData
 * @subpackage Structs
 */
class TicketSchemeEnrollmentData extends ExtensibleDataContract
{
    /**
     * The Enrollments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfEnrollmentAndTicketsData
     */
    public $Enrollments;
    /**
     * The SomeTicketsRequirePurchaseOnEnrollForClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SomeTicketsRequirePurchaseOnEnrollForClient;
    /**
     * The TicketScheme
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_TicketScheme
     */
    public $TicketScheme;
    /**
     * The Transactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketSchemeTransactionData
     */
    public $Transactions;
    /**
     * Constructor method for TicketSchemeEnrollmentData
     * @uses TicketSchemeEnrollmentData::setEnrollments()
     * @uses TicketSchemeEnrollmentData::setSomeTicketsRequirePurchaseOnEnrollForClient()
     * @uses TicketSchemeEnrollmentData::setTicketScheme()
     * @uses TicketSchemeEnrollmentData::setTransactions()
     * @param \patest\ArrayType\ArrayOfEnrollmentAndTicketsData $enrollments
     * @param bool $someTicketsRequirePurchaseOnEnrollForClient
     * @param \patest\StructType\Crm_TicketScheme $ticketScheme
     * @param \patest\ArrayType\ArrayOfTicketSchemeTransactionData $transactions
     */
    public function __construct(\patest\ArrayType\ArrayOfEnrollmentAndTicketsData $enrollments = null, $someTicketsRequirePurchaseOnEnrollForClient = null, \patest\StructType\Crm_TicketScheme $ticketScheme = null, \patest\ArrayType\ArrayOfTicketSchemeTransactionData $transactions = null)
    {
        $this
            ->setEnrollments($enrollments)
            ->setSomeTicketsRequirePurchaseOnEnrollForClient($someTicketsRequirePurchaseOnEnrollForClient)
            ->setTicketScheme($ticketScheme)
            ->setTransactions($transactions);
    }
    /**
     * Get Enrollments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfEnrollmentAndTicketsData|null
     */
    public function getEnrollments()
    {
        return isset($this->Enrollments) ? $this->Enrollments : null;
    }
    /**
     * Set Enrollments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfEnrollmentAndTicketsData $enrollments
     * @return \patest\StructType\TicketSchemeEnrollmentData
     */
    public function setEnrollments(\patest\ArrayType\ArrayOfEnrollmentAndTicketsData $enrollments = null)
    {
        if (is_null($enrollments) || (is_array($enrollments) && empty($enrollments))) {
            unset($this->Enrollments);
        } else {
            $this->Enrollments = $enrollments;
        }
        return $this;
    }
    /**
     * Get SomeTicketsRequirePurchaseOnEnrollForClient value
     * @return bool|null
     */
    public function getSomeTicketsRequirePurchaseOnEnrollForClient()
    {
        return $this->SomeTicketsRequirePurchaseOnEnrollForClient;
    }
    /**
     * Set SomeTicketsRequirePurchaseOnEnrollForClient value
     * @param bool $someTicketsRequirePurchaseOnEnrollForClient
     * @return \patest\StructType\TicketSchemeEnrollmentData
     */
    public function setSomeTicketsRequirePurchaseOnEnrollForClient($someTicketsRequirePurchaseOnEnrollForClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($someTicketsRequirePurchaseOnEnrollForClient) && !is_bool($someTicketsRequirePurchaseOnEnrollForClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($someTicketsRequirePurchaseOnEnrollForClient, true), gettype($someTicketsRequirePurchaseOnEnrollForClient)), __LINE__);
        }
        $this->SomeTicketsRequirePurchaseOnEnrollForClient = $someTicketsRequirePurchaseOnEnrollForClient;
        return $this;
    }
    /**
     * Get TicketScheme value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_TicketScheme|null
     */
    public function getTicketScheme()
    {
        return isset($this->TicketScheme) ? $this->TicketScheme : null;
    }
    /**
     * Set TicketScheme value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_TicketScheme $ticketScheme
     * @return \patest\StructType\TicketSchemeEnrollmentData
     */
    public function setTicketScheme(\patest\StructType\Crm_TicketScheme $ticketScheme = null)
    {
        if (is_null($ticketScheme) || (is_array($ticketScheme) && empty($ticketScheme))) {
            unset($this->TicketScheme);
        } else {
            $this->TicketScheme = $ticketScheme;
        }
        return $this;
    }
    /**
     * Get Transactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketSchemeTransactionData|null
     */
    public function getTransactions()
    {
        return isset($this->Transactions) ? $this->Transactions : null;
    }
    /**
     * Set Transactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketSchemeTransactionData $transactions
     * @return \patest\StructType\TicketSchemeEnrollmentData
     */
    public function setTransactions(\patest\ArrayType\ArrayOfTicketSchemeTransactionData $transactions = null)
    {
        if (is_null($transactions) || (is_array($transactions) && empty($transactions))) {
            unset($this->Transactions);
        } else {
            $this->Transactions = $transactions;
        }
        return $this;
    }
}
