<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketItem
 * @subpackage Structs
 */
class TicketItem extends AbstractProductItem
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaName;
    /**
     * The Availability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Availability;
    /**
     * The EventDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventDateTime;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelName;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The SeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatId;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeatingType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SeatingType;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectorName;
    /**
     * The ShowId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowId;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowName;
    /**
     * The ShowTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowTypeId;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TicketNumber;
    /**
     * The WaitMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WaitMode;
    /**
     * The IsAutoCatchInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoCatchInSubscription;
    /**
     * The IsSubscriptionInBasket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriptionInBasket;
    /**
     * The ReturnAgainstSubscriptionBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnAgainstSubscriptionBalance;
    /**
     * The RoleInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoleInSubscription;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The ContinuedByAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContinuedByAction;
    /**
     * The ContinuedByTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContinuedByTicketId;
    /**
     * The FormattedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedDate;
    /**
     * The HasBackwardContinuation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasBackwardContinuation;
    /**
     * The IsIrregularInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIrregularInSubscription;
    /**
     * The IsReplaceableInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReplaceableInSubscription;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesName;
    /**
     * The SubscriberTicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberTicketType;
    /**
     * The _Reserved1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $_Reserved1;
    /**
     * The _Reserved2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $_Reserved2;
    /**
     * The RelatedSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedSubscriptionInstanceId;
    /**
     * The WorthInSubscriptionBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $WorthInSubscriptionBalance;
    /**
     * The CompensationOfTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CompensationOfTicketId;
    /**
     * The ConsumedAllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ConsumedAllocationTypeId;
    /**
     * The ForcedAllocationTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForcedAllocationTypeId;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsResale;
    /**
     * The ResaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleStatus;
    /**
     * The PrintMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethod;
    /**
     * The PrintMethodData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethodData;
    /**
     * The SeatAllocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatAllocations;
    /**
     * The SeatLock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatLock;
    /**
     * The SeatTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatTypeId;
    /**
     * The TurnbackDonationProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TurnbackDonationProductId;
    /**
     * The OriginalTicketForResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketIdentity
     */
    public $OriginalTicketForResale;
    /**
     * The IsHospitality
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsHospitality;
    /**
     * The SlotIdInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SlotIdInSubscription;
    /**
     * The PrintedAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedAs;
    /**
     * The IsOnlineForwarded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOnlineForwarded;
    /**
     * The IsFullStackExchangedSubscriptionTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullStackExchangedSubscriptionTicket;
    /**
     * The StandId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StandId;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StandName;
    /**
     * The NumberOfOwnershipChanges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfOwnershipChanges;
    /**
     * The ResaleMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleMethod;
    /**
     * The AccessCodeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCodeId;
    /**
     * Constructor method for TicketItem
     * @uses TicketItem::setAreaId()
     * @uses TicketItem::setAreaName()
     * @uses TicketItem::setAvailability()
     * @uses TicketItem::setEventDateTime()
     * @uses TicketItem::setEventId()
     * @uses TicketItem::setHallId()
     * @uses TicketItem::setHallName()
     * @uses TicketItem::setPriceLevelId()
     * @uses TicketItem::setPriceLevelName()
     * @uses TicketItem::setRowName()
     * @uses TicketItem::setSeatId()
     * @uses TicketItem::setSeatName()
     * @uses TicketItem::setSeatingType()
     * @uses TicketItem::setSectorName()
     * @uses TicketItem::setShowId()
     * @uses TicketItem::setShowName()
     * @uses TicketItem::setShowTypeId()
     * @uses TicketItem::setTicketNumber()
     * @uses TicketItem::setWaitMode()
     * @uses TicketItem::setIsAutoCatchInSubscription()
     * @uses TicketItem::setIsSubscriptionInBasket()
     * @uses TicketItem::setReturnAgainstSubscriptionBalance()
     * @uses TicketItem::setRoleInSubscription()
     * @uses TicketItem::setSeriesId()
     * @uses TicketItem::setSubscriptionInstanceId()
     * @uses TicketItem::setContinuedByAction()
     * @uses TicketItem::setContinuedByTicketId()
     * @uses TicketItem::setFormattedDate()
     * @uses TicketItem::setHasBackwardContinuation()
     * @uses TicketItem::setIsIrregularInSubscription()
     * @uses TicketItem::setIsReplaceableInSubscription()
     * @uses TicketItem::setSeriesName()
     * @uses TicketItem::setSubscriberTicketType()
     * @uses TicketItem::set_Reserved1()
     * @uses TicketItem::set_Reserved2()
     * @uses TicketItem::setRelatedSubscriptionInstanceId()
     * @uses TicketItem::setWorthInSubscriptionBalance()
     * @uses TicketItem::setCompensationOfTicketId()
     * @uses TicketItem::setConsumedAllocationTypeId()
     * @uses TicketItem::setForcedAllocationTypeId()
     * @uses TicketItem::setIsResale()
     * @uses TicketItem::setResaleStatus()
     * @uses TicketItem::setPrintMethod()
     * @uses TicketItem::setPrintMethodData()
     * @uses TicketItem::setSeatAllocations()
     * @uses TicketItem::setSeatLock()
     * @uses TicketItem::setSeatTypeId()
     * @uses TicketItem::setTurnbackDonationProductId()
     * @uses TicketItem::setOriginalTicketForResale()
     * @uses TicketItem::setIsHospitality()
     * @uses TicketItem::setSlotIdInSubscription()
     * @uses TicketItem::setPrintedAs()
     * @uses TicketItem::setIsOnlineForwarded()
     * @uses TicketItem::setIsFullStackExchangedSubscriptionTicket()
     * @uses TicketItem::setStandId()
     * @uses TicketItem::setStandName()
     * @uses TicketItem::setNumberOfOwnershipChanges()
     * @uses TicketItem::setResaleMethod()
     * @uses TicketItem::setAccessCodeId()
     * @param string $areaId
     * @param string $areaName
     * @param string $availability
     * @param string $eventDateTime
     * @param string $eventId
     * @param string $hallId
     * @param string $hallName
     * @param string $priceLevelId
     * @param string $priceLevelName
     * @param string $rowName
     * @param int $seatId
     * @param string $seatName
     * @param string $seatingType
     * @param string $sectorName
     * @param string $showId
     * @param string $showName
     * @param string $showTypeId
     * @param int $ticketNumber
     * @param string $waitMode
     * @param bool $isAutoCatchInSubscription
     * @param bool $isSubscriptionInBasket
     * @param bool $returnAgainstSubscriptionBalance
     * @param string $roleInSubscription
     * @param string $seriesId
     * @param string $subscriptionInstanceId
     * @param string $continuedByAction
     * @param string $continuedByTicketId
     * @param string $formattedDate
     * @param bool $hasBackwardContinuation
     * @param bool $isIrregularInSubscription
     * @param bool $isReplaceableInSubscription
     * @param string $seriesName
     * @param string $subscriberTicketType
     * @param string $_Reserved1
     * @param string $_Reserved2
     * @param string $relatedSubscriptionInstanceId
     * @param float $worthInSubscriptionBalance
     * @param string $compensationOfTicketId
     * @param string $consumedAllocationTypeId
     * @param string $forcedAllocationTypeId
     * @param bool $isResale
     * @param string $resaleStatus
     * @param string $printMethod
     * @param string $printMethodData
     * @param string $seatAllocations
     * @param string $seatLock
     * @param string $seatTypeId
     * @param string $turnbackDonationProductId
     * @param \patest\StructType\TicketIdentity $originalTicketForResale
     * @param bool $isHospitality
     * @param int $slotIdInSubscription
     * @param string $printedAs
     * @param bool $isOnlineForwarded
     * @param bool $isFullStackExchangedSubscriptionTicket
     * @param string $standId
     * @param string $standName
     * @param int $numberOfOwnershipChanges
     * @param string $resaleMethod
     * @param string $accessCodeId
     */
    public function __construct($areaId = null, $areaName = null, $availability = null, $eventDateTime = null, $eventId = null, $hallId = null, $hallName = null, $priceLevelId = null, $priceLevelName = null, $rowName = null, $seatId = null, $seatName = null, $seatingType = null, $sectorName = null, $showId = null, $showName = null, $showTypeId = null, $ticketNumber = null, $waitMode = null, $isAutoCatchInSubscription = null, $isSubscriptionInBasket = null, $returnAgainstSubscriptionBalance = null, $roleInSubscription = null, $seriesId = null, $subscriptionInstanceId = null, $continuedByAction = null, $continuedByTicketId = null, $formattedDate = null, $hasBackwardContinuation = null, $isIrregularInSubscription = null, $isReplaceableInSubscription = null, $seriesName = null, $subscriberTicketType = null, $_Reserved1 = null, $_Reserved2 = null, $relatedSubscriptionInstanceId = null, $worthInSubscriptionBalance = null, $compensationOfTicketId = null, $consumedAllocationTypeId = null, $forcedAllocationTypeId = null, $isResale = null, $resaleStatus = null, $printMethod = null, $printMethodData = null, $seatAllocations = null, $seatLock = null, $seatTypeId = null, $turnbackDonationProductId = null, \patest\StructType\TicketIdentity $originalTicketForResale = null, $isHospitality = null, $slotIdInSubscription = null, $printedAs = null, $isOnlineForwarded = null, $isFullStackExchangedSubscriptionTicket = null, $standId = null, $standName = null, $numberOfOwnershipChanges = null, $resaleMethod = null, $accessCodeId = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setAvailability($availability)
            ->setEventDateTime($eventDateTime)
            ->setEventId($eventId)
            ->setHallId($hallId)
            ->setHallName($hallName)
            ->setPriceLevelId($priceLevelId)
            ->setPriceLevelName($priceLevelName)
            ->setRowName($rowName)
            ->setSeatId($seatId)
            ->setSeatName($seatName)
            ->setSeatingType($seatingType)
            ->setSectorName($sectorName)
            ->setShowId($showId)
            ->setShowName($showName)
            ->setShowTypeId($showTypeId)
            ->setTicketNumber($ticketNumber)
            ->setWaitMode($waitMode)
            ->setIsAutoCatchInSubscription($isAutoCatchInSubscription)
            ->setIsSubscriptionInBasket($isSubscriptionInBasket)
            ->setReturnAgainstSubscriptionBalance($returnAgainstSubscriptionBalance)
            ->setRoleInSubscription($roleInSubscription)
            ->setSeriesId($seriesId)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setContinuedByAction($continuedByAction)
            ->setContinuedByTicketId($continuedByTicketId)
            ->setFormattedDate($formattedDate)
            ->setHasBackwardContinuation($hasBackwardContinuation)
            ->setIsIrregularInSubscription($isIrregularInSubscription)
            ->setIsReplaceableInSubscription($isReplaceableInSubscription)
            ->setSeriesName($seriesName)
            ->setSubscriberTicketType($subscriberTicketType)
            ->set_Reserved1($_Reserved1)
            ->set_Reserved2($_Reserved2)
            ->setRelatedSubscriptionInstanceId($relatedSubscriptionInstanceId)
            ->setWorthInSubscriptionBalance($worthInSubscriptionBalance)
            ->setCompensationOfTicketId($compensationOfTicketId)
            ->setConsumedAllocationTypeId($consumedAllocationTypeId)
            ->setForcedAllocationTypeId($forcedAllocationTypeId)
            ->setIsResale($isResale)
            ->setResaleStatus($resaleStatus)
            ->setPrintMethod($printMethod)
            ->setPrintMethodData($printMethodData)
            ->setSeatAllocations($seatAllocations)
            ->setSeatLock($seatLock)
            ->setSeatTypeId($seatTypeId)
            ->setTurnbackDonationProductId($turnbackDonationProductId)
            ->setOriginalTicketForResale($originalTicketForResale)
            ->setIsHospitality($isHospitality)
            ->setSlotIdInSubscription($slotIdInSubscription)
            ->setPrintedAs($printedAs)
            ->setIsOnlineForwarded($isOnlineForwarded)
            ->setIsFullStackExchangedSubscriptionTicket($isFullStackExchangedSubscriptionTicket)
            ->setStandId($standId)
            ->setStandName($standName)
            ->setNumberOfOwnershipChanges($numberOfOwnershipChanges)
            ->setResaleMethod($resaleMethod)
            ->setAccessCodeId($accessCodeId);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\TicketItem
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaName
     * @return \patest\StructType\TicketItem
     */
    public function setAreaName($areaName = null)
    {
        // validation for constraint: string
        if (!is_null($areaName) && !is_string($areaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaName, true), gettype($areaName)), __LINE__);
        }
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get Availability value
     * @return string|null
     */
    public function getAvailability()
    {
        return $this->Availability;
    }
    /**
     * Set Availability value
     * @uses \patest\EnumType\SeatAvailability::valueIsValid()
     * @uses \patest\EnumType\SeatAvailability::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availability
     * @return \patest\StructType\TicketItem
     */
    public function setAvailability($availability = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatAvailability::valueIsValid($availability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatAvailability', is_array($availability) ? implode(', ', $availability) : var_export($availability, true), implode(', ', \patest\EnumType\SeatAvailability::getValidValues())), __LINE__);
        }
        $this->Availability = $availability;
        return $this;
    }
    /**
     * Get EventDateTime value
     * @return string|null
     */
    public function getEventDateTime()
    {
        return $this->EventDateTime;
    }
    /**
     * Set EventDateTime value
     * @param string $eventDateTime
     * @return \patest\StructType\TicketItem
     */
    public function setEventDateTime($eventDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateTime) && !is_string($eventDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateTime, true), gettype($eventDateTime)), __LINE__);
        }
        $this->EventDateTime = $eventDateTime;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\TicketItem
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get HallId value
     * @return string|null
     */
    public function getHallId()
    {
        return $this->HallId;
    }
    /**
     * Set HallId value
     * @param string $hallId
     * @return \patest\StructType\TicketItem
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        $this->HallId = $hallId;
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\TicketItem
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\TicketItem
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelName
     * @return \patest\StructType\TicketItem
     */
    public function setPriceLevelName($priceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelName) && !is_string($priceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelName, true), gettype($priceLevelName)), __LINE__);
        }
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\TicketItem
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get SeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatId()
    {
        return isset($this->SeatId) ? $this->SeatId : null;
    }
    /**
     * Set SeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatId
     * @return \patest\StructType\TicketItem
     */
    public function setSeatId($seatId = null)
    {
        // validation for constraint: int
        if (!is_null($seatId) && !(is_int($seatId) || ctype_digit($seatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatId, true), gettype($seatId)), __LINE__);
        }
        if (is_null($seatId) || (is_array($seatId) && empty($seatId))) {
            unset($this->SeatId);
        } else {
            $this->SeatId = $seatId;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\TicketItem
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeatingType value
     * @return string|null
     */
    public function getSeatingType()
    {
        return $this->SeatingType;
    }
    /**
     * Set SeatingType value
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatingType
     * @return \patest\StructType\TicketItem
     */
    public function setSeatingType($seatingType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($seatingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($seatingType) ? implode(', ', $seatingType) : var_export($seatingType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        $this->SeatingType = $seatingType;
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorName
     * @return \patest\StructType\TicketItem
     */
    public function setSectorName($sectorName = null)
    {
        // validation for constraint: string
        if (!is_null($sectorName) && !is_string($sectorName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorName, true), gettype($sectorName)), __LINE__);
        }
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get ShowId value
     * @return string|null
     */
    public function getShowId()
    {
        return $this->ShowId;
    }
    /**
     * Set ShowId value
     * @param string $showId
     * @return \patest\StructType\TicketItem
     */
    public function setShowId($showId = null)
    {
        // validation for constraint: string
        if (!is_null($showId) && !is_string($showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showId, true), gettype($showId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showId, true)), __LINE__);
        }
        $this->ShowId = $showId;
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showName
     * @return \patest\StructType\TicketItem
     */
    public function setShowName($showName = null)
    {
        // validation for constraint: string
        if (!is_null($showName) && !is_string($showName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showName, true), gettype($showName)), __LINE__);
        }
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get ShowTypeId value
     * @return string|null
     */
    public function getShowTypeId()
    {
        return $this->ShowTypeId;
    }
    /**
     * Set ShowTypeId value
     * @param string $showTypeId
     * @return \patest\StructType\TicketItem
     */
    public function setShowTypeId($showTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($showTypeId) && !is_string($showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTypeId, true), gettype($showTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showTypeId, true)), __LINE__);
        }
        $this->ShowTypeId = $showTypeId;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return int|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param int $ticketNumber
     * @return \patest\StructType\TicketItem
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get WaitMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWaitMode()
    {
        return isset($this->WaitMode) ? $this->WaitMode : null;
    }
    /**
     * Set WaitMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketWaitMode::valueIsValid()
     * @uses \patest\EnumType\TicketWaitMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $waitMode
     * @return \patest\StructType\TicketItem
     */
    public function setWaitMode($waitMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketWaitMode::valueIsValid($waitMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketWaitMode', is_array($waitMode) ? implode(', ', $waitMode) : var_export($waitMode, true), implode(', ', \patest\EnumType\TicketWaitMode::getValidValues())), __LINE__);
        }
        if (is_null($waitMode) || (is_array($waitMode) && empty($waitMode))) {
            unset($this->WaitMode);
        } else {
            $this->WaitMode = $waitMode;
        }
        return $this;
    }
    /**
     * Get IsAutoCatchInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoCatchInSubscription()
    {
        return isset($this->IsAutoCatchInSubscription) ? $this->IsAutoCatchInSubscription : null;
    }
    /**
     * Set IsAutoCatchInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoCatchInSubscription
     * @return \patest\StructType\TicketItem
     */
    public function setIsAutoCatchInSubscription($isAutoCatchInSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoCatchInSubscription) && !is_bool($isAutoCatchInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoCatchInSubscription, true), gettype($isAutoCatchInSubscription)), __LINE__);
        }
        if (is_null($isAutoCatchInSubscription) || (is_array($isAutoCatchInSubscription) && empty($isAutoCatchInSubscription))) {
            unset($this->IsAutoCatchInSubscription);
        } else {
            $this->IsAutoCatchInSubscription = $isAutoCatchInSubscription;
        }
        return $this;
    }
    /**
     * Get IsSubscriptionInBasket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriptionInBasket()
    {
        return isset($this->IsSubscriptionInBasket) ? $this->IsSubscriptionInBasket : null;
    }
    /**
     * Set IsSubscriptionInBasket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriptionInBasket
     * @return \patest\StructType\TicketItem
     */
    public function setIsSubscriptionInBasket($isSubscriptionInBasket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriptionInBasket) && !is_bool($isSubscriptionInBasket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriptionInBasket, true), gettype($isSubscriptionInBasket)), __LINE__);
        }
        if (is_null($isSubscriptionInBasket) || (is_array($isSubscriptionInBasket) && empty($isSubscriptionInBasket))) {
            unset($this->IsSubscriptionInBasket);
        } else {
            $this->IsSubscriptionInBasket = $isSubscriptionInBasket;
        }
        return $this;
    }
    /**
     * Get ReturnAgainstSubscriptionBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnAgainstSubscriptionBalance()
    {
        return isset($this->ReturnAgainstSubscriptionBalance) ? $this->ReturnAgainstSubscriptionBalance : null;
    }
    /**
     * Set ReturnAgainstSubscriptionBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnAgainstSubscriptionBalance
     * @return \patest\StructType\TicketItem
     */
    public function setReturnAgainstSubscriptionBalance($returnAgainstSubscriptionBalance = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnAgainstSubscriptionBalance) && !is_bool($returnAgainstSubscriptionBalance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnAgainstSubscriptionBalance, true), gettype($returnAgainstSubscriptionBalance)), __LINE__);
        }
        if (is_null($returnAgainstSubscriptionBalance) || (is_array($returnAgainstSubscriptionBalance) && empty($returnAgainstSubscriptionBalance))) {
            unset($this->ReturnAgainstSubscriptionBalance);
        } else {
            $this->ReturnAgainstSubscriptionBalance = $returnAgainstSubscriptionBalance;
        }
        return $this;
    }
    /**
     * Get RoleInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleInSubscription()
    {
        return isset($this->RoleInSubscription) ? $this->RoleInSubscription : null;
    }
    /**
     * Set RoleInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RoleInSubscription::valueIsValid()
     * @uses \patest\EnumType\RoleInSubscription::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $roleInSubscription
     * @return \patest\StructType\TicketItem
     */
    public function setRoleInSubscription($roleInSubscription = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RoleInSubscription::valueIsValid($roleInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RoleInSubscription', is_array($roleInSubscription) ? implode(', ', $roleInSubscription) : var_export($roleInSubscription, true), implode(', ', \patest\EnumType\RoleInSubscription::getValidValues())), __LINE__);
        }
        if (is_null($roleInSubscription) || (is_array($roleInSubscription) && empty($roleInSubscription))) {
            unset($this->RoleInSubscription);
        } else {
            $this->RoleInSubscription = $roleInSubscription;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\TicketItem
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\TicketItem
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get ContinuedByAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuedByAction()
    {
        return isset($this->ContinuedByAction) ? $this->ContinuedByAction : null;
    }
    /**
     * Set ContinuedByAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketContinuationAction::valueIsValid()
     * @uses \patest\EnumType\TicketContinuationAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $continuedByAction
     * @return \patest\StructType\TicketItem
     */
    public function setContinuedByAction($continuedByAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketContinuationAction::valueIsValid($continuedByAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketContinuationAction', is_array($continuedByAction) ? implode(', ', $continuedByAction) : var_export($continuedByAction, true), implode(', ', \patest\EnumType\TicketContinuationAction::getValidValues())), __LINE__);
        }
        if (is_null($continuedByAction) || (is_array($continuedByAction) && empty($continuedByAction))) {
            unset($this->ContinuedByAction);
        } else {
            $this->ContinuedByAction = $continuedByAction;
        }
        return $this;
    }
    /**
     * Get ContinuedByTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuedByTicketId()
    {
        return isset($this->ContinuedByTicketId) ? $this->ContinuedByTicketId : null;
    }
    /**
     * Set ContinuedByTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $continuedByTicketId
     * @return \patest\StructType\TicketItem
     */
    public function setContinuedByTicketId($continuedByTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($continuedByTicketId) && !is_string($continuedByTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continuedByTicketId, true), gettype($continuedByTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($continuedByTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $continuedByTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($continuedByTicketId, true)), __LINE__);
        }
        if (is_null($continuedByTicketId) || (is_array($continuedByTicketId) && empty($continuedByTicketId))) {
            unset($this->ContinuedByTicketId);
        } else {
            $this->ContinuedByTicketId = $continuedByTicketId;
        }
        return $this;
    }
    /**
     * Get FormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedDate()
    {
        return isset($this->FormattedDate) ? $this->FormattedDate : null;
    }
    /**
     * Set FormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedDate
     * @return \patest\StructType\TicketItem
     */
    public function setFormattedDate($formattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedDate) && !is_string($formattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedDate, true), gettype($formattedDate)), __LINE__);
        }
        if (is_null($formattedDate) || (is_array($formattedDate) && empty($formattedDate))) {
            unset($this->FormattedDate);
        } else {
            $this->FormattedDate = $formattedDate;
        }
        return $this;
    }
    /**
     * Get HasBackwardContinuation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasBackwardContinuation()
    {
        return isset($this->HasBackwardContinuation) ? $this->HasBackwardContinuation : null;
    }
    /**
     * Set HasBackwardContinuation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasBackwardContinuation
     * @return \patest\StructType\TicketItem
     */
    public function setHasBackwardContinuation($hasBackwardContinuation = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasBackwardContinuation) && !is_bool($hasBackwardContinuation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasBackwardContinuation, true), gettype($hasBackwardContinuation)), __LINE__);
        }
        if (is_null($hasBackwardContinuation) || (is_array($hasBackwardContinuation) && empty($hasBackwardContinuation))) {
            unset($this->HasBackwardContinuation);
        } else {
            $this->HasBackwardContinuation = $hasBackwardContinuation;
        }
        return $this;
    }
    /**
     * Get IsIrregularInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIrregularInSubscription()
    {
        return isset($this->IsIrregularInSubscription) ? $this->IsIrregularInSubscription : null;
    }
    /**
     * Set IsIrregularInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIrregularInSubscription
     * @return \patest\StructType\TicketItem
     */
    public function setIsIrregularInSubscription($isIrregularInSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIrregularInSubscription) && !is_bool($isIrregularInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIrregularInSubscription, true), gettype($isIrregularInSubscription)), __LINE__);
        }
        if (is_null($isIrregularInSubscription) || (is_array($isIrregularInSubscription) && empty($isIrregularInSubscription))) {
            unset($this->IsIrregularInSubscription);
        } else {
            $this->IsIrregularInSubscription = $isIrregularInSubscription;
        }
        return $this;
    }
    /**
     * Get IsReplaceableInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReplaceableInSubscription()
    {
        return isset($this->IsReplaceableInSubscription) ? $this->IsReplaceableInSubscription : null;
    }
    /**
     * Set IsReplaceableInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReplaceableInSubscription
     * @return \patest\StructType\TicketItem
     */
    public function setIsReplaceableInSubscription($isReplaceableInSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReplaceableInSubscription) && !is_bool($isReplaceableInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReplaceableInSubscription, true), gettype($isReplaceableInSubscription)), __LINE__);
        }
        if (is_null($isReplaceableInSubscription) || (is_array($isReplaceableInSubscription) && empty($isReplaceableInSubscription))) {
            unset($this->IsReplaceableInSubscription);
        } else {
            $this->IsReplaceableInSubscription = $isReplaceableInSubscription;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesName
     * @return \patest\StructType\TicketItem
     */
    public function setSeriesName($seriesName = null)
    {
        // validation for constraint: string
        if (!is_null($seriesName) && !is_string($seriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesName, true), gettype($seriesName)), __LINE__);
        }
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get SubscriberTicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberTicketType()
    {
        return isset($this->SubscriberTicketType) ? $this->SubscriberTicketType : null;
    }
    /**
     * Set SubscriberTicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketType::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberTicketType
     * @return \patest\StructType\TicketItem
     */
    public function setSubscriberTicketType($subscriberTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketType::valueIsValid($subscriberTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketType', is_array($subscriberTicketType) ? implode(', ', $subscriberTicketType) : var_export($subscriberTicketType, true), implode(', ', \patest\EnumType\SubscriberTicketType::getValidValues())), __LINE__);
        }
        if (is_null($subscriberTicketType) || (is_array($subscriberTicketType) && empty($subscriberTicketType))) {
            unset($this->SubscriberTicketType);
        } else {
            $this->SubscriberTicketType = $subscriberTicketType;
        }
        return $this;
    }
    /**
     * Get _Reserved1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function get_Reserved1()
    {
        return isset($this->_Reserved1) ? $this->_Reserved1 : null;
    }
    /**
     * Set _Reserved1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $_Reserved1
     * @return \patest\StructType\TicketItem
     */
    public function set_Reserved1($_Reserved1 = null)
    {
        // validation for constraint: string
        if (!is_null($_Reserved1) && !is_string($_Reserved1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_Reserved1, true), gettype($_Reserved1)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($_Reserved1) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $_Reserved1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($_Reserved1, true)), __LINE__);
        }
        if (is_null($_Reserved1) || (is_array($_Reserved1) && empty($_Reserved1))) {
            unset($this->_Reserved1);
        } else {
            $this->_Reserved1 = $_Reserved1;
        }
        return $this;
    }
    /**
     * Get _Reserved2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function get_Reserved2()
    {
        return isset($this->_Reserved2) ? $this->_Reserved2 : null;
    }
    /**
     * Set _Reserved2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $_Reserved2
     * @return \patest\StructType\TicketItem
     */
    public function set_Reserved2($_Reserved2 = null)
    {
        // validation for constraint: string
        if (!is_null($_Reserved2) && !is_string($_Reserved2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_Reserved2, true), gettype($_Reserved2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($_Reserved2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $_Reserved2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($_Reserved2, true)), __LINE__);
        }
        if (is_null($_Reserved2) || (is_array($_Reserved2) && empty($_Reserved2))) {
            unset($this->_Reserved2);
        } else {
            $this->_Reserved2 = $_Reserved2;
        }
        return $this;
    }
    /**
     * Get RelatedSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedSubscriptionInstanceId()
    {
        return isset($this->RelatedSubscriptionInstanceId) ? $this->RelatedSubscriptionInstanceId : null;
    }
    /**
     * Set RelatedSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedSubscriptionInstanceId
     * @return \patest\StructType\TicketItem
     */
    public function setRelatedSubscriptionInstanceId($relatedSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedSubscriptionInstanceId) && !is_string($relatedSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedSubscriptionInstanceId, true), gettype($relatedSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($relatedSubscriptionInstanceId) || (is_array($relatedSubscriptionInstanceId) && empty($relatedSubscriptionInstanceId))) {
            unset($this->RelatedSubscriptionInstanceId);
        } else {
            $this->RelatedSubscriptionInstanceId = $relatedSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get WorthInSubscriptionBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWorthInSubscriptionBalance()
    {
        return isset($this->WorthInSubscriptionBalance) ? $this->WorthInSubscriptionBalance : null;
    }
    /**
     * Set WorthInSubscriptionBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $worthInSubscriptionBalance
     * @return \patest\StructType\TicketItem
     */
    public function setWorthInSubscriptionBalance($worthInSubscriptionBalance = null)
    {
        // validation for constraint: float
        if (!is_null($worthInSubscriptionBalance) && !(is_float($worthInSubscriptionBalance) || is_numeric($worthInSubscriptionBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($worthInSubscriptionBalance, true), gettype($worthInSubscriptionBalance)), __LINE__);
        }
        if (is_null($worthInSubscriptionBalance) || (is_array($worthInSubscriptionBalance) && empty($worthInSubscriptionBalance))) {
            unset($this->WorthInSubscriptionBalance);
        } else {
            $this->WorthInSubscriptionBalance = $worthInSubscriptionBalance;
        }
        return $this;
    }
    /**
     * Get CompensationOfTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompensationOfTicketId()
    {
        return isset($this->CompensationOfTicketId) ? $this->CompensationOfTicketId : null;
    }
    /**
     * Set CompensationOfTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compensationOfTicketId
     * @return \patest\StructType\TicketItem
     */
    public function setCompensationOfTicketId($compensationOfTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($compensationOfTicketId) && !is_string($compensationOfTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($compensationOfTicketId, true), gettype($compensationOfTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($compensationOfTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $compensationOfTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($compensationOfTicketId, true)), __LINE__);
        }
        if (is_null($compensationOfTicketId) || (is_array($compensationOfTicketId) && empty($compensationOfTicketId))) {
            unset($this->CompensationOfTicketId);
        } else {
            $this->CompensationOfTicketId = $compensationOfTicketId;
        }
        return $this;
    }
    /**
     * Get ConsumedAllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConsumedAllocationTypeId()
    {
        return isset($this->ConsumedAllocationTypeId) ? $this->ConsumedAllocationTypeId : null;
    }
    /**
     * Set ConsumedAllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $consumedAllocationTypeId
     * @return \patest\StructType\TicketItem
     */
    public function setConsumedAllocationTypeId($consumedAllocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($consumedAllocationTypeId) && !is_string($consumedAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($consumedAllocationTypeId, true), gettype($consumedAllocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($consumedAllocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $consumedAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($consumedAllocationTypeId, true)), __LINE__);
        }
        if (is_null($consumedAllocationTypeId) || (is_array($consumedAllocationTypeId) && empty($consumedAllocationTypeId))) {
            unset($this->ConsumedAllocationTypeId);
        } else {
            $this->ConsumedAllocationTypeId = $consumedAllocationTypeId;
        }
        return $this;
    }
    /**
     * Get ForcedAllocationTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForcedAllocationTypeId()
    {
        return isset($this->ForcedAllocationTypeId) ? $this->ForcedAllocationTypeId : null;
    }
    /**
     * Set ForcedAllocationTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forcedAllocationTypeId
     * @return \patest\StructType\TicketItem
     */
    public function setForcedAllocationTypeId($forcedAllocationTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($forcedAllocationTypeId) && !is_string($forcedAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forcedAllocationTypeId, true), gettype($forcedAllocationTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($forcedAllocationTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $forcedAllocationTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($forcedAllocationTypeId, true)), __LINE__);
        }
        if (is_null($forcedAllocationTypeId) || (is_array($forcedAllocationTypeId) && empty($forcedAllocationTypeId))) {
            unset($this->ForcedAllocationTypeId);
        } else {
            $this->ForcedAllocationTypeId = $forcedAllocationTypeId;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * @return bool|null
     */
    public function getIsResale()
    {
        return $this->IsResale;
    }
    /**
     * Set IsResale value
     * @param bool $isResale
     * @return \patest\StructType\TicketItem
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        $this->IsResale = $isResale;
        return $this;
    }
    /**
     * Get ResaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleStatus()
    {
        return isset($this->ResaleStatus) ? $this->ResaleStatus : null;
    }
    /**
     * Set ResaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ResaleStatus::valueIsValid()
     * @uses \patest\EnumType\ResaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleStatus
     * @return \patest\StructType\TicketItem
     */
    public function setResaleStatus($resaleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResaleStatus::valueIsValid($resaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResaleStatus', is_array($resaleStatus) ? implode(', ', $resaleStatus) : var_export($resaleStatus, true), implode(', ', \patest\EnumType\ResaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($resaleStatus) || (is_array($resaleStatus) && empty($resaleStatus))) {
            unset($this->ResaleStatus);
        } else {
            $this->ResaleStatus = $resaleStatus;
        }
        return $this;
    }
    /**
     * Get PrintMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethod()
    {
        return isset($this->PrintMethod) ? $this->PrintMethod : null;
    }
    /**
     * Set PrintMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethod
     * @return \patest\StructType\TicketItem
     */
    public function setPrintMethod($printMethod = null)
    {
        // validation for constraint: string
        if (!is_null($printMethod) && !is_string($printMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethod, true), gettype($printMethod)), __LINE__);
        }
        if (is_null($printMethod) || (is_array($printMethod) && empty($printMethod))) {
            unset($this->PrintMethod);
        } else {
            $this->PrintMethod = $printMethod;
        }
        return $this;
    }
    /**
     * Get PrintMethodData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethodData()
    {
        return isset($this->PrintMethodData) ? $this->PrintMethodData : null;
    }
    /**
     * Set PrintMethodData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethodData
     * @return \patest\StructType\TicketItem
     */
    public function setPrintMethodData($printMethodData = null)
    {
        // validation for constraint: string
        if (!is_null($printMethodData) && !is_string($printMethodData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethodData, true), gettype($printMethodData)), __LINE__);
        }
        if (is_null($printMethodData) || (is_array($printMethodData) && empty($printMethodData))) {
            unset($this->PrintMethodData);
        } else {
            $this->PrintMethodData = $printMethodData;
        }
        return $this;
    }
    /**
     * Get SeatAllocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatAllocations()
    {
        return isset($this->SeatAllocations) ? $this->SeatAllocations : null;
    }
    /**
     * Set SeatAllocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatAllocations
     * @return \patest\StructType\TicketItem
     */
    public function setSeatAllocations($seatAllocations = null)
    {
        // validation for constraint: string
        if (!is_null($seatAllocations) && !is_string($seatAllocations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatAllocations, true), gettype($seatAllocations)), __LINE__);
        }
        if (is_null($seatAllocations) || (is_array($seatAllocations) && empty($seatAllocations))) {
            unset($this->SeatAllocations);
        } else {
            $this->SeatAllocations = $seatAllocations;
        }
        return $this;
    }
    /**
     * Get SeatLock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatLock()
    {
        return isset($this->SeatLock) ? $this->SeatLock : null;
    }
    /**
     * Set SeatLock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatLock
     * @return \patest\StructType\TicketItem
     */
    public function setSeatLock($seatLock = null)
    {
        // validation for constraint: string
        if (!is_null($seatLock) && !is_string($seatLock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatLock, true), gettype($seatLock)), __LINE__);
        }
        if (is_null($seatLock) || (is_array($seatLock) && empty($seatLock))) {
            unset($this->SeatLock);
        } else {
            $this->SeatLock = $seatLock;
        }
        return $this;
    }
    /**
     * Get SeatTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeId()
    {
        return isset($this->SeatTypeId) ? $this->SeatTypeId : null;
    }
    /**
     * Set SeatTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeId
     * @return \patest\StructType\TicketItem
     */
    public function setSeatTypeId($seatTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeId) && !is_string($seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeId, true), gettype($seatTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatTypeId, true)), __LINE__);
        }
        if (is_null($seatTypeId) || (is_array($seatTypeId) && empty($seatTypeId))) {
            unset($this->SeatTypeId);
        } else {
            $this->SeatTypeId = $seatTypeId;
        }
        return $this;
    }
    /**
     * Get TurnbackDonationProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnbackDonationProductId()
    {
        return isset($this->TurnbackDonationProductId) ? $this->TurnbackDonationProductId : null;
    }
    /**
     * Set TurnbackDonationProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnbackDonationProductId
     * @return \patest\StructType\TicketItem
     */
    public function setTurnbackDonationProductId($turnbackDonationProductId = null)
    {
        // validation for constraint: string
        if (!is_null($turnbackDonationProductId) && !is_string($turnbackDonationProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnbackDonationProductId, true), gettype($turnbackDonationProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($turnbackDonationProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $turnbackDonationProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($turnbackDonationProductId, true)), __LINE__);
        }
        if (is_null($turnbackDonationProductId) || (is_array($turnbackDonationProductId) && empty($turnbackDonationProductId))) {
            unset($this->TurnbackDonationProductId);
        } else {
            $this->TurnbackDonationProductId = $turnbackDonationProductId;
        }
        return $this;
    }
    /**
     * Get OriginalTicketForResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketIdentity|null
     */
    public function getOriginalTicketForResale()
    {
        return isset($this->OriginalTicketForResale) ? $this->OriginalTicketForResale : null;
    }
    /**
     * Set OriginalTicketForResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketIdentity $originalTicketForResale
     * @return \patest\StructType\TicketItem
     */
    public function setOriginalTicketForResale(\patest\StructType\TicketIdentity $originalTicketForResale = null)
    {
        if (is_null($originalTicketForResale) || (is_array($originalTicketForResale) && empty($originalTicketForResale))) {
            unset($this->OriginalTicketForResale);
        } else {
            $this->OriginalTicketForResale = $originalTicketForResale;
        }
        return $this;
    }
    /**
     * Get IsHospitality value
     * @return bool|null
     */
    public function getIsHospitality()
    {
        return $this->IsHospitality;
    }
    /**
     * Set IsHospitality value
     * @param bool $isHospitality
     * @return \patest\StructType\TicketItem
     */
    public function setIsHospitality($isHospitality = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHospitality) && !is_bool($isHospitality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHospitality, true), gettype($isHospitality)), __LINE__);
        }
        $this->IsHospitality = $isHospitality;
        return $this;
    }
    /**
     * Get SlotIdInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSlotIdInSubscription()
    {
        return isset($this->SlotIdInSubscription) ? $this->SlotIdInSubscription : null;
    }
    /**
     * Set SlotIdInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $slotIdInSubscription
     * @return \patest\StructType\TicketItem
     */
    public function setSlotIdInSubscription($slotIdInSubscription = null)
    {
        // validation for constraint: int
        if (!is_null($slotIdInSubscription) && !(is_int($slotIdInSubscription) || ctype_digit($slotIdInSubscription))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($slotIdInSubscription, true), gettype($slotIdInSubscription)), __LINE__);
        }
        if (is_null($slotIdInSubscription) || (is_array($slotIdInSubscription) && empty($slotIdInSubscription))) {
            unset($this->SlotIdInSubscription);
        } else {
            $this->SlotIdInSubscription = $slotIdInSubscription;
        }
        return $this;
    }
    /**
     * Get PrintedAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedAs()
    {
        return isset($this->PrintedAs) ? $this->PrintedAs : null;
    }
    /**
     * Set PrintedAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedAs
     * @return \patest\StructType\TicketItem
     */
    public function setPrintedAs($printedAs = null)
    {
        // validation for constraint: string
        if (!is_null($printedAs) && !is_string($printedAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedAs, true), gettype($printedAs)), __LINE__);
        }
        if (is_null($printedAs) || (is_array($printedAs) && empty($printedAs))) {
            unset($this->PrintedAs);
        } else {
            $this->PrintedAs = $printedAs;
        }
        return $this;
    }
    /**
     * Get IsOnlineForwarded value
     * @return bool|null
     */
    public function getIsOnlineForwarded()
    {
        return $this->IsOnlineForwarded;
    }
    /**
     * Set IsOnlineForwarded value
     * @param bool $isOnlineForwarded
     * @return \patest\StructType\TicketItem
     */
    public function setIsOnlineForwarded($isOnlineForwarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnlineForwarded) && !is_bool($isOnlineForwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnlineForwarded, true), gettype($isOnlineForwarded)), __LINE__);
        }
        $this->IsOnlineForwarded = $isOnlineForwarded;
        return $this;
    }
    /**
     * Get IsFullStackExchangedSubscriptionTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullStackExchangedSubscriptionTicket()
    {
        return isset($this->IsFullStackExchangedSubscriptionTicket) ? $this->IsFullStackExchangedSubscriptionTicket : null;
    }
    /**
     * Set IsFullStackExchangedSubscriptionTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullStackExchangedSubscriptionTicket
     * @return \patest\StructType\TicketItem
     */
    public function setIsFullStackExchangedSubscriptionTicket($isFullStackExchangedSubscriptionTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullStackExchangedSubscriptionTicket) && !is_bool($isFullStackExchangedSubscriptionTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullStackExchangedSubscriptionTicket, true), gettype($isFullStackExchangedSubscriptionTicket)), __LINE__);
        }
        if (is_null($isFullStackExchangedSubscriptionTicket) || (is_array($isFullStackExchangedSubscriptionTicket) && empty($isFullStackExchangedSubscriptionTicket))) {
            unset($this->IsFullStackExchangedSubscriptionTicket);
        } else {
            $this->IsFullStackExchangedSubscriptionTicket = $isFullStackExchangedSubscriptionTicket;
        }
        return $this;
    }
    /**
     * Get StandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandId()
    {
        return isset($this->StandId) ? $this->StandId : null;
    }
    /**
     * Set StandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standId
     * @return \patest\StructType\TicketItem
     */
    public function setStandId($standId = null)
    {
        // validation for constraint: string
        if (!is_null($standId) && !is_string($standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standId, true), gettype($standId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($standId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $standId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($standId, true)), __LINE__);
        }
        if (is_null($standId) || (is_array($standId) && empty($standId))) {
            unset($this->StandId);
        } else {
            $this->StandId = $standId;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $standName
     * @return \patest\StructType\TicketItem
     */
    public function setStandName($standName = null)
    {
        // validation for constraint: string
        if (!is_null($standName) && !is_string($standName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($standName, true), gettype($standName)), __LINE__);
        }
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get NumberOfOwnershipChanges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfOwnershipChanges()
    {
        return isset($this->NumberOfOwnershipChanges) ? $this->NumberOfOwnershipChanges : null;
    }
    /**
     * Set NumberOfOwnershipChanges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfOwnershipChanges
     * @return \patest\StructType\TicketItem
     */
    public function setNumberOfOwnershipChanges($numberOfOwnershipChanges = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOwnershipChanges) && !(is_int($numberOfOwnershipChanges) || ctype_digit($numberOfOwnershipChanges))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOwnershipChanges, true), gettype($numberOfOwnershipChanges)), __LINE__);
        }
        if (is_null($numberOfOwnershipChanges) || (is_array($numberOfOwnershipChanges) && empty($numberOfOwnershipChanges))) {
            unset($this->NumberOfOwnershipChanges);
        } else {
            $this->NumberOfOwnershipChanges = $numberOfOwnershipChanges;
        }
        return $this;
    }
    /**
     * Get ResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleMethod()
    {
        return isset($this->ResaleMethod) ? $this->ResaleMethod : null;
    }
    /**
     * Set ResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleMethod
     * @return \patest\StructType\TicketItem
     */
    public function setResaleMethod($resaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($resaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($resaleMethod) ? implode(', ', $resaleMethod) : var_export($resaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($resaleMethod) || (is_array($resaleMethod) && empty($resaleMethod))) {
            unset($this->ResaleMethod);
        } else {
            $this->ResaleMethod = $resaleMethod;
        }
        return $this;
    }
    /**
     * Get AccessCodeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCodeId()
    {
        return isset($this->AccessCodeId) ? $this->AccessCodeId : null;
    }
    /**
     * Set AccessCodeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCodeId
     * @return \patest\StructType\TicketItem
     */
    public function setAccessCodeId($accessCodeId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCodeId) && !is_string($accessCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCodeId, true), gettype($accessCodeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCodeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCodeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCodeId, true)), __LINE__);
        }
        if (is_null($accessCodeId) || (is_array($accessCodeId) && empty($accessCodeId))) {
            unset($this->AccessCodeId);
        } else {
            $this->AccessCodeId = $accessCodeId;
        }
        return $this;
    }
}
