<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncDeletedEntitiesFromExternalSourceRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SyncDeletedEntitiesFromExternalSourceRequest
 * @subpackage Structs
 */
class SyncDeletedEntitiesFromExternalSourceRequest extends AbstractStructBase
{
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The ExternalIdsOfDeleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $ExternalIdsOfDeleted;
    /**
     * Constructor method for SyncDeletedEntitiesFromExternalSourceRequest
     * @uses SyncDeletedEntitiesFromExternalSourceRequest::setEntityName()
     * @uses SyncDeletedEntitiesFromExternalSourceRequest::setExternalIdsOfDeleted()
     * @param string $entityName
     * @param \patest\ArrayType\ArrayOfstring $externalIdsOfDeleted
     */
    public function __construct($entityName = null, \patest\ArrayType\ArrayOfstring $externalIdsOfDeleted = null)
    {
        $this
            ->setEntityName($entityName)
            ->setExternalIdsOfDeleted($externalIdsOfDeleted);
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\SyncDeletedEntitiesFromExternalSourceRequest
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get ExternalIdsOfDeleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getExternalIdsOfDeleted()
    {
        return isset($this->ExternalIdsOfDeleted) ? $this->ExternalIdsOfDeleted : null;
    }
    /**
     * Set ExternalIdsOfDeleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $externalIdsOfDeleted
     * @return \patest\StructType\SyncDeletedEntitiesFromExternalSourceRequest
     */
    public function setExternalIdsOfDeleted(\patest\ArrayType\ArrayOfstring $externalIdsOfDeleted = null)
    {
        if (is_null($externalIdsOfDeleted) || (is_array($externalIdsOfDeleted) && empty($externalIdsOfDeleted))) {
            unset($this->ExternalIdsOfDeleted);
        } else {
            $this->ExternalIdsOfDeleted = $externalIdsOfDeleted;
        }
        return $this;
    }
}
