<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreJournalEntriesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StoreJournalEntriesRequest
 * @subpackage Structs
 */
class StoreJournalEntriesRequest extends AbstractStructBase
{
    /**
     * The Entries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAnyEntity
     */
    public $Entries;
    /**
     * The JournalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JournalName;
    /**
     * Constructor method for StoreJournalEntriesRequest
     * @uses StoreJournalEntriesRequest::setEntries()
     * @uses StoreJournalEntriesRequest::setJournalName()
     * @param \patest\StructType\RecordSetOfAnyEntity $entries
     * @param string $journalName
     */
    public function __construct(\patest\StructType\RecordSetOfAnyEntity $entries = null, $journalName = null)
    {
        $this
            ->setEntries($entries)
            ->setJournalName($journalName);
    }
    /**
     * Get Entries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAnyEntity|null
     */
    public function getEntries()
    {
        return isset($this->Entries) ? $this->Entries : null;
    }
    /**
     * Set Entries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAnyEntity $entries
     * @return \patest\StructType\StoreJournalEntriesRequest
     */
    public function setEntries(\patest\StructType\RecordSetOfAnyEntity $entries = null)
    {
        if (is_null($entries) || (is_array($entries) && empty($entries))) {
            unset($this->Entries);
        } else {
            $this->Entries = $entries;
        }
        return $this;
    }
    /**
     * Get JournalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJournalName()
    {
        return isset($this->JournalName) ? $this->JournalName : null;
    }
    /**
     * Set JournalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $journalName
     * @return \patest\StructType\StoreJournalEntriesRequest
     */
    public function setJournalName($journalName = null)
    {
        // validation for constraint: string
        if (!is_null($journalName) && !is_string($journalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journalName, true), gettype($journalName)), __LINE__);
        }
        if (is_null($journalName) || (is_array($journalName) && empty($journalName))) {
            unset($this->JournalName);
        } else {
            $this->JournalName = $journalName;
        }
        return $this;
    }
}
