<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ServiceItem
 * @subpackage Structs
 */
class ServiceItem extends AbstractStructBase
{
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for ServiceItem
     * @uses ServiceItem::setMerchandiseId()
     * @uses ServiceItem::setQuantity()
     * @param string $merchandiseId
     * @param int $quantity
     */
    public function __construct($merchandiseId = null, $quantity = null)
    {
        $this
            ->setMerchandiseId($merchandiseId)
            ->setQuantity($quantity);
    }
    /**
     * Get MerchandiseId value
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return $this->MerchandiseId;
    }
    /**
     * Set MerchandiseId value
     * @param string $merchandiseId
     * @return \patest\StructType\ServiceItem
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        $this->MerchandiseId = $merchandiseId;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \patest\StructType\ServiceItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
}
