<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendByEmailData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendByEmailData
 * @subpackage Structs
 */
class SendByEmailData extends AbstractStructBase
{
    /**
     * The CCRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCRecipients;
    /**
     * The EmailBodyOptionalMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBodyOptionalMessage;
    /**
     * The ToRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToRecipients;
    /**
     * Constructor method for SendByEmailData
     * @uses SendByEmailData::setCCRecipients()
     * @uses SendByEmailData::setEmailBodyOptionalMessage()
     * @uses SendByEmailData::setToRecipients()
     * @param string $cCRecipients
     * @param string $emailBodyOptionalMessage
     * @param string $toRecipients
     */
    public function __construct($cCRecipients = null, $emailBodyOptionalMessage = null, $toRecipients = null)
    {
        $this
            ->setCCRecipients($cCRecipients)
            ->setEmailBodyOptionalMessage($emailBodyOptionalMessage)
            ->setToRecipients($toRecipients);
    }
    /**
     * Get CCRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCRecipients()
    {
        return isset($this->CCRecipients) ? $this->CCRecipients : null;
    }
    /**
     * Set CCRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCRecipients
     * @return \patest\StructType\SendByEmailData
     */
    public function setCCRecipients($cCRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($cCRecipients) && !is_string($cCRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCRecipients, true), gettype($cCRecipients)), __LINE__);
        }
        if (is_null($cCRecipients) || (is_array($cCRecipients) && empty($cCRecipients))) {
            unset($this->CCRecipients);
        } else {
            $this->CCRecipients = $cCRecipients;
        }
        return $this;
    }
    /**
     * Get EmailBodyOptionalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBodyOptionalMessage()
    {
        return isset($this->EmailBodyOptionalMessage) ? $this->EmailBodyOptionalMessage : null;
    }
    /**
     * Set EmailBodyOptionalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBodyOptionalMessage
     * @return \patest\StructType\SendByEmailData
     */
    public function setEmailBodyOptionalMessage($emailBodyOptionalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($emailBodyOptionalMessage) && !is_string($emailBodyOptionalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBodyOptionalMessage, true), gettype($emailBodyOptionalMessage)), __LINE__);
        }
        if (is_null($emailBodyOptionalMessage) || (is_array($emailBodyOptionalMessage) && empty($emailBodyOptionalMessage))) {
            unset($this->EmailBodyOptionalMessage);
        } else {
            $this->EmailBodyOptionalMessage = $emailBodyOptionalMessage;
        }
        return $this;
    }
    /**
     * Get ToRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToRecipients()
    {
        return isset($this->ToRecipients) ? $this->ToRecipients : null;
    }
    /**
     * Set ToRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toRecipients
     * @return \patest\StructType\SendByEmailData
     */
    public function setToRecipients($toRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($toRecipients) && !is_string($toRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toRecipients, true), gettype($toRecipients)), __LINE__);
        }
        if (is_null($toRecipients) || (is_array($toRecipients) && empty($toRecipients))) {
            unset($this->ToRecipients);
        } else {
            $this->ToRecipients = $toRecipients;
        }
        return $this;
    }
}
