<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SystemUser StructType
 * @subpackage Structs
 */
class Security_SystemUser extends Security_User
{
    /**
     * The IsSystemFlag
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystemFlag;
    /**
     * Constructor method for Security.SystemUser
     * @uses Security_SystemUser::setIsSystemFlag()
     * @param bool $isSystemFlag
     */
    public function __construct($isSystemFlag = null)
    {
        $this
            ->setIsSystemFlag($isSystemFlag);
    }
    /**
     * Get IsSystemFlag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystemFlag()
    {
        return isset($this->IsSystemFlag) ? $this->IsSystemFlag : null;
    }
    /**
     * Set IsSystemFlag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystemFlag
     * @return \patest\StructType\Security_SystemUser
     */
    public function setIsSystemFlag($isSystemFlag = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystemFlag) && !is_bool($isSystemFlag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystemFlag, true), gettype($isSystemFlag)), __LINE__);
        }
        if (is_null($isSystemFlag) || (is_array($isSystemFlag) && empty($isSystemFlag))) {
            unset($this->IsSystemFlag);
        } else {
            $this->IsSystemFlag = $isSystemFlag;
        }
        return $this;
    }
}
