<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.ScanDataIngestionParameters StructType
 * @subpackage Structs
 */
class Security_ScanDataIngestionParameters extends Security_CompanyParameterBase
{
    /**
     * The EnableIngestNonSuccessScans
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableIngestNonSuccessScans;
    /**
     * The EnableScansMetricsLogging
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnableScansMetricsLogging;
    /**
     * The Mode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mode;
    /**
     * The ScansArriveAnomalyCriteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScansArriveAnomalyCriteria;
    /**
     * Constructor method for Security.ScanDataIngestionParameters
     * @uses Security_ScanDataIngestionParameters::setEnableIngestNonSuccessScans()
     * @uses Security_ScanDataIngestionParameters::setEnableScansMetricsLogging()
     * @uses Security_ScanDataIngestionParameters::setMode()
     * @uses Security_ScanDataIngestionParameters::setScansArriveAnomalyCriteria()
     * @param bool $enableIngestNonSuccessScans
     * @param bool $enableScansMetricsLogging
     * @param string $mode
     * @param int $scansArriveAnomalyCriteria
     */
    public function __construct($enableIngestNonSuccessScans = null, $enableScansMetricsLogging = null, $mode = null, $scansArriveAnomalyCriteria = null)
    {
        $this
            ->setEnableIngestNonSuccessScans($enableIngestNonSuccessScans)
            ->setEnableScansMetricsLogging($enableScansMetricsLogging)
            ->setMode($mode)
            ->setScansArriveAnomalyCriteria($scansArriveAnomalyCriteria);
    }
    /**
     * Get EnableIngestNonSuccessScans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableIngestNonSuccessScans()
    {
        return isset($this->EnableIngestNonSuccessScans) ? $this->EnableIngestNonSuccessScans : null;
    }
    /**
     * Set EnableIngestNonSuccessScans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableIngestNonSuccessScans
     * @return \patest\StructType\Security_ScanDataIngestionParameters
     */
    public function setEnableIngestNonSuccessScans($enableIngestNonSuccessScans = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableIngestNonSuccessScans) && !is_bool($enableIngestNonSuccessScans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableIngestNonSuccessScans, true), gettype($enableIngestNonSuccessScans)), __LINE__);
        }
        if (is_null($enableIngestNonSuccessScans) || (is_array($enableIngestNonSuccessScans) && empty($enableIngestNonSuccessScans))) {
            unset($this->EnableIngestNonSuccessScans);
        } else {
            $this->EnableIngestNonSuccessScans = $enableIngestNonSuccessScans;
        }
        return $this;
    }
    /**
     * Get EnableScansMetricsLogging value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnableScansMetricsLogging()
    {
        return isset($this->EnableScansMetricsLogging) ? $this->EnableScansMetricsLogging : null;
    }
    /**
     * Set EnableScansMetricsLogging value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enableScansMetricsLogging
     * @return \patest\StructType\Security_ScanDataIngestionParameters
     */
    public function setEnableScansMetricsLogging($enableScansMetricsLogging = null)
    {
        // validation for constraint: boolean
        if (!is_null($enableScansMetricsLogging) && !is_bool($enableScansMetricsLogging)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enableScansMetricsLogging, true), gettype($enableScansMetricsLogging)), __LINE__);
        }
        if (is_null($enableScansMetricsLogging) || (is_array($enableScansMetricsLogging) && empty($enableScansMetricsLogging))) {
            unset($this->EnableScansMetricsLogging);
        } else {
            $this->EnableScansMetricsLogging = $enableScansMetricsLogging;
        }
        return $this;
    }
    /**
     * Get Mode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMode()
    {
        return isset($this->Mode) ? $this->Mode : null;
    }
    /**
     * Set Mode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ScanIngestionHandlerMode::valueIsValid()
     * @uses \patest\EnumType\ScanIngestionHandlerMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mode
     * @return \patest\StructType\Security_ScanDataIngestionParameters
     */
    public function setMode($mode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ScanIngestionHandlerMode::valueIsValid($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ScanIngestionHandlerMode', is_array($mode) ? implode(', ', $mode) : var_export($mode, true), implode(', ', \patest\EnumType\ScanIngestionHandlerMode::getValidValues())), __LINE__);
        }
        if (is_null($mode) || (is_array($mode) && empty($mode))) {
            unset($this->Mode);
        } else {
            $this->Mode = $mode;
        }
        return $this;
    }
    /**
     * Get ScansArriveAnomalyCriteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScansArriveAnomalyCriteria()
    {
        return isset($this->ScansArriveAnomalyCriteria) ? $this->ScansArriveAnomalyCriteria : null;
    }
    /**
     * Set ScansArriveAnomalyCriteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scansArriveAnomalyCriteria
     * @return \patest\StructType\Security_ScanDataIngestionParameters
     */
    public function setScansArriveAnomalyCriteria($scansArriveAnomalyCriteria = null)
    {
        // validation for constraint: int
        if (!is_null($scansArriveAnomalyCriteria) && !(is_int($scansArriveAnomalyCriteria) || ctype_digit($scansArriveAnomalyCriteria))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scansArriveAnomalyCriteria, true), gettype($scansArriveAnomalyCriteria)), __LINE__);
        }
        if (is_null($scansArriveAnomalyCriteria) || (is_array($scansArriveAnomalyCriteria) && empty($scansArriveAnomalyCriteria))) {
            unset($this->ScansArriveAnomalyCriteria);
        } else {
            $this->ScansArriveAnomalyCriteria = $scansArriveAnomalyCriteria;
        }
        return $this;
    }
}
