<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.PointOfSaleCompanyParameters StructType
 * @subpackage Structs
 */
class Security_PointOfSaleCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AllEventsAreGa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllEventsAreGa;
    /**
     * The AutoCommitAfterFullPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoCommitAfterFullPayment;
    /**
     * The AutoLogOutAfterTransactionCommit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoLogOutAfterTransactionCommit;
    /**
     * The BsroQuickSearchDefaultOrganizationUnit
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BsroQuickSearchDefaultOrganizationUnit;
    /**
     * The DefaultSaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSaleMode;
    /**
     * The DisplayedPriceIs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayedPriceIs;
    /**
     * The DisplayEventRemarkUponSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayEventRemarkUponSelection;
    /**
     * The DisplayTransactionSummaryAtEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayTransactionSummaryAtEnd;
    /**
     * The MerchandisePanelType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchandisePanelType;
    /**
     * The NormalBasketHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NormalBasketHeight;
    /**
     * The OpenEventSeatingPlanUponSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OpenEventSeatingPlanUponSelection;
    /**
     * The OrderEventsBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderEventsBy;
    /**
     * The SaleModeStartupAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleModeStartupAs;
    /**
     * The SalesDefaultTab
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesDefaultTab;
    /**
     * The ShowCustomerDetailsSummaryScreen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowCustomerDetailsSummaryScreen;
    /**
     * The WideRowsToSupportTouch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WideRowsToSupportTouch;
    /**
     * Constructor method for Security.PointOfSaleCompanyParameters
     * @uses Security_PointOfSaleCompanyParameters::setAllEventsAreGa()
     * @uses Security_PointOfSaleCompanyParameters::setAutoCommitAfterFullPayment()
     * @uses Security_PointOfSaleCompanyParameters::setAutoLogOutAfterTransactionCommit()
     * @uses Security_PointOfSaleCompanyParameters::setBsroQuickSearchDefaultOrganizationUnit()
     * @uses Security_PointOfSaleCompanyParameters::setDefaultSaleMode()
     * @uses Security_PointOfSaleCompanyParameters::setDisplayedPriceIs()
     * @uses Security_PointOfSaleCompanyParameters::setDisplayEventRemarkUponSelection()
     * @uses Security_PointOfSaleCompanyParameters::setDisplayTransactionSummaryAtEnd()
     * @uses Security_PointOfSaleCompanyParameters::setMerchandisePanelType()
     * @uses Security_PointOfSaleCompanyParameters::setNormalBasketHeight()
     * @uses Security_PointOfSaleCompanyParameters::setOpenEventSeatingPlanUponSelection()
     * @uses Security_PointOfSaleCompanyParameters::setOrderEventsBy()
     * @uses Security_PointOfSaleCompanyParameters::setSaleModeStartupAs()
     * @uses Security_PointOfSaleCompanyParameters::setSalesDefaultTab()
     * @uses Security_PointOfSaleCompanyParameters::setShowCustomerDetailsSummaryScreen()
     * @uses Security_PointOfSaleCompanyParameters::setWideRowsToSupportTouch()
     * @param bool $allEventsAreGa
     * @param bool $autoCommitAfterFullPayment
     * @param bool $autoLogOutAfterTransactionCommit
     * @param string $bsroQuickSearchDefaultOrganizationUnit
     * @param string $defaultSaleMode
     * @param string $displayedPriceIs
     * @param bool $displayEventRemarkUponSelection
     * @param bool $displayTransactionSummaryAtEnd
     * @param string $merchandisePanelType
     * @param int $normalBasketHeight
     * @param bool $openEventSeatingPlanUponSelection
     * @param string $orderEventsBy
     * @param string $saleModeStartupAs
     * @param string $salesDefaultTab
     * @param bool $showCustomerDetailsSummaryScreen
     * @param bool $wideRowsToSupportTouch
     */
    public function __construct($allEventsAreGa = null, $autoCommitAfterFullPayment = null, $autoLogOutAfterTransactionCommit = null, $bsroQuickSearchDefaultOrganizationUnit = null, $defaultSaleMode = null, $displayedPriceIs = null, $displayEventRemarkUponSelection = null, $displayTransactionSummaryAtEnd = null, $merchandisePanelType = null, $normalBasketHeight = null, $openEventSeatingPlanUponSelection = null, $orderEventsBy = null, $saleModeStartupAs = null, $salesDefaultTab = null, $showCustomerDetailsSummaryScreen = null, $wideRowsToSupportTouch = null)
    {
        $this
            ->setAllEventsAreGa($allEventsAreGa)
            ->setAutoCommitAfterFullPayment($autoCommitAfterFullPayment)
            ->setAutoLogOutAfterTransactionCommit($autoLogOutAfterTransactionCommit)
            ->setBsroQuickSearchDefaultOrganizationUnit($bsroQuickSearchDefaultOrganizationUnit)
            ->setDefaultSaleMode($defaultSaleMode)
            ->setDisplayedPriceIs($displayedPriceIs)
            ->setDisplayEventRemarkUponSelection($displayEventRemarkUponSelection)
            ->setDisplayTransactionSummaryAtEnd($displayTransactionSummaryAtEnd)
            ->setMerchandisePanelType($merchandisePanelType)
            ->setNormalBasketHeight($normalBasketHeight)
            ->setOpenEventSeatingPlanUponSelection($openEventSeatingPlanUponSelection)
            ->setOrderEventsBy($orderEventsBy)
            ->setSaleModeStartupAs($saleModeStartupAs)
            ->setSalesDefaultTab($salesDefaultTab)
            ->setShowCustomerDetailsSummaryScreen($showCustomerDetailsSummaryScreen)
            ->setWideRowsToSupportTouch($wideRowsToSupportTouch);
    }
    /**
     * Get AllEventsAreGa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllEventsAreGa()
    {
        return isset($this->AllEventsAreGa) ? $this->AllEventsAreGa : null;
    }
    /**
     * Set AllEventsAreGa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allEventsAreGa
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setAllEventsAreGa($allEventsAreGa = null)
    {
        // validation for constraint: boolean
        if (!is_null($allEventsAreGa) && !is_bool($allEventsAreGa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allEventsAreGa, true), gettype($allEventsAreGa)), __LINE__);
        }
        if (is_null($allEventsAreGa) || (is_array($allEventsAreGa) && empty($allEventsAreGa))) {
            unset($this->AllEventsAreGa);
        } else {
            $this->AllEventsAreGa = $allEventsAreGa;
        }
        return $this;
    }
    /**
     * Get AutoCommitAfterFullPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoCommitAfterFullPayment()
    {
        return isset($this->AutoCommitAfterFullPayment) ? $this->AutoCommitAfterFullPayment : null;
    }
    /**
     * Set AutoCommitAfterFullPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoCommitAfterFullPayment
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setAutoCommitAfterFullPayment($autoCommitAfterFullPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoCommitAfterFullPayment) && !is_bool($autoCommitAfterFullPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoCommitAfterFullPayment, true), gettype($autoCommitAfterFullPayment)), __LINE__);
        }
        if (is_null($autoCommitAfterFullPayment) || (is_array($autoCommitAfterFullPayment) && empty($autoCommitAfterFullPayment))) {
            unset($this->AutoCommitAfterFullPayment);
        } else {
            $this->AutoCommitAfterFullPayment = $autoCommitAfterFullPayment;
        }
        return $this;
    }
    /**
     * Get AutoLogOutAfterTransactionCommit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoLogOutAfterTransactionCommit()
    {
        return isset($this->AutoLogOutAfterTransactionCommit) ? $this->AutoLogOutAfterTransactionCommit : null;
    }
    /**
     * Set AutoLogOutAfterTransactionCommit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoLogOutAfterTransactionCommit
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setAutoLogOutAfterTransactionCommit($autoLogOutAfterTransactionCommit = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoLogOutAfterTransactionCommit) && !is_bool($autoLogOutAfterTransactionCommit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoLogOutAfterTransactionCommit, true), gettype($autoLogOutAfterTransactionCommit)), __LINE__);
        }
        if (is_null($autoLogOutAfterTransactionCommit) || (is_array($autoLogOutAfterTransactionCommit) && empty($autoLogOutAfterTransactionCommit))) {
            unset($this->AutoLogOutAfterTransactionCommit);
        } else {
            $this->AutoLogOutAfterTransactionCommit = $autoLogOutAfterTransactionCommit;
        }
        return $this;
    }
    /**
     * Get BsroQuickSearchDefaultOrganizationUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBsroQuickSearchDefaultOrganizationUnit()
    {
        return isset($this->BsroQuickSearchDefaultOrganizationUnit) ? $this->BsroQuickSearchDefaultOrganizationUnit : null;
    }
    /**
     * Set BsroQuickSearchDefaultOrganizationUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bsroQuickSearchDefaultOrganizationUnit
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setBsroQuickSearchDefaultOrganizationUnit($bsroQuickSearchDefaultOrganizationUnit = null)
    {
        // validation for constraint: string
        if (!is_null($bsroQuickSearchDefaultOrganizationUnit) && !is_string($bsroQuickSearchDefaultOrganizationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bsroQuickSearchDefaultOrganizationUnit, true), gettype($bsroQuickSearchDefaultOrganizationUnit)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bsroQuickSearchDefaultOrganizationUnit) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bsroQuickSearchDefaultOrganizationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bsroQuickSearchDefaultOrganizationUnit, true)), __LINE__);
        }
        if (is_null($bsroQuickSearchDefaultOrganizationUnit) || (is_array($bsroQuickSearchDefaultOrganizationUnit) && empty($bsroQuickSearchDefaultOrganizationUnit))) {
            unset($this->BsroQuickSearchDefaultOrganizationUnit);
        } else {
            $this->BsroQuickSearchDefaultOrganizationUnit = $bsroQuickSearchDefaultOrganizationUnit;
        }
        return $this;
    }
    /**
     * Get DefaultSaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSaleMode()
    {
        return isset($this->DefaultSaleMode) ? $this->DefaultSaleMode : null;
    }
    /**
     * Set DefaultSaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSaleMode
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setDefaultSaleMode($defaultSaleMode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSaleMode) && !is_string($defaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSaleMode, true), gettype($defaultSaleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSaleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSaleMode, true)), __LINE__);
        }
        if (is_null($defaultSaleMode) || (is_array($defaultSaleMode) && empty($defaultSaleMode))) {
            unset($this->DefaultSaleMode);
        } else {
            $this->DefaultSaleMode = $defaultSaleMode;
        }
        return $this;
    }
    /**
     * Get DisplayedPriceIs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayedPriceIs()
    {
        return isset($this->DisplayedPriceIs) ? $this->DisplayedPriceIs : null;
    }
    /**
     * Set DisplayedPriceIs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DisplayedPriceIs::valueIsValid()
     * @uses \patest\EnumType\DisplayedPriceIs::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $displayedPriceIs
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setDisplayedPriceIs($displayedPriceIs = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DisplayedPriceIs::valueIsValid($displayedPriceIs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DisplayedPriceIs', is_array($displayedPriceIs) ? implode(', ', $displayedPriceIs) : var_export($displayedPriceIs, true), implode(', ', \patest\EnumType\DisplayedPriceIs::getValidValues())), __LINE__);
        }
        if (is_null($displayedPriceIs) || (is_array($displayedPriceIs) && empty($displayedPriceIs))) {
            unset($this->DisplayedPriceIs);
        } else {
            $this->DisplayedPriceIs = $displayedPriceIs;
        }
        return $this;
    }
    /**
     * Get DisplayEventRemarkUponSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayEventRemarkUponSelection()
    {
        return isset($this->DisplayEventRemarkUponSelection) ? $this->DisplayEventRemarkUponSelection : null;
    }
    /**
     * Set DisplayEventRemarkUponSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayEventRemarkUponSelection
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setDisplayEventRemarkUponSelection($displayEventRemarkUponSelection = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayEventRemarkUponSelection) && !is_bool($displayEventRemarkUponSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayEventRemarkUponSelection, true), gettype($displayEventRemarkUponSelection)), __LINE__);
        }
        if (is_null($displayEventRemarkUponSelection) || (is_array($displayEventRemarkUponSelection) && empty($displayEventRemarkUponSelection))) {
            unset($this->DisplayEventRemarkUponSelection);
        } else {
            $this->DisplayEventRemarkUponSelection = $displayEventRemarkUponSelection;
        }
        return $this;
    }
    /**
     * Get DisplayTransactionSummaryAtEnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayTransactionSummaryAtEnd()
    {
        return isset($this->DisplayTransactionSummaryAtEnd) ? $this->DisplayTransactionSummaryAtEnd : null;
    }
    /**
     * Set DisplayTransactionSummaryAtEnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayTransactionSummaryAtEnd
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setDisplayTransactionSummaryAtEnd($displayTransactionSummaryAtEnd = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayTransactionSummaryAtEnd) && !is_bool($displayTransactionSummaryAtEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayTransactionSummaryAtEnd, true), gettype($displayTransactionSummaryAtEnd)), __LINE__);
        }
        if (is_null($displayTransactionSummaryAtEnd) || (is_array($displayTransactionSummaryAtEnd) && empty($displayTransactionSummaryAtEnd))) {
            unset($this->DisplayTransactionSummaryAtEnd);
        } else {
            $this->DisplayTransactionSummaryAtEnd = $displayTransactionSummaryAtEnd;
        }
        return $this;
    }
    /**
     * Get MerchandisePanelType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandisePanelType()
    {
        return isset($this->MerchandisePanelType) ? $this->MerchandisePanelType : null;
    }
    /**
     * Set MerchandisePanelType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MerchandisePanelType::valueIsValid()
     * @uses \patest\EnumType\MerchandisePanelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $merchandisePanelType
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setMerchandisePanelType($merchandisePanelType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MerchandisePanelType::valueIsValid($merchandisePanelType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MerchandisePanelType', is_array($merchandisePanelType) ? implode(', ', $merchandisePanelType) : var_export($merchandisePanelType, true), implode(', ', \patest\EnumType\MerchandisePanelType::getValidValues())), __LINE__);
        }
        if (is_null($merchandisePanelType) || (is_array($merchandisePanelType) && empty($merchandisePanelType))) {
            unset($this->MerchandisePanelType);
        } else {
            $this->MerchandisePanelType = $merchandisePanelType;
        }
        return $this;
    }
    /**
     * Get NormalBasketHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNormalBasketHeight()
    {
        return isset($this->NormalBasketHeight) ? $this->NormalBasketHeight : null;
    }
    /**
     * Set NormalBasketHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $normalBasketHeight
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setNormalBasketHeight($normalBasketHeight = null)
    {
        // validation for constraint: int
        if (!is_null($normalBasketHeight) && !(is_int($normalBasketHeight) || ctype_digit($normalBasketHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($normalBasketHeight, true), gettype($normalBasketHeight)), __LINE__);
        }
        if (is_null($normalBasketHeight) || (is_array($normalBasketHeight) && empty($normalBasketHeight))) {
            unset($this->NormalBasketHeight);
        } else {
            $this->NormalBasketHeight = $normalBasketHeight;
        }
        return $this;
    }
    /**
     * Get OpenEventSeatingPlanUponSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOpenEventSeatingPlanUponSelection()
    {
        return isset($this->OpenEventSeatingPlanUponSelection) ? $this->OpenEventSeatingPlanUponSelection : null;
    }
    /**
     * Set OpenEventSeatingPlanUponSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $openEventSeatingPlanUponSelection
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setOpenEventSeatingPlanUponSelection($openEventSeatingPlanUponSelection = null)
    {
        // validation for constraint: boolean
        if (!is_null($openEventSeatingPlanUponSelection) && !is_bool($openEventSeatingPlanUponSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($openEventSeatingPlanUponSelection, true), gettype($openEventSeatingPlanUponSelection)), __LINE__);
        }
        if (is_null($openEventSeatingPlanUponSelection) || (is_array($openEventSeatingPlanUponSelection) && empty($openEventSeatingPlanUponSelection))) {
            unset($this->OpenEventSeatingPlanUponSelection);
        } else {
            $this->OpenEventSeatingPlanUponSelection = $openEventSeatingPlanUponSelection;
        }
        return $this;
    }
    /**
     * Get OrderEventsBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderEventsBy()
    {
        return isset($this->OrderEventsBy) ? $this->OrderEventsBy : null;
    }
    /**
     * Set OrderEventsBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrderEventsBy::valueIsValid()
     * @uses \patest\EnumType\OrderEventsBy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderEventsBy
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setOrderEventsBy($orderEventsBy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrderEventsBy::valueIsValid($orderEventsBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrderEventsBy', is_array($orderEventsBy) ? implode(', ', $orderEventsBy) : var_export($orderEventsBy, true), implode(', ', \patest\EnumType\OrderEventsBy::getValidValues())), __LINE__);
        }
        if (is_null($orderEventsBy) || (is_array($orderEventsBy) && empty($orderEventsBy))) {
            unset($this->OrderEventsBy);
        } else {
            $this->OrderEventsBy = $orderEventsBy;
        }
        return $this;
    }
    /**
     * Get SaleModeStartupAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeStartupAs()
    {
        return isset($this->SaleModeStartupAs) ? $this->SaleModeStartupAs : null;
    }
    /**
     * Set SaleModeStartupAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SaleModeStartupAs::valueIsValid()
     * @uses \patest\EnumType\SaleModeStartupAs::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saleModeStartupAs
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setSaleModeStartupAs($saleModeStartupAs = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SaleModeStartupAs::valueIsValid($saleModeStartupAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SaleModeStartupAs', is_array($saleModeStartupAs) ? implode(', ', $saleModeStartupAs) : var_export($saleModeStartupAs, true), implode(', ', \patest\EnumType\SaleModeStartupAs::getValidValues())), __LINE__);
        }
        if (is_null($saleModeStartupAs) || (is_array($saleModeStartupAs) && empty($saleModeStartupAs))) {
            unset($this->SaleModeStartupAs);
        } else {
            $this->SaleModeStartupAs = $saleModeStartupAs;
        }
        return $this;
    }
    /**
     * Get SalesDefaultTab value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesDefaultTab()
    {
        return isset($this->SalesDefaultTab) ? $this->SalesDefaultTab : null;
    }
    /**
     * Set SalesDefaultTab value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SaleTabs::valueIsValid()
     * @uses \patest\EnumType\SaleTabs::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salesDefaultTab
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setSalesDefaultTab($salesDefaultTab = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SaleTabs::valueIsValid($salesDefaultTab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SaleTabs', is_array($salesDefaultTab) ? implode(', ', $salesDefaultTab) : var_export($salesDefaultTab, true), implode(', ', \patest\EnumType\SaleTabs::getValidValues())), __LINE__);
        }
        if (is_null($salesDefaultTab) || (is_array($salesDefaultTab) && empty($salesDefaultTab))) {
            unset($this->SalesDefaultTab);
        } else {
            $this->SalesDefaultTab = $salesDefaultTab;
        }
        return $this;
    }
    /**
     * Get ShowCustomerDetailsSummaryScreen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowCustomerDetailsSummaryScreen()
    {
        return isset($this->ShowCustomerDetailsSummaryScreen) ? $this->ShowCustomerDetailsSummaryScreen : null;
    }
    /**
     * Set ShowCustomerDetailsSummaryScreen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showCustomerDetailsSummaryScreen
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setShowCustomerDetailsSummaryScreen($showCustomerDetailsSummaryScreen = null)
    {
        // validation for constraint: boolean
        if (!is_null($showCustomerDetailsSummaryScreen) && !is_bool($showCustomerDetailsSummaryScreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showCustomerDetailsSummaryScreen, true), gettype($showCustomerDetailsSummaryScreen)), __LINE__);
        }
        if (is_null($showCustomerDetailsSummaryScreen) || (is_array($showCustomerDetailsSummaryScreen) && empty($showCustomerDetailsSummaryScreen))) {
            unset($this->ShowCustomerDetailsSummaryScreen);
        } else {
            $this->ShowCustomerDetailsSummaryScreen = $showCustomerDetailsSummaryScreen;
        }
        return $this;
    }
    /**
     * Get WideRowsToSupportTouch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWideRowsToSupportTouch()
    {
        return isset($this->WideRowsToSupportTouch) ? $this->WideRowsToSupportTouch : null;
    }
    /**
     * Set WideRowsToSupportTouch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wideRowsToSupportTouch
     * @return \patest\StructType\Security_PointOfSaleCompanyParameters
     */
    public function setWideRowsToSupportTouch($wideRowsToSupportTouch = null)
    {
        // validation for constraint: boolean
        if (!is_null($wideRowsToSupportTouch) && !is_bool($wideRowsToSupportTouch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wideRowsToSupportTouch, true), gettype($wideRowsToSupportTouch)), __LINE__);
        }
        if (is_null($wideRowsToSupportTouch) || (is_array($wideRowsToSupportTouch) && empty($wideRowsToSupportTouch))) {
            unset($this->WideRowsToSupportTouch);
        } else {
            $this->WideRowsToSupportTouch = $wideRowsToSupportTouch;
        }
        return $this;
    }
}
