<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.ParameterValue StructType
 * @subpackage Structs
 */
class Security_ParameterValue extends PersistableEntity
{
    /**
     * The KeyValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $KeyValue;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Level;
    /**
     * The ParameterName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParameterName;
    /**
     * The ParameterOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ParameterOwner;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for Security.ParameterValue
     * @uses Security_ParameterValue::setKeyValue()
     * @uses Security_ParameterValue::setLevel()
     * @uses Security_ParameterValue::setParameterName()
     * @uses Security_ParameterValue::setParameterOwner()
     * @uses Security_ParameterValue::setValue()
     * @param string $keyValue
     * @param string $level
     * @param string $parameterName
     * @param string $parameterOwner
     * @param string $value
     */
    public function __construct($keyValue = null, $level = null, $parameterName = null, $parameterOwner = null, $value = null)
    {
        $this
            ->setKeyValue($keyValue)
            ->setLevel($level)
            ->setParameterName($parameterName)
            ->setParameterOwner($parameterOwner)
            ->setValue($value);
    }
    /**
     * Get KeyValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKeyValue()
    {
        return isset($this->KeyValue) ? $this->KeyValue : null;
    }
    /**
     * Set KeyValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $keyValue
     * @return \patest\StructType\Security_ParameterValue
     */
    public function setKeyValue($keyValue = null)
    {
        // validation for constraint: string
        if (!is_null($keyValue) && !is_string($keyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyValue, true), gettype($keyValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($keyValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $keyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($keyValue, true)), __LINE__);
        }
        if (is_null($keyValue) || (is_array($keyValue) && empty($keyValue))) {
            unset($this->KeyValue);
        } else {
            $this->KeyValue = $keyValue;
        }
        return $this;
    }
    /**
     * Get Level value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLevel()
    {
        return isset($this->Level) ? $this->Level : null;
    }
    /**
     * Set Level value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ParameterNodeType::valueIsValid()
     * @uses \patest\EnumType\ParameterNodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \patest\StructType\Security_ParameterValue
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ParameterNodeType::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ParameterNodeType', is_array($level) ? implode(', ', $level) : var_export($level, true), implode(', ', \patest\EnumType\ParameterNodeType::getValidValues())), __LINE__);
        }
        if (is_null($level) || (is_array($level) && empty($level))) {
            unset($this->Level);
        } else {
            $this->Level = $level;
        }
        return $this;
    }
    /**
     * Get ParameterName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParameterName()
    {
        return isset($this->ParameterName) ? $this->ParameterName : null;
    }
    /**
     * Set ParameterName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parameterName
     * @return \patest\StructType\Security_ParameterValue
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        if (is_null($parameterName) || (is_array($parameterName) && empty($parameterName))) {
            unset($this->ParameterName);
        } else {
            $this->ParameterName = $parameterName;
        }
        return $this;
    }
    /**
     * Get ParameterOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParameterOwner()
    {
        return isset($this->ParameterOwner) ? $this->ParameterOwner : null;
    }
    /**
     * Set ParameterOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parameterOwner
     * @return \patest\StructType\Security_ParameterValue
     */
    public function setParameterOwner($parameterOwner = null)
    {
        // validation for constraint: string
        if (!is_null($parameterOwner) && !is_string($parameterOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterOwner, true), gettype($parameterOwner)), __LINE__);
        }
        if (is_null($parameterOwner) || (is_array($parameterOwner) && empty($parameterOwner))) {
            unset($this->ParameterOwner);
        } else {
            $this->ParameterOwner = $parameterOwner;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \patest\StructType\Security_ParameterValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
