<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.OpenedTill StructType
 * @subpackage Structs
 */
class Security_OpenedTill extends Security_Till
{
    /**
     * The OpenedFromDateTime
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpenedFromDateTime;
    /**
     * Constructor method for Security.OpenedTill
     * @uses Security_OpenedTill::setOpenedFromDateTime()
     * @param string $openedFromDateTime
     */
    public function __construct($openedFromDateTime = null)
    {
        $this
            ->setOpenedFromDateTime($openedFromDateTime);
    }
    /**
     * Get OpenedFromDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenedFromDateTime()
    {
        return isset($this->OpenedFromDateTime) ? $this->OpenedFromDateTime : null;
    }
    /**
     * Set OpenedFromDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openedFromDateTime
     * @return \patest\StructType\Security_OpenedTill
     */
    public function setOpenedFromDateTime($openedFromDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($openedFromDateTime) && !is_string($openedFromDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openedFromDateTime, true), gettype($openedFromDateTime)), __LINE__);
        }
        if (is_null($openedFromDateTime) || (is_array($openedFromDateTime) && empty($openedFromDateTime))) {
            unset($this->OpenedFromDateTime);
        } else {
            $this->OpenedFromDateTime = $openedFromDateTime;
        }
        return $this;
    }
}
