<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.MembershipCompanyParameters StructType
 * @subpackage Structs
 */
class Security_MembershipCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AllowOperationByPurchaserThatIsNotOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowOperationByPurchaserThatIsNotOwner;
    /**
     * The BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized;
    /**
     * The DefaultAutoRenewBatchPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultAutoRenewBatchPeriod;
    /**
     * The DefaultNumberCounterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultNumberCounterId;
    /**
     * The DefaultNumberPrefix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultNumberPrefix;
    /**
     * The DefaultNumberSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultNumberSize;
    /**
     * The DefaultRedExpiryClosePeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultRedExpiryClosePeriod;
    /**
     * The DefaultYellowExpiryClosePeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultYellowExpiryClosePeriod;
    /**
     * The DisplayClientMembershipAlerts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayClientMembershipAlerts;
    /**
     * The DisplayFullyUtiliztedBenefits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayFullyUtiliztedBenefits;
    /**
     * The DoNotDisplayOrUtilzedExpiredBefore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DoNotDisplayOrUtilzedExpiredBefore;
    /**
     * The MaximumBlackClientPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaximumBlackClientPoints;
    /**
     * The MembershipBenefitPriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipBenefitPriceTypeIds;
    /**
     * The MembershipRenewalStartDateOptionWhenStartIsInPast
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipRenewalStartDateOptionWhenStartIsInPast;
    /**
     * The NumberingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberingOption;
    /**
     * The RenewStartDateOptionForValidMemberships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenewStartDateOptionForValidMemberships;
    /**
     * The ScheduledRenewalDelay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScheduledRenewalDelay;
    /**
     * The ScheduledRenewalExpiryPeriodDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScheduledRenewalExpiryPeriodDays;
    /**
     * The ScheduledRenewalRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScheduledRenewalRecipients;
    /**
     * The ScheduledRenewalVerificationDelay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScheduledRenewalVerificationDelay;
    /**
     * The ScheduledRenewalVerificationRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScheduledRenewalVerificationRecipients;
    /**
     * The UtilizeBenefitsOfExpiredMemberships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UtilizeBenefitsOfExpiredMemberships;
    /**
     * Constructor method for Security.MembershipCompanyParameters
     * @uses Security_MembershipCompanyParameters::setAllowOperationByPurchaserThatIsNotOwner()
     * @uses Security_MembershipCompanyParameters::setBenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized()
     * @uses Security_MembershipCompanyParameters::setDefaultAutoRenewBatchPeriod()
     * @uses Security_MembershipCompanyParameters::setDefaultNumberCounterId()
     * @uses Security_MembershipCompanyParameters::setDefaultNumberPrefix()
     * @uses Security_MembershipCompanyParameters::setDefaultNumberSize()
     * @uses Security_MembershipCompanyParameters::setDefaultRedExpiryClosePeriod()
     * @uses Security_MembershipCompanyParameters::setDefaultYellowExpiryClosePeriod()
     * @uses Security_MembershipCompanyParameters::setDisplayClientMembershipAlerts()
     * @uses Security_MembershipCompanyParameters::setDisplayFullyUtiliztedBenefits()
     * @uses Security_MembershipCompanyParameters::setDoNotDisplayOrUtilzedExpiredBefore()
     * @uses Security_MembershipCompanyParameters::setMaximumBlackClientPoints()
     * @uses Security_MembershipCompanyParameters::setMembershipBenefitPriceTypeIds()
     * @uses Security_MembershipCompanyParameters::setMembershipRenewalStartDateOptionWhenStartIsInPast()
     * @uses Security_MembershipCompanyParameters::setNumberingOption()
     * @uses Security_MembershipCompanyParameters::setRenewStartDateOptionForValidMemberships()
     * @uses Security_MembershipCompanyParameters::setScheduledRenewalDelay()
     * @uses Security_MembershipCompanyParameters::setScheduledRenewalExpiryPeriodDays()
     * @uses Security_MembershipCompanyParameters::setScheduledRenewalRecipients()
     * @uses Security_MembershipCompanyParameters::setScheduledRenewalVerificationDelay()
     * @uses Security_MembershipCompanyParameters::setScheduledRenewalVerificationRecipients()
     * @uses Security_MembershipCompanyParameters::setUtilizeBenefitsOfExpiredMemberships()
     * @param bool $allowOperationByPurchaserThatIsNotOwner
     * @param bool $benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized
     * @param int $defaultAutoRenewBatchPeriod
     * @param string $defaultNumberCounterId
     * @param string $defaultNumberPrefix
     * @param int $defaultNumberSize
     * @param int $defaultRedExpiryClosePeriod
     * @param int $defaultYellowExpiryClosePeriod
     * @param bool $displayClientMembershipAlerts
     * @param bool $displayFullyUtiliztedBenefits
     * @param string $doNotDisplayOrUtilzedExpiredBefore
     * @param int $maximumBlackClientPoints
     * @param string $membershipBenefitPriceTypeIds
     * @param string $membershipRenewalStartDateOptionWhenStartIsInPast
     * @param string $numberingOption
     * @param string $renewStartDateOptionForValidMemberships
     * @param int $scheduledRenewalDelay
     * @param int $scheduledRenewalExpiryPeriodDays
     * @param string $scheduledRenewalRecipients
     * @param int $scheduledRenewalVerificationDelay
     * @param string $scheduledRenewalVerificationRecipients
     * @param bool $utilizeBenefitsOfExpiredMemberships
     */
    public function __construct($allowOperationByPurchaserThatIsNotOwner = null, $benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized = null, $defaultAutoRenewBatchPeriod = null, $defaultNumberCounterId = null, $defaultNumberPrefix = null, $defaultNumberSize = null, $defaultRedExpiryClosePeriod = null, $defaultYellowExpiryClosePeriod = null, $displayClientMembershipAlerts = null, $displayFullyUtiliztedBenefits = null, $doNotDisplayOrUtilzedExpiredBefore = null, $maximumBlackClientPoints = null, $membershipBenefitPriceTypeIds = null, $membershipRenewalStartDateOptionWhenStartIsInPast = null, $numberingOption = null, $renewStartDateOptionForValidMemberships = null, $scheduledRenewalDelay = null, $scheduledRenewalExpiryPeriodDays = null, $scheduledRenewalRecipients = null, $scheduledRenewalVerificationDelay = null, $scheduledRenewalVerificationRecipients = null, $utilizeBenefitsOfExpiredMemberships = null)
    {
        $this
            ->setAllowOperationByPurchaserThatIsNotOwner($allowOperationByPurchaserThatIsNotOwner)
            ->setBenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized)
            ->setDefaultAutoRenewBatchPeriod($defaultAutoRenewBatchPeriod)
            ->setDefaultNumberCounterId($defaultNumberCounterId)
            ->setDefaultNumberPrefix($defaultNumberPrefix)
            ->setDefaultNumberSize($defaultNumberSize)
            ->setDefaultRedExpiryClosePeriod($defaultRedExpiryClosePeriod)
            ->setDefaultYellowExpiryClosePeriod($defaultYellowExpiryClosePeriod)
            ->setDisplayClientMembershipAlerts($displayClientMembershipAlerts)
            ->setDisplayFullyUtiliztedBenefits($displayFullyUtiliztedBenefits)
            ->setDoNotDisplayOrUtilzedExpiredBefore($doNotDisplayOrUtilzedExpiredBefore)
            ->setMaximumBlackClientPoints($maximumBlackClientPoints)
            ->setMembershipBenefitPriceTypeIds($membershipBenefitPriceTypeIds)
            ->setMembershipRenewalStartDateOptionWhenStartIsInPast($membershipRenewalStartDateOptionWhenStartIsInPast)
            ->setNumberingOption($numberingOption)
            ->setRenewStartDateOptionForValidMemberships($renewStartDateOptionForValidMemberships)
            ->setScheduledRenewalDelay($scheduledRenewalDelay)
            ->setScheduledRenewalExpiryPeriodDays($scheduledRenewalExpiryPeriodDays)
            ->setScheduledRenewalRecipients($scheduledRenewalRecipients)
            ->setScheduledRenewalVerificationDelay($scheduledRenewalVerificationDelay)
            ->setScheduledRenewalVerificationRecipients($scheduledRenewalVerificationRecipients)
            ->setUtilizeBenefitsOfExpiredMemberships($utilizeBenefitsOfExpiredMemberships);
    }
    /**
     * Get AllowOperationByPurchaserThatIsNotOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowOperationByPurchaserThatIsNotOwner()
    {
        return isset($this->AllowOperationByPurchaserThatIsNotOwner) ? $this->AllowOperationByPurchaserThatIsNotOwner : null;
    }
    /**
     * Set AllowOperationByPurchaserThatIsNotOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowOperationByPurchaserThatIsNotOwner
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setAllowOperationByPurchaserThatIsNotOwner($allowOperationByPurchaserThatIsNotOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowOperationByPurchaserThatIsNotOwner) && !is_bool($allowOperationByPurchaserThatIsNotOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowOperationByPurchaserThatIsNotOwner, true), gettype($allowOperationByPurchaserThatIsNotOwner)), __LINE__);
        }
        if (is_null($allowOperationByPurchaserThatIsNotOwner) || (is_array($allowOperationByPurchaserThatIsNotOwner) && empty($allowOperationByPurchaserThatIsNotOwner))) {
            unset($this->AllowOperationByPurchaserThatIsNotOwner);
        } else {
            $this->AllowOperationByPurchaserThatIsNotOwner = $allowOperationByPurchaserThatIsNotOwner;
        }
        return $this;
    }
    /**
     * Get BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized()
    {
        return isset($this->BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized) ? $this->BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized : null;
    }
    /**
     * Set BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setBenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized = null)
    {
        // validation for constraint: boolean
        if (!is_null($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized) && !is_bool($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized, true), gettype($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized)), __LINE__);
        }
        if (is_null($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized) || (is_array($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized) && empty($benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized))) {
            unset($this->BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized);
        } else {
            $this->BenefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized = $benefitsOfEventsAfterMembershipExpiryCanAlsoBeUtilized;
        }
        return $this;
    }
    /**
     * Get DefaultAutoRenewBatchPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultAutoRenewBatchPeriod()
    {
        return isset($this->DefaultAutoRenewBatchPeriod) ? $this->DefaultAutoRenewBatchPeriod : null;
    }
    /**
     * Set DefaultAutoRenewBatchPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultAutoRenewBatchPeriod
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDefaultAutoRenewBatchPeriod($defaultAutoRenewBatchPeriod = null)
    {
        // validation for constraint: int
        if (!is_null($defaultAutoRenewBatchPeriod) && !(is_int($defaultAutoRenewBatchPeriod) || ctype_digit($defaultAutoRenewBatchPeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultAutoRenewBatchPeriod, true), gettype($defaultAutoRenewBatchPeriod)), __LINE__);
        }
        if (is_null($defaultAutoRenewBatchPeriod) || (is_array($defaultAutoRenewBatchPeriod) && empty($defaultAutoRenewBatchPeriod))) {
            unset($this->DefaultAutoRenewBatchPeriod);
        } else {
            $this->DefaultAutoRenewBatchPeriod = $defaultAutoRenewBatchPeriod;
        }
        return $this;
    }
    /**
     * Get DefaultNumberCounterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultNumberCounterId()
    {
        return isset($this->DefaultNumberCounterId) ? $this->DefaultNumberCounterId : null;
    }
    /**
     * Set DefaultNumberCounterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultNumberCounterId
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDefaultNumberCounterId($defaultNumberCounterId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultNumberCounterId) && !is_string($defaultNumberCounterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultNumberCounterId, true), gettype($defaultNumberCounterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultNumberCounterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultNumberCounterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultNumberCounterId, true)), __LINE__);
        }
        if (is_null($defaultNumberCounterId) || (is_array($defaultNumberCounterId) && empty($defaultNumberCounterId))) {
            unset($this->DefaultNumberCounterId);
        } else {
            $this->DefaultNumberCounterId = $defaultNumberCounterId;
        }
        return $this;
    }
    /**
     * Get DefaultNumberPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultNumberPrefix()
    {
        return isset($this->DefaultNumberPrefix) ? $this->DefaultNumberPrefix : null;
    }
    /**
     * Set DefaultNumberPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultNumberPrefix
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDefaultNumberPrefix($defaultNumberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($defaultNumberPrefix) && !is_string($defaultNumberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultNumberPrefix, true), gettype($defaultNumberPrefix)), __LINE__);
        }
        if (is_null($defaultNumberPrefix) || (is_array($defaultNumberPrefix) && empty($defaultNumberPrefix))) {
            unset($this->DefaultNumberPrefix);
        } else {
            $this->DefaultNumberPrefix = $defaultNumberPrefix;
        }
        return $this;
    }
    /**
     * Get DefaultNumberSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultNumberSize()
    {
        return isset($this->DefaultNumberSize) ? $this->DefaultNumberSize : null;
    }
    /**
     * Set DefaultNumberSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultNumberSize
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDefaultNumberSize($defaultNumberSize = null)
    {
        // validation for constraint: int
        if (!is_null($defaultNumberSize) && !(is_int($defaultNumberSize) || ctype_digit($defaultNumberSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultNumberSize, true), gettype($defaultNumberSize)), __LINE__);
        }
        if (is_null($defaultNumberSize) || (is_array($defaultNumberSize) && empty($defaultNumberSize))) {
            unset($this->DefaultNumberSize);
        } else {
            $this->DefaultNumberSize = $defaultNumberSize;
        }
        return $this;
    }
    /**
     * Get DefaultRedExpiryClosePeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultRedExpiryClosePeriod()
    {
        return isset($this->DefaultRedExpiryClosePeriod) ? $this->DefaultRedExpiryClosePeriod : null;
    }
    /**
     * Set DefaultRedExpiryClosePeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultRedExpiryClosePeriod
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDefaultRedExpiryClosePeriod($defaultRedExpiryClosePeriod = null)
    {
        // validation for constraint: int
        if (!is_null($defaultRedExpiryClosePeriod) && !(is_int($defaultRedExpiryClosePeriod) || ctype_digit($defaultRedExpiryClosePeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultRedExpiryClosePeriod, true), gettype($defaultRedExpiryClosePeriod)), __LINE__);
        }
        if (is_null($defaultRedExpiryClosePeriod) || (is_array($defaultRedExpiryClosePeriod) && empty($defaultRedExpiryClosePeriod))) {
            unset($this->DefaultRedExpiryClosePeriod);
        } else {
            $this->DefaultRedExpiryClosePeriod = $defaultRedExpiryClosePeriod;
        }
        return $this;
    }
    /**
     * Get DefaultYellowExpiryClosePeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultYellowExpiryClosePeriod()
    {
        return isset($this->DefaultYellowExpiryClosePeriod) ? $this->DefaultYellowExpiryClosePeriod : null;
    }
    /**
     * Set DefaultYellowExpiryClosePeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultYellowExpiryClosePeriod
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDefaultYellowExpiryClosePeriod($defaultYellowExpiryClosePeriod = null)
    {
        // validation for constraint: int
        if (!is_null($defaultYellowExpiryClosePeriod) && !(is_int($defaultYellowExpiryClosePeriod) || ctype_digit($defaultYellowExpiryClosePeriod))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultYellowExpiryClosePeriod, true), gettype($defaultYellowExpiryClosePeriod)), __LINE__);
        }
        if (is_null($defaultYellowExpiryClosePeriod) || (is_array($defaultYellowExpiryClosePeriod) && empty($defaultYellowExpiryClosePeriod))) {
            unset($this->DefaultYellowExpiryClosePeriod);
        } else {
            $this->DefaultYellowExpiryClosePeriod = $defaultYellowExpiryClosePeriod;
        }
        return $this;
    }
    /**
     * Get DisplayClientMembershipAlerts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayClientMembershipAlerts()
    {
        return isset($this->DisplayClientMembershipAlerts) ? $this->DisplayClientMembershipAlerts : null;
    }
    /**
     * Set DisplayClientMembershipAlerts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayClientMembershipAlerts
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDisplayClientMembershipAlerts($displayClientMembershipAlerts = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayClientMembershipAlerts) && !is_bool($displayClientMembershipAlerts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayClientMembershipAlerts, true), gettype($displayClientMembershipAlerts)), __LINE__);
        }
        if (is_null($displayClientMembershipAlerts) || (is_array($displayClientMembershipAlerts) && empty($displayClientMembershipAlerts))) {
            unset($this->DisplayClientMembershipAlerts);
        } else {
            $this->DisplayClientMembershipAlerts = $displayClientMembershipAlerts;
        }
        return $this;
    }
    /**
     * Get DisplayFullyUtiliztedBenefits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayFullyUtiliztedBenefits()
    {
        return isset($this->DisplayFullyUtiliztedBenefits) ? $this->DisplayFullyUtiliztedBenefits : null;
    }
    /**
     * Set DisplayFullyUtiliztedBenefits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayFullyUtiliztedBenefits
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDisplayFullyUtiliztedBenefits($displayFullyUtiliztedBenefits = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayFullyUtiliztedBenefits) && !is_bool($displayFullyUtiliztedBenefits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayFullyUtiliztedBenefits, true), gettype($displayFullyUtiliztedBenefits)), __LINE__);
        }
        if (is_null($displayFullyUtiliztedBenefits) || (is_array($displayFullyUtiliztedBenefits) && empty($displayFullyUtiliztedBenefits))) {
            unset($this->DisplayFullyUtiliztedBenefits);
        } else {
            $this->DisplayFullyUtiliztedBenefits = $displayFullyUtiliztedBenefits;
        }
        return $this;
    }
    /**
     * Get DoNotDisplayOrUtilzedExpiredBefore value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoNotDisplayOrUtilzedExpiredBefore()
    {
        return isset($this->DoNotDisplayOrUtilzedExpiredBefore) ? $this->DoNotDisplayOrUtilzedExpiredBefore : null;
    }
    /**
     * Set DoNotDisplayOrUtilzedExpiredBefore value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doNotDisplayOrUtilzedExpiredBefore
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setDoNotDisplayOrUtilzedExpiredBefore($doNotDisplayOrUtilzedExpiredBefore = null)
    {
        // validation for constraint: string
        if (!is_null($doNotDisplayOrUtilzedExpiredBefore) && !is_string($doNotDisplayOrUtilzedExpiredBefore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doNotDisplayOrUtilzedExpiredBefore, true), gettype($doNotDisplayOrUtilzedExpiredBefore)), __LINE__);
        }
        if (is_null($doNotDisplayOrUtilzedExpiredBefore) || (is_array($doNotDisplayOrUtilzedExpiredBefore) && empty($doNotDisplayOrUtilzedExpiredBefore))) {
            unset($this->DoNotDisplayOrUtilzedExpiredBefore);
        } else {
            $this->DoNotDisplayOrUtilzedExpiredBefore = $doNotDisplayOrUtilzedExpiredBefore;
        }
        return $this;
    }
    /**
     * Get MaximumBlackClientPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaximumBlackClientPoints()
    {
        return isset($this->MaximumBlackClientPoints) ? $this->MaximumBlackClientPoints : null;
    }
    /**
     * Set MaximumBlackClientPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maximumBlackClientPoints
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setMaximumBlackClientPoints($maximumBlackClientPoints = null)
    {
        // validation for constraint: int
        if (!is_null($maximumBlackClientPoints) && !(is_int($maximumBlackClientPoints) || ctype_digit($maximumBlackClientPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumBlackClientPoints, true), gettype($maximumBlackClientPoints)), __LINE__);
        }
        if (is_null($maximumBlackClientPoints) || (is_array($maximumBlackClientPoints) && empty($maximumBlackClientPoints))) {
            unset($this->MaximumBlackClientPoints);
        } else {
            $this->MaximumBlackClientPoints = $maximumBlackClientPoints;
        }
        return $this;
    }
    /**
     * Get MembershipBenefitPriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipBenefitPriceTypeIds()
    {
        return isset($this->MembershipBenefitPriceTypeIds) ? $this->MembershipBenefitPriceTypeIds : null;
    }
    /**
     * Set MembershipBenefitPriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipBenefitPriceTypeIds
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setMembershipBenefitPriceTypeIds($membershipBenefitPriceTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($membershipBenefitPriceTypeIds) && !is_string($membershipBenefitPriceTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipBenefitPriceTypeIds, true), gettype($membershipBenefitPriceTypeIds)), __LINE__);
        }
        if (is_null($membershipBenefitPriceTypeIds) || (is_array($membershipBenefitPriceTypeIds) && empty($membershipBenefitPriceTypeIds))) {
            unset($this->MembershipBenefitPriceTypeIds);
        } else {
            $this->MembershipBenefitPriceTypeIds = $membershipBenefitPriceTypeIds;
        }
        return $this;
    }
    /**
     * Get MembershipRenewalStartDateOptionWhenStartIsInPast value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipRenewalStartDateOptionWhenStartIsInPast()
    {
        return isset($this->MembershipRenewalStartDateOptionWhenStartIsInPast) ? $this->MembershipRenewalStartDateOptionWhenStartIsInPast : null;
    }
    /**
     * Set MembershipRenewalStartDateOptionWhenStartIsInPast value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipRenewalStartDateOption::valueIsValid()
     * @uses \patest\EnumType\MembershipRenewalStartDateOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $membershipRenewalStartDateOptionWhenStartIsInPast
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setMembershipRenewalStartDateOptionWhenStartIsInPast($membershipRenewalStartDateOptionWhenStartIsInPast = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipRenewalStartDateOption::valueIsValid($membershipRenewalStartDateOptionWhenStartIsInPast)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipRenewalStartDateOption', is_array($membershipRenewalStartDateOptionWhenStartIsInPast) ? implode(', ', $membershipRenewalStartDateOptionWhenStartIsInPast) : var_export($membershipRenewalStartDateOptionWhenStartIsInPast, true), implode(', ', \patest\EnumType\MembershipRenewalStartDateOption::getValidValues())), __LINE__);
        }
        if (is_null($membershipRenewalStartDateOptionWhenStartIsInPast) || (is_array($membershipRenewalStartDateOptionWhenStartIsInPast) && empty($membershipRenewalStartDateOptionWhenStartIsInPast))) {
            unset($this->MembershipRenewalStartDateOptionWhenStartIsInPast);
        } else {
            $this->MembershipRenewalStartDateOptionWhenStartIsInPast = $membershipRenewalStartDateOptionWhenStartIsInPast;
        }
        return $this;
    }
    /**
     * Get NumberingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberingOption()
    {
        return isset($this->NumberingOption) ? $this->NumberingOption : null;
    }
    /**
     * Set NumberingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipNumberingOption::valueIsValid()
     * @uses \patest\EnumType\MembershipNumberingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $numberingOption
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setNumberingOption($numberingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipNumberingOption::valueIsValid($numberingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipNumberingOption', is_array($numberingOption) ? implode(', ', $numberingOption) : var_export($numberingOption, true), implode(', ', \patest\EnumType\MembershipNumberingOption::getValidValues())), __LINE__);
        }
        if (is_null($numberingOption) || (is_array($numberingOption) && empty($numberingOption))) {
            unset($this->NumberingOption);
        } else {
            $this->NumberingOption = $numberingOption;
        }
        return $this;
    }
    /**
     * Get RenewStartDateOptionForValidMemberships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewStartDateOptionForValidMemberships()
    {
        return isset($this->RenewStartDateOptionForValidMemberships) ? $this->RenewStartDateOptionForValidMemberships : null;
    }
    /**
     * Set RenewStartDateOptionForValidMemberships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RenewStartDateOptionForValidMemberships::valueIsValid()
     * @uses \patest\EnumType\RenewStartDateOptionForValidMemberships::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $renewStartDateOptionForValidMemberships
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setRenewStartDateOptionForValidMemberships($renewStartDateOptionForValidMemberships = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RenewStartDateOptionForValidMemberships::valueIsValid($renewStartDateOptionForValidMemberships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RenewStartDateOptionForValidMemberships', is_array($renewStartDateOptionForValidMemberships) ? implode(', ', $renewStartDateOptionForValidMemberships) : var_export($renewStartDateOptionForValidMemberships, true), implode(', ', \patest\EnumType\RenewStartDateOptionForValidMemberships::getValidValues())), __LINE__);
        }
        if (is_null($renewStartDateOptionForValidMemberships) || (is_array($renewStartDateOptionForValidMemberships) && empty($renewStartDateOptionForValidMemberships))) {
            unset($this->RenewStartDateOptionForValidMemberships);
        } else {
            $this->RenewStartDateOptionForValidMemberships = $renewStartDateOptionForValidMemberships;
        }
        return $this;
    }
    /**
     * Get ScheduledRenewalDelay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScheduledRenewalDelay()
    {
        return isset($this->ScheduledRenewalDelay) ? $this->ScheduledRenewalDelay : null;
    }
    /**
     * Set ScheduledRenewalDelay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scheduledRenewalDelay
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setScheduledRenewalDelay($scheduledRenewalDelay = null)
    {
        // validation for constraint: int
        if (!is_null($scheduledRenewalDelay) && !(is_int($scheduledRenewalDelay) || ctype_digit($scheduledRenewalDelay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scheduledRenewalDelay, true), gettype($scheduledRenewalDelay)), __LINE__);
        }
        if (is_null($scheduledRenewalDelay) || (is_array($scheduledRenewalDelay) && empty($scheduledRenewalDelay))) {
            unset($this->ScheduledRenewalDelay);
        } else {
            $this->ScheduledRenewalDelay = $scheduledRenewalDelay;
        }
        return $this;
    }
    /**
     * Get ScheduledRenewalExpiryPeriodDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScheduledRenewalExpiryPeriodDays()
    {
        return isset($this->ScheduledRenewalExpiryPeriodDays) ? $this->ScheduledRenewalExpiryPeriodDays : null;
    }
    /**
     * Set ScheduledRenewalExpiryPeriodDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scheduledRenewalExpiryPeriodDays
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setScheduledRenewalExpiryPeriodDays($scheduledRenewalExpiryPeriodDays = null)
    {
        // validation for constraint: int
        if (!is_null($scheduledRenewalExpiryPeriodDays) && !(is_int($scheduledRenewalExpiryPeriodDays) || ctype_digit($scheduledRenewalExpiryPeriodDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scheduledRenewalExpiryPeriodDays, true), gettype($scheduledRenewalExpiryPeriodDays)), __LINE__);
        }
        if (is_null($scheduledRenewalExpiryPeriodDays) || (is_array($scheduledRenewalExpiryPeriodDays) && empty($scheduledRenewalExpiryPeriodDays))) {
            unset($this->ScheduledRenewalExpiryPeriodDays);
        } else {
            $this->ScheduledRenewalExpiryPeriodDays = $scheduledRenewalExpiryPeriodDays;
        }
        return $this;
    }
    /**
     * Get ScheduledRenewalRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScheduledRenewalRecipients()
    {
        return isset($this->ScheduledRenewalRecipients) ? $this->ScheduledRenewalRecipients : null;
    }
    /**
     * Set ScheduledRenewalRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scheduledRenewalRecipients
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setScheduledRenewalRecipients($scheduledRenewalRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledRenewalRecipients) && !is_string($scheduledRenewalRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledRenewalRecipients, true), gettype($scheduledRenewalRecipients)), __LINE__);
        }
        if (is_null($scheduledRenewalRecipients) || (is_array($scheduledRenewalRecipients) && empty($scheduledRenewalRecipients))) {
            unset($this->ScheduledRenewalRecipients);
        } else {
            $this->ScheduledRenewalRecipients = $scheduledRenewalRecipients;
        }
        return $this;
    }
    /**
     * Get ScheduledRenewalVerificationDelay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScheduledRenewalVerificationDelay()
    {
        return isset($this->ScheduledRenewalVerificationDelay) ? $this->ScheduledRenewalVerificationDelay : null;
    }
    /**
     * Set ScheduledRenewalVerificationDelay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scheduledRenewalVerificationDelay
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setScheduledRenewalVerificationDelay($scheduledRenewalVerificationDelay = null)
    {
        // validation for constraint: int
        if (!is_null($scheduledRenewalVerificationDelay) && !(is_int($scheduledRenewalVerificationDelay) || ctype_digit($scheduledRenewalVerificationDelay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scheduledRenewalVerificationDelay, true), gettype($scheduledRenewalVerificationDelay)), __LINE__);
        }
        if (is_null($scheduledRenewalVerificationDelay) || (is_array($scheduledRenewalVerificationDelay) && empty($scheduledRenewalVerificationDelay))) {
            unset($this->ScheduledRenewalVerificationDelay);
        } else {
            $this->ScheduledRenewalVerificationDelay = $scheduledRenewalVerificationDelay;
        }
        return $this;
    }
    /**
     * Get ScheduledRenewalVerificationRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScheduledRenewalVerificationRecipients()
    {
        return isset($this->ScheduledRenewalVerificationRecipients) ? $this->ScheduledRenewalVerificationRecipients : null;
    }
    /**
     * Set ScheduledRenewalVerificationRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scheduledRenewalVerificationRecipients
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setScheduledRenewalVerificationRecipients($scheduledRenewalVerificationRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledRenewalVerificationRecipients) && !is_string($scheduledRenewalVerificationRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduledRenewalVerificationRecipients, true), gettype($scheduledRenewalVerificationRecipients)), __LINE__);
        }
        if (is_null($scheduledRenewalVerificationRecipients) || (is_array($scheduledRenewalVerificationRecipients) && empty($scheduledRenewalVerificationRecipients))) {
            unset($this->ScheduledRenewalVerificationRecipients);
        } else {
            $this->ScheduledRenewalVerificationRecipients = $scheduledRenewalVerificationRecipients;
        }
        return $this;
    }
    /**
     * Get UtilizeBenefitsOfExpiredMemberships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUtilizeBenefitsOfExpiredMemberships()
    {
        return isset($this->UtilizeBenefitsOfExpiredMemberships) ? $this->UtilizeBenefitsOfExpiredMemberships : null;
    }
    /**
     * Set UtilizeBenefitsOfExpiredMemberships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $utilizeBenefitsOfExpiredMemberships
     * @return \patest\StructType\Security_MembershipCompanyParameters
     */
    public function setUtilizeBenefitsOfExpiredMemberships($utilizeBenefitsOfExpiredMemberships = null)
    {
        // validation for constraint: boolean
        if (!is_null($utilizeBenefitsOfExpiredMemberships) && !is_bool($utilizeBenefitsOfExpiredMemberships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($utilizeBenefitsOfExpiredMemberships, true), gettype($utilizeBenefitsOfExpiredMemberships)), __LINE__);
        }
        if (is_null($utilizeBenefitsOfExpiredMemberships) || (is_array($utilizeBenefitsOfExpiredMemberships) && empty($utilizeBenefitsOfExpiredMemberships))) {
            unset($this->UtilizeBenefitsOfExpiredMemberships);
        } else {
            $this->UtilizeBenefitsOfExpiredMemberships = $utilizeBenefitsOfExpiredMemberships;
        }
        return $this;
    }
}
