<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.HelpDeskUserParameters StructType
 * @subpackage Structs
 */
class Security_HelpDeskUserParameters extends AnyEntity
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The LastRequestTypeLaunched
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastRequestTypeLaunched;
    /**
     * The RequestsFilteredBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestsFilteredBy;
    /**
     * Constructor method for Security.HelpDeskUserParameters
     * @uses Security_HelpDeskUserParameters::setId()
     * @uses Security_HelpDeskUserParameters::setLastRequestTypeLaunched()
     * @uses Security_HelpDeskUserParameters::setRequestsFilteredBy()
     * @param string $id
     * @param string $lastRequestTypeLaunched
     * @param string $requestsFilteredBy
     */
    public function __construct($id = null, $lastRequestTypeLaunched = null, $requestsFilteredBy = null)
    {
        $this
            ->setId($id)
            ->setLastRequestTypeLaunched($lastRequestTypeLaunched)
            ->setRequestsFilteredBy($requestsFilteredBy);
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Security_HelpDeskUserParameters
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get LastRequestTypeLaunched value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastRequestTypeLaunched()
    {
        return isset($this->LastRequestTypeLaunched) ? $this->LastRequestTypeLaunched : null;
    }
    /**
     * Set LastRequestTypeLaunched value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastRequestTypeLaunched
     * @return \patest\StructType\Security_HelpDeskUserParameters
     */
    public function setLastRequestTypeLaunched($lastRequestTypeLaunched = null)
    {
        // validation for constraint: string
        if (!is_null($lastRequestTypeLaunched) && !is_string($lastRequestTypeLaunched)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastRequestTypeLaunched, true), gettype($lastRequestTypeLaunched)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastRequestTypeLaunched) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastRequestTypeLaunched)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastRequestTypeLaunched, true)), __LINE__);
        }
        if (is_null($lastRequestTypeLaunched) || (is_array($lastRequestTypeLaunched) && empty($lastRequestTypeLaunched))) {
            unset($this->LastRequestTypeLaunched);
        } else {
            $this->LastRequestTypeLaunched = $lastRequestTypeLaunched;
        }
        return $this;
    }
    /**
     * Get RequestsFilteredBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestsFilteredBy()
    {
        return isset($this->RequestsFilteredBy) ? $this->RequestsFilteredBy : null;
    }
    /**
     * Set RequestsFilteredBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestsFilteredBy
     * @return \patest\StructType\Security_HelpDeskUserParameters
     */
    public function setRequestsFilteredBy($requestsFilteredBy = null)
    {
        // validation for constraint: string
        if (!is_null($requestsFilteredBy) && !is_string($requestsFilteredBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestsFilteredBy, true), gettype($requestsFilteredBy)), __LINE__);
        }
        if (is_null($requestsFilteredBy) || (is_array($requestsFilteredBy) && empty($requestsFilteredBy))) {
            unset($this->RequestsFilteredBy);
        } else {
            $this->RequestsFilteredBy = $requestsFilteredBy;
        }
        return $this;
    }
}
