<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.EsroCompanyParameters StructType
 * @subpackage Structs
 */
class Security_EsroCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AccountDefaultSaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountDefaultSaleMode;
    /**
     * The AddTransactionToMatchedCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AddTransactionToMatchedCustomer;
    /**
     * The AllowClientsToPayByTokens
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowClientsToPayByTokens;
    /**
     * The AllowReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowReservation;
    /**
     * The AllowUpdateClientDetailsDuringCommit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowUpdateClientDetailsDuringCommit;
    /**
     * The AllowUpdateCustomerPreferredCultureIdDuringCommit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowUpdateCustomerPreferredCultureIdDuringCommit;
    /**
     * The AllowUpdateMatchedClientDetailsDuringCommit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowUpdateMatchedClientDetailsDuringCommit;
    /**
     * The AsroDefaultSaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AsroDefaultSaleMode;
    /**
     * The BringRelativesResaleCandidateTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BringRelativesResaleCandidateTickets;
    /**
     * The CanDowngradeMembershipOnRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanDowngradeMembershipOnRenew;
    /**
     * The DefaultSaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSaleMode;
    /**
     * The DepositCategoryForAutoReimbursement
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryForAutoReimbursement;
    /**
     * The ForceRelationshipLeftRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForceRelationshipLeftRoleId;
    /**
     * The ForceRelationshipProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ForceRelationshipProperties;
    /**
     * The ForceRelationshipRightRoleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForceRelationshipRightRoleId;
    /**
     * The ForceRelationshipTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForceRelationshipTypeId;
    /**
     * The ForceStrongRelationship
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ForceStrongRelationship;
    /**
     * The MinimalReimbursementAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MinimalReimbursementAmount;
    /**
     * The MuseumMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MuseumMode;
    /**
     * The OboSaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OboSaleMode;
    /**
     * The OfferRoundUpDonation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OfferRoundUpDonation;
    /**
     * The OnlineAssignTicketsToSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OnlineAssignTicketsToSubscription;
    /**
     * The PriceTypeChangeAppliesPriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeChangeAppliesPriceList;
    /**
     * The RefundVoucherCategoryForAutoReimbursement
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RefundVoucherCategoryForAutoReimbursement;
    /**
     * The ReplaceSubsTicketAllowedUntil
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $ReplaceSubsTicketAllowedUntil;
    /**
     * The ReservationAllowedUntil
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $ReservationAllowedUntil;
    /**
     * The ReservationRetrieveClientOwnTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReservationRetrieveClientOwnTransactions;
    /**
     * The RoundUpDonation
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoundUpDonation;
    /**
     * The RoundUpDonationFund
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoundUpDonationFund;
    /**
     * The SendResaleEmailNotification
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendResaleEmailNotification;
    /**
     * The ShowResalePromptOnLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowResalePromptOnLogin;
    /**
     * The StoreClientBeforeCommit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $StoreClientBeforeCommit;
    /**
     * The SupportReimbursementOnline
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SupportReimbursementOnline;
    /**
     * The UseSingleProductPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseSingleProductPage;
    /**
     * Constructor method for Security.EsroCompanyParameters
     * @uses Security_EsroCompanyParameters::setAccountDefaultSaleMode()
     * @uses Security_EsroCompanyParameters::setAddTransactionToMatchedCustomer()
     * @uses Security_EsroCompanyParameters::setAllowClientsToPayByTokens()
     * @uses Security_EsroCompanyParameters::setAllowReservation()
     * @uses Security_EsroCompanyParameters::setAllowUpdateClientDetailsDuringCommit()
     * @uses Security_EsroCompanyParameters::setAllowUpdateCustomerPreferredCultureIdDuringCommit()
     * @uses Security_EsroCompanyParameters::setAllowUpdateMatchedClientDetailsDuringCommit()
     * @uses Security_EsroCompanyParameters::setAsroDefaultSaleMode()
     * @uses Security_EsroCompanyParameters::setBringRelativesResaleCandidateTickets()
     * @uses Security_EsroCompanyParameters::setCanDowngradeMembershipOnRenew()
     * @uses Security_EsroCompanyParameters::setDefaultSaleMode()
     * @uses Security_EsroCompanyParameters::setDepositCategoryForAutoReimbursement()
     * @uses Security_EsroCompanyParameters::setForceRelationshipLeftRoleId()
     * @uses Security_EsroCompanyParameters::setForceRelationshipProperties()
     * @uses Security_EsroCompanyParameters::setForceRelationshipRightRoleId()
     * @uses Security_EsroCompanyParameters::setForceRelationshipTypeId()
     * @uses Security_EsroCompanyParameters::setForceStrongRelationship()
     * @uses Security_EsroCompanyParameters::setMinimalReimbursementAmount()
     * @uses Security_EsroCompanyParameters::setMuseumMode()
     * @uses Security_EsroCompanyParameters::setOboSaleMode()
     * @uses Security_EsroCompanyParameters::setOfferRoundUpDonation()
     * @uses Security_EsroCompanyParameters::setOnlineAssignTicketsToSubscription()
     * @uses Security_EsroCompanyParameters::setPriceTypeChangeAppliesPriceList()
     * @uses Security_EsroCompanyParameters::setRefundVoucherCategoryForAutoReimbursement()
     * @uses Security_EsroCompanyParameters::setReplaceSubsTicketAllowedUntil()
     * @uses Security_EsroCompanyParameters::setReservationAllowedUntil()
     * @uses Security_EsroCompanyParameters::setReservationRetrieveClientOwnTransactions()
     * @uses Security_EsroCompanyParameters::setRoundUpDonation()
     * @uses Security_EsroCompanyParameters::setRoundUpDonationFund()
     * @uses Security_EsroCompanyParameters::setSendResaleEmailNotification()
     * @uses Security_EsroCompanyParameters::setShowResalePromptOnLogin()
     * @uses Security_EsroCompanyParameters::setStoreClientBeforeCommit()
     * @uses Security_EsroCompanyParameters::setSupportReimbursementOnline()
     * @uses Security_EsroCompanyParameters::setUseSingleProductPage()
     * @param string $accountDefaultSaleMode
     * @param bool $addTransactionToMatchedCustomer
     * @param bool $allowClientsToPayByTokens
     * @param bool $allowReservation
     * @param bool $allowUpdateClientDetailsDuringCommit
     * @param bool $allowUpdateCustomerPreferredCultureIdDuringCommit
     * @param bool $allowUpdateMatchedClientDetailsDuringCommit
     * @param string $asroDefaultSaleMode
     * @param bool $bringRelativesResaleCandidateTickets
     * @param bool $canDowngradeMembershipOnRenew
     * @param string $defaultSaleMode
     * @param string $depositCategoryForAutoReimbursement
     * @param string $forceRelationshipLeftRoleId
     * @param bool $forceRelationshipProperties
     * @param string $forceRelationshipRightRoleId
     * @param string $forceRelationshipTypeId
     * @param bool $forceStrongRelationship
     * @param \patest\StructType\Money $minimalReimbursementAmount
     * @param bool $museumMode
     * @param string $oboSaleMode
     * @param bool $offerRoundUpDonation
     * @param bool $onlineAssignTicketsToSubscription
     * @param string $priceTypeChangeAppliesPriceList
     * @param string $refundVoucherCategoryForAutoReimbursement
     * @param string $replaceSubsTicketAllowedUntil
     * @param string $reservationAllowedUntil
     * @param bool $reservationRetrieveClientOwnTransactions
     * @param string $roundUpDonation
     * @param string $roundUpDonationFund
     * @param bool $sendResaleEmailNotification
     * @param bool $showResalePromptOnLogin
     * @param bool $storeClientBeforeCommit
     * @param bool $supportReimbursementOnline
     * @param bool $useSingleProductPage
     */
    public function __construct($accountDefaultSaleMode = null, $addTransactionToMatchedCustomer = null, $allowClientsToPayByTokens = null, $allowReservation = null, $allowUpdateClientDetailsDuringCommit = null, $allowUpdateCustomerPreferredCultureIdDuringCommit = null, $allowUpdateMatchedClientDetailsDuringCommit = null, $asroDefaultSaleMode = null, $bringRelativesResaleCandidateTickets = null, $canDowngradeMembershipOnRenew = null, $defaultSaleMode = null, $depositCategoryForAutoReimbursement = null, $forceRelationshipLeftRoleId = null, $forceRelationshipProperties = null, $forceRelationshipRightRoleId = null, $forceRelationshipTypeId = null, $forceStrongRelationship = null, \patest\StructType\Money $minimalReimbursementAmount = null, $museumMode = null, $oboSaleMode = null, $offerRoundUpDonation = null, $onlineAssignTicketsToSubscription = null, $priceTypeChangeAppliesPriceList = null, $refundVoucherCategoryForAutoReimbursement = null, $replaceSubsTicketAllowedUntil = null, $reservationAllowedUntil = null, $reservationRetrieveClientOwnTransactions = null, $roundUpDonation = null, $roundUpDonationFund = null, $sendResaleEmailNotification = null, $showResalePromptOnLogin = null, $storeClientBeforeCommit = null, $supportReimbursementOnline = null, $useSingleProductPage = null)
    {
        $this
            ->setAccountDefaultSaleMode($accountDefaultSaleMode)
            ->setAddTransactionToMatchedCustomer($addTransactionToMatchedCustomer)
            ->setAllowClientsToPayByTokens($allowClientsToPayByTokens)
            ->setAllowReservation($allowReservation)
            ->setAllowUpdateClientDetailsDuringCommit($allowUpdateClientDetailsDuringCommit)
            ->setAllowUpdateCustomerPreferredCultureIdDuringCommit($allowUpdateCustomerPreferredCultureIdDuringCommit)
            ->setAllowUpdateMatchedClientDetailsDuringCommit($allowUpdateMatchedClientDetailsDuringCommit)
            ->setAsroDefaultSaleMode($asroDefaultSaleMode)
            ->setBringRelativesResaleCandidateTickets($bringRelativesResaleCandidateTickets)
            ->setCanDowngradeMembershipOnRenew($canDowngradeMembershipOnRenew)
            ->setDefaultSaleMode($defaultSaleMode)
            ->setDepositCategoryForAutoReimbursement($depositCategoryForAutoReimbursement)
            ->setForceRelationshipLeftRoleId($forceRelationshipLeftRoleId)
            ->setForceRelationshipProperties($forceRelationshipProperties)
            ->setForceRelationshipRightRoleId($forceRelationshipRightRoleId)
            ->setForceRelationshipTypeId($forceRelationshipTypeId)
            ->setForceStrongRelationship($forceStrongRelationship)
            ->setMinimalReimbursementAmount($minimalReimbursementAmount)
            ->setMuseumMode($museumMode)
            ->setOboSaleMode($oboSaleMode)
            ->setOfferRoundUpDonation($offerRoundUpDonation)
            ->setOnlineAssignTicketsToSubscription($onlineAssignTicketsToSubscription)
            ->setPriceTypeChangeAppliesPriceList($priceTypeChangeAppliesPriceList)
            ->setRefundVoucherCategoryForAutoReimbursement($refundVoucherCategoryForAutoReimbursement)
            ->setReplaceSubsTicketAllowedUntil($replaceSubsTicketAllowedUntil)
            ->setReservationAllowedUntil($reservationAllowedUntil)
            ->setReservationRetrieveClientOwnTransactions($reservationRetrieveClientOwnTransactions)
            ->setRoundUpDonation($roundUpDonation)
            ->setRoundUpDonationFund($roundUpDonationFund)
            ->setSendResaleEmailNotification($sendResaleEmailNotification)
            ->setShowResalePromptOnLogin($showResalePromptOnLogin)
            ->setStoreClientBeforeCommit($storeClientBeforeCommit)
            ->setSupportReimbursementOnline($supportReimbursementOnline)
            ->setUseSingleProductPage($useSingleProductPage);
    }
    /**
     * Get AccountDefaultSaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountDefaultSaleMode()
    {
        return isset($this->AccountDefaultSaleMode) ? $this->AccountDefaultSaleMode : null;
    }
    /**
     * Set AccountDefaultSaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountDefaultSaleMode
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setAccountDefaultSaleMode($accountDefaultSaleMode = null)
    {
        // validation for constraint: string
        if (!is_null($accountDefaultSaleMode) && !is_string($accountDefaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountDefaultSaleMode, true), gettype($accountDefaultSaleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountDefaultSaleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountDefaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountDefaultSaleMode, true)), __LINE__);
        }
        if (is_null($accountDefaultSaleMode) || (is_array($accountDefaultSaleMode) && empty($accountDefaultSaleMode))) {
            unset($this->AccountDefaultSaleMode);
        } else {
            $this->AccountDefaultSaleMode = $accountDefaultSaleMode;
        }
        return $this;
    }
    /**
     * Get AddTransactionToMatchedCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAddTransactionToMatchedCustomer()
    {
        return isset($this->AddTransactionToMatchedCustomer) ? $this->AddTransactionToMatchedCustomer : null;
    }
    /**
     * Set AddTransactionToMatchedCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $addTransactionToMatchedCustomer
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setAddTransactionToMatchedCustomer($addTransactionToMatchedCustomer = null)
    {
        // validation for constraint: boolean
        if (!is_null($addTransactionToMatchedCustomer) && !is_bool($addTransactionToMatchedCustomer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addTransactionToMatchedCustomer, true), gettype($addTransactionToMatchedCustomer)), __LINE__);
        }
        if (is_null($addTransactionToMatchedCustomer) || (is_array($addTransactionToMatchedCustomer) && empty($addTransactionToMatchedCustomer))) {
            unset($this->AddTransactionToMatchedCustomer);
        } else {
            $this->AddTransactionToMatchedCustomer = $addTransactionToMatchedCustomer;
        }
        return $this;
    }
    /**
     * Get AllowClientsToPayByTokens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowClientsToPayByTokens()
    {
        return isset($this->AllowClientsToPayByTokens) ? $this->AllowClientsToPayByTokens : null;
    }
    /**
     * Set AllowClientsToPayByTokens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowClientsToPayByTokens
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setAllowClientsToPayByTokens($allowClientsToPayByTokens = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowClientsToPayByTokens) && !is_bool($allowClientsToPayByTokens)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowClientsToPayByTokens, true), gettype($allowClientsToPayByTokens)), __LINE__);
        }
        if (is_null($allowClientsToPayByTokens) || (is_array($allowClientsToPayByTokens) && empty($allowClientsToPayByTokens))) {
            unset($this->AllowClientsToPayByTokens);
        } else {
            $this->AllowClientsToPayByTokens = $allowClientsToPayByTokens;
        }
        return $this;
    }
    /**
     * Get AllowReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowReservation()
    {
        return isset($this->AllowReservation) ? $this->AllowReservation : null;
    }
    /**
     * Set AllowReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowReservation
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setAllowReservation($allowReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowReservation) && !is_bool($allowReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowReservation, true), gettype($allowReservation)), __LINE__);
        }
        if (is_null($allowReservation) || (is_array($allowReservation) && empty($allowReservation))) {
            unset($this->AllowReservation);
        } else {
            $this->AllowReservation = $allowReservation;
        }
        return $this;
    }
    /**
     * Get AllowUpdateClientDetailsDuringCommit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowUpdateClientDetailsDuringCommit()
    {
        return isset($this->AllowUpdateClientDetailsDuringCommit) ? $this->AllowUpdateClientDetailsDuringCommit : null;
    }
    /**
     * Set AllowUpdateClientDetailsDuringCommit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowUpdateClientDetailsDuringCommit
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setAllowUpdateClientDetailsDuringCommit($allowUpdateClientDetailsDuringCommit = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowUpdateClientDetailsDuringCommit) && !is_bool($allowUpdateClientDetailsDuringCommit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowUpdateClientDetailsDuringCommit, true), gettype($allowUpdateClientDetailsDuringCommit)), __LINE__);
        }
        if (is_null($allowUpdateClientDetailsDuringCommit) || (is_array($allowUpdateClientDetailsDuringCommit) && empty($allowUpdateClientDetailsDuringCommit))) {
            unset($this->AllowUpdateClientDetailsDuringCommit);
        } else {
            $this->AllowUpdateClientDetailsDuringCommit = $allowUpdateClientDetailsDuringCommit;
        }
        return $this;
    }
    /**
     * Get AllowUpdateCustomerPreferredCultureIdDuringCommit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowUpdateCustomerPreferredCultureIdDuringCommit()
    {
        return isset($this->AllowUpdateCustomerPreferredCultureIdDuringCommit) ? $this->AllowUpdateCustomerPreferredCultureIdDuringCommit : null;
    }
    /**
     * Set AllowUpdateCustomerPreferredCultureIdDuringCommit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowUpdateCustomerPreferredCultureIdDuringCommit
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setAllowUpdateCustomerPreferredCultureIdDuringCommit($allowUpdateCustomerPreferredCultureIdDuringCommit = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowUpdateCustomerPreferredCultureIdDuringCommit) && !is_bool($allowUpdateCustomerPreferredCultureIdDuringCommit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowUpdateCustomerPreferredCultureIdDuringCommit, true), gettype($allowUpdateCustomerPreferredCultureIdDuringCommit)), __LINE__);
        }
        if (is_null($allowUpdateCustomerPreferredCultureIdDuringCommit) || (is_array($allowUpdateCustomerPreferredCultureIdDuringCommit) && empty($allowUpdateCustomerPreferredCultureIdDuringCommit))) {
            unset($this->AllowUpdateCustomerPreferredCultureIdDuringCommit);
        } else {
            $this->AllowUpdateCustomerPreferredCultureIdDuringCommit = $allowUpdateCustomerPreferredCultureIdDuringCommit;
        }
        return $this;
    }
    /**
     * Get AllowUpdateMatchedClientDetailsDuringCommit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowUpdateMatchedClientDetailsDuringCommit()
    {
        return isset($this->AllowUpdateMatchedClientDetailsDuringCommit) ? $this->AllowUpdateMatchedClientDetailsDuringCommit : null;
    }
    /**
     * Set AllowUpdateMatchedClientDetailsDuringCommit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowUpdateMatchedClientDetailsDuringCommit
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setAllowUpdateMatchedClientDetailsDuringCommit($allowUpdateMatchedClientDetailsDuringCommit = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowUpdateMatchedClientDetailsDuringCommit) && !is_bool($allowUpdateMatchedClientDetailsDuringCommit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowUpdateMatchedClientDetailsDuringCommit, true), gettype($allowUpdateMatchedClientDetailsDuringCommit)), __LINE__);
        }
        if (is_null($allowUpdateMatchedClientDetailsDuringCommit) || (is_array($allowUpdateMatchedClientDetailsDuringCommit) && empty($allowUpdateMatchedClientDetailsDuringCommit))) {
            unset($this->AllowUpdateMatchedClientDetailsDuringCommit);
        } else {
            $this->AllowUpdateMatchedClientDetailsDuringCommit = $allowUpdateMatchedClientDetailsDuringCommit;
        }
        return $this;
    }
    /**
     * Get AsroDefaultSaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAsroDefaultSaleMode()
    {
        return isset($this->AsroDefaultSaleMode) ? $this->AsroDefaultSaleMode : null;
    }
    /**
     * Set AsroDefaultSaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $asroDefaultSaleMode
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setAsroDefaultSaleMode($asroDefaultSaleMode = null)
    {
        // validation for constraint: string
        if (!is_null($asroDefaultSaleMode) && !is_string($asroDefaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asroDefaultSaleMode, true), gettype($asroDefaultSaleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($asroDefaultSaleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $asroDefaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($asroDefaultSaleMode, true)), __LINE__);
        }
        if (is_null($asroDefaultSaleMode) || (is_array($asroDefaultSaleMode) && empty($asroDefaultSaleMode))) {
            unset($this->AsroDefaultSaleMode);
        } else {
            $this->AsroDefaultSaleMode = $asroDefaultSaleMode;
        }
        return $this;
    }
    /**
     * Get BringRelativesResaleCandidateTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBringRelativesResaleCandidateTickets()
    {
        return isset($this->BringRelativesResaleCandidateTickets) ? $this->BringRelativesResaleCandidateTickets : null;
    }
    /**
     * Set BringRelativesResaleCandidateTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bringRelativesResaleCandidateTickets
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setBringRelativesResaleCandidateTickets($bringRelativesResaleCandidateTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($bringRelativesResaleCandidateTickets) && !is_bool($bringRelativesResaleCandidateTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bringRelativesResaleCandidateTickets, true), gettype($bringRelativesResaleCandidateTickets)), __LINE__);
        }
        if (is_null($bringRelativesResaleCandidateTickets) || (is_array($bringRelativesResaleCandidateTickets) && empty($bringRelativesResaleCandidateTickets))) {
            unset($this->BringRelativesResaleCandidateTickets);
        } else {
            $this->BringRelativesResaleCandidateTickets = $bringRelativesResaleCandidateTickets;
        }
        return $this;
    }
    /**
     * Get CanDowngradeMembershipOnRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanDowngradeMembershipOnRenew()
    {
        return isset($this->CanDowngradeMembershipOnRenew) ? $this->CanDowngradeMembershipOnRenew : null;
    }
    /**
     * Set CanDowngradeMembershipOnRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canDowngradeMembershipOnRenew
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setCanDowngradeMembershipOnRenew($canDowngradeMembershipOnRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($canDowngradeMembershipOnRenew) && !is_bool($canDowngradeMembershipOnRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canDowngradeMembershipOnRenew, true), gettype($canDowngradeMembershipOnRenew)), __LINE__);
        }
        if (is_null($canDowngradeMembershipOnRenew) || (is_array($canDowngradeMembershipOnRenew) && empty($canDowngradeMembershipOnRenew))) {
            unset($this->CanDowngradeMembershipOnRenew);
        } else {
            $this->CanDowngradeMembershipOnRenew = $canDowngradeMembershipOnRenew;
        }
        return $this;
    }
    /**
     * Get DefaultSaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSaleMode()
    {
        return isset($this->DefaultSaleMode) ? $this->DefaultSaleMode : null;
    }
    /**
     * Set DefaultSaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSaleMode
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setDefaultSaleMode($defaultSaleMode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSaleMode) && !is_string($defaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSaleMode, true), gettype($defaultSaleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSaleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSaleMode, true)), __LINE__);
        }
        if (is_null($defaultSaleMode) || (is_array($defaultSaleMode) && empty($defaultSaleMode))) {
            unset($this->DefaultSaleMode);
        } else {
            $this->DefaultSaleMode = $defaultSaleMode;
        }
        return $this;
    }
    /**
     * Get DepositCategoryForAutoReimbursement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryForAutoReimbursement()
    {
        return isset($this->DepositCategoryForAutoReimbursement) ? $this->DepositCategoryForAutoReimbursement : null;
    }
    /**
     * Set DepositCategoryForAutoReimbursement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryForAutoReimbursement
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setDepositCategoryForAutoReimbursement($depositCategoryForAutoReimbursement = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryForAutoReimbursement) && !is_string($depositCategoryForAutoReimbursement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryForAutoReimbursement, true), gettype($depositCategoryForAutoReimbursement)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryForAutoReimbursement) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryForAutoReimbursement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryForAutoReimbursement, true)), __LINE__);
        }
        if (is_null($depositCategoryForAutoReimbursement) || (is_array($depositCategoryForAutoReimbursement) && empty($depositCategoryForAutoReimbursement))) {
            unset($this->DepositCategoryForAutoReimbursement);
        } else {
            $this->DepositCategoryForAutoReimbursement = $depositCategoryForAutoReimbursement;
        }
        return $this;
    }
    /**
     * Get ForceRelationshipLeftRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForceRelationshipLeftRoleId()
    {
        return isset($this->ForceRelationshipLeftRoleId) ? $this->ForceRelationshipLeftRoleId : null;
    }
    /**
     * Set ForceRelationshipLeftRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forceRelationshipLeftRoleId
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setForceRelationshipLeftRoleId($forceRelationshipLeftRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($forceRelationshipLeftRoleId) && !is_string($forceRelationshipLeftRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forceRelationshipLeftRoleId, true), gettype($forceRelationshipLeftRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($forceRelationshipLeftRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $forceRelationshipLeftRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($forceRelationshipLeftRoleId, true)), __LINE__);
        }
        if (is_null($forceRelationshipLeftRoleId) || (is_array($forceRelationshipLeftRoleId) && empty($forceRelationshipLeftRoleId))) {
            unset($this->ForceRelationshipLeftRoleId);
        } else {
            $this->ForceRelationshipLeftRoleId = $forceRelationshipLeftRoleId;
        }
        return $this;
    }
    /**
     * Get ForceRelationshipProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceRelationshipProperties()
    {
        return isset($this->ForceRelationshipProperties) ? $this->ForceRelationshipProperties : null;
    }
    /**
     * Set ForceRelationshipProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceRelationshipProperties
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setForceRelationshipProperties($forceRelationshipProperties = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceRelationshipProperties) && !is_bool($forceRelationshipProperties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceRelationshipProperties, true), gettype($forceRelationshipProperties)), __LINE__);
        }
        if (is_null($forceRelationshipProperties) || (is_array($forceRelationshipProperties) && empty($forceRelationshipProperties))) {
            unset($this->ForceRelationshipProperties);
        } else {
            $this->ForceRelationshipProperties = $forceRelationshipProperties;
        }
        return $this;
    }
    /**
     * Get ForceRelationshipRightRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForceRelationshipRightRoleId()
    {
        return isset($this->ForceRelationshipRightRoleId) ? $this->ForceRelationshipRightRoleId : null;
    }
    /**
     * Set ForceRelationshipRightRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forceRelationshipRightRoleId
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setForceRelationshipRightRoleId($forceRelationshipRightRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($forceRelationshipRightRoleId) && !is_string($forceRelationshipRightRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forceRelationshipRightRoleId, true), gettype($forceRelationshipRightRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($forceRelationshipRightRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $forceRelationshipRightRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($forceRelationshipRightRoleId, true)), __LINE__);
        }
        if (is_null($forceRelationshipRightRoleId) || (is_array($forceRelationshipRightRoleId) && empty($forceRelationshipRightRoleId))) {
            unset($this->ForceRelationshipRightRoleId);
        } else {
            $this->ForceRelationshipRightRoleId = $forceRelationshipRightRoleId;
        }
        return $this;
    }
    /**
     * Get ForceRelationshipTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForceRelationshipTypeId()
    {
        return isset($this->ForceRelationshipTypeId) ? $this->ForceRelationshipTypeId : null;
    }
    /**
     * Set ForceRelationshipTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forceRelationshipTypeId
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setForceRelationshipTypeId($forceRelationshipTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($forceRelationshipTypeId) && !is_string($forceRelationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forceRelationshipTypeId, true), gettype($forceRelationshipTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($forceRelationshipTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $forceRelationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($forceRelationshipTypeId, true)), __LINE__);
        }
        if (is_null($forceRelationshipTypeId) || (is_array($forceRelationshipTypeId) && empty($forceRelationshipTypeId))) {
            unset($this->ForceRelationshipTypeId);
        } else {
            $this->ForceRelationshipTypeId = $forceRelationshipTypeId;
        }
        return $this;
    }
    /**
     * Get ForceStrongRelationship value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceStrongRelationship()
    {
        return isset($this->ForceStrongRelationship) ? $this->ForceStrongRelationship : null;
    }
    /**
     * Set ForceStrongRelationship value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceStrongRelationship
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setForceStrongRelationship($forceStrongRelationship = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceStrongRelationship) && !is_bool($forceStrongRelationship)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceStrongRelationship, true), gettype($forceStrongRelationship)), __LINE__);
        }
        if (is_null($forceStrongRelationship) || (is_array($forceStrongRelationship) && empty($forceStrongRelationship))) {
            unset($this->ForceStrongRelationship);
        } else {
            $this->ForceStrongRelationship = $forceStrongRelationship;
        }
        return $this;
    }
    /**
     * Get MinimalReimbursementAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMinimalReimbursementAmount()
    {
        return isset($this->MinimalReimbursementAmount) ? $this->MinimalReimbursementAmount : null;
    }
    /**
     * Set MinimalReimbursementAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $minimalReimbursementAmount
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setMinimalReimbursementAmount(\patest\StructType\Money $minimalReimbursementAmount = null)
    {
        if (is_null($minimalReimbursementAmount) || (is_array($minimalReimbursementAmount) && empty($minimalReimbursementAmount))) {
            unset($this->MinimalReimbursementAmount);
        } else {
            $this->MinimalReimbursementAmount = $minimalReimbursementAmount;
        }
        return $this;
    }
    /**
     * Get MuseumMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMuseumMode()
    {
        return isset($this->MuseumMode) ? $this->MuseumMode : null;
    }
    /**
     * Set MuseumMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $museumMode
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setMuseumMode($museumMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($museumMode) && !is_bool($museumMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($museumMode, true), gettype($museumMode)), __LINE__);
        }
        if (is_null($museumMode) || (is_array($museumMode) && empty($museumMode))) {
            unset($this->MuseumMode);
        } else {
            $this->MuseumMode = $museumMode;
        }
        return $this;
    }
    /**
     * Get OboSaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOboSaleMode()
    {
        return isset($this->OboSaleMode) ? $this->OboSaleMode : null;
    }
    /**
     * Set OboSaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oboSaleMode
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setOboSaleMode($oboSaleMode = null)
    {
        // validation for constraint: string
        if (!is_null($oboSaleMode) && !is_string($oboSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oboSaleMode, true), gettype($oboSaleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($oboSaleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $oboSaleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($oboSaleMode, true)), __LINE__);
        }
        if (is_null($oboSaleMode) || (is_array($oboSaleMode) && empty($oboSaleMode))) {
            unset($this->OboSaleMode);
        } else {
            $this->OboSaleMode = $oboSaleMode;
        }
        return $this;
    }
    /**
     * Get OfferRoundUpDonation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOfferRoundUpDonation()
    {
        return isset($this->OfferRoundUpDonation) ? $this->OfferRoundUpDonation : null;
    }
    /**
     * Set OfferRoundUpDonation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $offerRoundUpDonation
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setOfferRoundUpDonation($offerRoundUpDonation = null)
    {
        // validation for constraint: boolean
        if (!is_null($offerRoundUpDonation) && !is_bool($offerRoundUpDonation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($offerRoundUpDonation, true), gettype($offerRoundUpDonation)), __LINE__);
        }
        if (is_null($offerRoundUpDonation) || (is_array($offerRoundUpDonation) && empty($offerRoundUpDonation))) {
            unset($this->OfferRoundUpDonation);
        } else {
            $this->OfferRoundUpDonation = $offerRoundUpDonation;
        }
        return $this;
    }
    /**
     * Get OnlineAssignTicketsToSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOnlineAssignTicketsToSubscription()
    {
        return isset($this->OnlineAssignTicketsToSubscription) ? $this->OnlineAssignTicketsToSubscription : null;
    }
    /**
     * Set OnlineAssignTicketsToSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $onlineAssignTicketsToSubscription
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setOnlineAssignTicketsToSubscription($onlineAssignTicketsToSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlineAssignTicketsToSubscription) && !is_bool($onlineAssignTicketsToSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlineAssignTicketsToSubscription, true), gettype($onlineAssignTicketsToSubscription)), __LINE__);
        }
        if (is_null($onlineAssignTicketsToSubscription) || (is_array($onlineAssignTicketsToSubscription) && empty($onlineAssignTicketsToSubscription))) {
            unset($this->OnlineAssignTicketsToSubscription);
        } else {
            $this->OnlineAssignTicketsToSubscription = $onlineAssignTicketsToSubscription;
        }
        return $this;
    }
    /**
     * Get PriceTypeChangeAppliesPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeChangeAppliesPriceList()
    {
        return isset($this->PriceTypeChangeAppliesPriceList) ? $this->PriceTypeChangeAppliesPriceList : null;
    }
    /**
     * Set PriceTypeChangeAppliesPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ChangeSubsTicketAppliedPriceListEnum::valueIsValid()
     * @uses \patest\EnumType\ChangeSubsTicketAppliedPriceListEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceTypeChangeAppliesPriceList
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setPriceTypeChangeAppliesPriceList($priceTypeChangeAppliesPriceList = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ChangeSubsTicketAppliedPriceListEnum::valueIsValid($priceTypeChangeAppliesPriceList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ChangeSubsTicketAppliedPriceListEnum', is_array($priceTypeChangeAppliesPriceList) ? implode(', ', $priceTypeChangeAppliesPriceList) : var_export($priceTypeChangeAppliesPriceList, true), implode(', ', \patest\EnumType\ChangeSubsTicketAppliedPriceListEnum::getValidValues())), __LINE__);
        }
        if (is_null($priceTypeChangeAppliesPriceList) || (is_array($priceTypeChangeAppliesPriceList) && empty($priceTypeChangeAppliesPriceList))) {
            unset($this->PriceTypeChangeAppliesPriceList);
        } else {
            $this->PriceTypeChangeAppliesPriceList = $priceTypeChangeAppliesPriceList;
        }
        return $this;
    }
    /**
     * Get RefundVoucherCategoryForAutoReimbursement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefundVoucherCategoryForAutoReimbursement()
    {
        return isset($this->RefundVoucherCategoryForAutoReimbursement) ? $this->RefundVoucherCategoryForAutoReimbursement : null;
    }
    /**
     * Set RefundVoucherCategoryForAutoReimbursement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refundVoucherCategoryForAutoReimbursement
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setRefundVoucherCategoryForAutoReimbursement($refundVoucherCategoryForAutoReimbursement = null)
    {
        // validation for constraint: string
        if (!is_null($refundVoucherCategoryForAutoReimbursement) && !is_string($refundVoucherCategoryForAutoReimbursement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refundVoucherCategoryForAutoReimbursement, true), gettype($refundVoucherCategoryForAutoReimbursement)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($refundVoucherCategoryForAutoReimbursement) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $refundVoucherCategoryForAutoReimbursement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($refundVoucherCategoryForAutoReimbursement, true)), __LINE__);
        }
        if (is_null($refundVoucherCategoryForAutoReimbursement) || (is_array($refundVoucherCategoryForAutoReimbursement) && empty($refundVoucherCategoryForAutoReimbursement))) {
            unset($this->RefundVoucherCategoryForAutoReimbursement);
        } else {
            $this->RefundVoucherCategoryForAutoReimbursement = $refundVoucherCategoryForAutoReimbursement;
        }
        return $this;
    }
    /**
     * Get ReplaceSubsTicketAllowedUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplaceSubsTicketAllowedUntil()
    {
        return isset($this->ReplaceSubsTicketAllowedUntil) ? $this->ReplaceSubsTicketAllowedUntil : null;
    }
    /**
     * Set ReplaceSubsTicketAllowedUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $replaceSubsTicketAllowedUntil
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setReplaceSubsTicketAllowedUntil($replaceSubsTicketAllowedUntil = null)
    {
        // validation for constraint: string
        if (!is_null($replaceSubsTicketAllowedUntil) && !is_string($replaceSubsTicketAllowedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($replaceSubsTicketAllowedUntil, true), gettype($replaceSubsTicketAllowedUntil)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($replaceSubsTicketAllowedUntil) && false === mb_strpos($replaceSubsTicketAllowedUntil, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $replaceSubsTicketAllowedUntil)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($replaceSubsTicketAllowedUntil, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($replaceSubsTicketAllowedUntil) && false !== mb_strpos($replaceSubsTicketAllowedUntil, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $replaceSubsTicketAllowedUntil)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($replaceSubsTicketAllowedUntil, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($replaceSubsTicketAllowedUntil) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $replaceSubsTicketAllowedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($replaceSubsTicketAllowedUntil, true)), __LINE__);
        }
        if (is_null($replaceSubsTicketAllowedUntil) || (is_array($replaceSubsTicketAllowedUntil) && empty($replaceSubsTicketAllowedUntil))) {
            unset($this->ReplaceSubsTicketAllowedUntil);
        } else {
            $this->ReplaceSubsTicketAllowedUntil = $replaceSubsTicketAllowedUntil;
        }
        return $this;
    }
    /**
     * Get ReservationAllowedUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationAllowedUntil()
    {
        return isset($this->ReservationAllowedUntil) ? $this->ReservationAllowedUntil : null;
    }
    /**
     * Set ReservationAllowedUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationAllowedUntil
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setReservationAllowedUntil($reservationAllowedUntil = null)
    {
        // validation for constraint: string
        if (!is_null($reservationAllowedUntil) && !is_string($reservationAllowedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationAllowedUntil, true), gettype($reservationAllowedUntil)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($reservationAllowedUntil) && false === mb_strpos($reservationAllowedUntil, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $reservationAllowedUntil)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($reservationAllowedUntil, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($reservationAllowedUntil) && false !== mb_strpos($reservationAllowedUntil, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $reservationAllowedUntil)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($reservationAllowedUntil, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($reservationAllowedUntil) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $reservationAllowedUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($reservationAllowedUntil, true)), __LINE__);
        }
        if (is_null($reservationAllowedUntil) || (is_array($reservationAllowedUntil) && empty($reservationAllowedUntil))) {
            unset($this->ReservationAllowedUntil);
        } else {
            $this->ReservationAllowedUntil = $reservationAllowedUntil;
        }
        return $this;
    }
    /**
     * Get ReservationRetrieveClientOwnTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReservationRetrieveClientOwnTransactions()
    {
        return isset($this->ReservationRetrieveClientOwnTransactions) ? $this->ReservationRetrieveClientOwnTransactions : null;
    }
    /**
     * Set ReservationRetrieveClientOwnTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reservationRetrieveClientOwnTransactions
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setReservationRetrieveClientOwnTransactions($reservationRetrieveClientOwnTransactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($reservationRetrieveClientOwnTransactions) && !is_bool($reservationRetrieveClientOwnTransactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reservationRetrieveClientOwnTransactions, true), gettype($reservationRetrieveClientOwnTransactions)), __LINE__);
        }
        if (is_null($reservationRetrieveClientOwnTransactions) || (is_array($reservationRetrieveClientOwnTransactions) && empty($reservationRetrieveClientOwnTransactions))) {
            unset($this->ReservationRetrieveClientOwnTransactions);
        } else {
            $this->ReservationRetrieveClientOwnTransactions = $reservationRetrieveClientOwnTransactions;
        }
        return $this;
    }
    /**
     * Get RoundUpDonation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoundUpDonation()
    {
        return isset($this->RoundUpDonation) ? $this->RoundUpDonation : null;
    }
    /**
     * Set RoundUpDonation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roundUpDonation
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setRoundUpDonation($roundUpDonation = null)
    {
        // validation for constraint: string
        if (!is_null($roundUpDonation) && !is_string($roundUpDonation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roundUpDonation, true), gettype($roundUpDonation)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roundUpDonation) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roundUpDonation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roundUpDonation, true)), __LINE__);
        }
        if (is_null($roundUpDonation) || (is_array($roundUpDonation) && empty($roundUpDonation))) {
            unset($this->RoundUpDonation);
        } else {
            $this->RoundUpDonation = $roundUpDonation;
        }
        return $this;
    }
    /**
     * Get RoundUpDonationFund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoundUpDonationFund()
    {
        return isset($this->RoundUpDonationFund) ? $this->RoundUpDonationFund : null;
    }
    /**
     * Set RoundUpDonationFund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roundUpDonationFund
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setRoundUpDonationFund($roundUpDonationFund = null)
    {
        // validation for constraint: string
        if (!is_null($roundUpDonationFund) && !is_string($roundUpDonationFund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roundUpDonationFund, true), gettype($roundUpDonationFund)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roundUpDonationFund) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roundUpDonationFund)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roundUpDonationFund, true)), __LINE__);
        }
        if (is_null($roundUpDonationFund) || (is_array($roundUpDonationFund) && empty($roundUpDonationFund))) {
            unset($this->RoundUpDonationFund);
        } else {
            $this->RoundUpDonationFund = $roundUpDonationFund;
        }
        return $this;
    }
    /**
     * Get SendResaleEmailNotification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendResaleEmailNotification()
    {
        return isset($this->SendResaleEmailNotification) ? $this->SendResaleEmailNotification : null;
    }
    /**
     * Set SendResaleEmailNotification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendResaleEmailNotification
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setSendResaleEmailNotification($sendResaleEmailNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendResaleEmailNotification) && !is_bool($sendResaleEmailNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendResaleEmailNotification, true), gettype($sendResaleEmailNotification)), __LINE__);
        }
        if (is_null($sendResaleEmailNotification) || (is_array($sendResaleEmailNotification) && empty($sendResaleEmailNotification))) {
            unset($this->SendResaleEmailNotification);
        } else {
            $this->SendResaleEmailNotification = $sendResaleEmailNotification;
        }
        return $this;
    }
    /**
     * Get ShowResalePromptOnLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowResalePromptOnLogin()
    {
        return isset($this->ShowResalePromptOnLogin) ? $this->ShowResalePromptOnLogin : null;
    }
    /**
     * Set ShowResalePromptOnLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showResalePromptOnLogin
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setShowResalePromptOnLogin($showResalePromptOnLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($showResalePromptOnLogin) && !is_bool($showResalePromptOnLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showResalePromptOnLogin, true), gettype($showResalePromptOnLogin)), __LINE__);
        }
        if (is_null($showResalePromptOnLogin) || (is_array($showResalePromptOnLogin) && empty($showResalePromptOnLogin))) {
            unset($this->ShowResalePromptOnLogin);
        } else {
            $this->ShowResalePromptOnLogin = $showResalePromptOnLogin;
        }
        return $this;
    }
    /**
     * Get StoreClientBeforeCommit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getStoreClientBeforeCommit()
    {
        return isset($this->StoreClientBeforeCommit) ? $this->StoreClientBeforeCommit : null;
    }
    /**
     * Set StoreClientBeforeCommit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $storeClientBeforeCommit
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setStoreClientBeforeCommit($storeClientBeforeCommit = null)
    {
        // validation for constraint: boolean
        if (!is_null($storeClientBeforeCommit) && !is_bool($storeClientBeforeCommit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($storeClientBeforeCommit, true), gettype($storeClientBeforeCommit)), __LINE__);
        }
        if (is_null($storeClientBeforeCommit) || (is_array($storeClientBeforeCommit) && empty($storeClientBeforeCommit))) {
            unset($this->StoreClientBeforeCommit);
        } else {
            $this->StoreClientBeforeCommit = $storeClientBeforeCommit;
        }
        return $this;
    }
    /**
     * Get SupportReimbursementOnline value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSupportReimbursementOnline()
    {
        return isset($this->SupportReimbursementOnline) ? $this->SupportReimbursementOnline : null;
    }
    /**
     * Set SupportReimbursementOnline value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $supportReimbursementOnline
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setSupportReimbursementOnline($supportReimbursementOnline = null)
    {
        // validation for constraint: boolean
        if (!is_null($supportReimbursementOnline) && !is_bool($supportReimbursementOnline)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($supportReimbursementOnline, true), gettype($supportReimbursementOnline)), __LINE__);
        }
        if (is_null($supportReimbursementOnline) || (is_array($supportReimbursementOnline) && empty($supportReimbursementOnline))) {
            unset($this->SupportReimbursementOnline);
        } else {
            $this->SupportReimbursementOnline = $supportReimbursementOnline;
        }
        return $this;
    }
    /**
     * Get UseSingleProductPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseSingleProductPage()
    {
        return isset($this->UseSingleProductPage) ? $this->UseSingleProductPage : null;
    }
    /**
     * Set UseSingleProductPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useSingleProductPage
     * @return \patest\StructType\Security_EsroCompanyParameters
     */
    public function setUseSingleProductPage($useSingleProductPage = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSingleProductPage) && !is_bool($useSingleProductPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useSingleProductPage, true), gettype($useSingleProductPage)), __LINE__);
        }
        if (is_null($useSingleProductPage) || (is_array($useSingleProductPage) && empty($useSingleProductPage))) {
            unset($this->UseSingleProductPage);
        } else {
            $this->UseSingleProductPage = $useSingleProductPage;
        }
        return $this;
    }
}
