<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.CrossOrgUnitsDataAccessRule StructType
 * @subpackage Structs
 */
class Security_CrossOrgUnitsDataAccessRule extends VolatileEntity
{
    /**
     * The IsSalesAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSalesAllowed;
    /**
     * The IsSearchAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSearchAllowed;
    /**
     * The IsSellNonAllocatedSeatsAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSellNonAllocatedSeatsAllowed;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProductType;
    /**
     * The TargetOrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetOrganizationUnitId;
    /**
     * Constructor method for Security.CrossOrgUnitsDataAccessRule
     * @uses Security_CrossOrgUnitsDataAccessRule::setIsSalesAllowed()
     * @uses Security_CrossOrgUnitsDataAccessRule::setIsSearchAllowed()
     * @uses Security_CrossOrgUnitsDataAccessRule::setIsSellNonAllocatedSeatsAllowed()
     * @uses Security_CrossOrgUnitsDataAccessRule::setOrganizationUnitId()
     * @uses Security_CrossOrgUnitsDataAccessRule::setProductType()
     * @uses Security_CrossOrgUnitsDataAccessRule::setTargetOrganizationUnitId()
     * @param bool $isSalesAllowed
     * @param bool $isSearchAllowed
     * @param bool $isSellNonAllocatedSeatsAllowed
     * @param string $organizationUnitId
     * @param int $productType
     * @param string $targetOrganizationUnitId
     */
    public function __construct($isSalesAllowed = null, $isSearchAllowed = null, $isSellNonAllocatedSeatsAllowed = null, $organizationUnitId = null, $productType = null, $targetOrganizationUnitId = null)
    {
        $this
            ->setIsSalesAllowed($isSalesAllowed)
            ->setIsSearchAllowed($isSearchAllowed)
            ->setIsSellNonAllocatedSeatsAllowed($isSellNonAllocatedSeatsAllowed)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProductType($productType)
            ->setTargetOrganizationUnitId($targetOrganizationUnitId);
    }
    /**
     * Get IsSalesAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSalesAllowed()
    {
        return isset($this->IsSalesAllowed) ? $this->IsSalesAllowed : null;
    }
    /**
     * Set IsSalesAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSalesAllowed
     * @return \patest\StructType\Security_CrossOrgUnitsDataAccessRule
     */
    public function setIsSalesAllowed($isSalesAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesAllowed) && !is_bool($isSalesAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesAllowed, true), gettype($isSalesAllowed)), __LINE__);
        }
        if (is_null($isSalesAllowed) || (is_array($isSalesAllowed) && empty($isSalesAllowed))) {
            unset($this->IsSalesAllowed);
        } else {
            $this->IsSalesAllowed = $isSalesAllowed;
        }
        return $this;
    }
    /**
     * Get IsSearchAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSearchAllowed()
    {
        return isset($this->IsSearchAllowed) ? $this->IsSearchAllowed : null;
    }
    /**
     * Set IsSearchAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSearchAllowed
     * @return \patest\StructType\Security_CrossOrgUnitsDataAccessRule
     */
    public function setIsSearchAllowed($isSearchAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSearchAllowed) && !is_bool($isSearchAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSearchAllowed, true), gettype($isSearchAllowed)), __LINE__);
        }
        if (is_null($isSearchAllowed) || (is_array($isSearchAllowed) && empty($isSearchAllowed))) {
            unset($this->IsSearchAllowed);
        } else {
            $this->IsSearchAllowed = $isSearchAllowed;
        }
        return $this;
    }
    /**
     * Get IsSellNonAllocatedSeatsAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSellNonAllocatedSeatsAllowed()
    {
        return isset($this->IsSellNonAllocatedSeatsAllowed) ? $this->IsSellNonAllocatedSeatsAllowed : null;
    }
    /**
     * Set IsSellNonAllocatedSeatsAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSellNonAllocatedSeatsAllowed
     * @return \patest\StructType\Security_CrossOrgUnitsDataAccessRule
     */
    public function setIsSellNonAllocatedSeatsAllowed($isSellNonAllocatedSeatsAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSellNonAllocatedSeatsAllowed) && !is_bool($isSellNonAllocatedSeatsAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSellNonAllocatedSeatsAllowed, true), gettype($isSellNonAllocatedSeatsAllowed)), __LINE__);
        }
        if (is_null($isSellNonAllocatedSeatsAllowed) || (is_array($isSellNonAllocatedSeatsAllowed) && empty($isSellNonAllocatedSeatsAllowed))) {
            unset($this->IsSellNonAllocatedSeatsAllowed);
        } else {
            $this->IsSellNonAllocatedSeatsAllowed = $isSellNonAllocatedSeatsAllowed;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Security_CrossOrgUnitsDataAccessRule
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProductType()
    {
        return isset($this->ProductType) ? $this->ProductType : null;
    }
    /**
     * Set ProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $productType
     * @return \patest\StructType\Security_CrossOrgUnitsDataAccessRule
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: int
        if (!is_null($productType) && !(is_int($productType) || ctype_digit($productType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        if (is_null($productType) || (is_array($productType) && empty($productType))) {
            unset($this->ProductType);
        } else {
            $this->ProductType = $productType;
        }
        return $this;
    }
    /**
     * Get TargetOrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetOrganizationUnitId()
    {
        return isset($this->TargetOrganizationUnitId) ? $this->TargetOrganizationUnitId : null;
    }
    /**
     * Set TargetOrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetOrganizationUnitId
     * @return \patest\StructType\Security_CrossOrgUnitsDataAccessRule
     */
    public function setTargetOrganizationUnitId($targetOrganizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($targetOrganizationUnitId) && !is_string($targetOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetOrganizationUnitId, true), gettype($targetOrganizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetOrganizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetOrganizationUnitId, true)), __LINE__);
        }
        if (is_null($targetOrganizationUnitId) || (is_array($targetOrganizationUnitId) && empty($targetOrganizationUnitId))) {
            unset($this->TargetOrganizationUnitId);
        } else {
            $this->TargetOrganizationUnitId = $targetOrganizationUnitId;
        }
        return $this;
    }
}
