<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.CommunicationCompanyParameters StructType
 * @subpackage Structs
 */
class Security_CommunicationCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The CommunicationProfileForBankFileProcessingProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationProfileForBankFileProcessingProcess;
    /**
     * The CommunicationProfileForBarcodeImportProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationProfileForBarcodeImportProcess;
    /**
     * The CommunicationProfileForClientPasswordNotificationProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationProfileForClientPasswordNotificationProcess;
    /**
     * The CommunicationProfileForGroupSalesProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationProfileForGroupSalesProcess;
    /**
     * The CommunicationProfileForMarketingProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationProfileForMarketingProcess;
    /**
     * The CommunicationProfileForPrinterErrorProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationProfileForPrinterErrorProcess;
    /**
     * The CommunicationProfileForPrintingProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationProfileForPrintingProcess;
    /**
     * The CommunicationProfileForReportSendingProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CommunicationProfileForReportSendingProcess;
    /**
     * Constructor method for Security.CommunicationCompanyParameters
     * @uses Security_CommunicationCompanyParameters::setCommunicationProfileForBankFileProcessingProcess()
     * @uses Security_CommunicationCompanyParameters::setCommunicationProfileForBarcodeImportProcess()
     * @uses Security_CommunicationCompanyParameters::setCommunicationProfileForClientPasswordNotificationProcess()
     * @uses Security_CommunicationCompanyParameters::setCommunicationProfileForGroupSalesProcess()
     * @uses Security_CommunicationCompanyParameters::setCommunicationProfileForMarketingProcess()
     * @uses Security_CommunicationCompanyParameters::setCommunicationProfileForPrinterErrorProcess()
     * @uses Security_CommunicationCompanyParameters::setCommunicationProfileForPrintingProcess()
     * @uses Security_CommunicationCompanyParameters::setCommunicationProfileForReportSendingProcess()
     * @param string $communicationProfileForBankFileProcessingProcess
     * @param string $communicationProfileForBarcodeImportProcess
     * @param string $communicationProfileForClientPasswordNotificationProcess
     * @param string $communicationProfileForGroupSalesProcess
     * @param string $communicationProfileForMarketingProcess
     * @param string $communicationProfileForPrinterErrorProcess
     * @param string $communicationProfileForPrintingProcess
     * @param string $communicationProfileForReportSendingProcess
     */
    public function __construct($communicationProfileForBankFileProcessingProcess = null, $communicationProfileForBarcodeImportProcess = null, $communicationProfileForClientPasswordNotificationProcess = null, $communicationProfileForGroupSalesProcess = null, $communicationProfileForMarketingProcess = null, $communicationProfileForPrinterErrorProcess = null, $communicationProfileForPrintingProcess = null, $communicationProfileForReportSendingProcess = null)
    {
        $this
            ->setCommunicationProfileForBankFileProcessingProcess($communicationProfileForBankFileProcessingProcess)
            ->setCommunicationProfileForBarcodeImportProcess($communicationProfileForBarcodeImportProcess)
            ->setCommunicationProfileForClientPasswordNotificationProcess($communicationProfileForClientPasswordNotificationProcess)
            ->setCommunicationProfileForGroupSalesProcess($communicationProfileForGroupSalesProcess)
            ->setCommunicationProfileForMarketingProcess($communicationProfileForMarketingProcess)
            ->setCommunicationProfileForPrinterErrorProcess($communicationProfileForPrinterErrorProcess)
            ->setCommunicationProfileForPrintingProcess($communicationProfileForPrintingProcess)
            ->setCommunicationProfileForReportSendingProcess($communicationProfileForReportSendingProcess);
    }
    /**
     * Get CommunicationProfileForBankFileProcessingProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationProfileForBankFileProcessingProcess()
    {
        return isset($this->CommunicationProfileForBankFileProcessingProcess) ? $this->CommunicationProfileForBankFileProcessingProcess : null;
    }
    /**
     * Set CommunicationProfileForBankFileProcessingProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationProfileForBankFileProcessingProcess
     * @return \patest\StructType\Security_CommunicationCompanyParameters
     */
    public function setCommunicationProfileForBankFileProcessingProcess($communicationProfileForBankFileProcessingProcess = null)
    {
        // validation for constraint: string
        if (!is_null($communicationProfileForBankFileProcessingProcess) && !is_string($communicationProfileForBankFileProcessingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationProfileForBankFileProcessingProcess, true), gettype($communicationProfileForBankFileProcessingProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationProfileForBankFileProcessingProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationProfileForBankFileProcessingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationProfileForBankFileProcessingProcess, true)), __LINE__);
        }
        if (is_null($communicationProfileForBankFileProcessingProcess) || (is_array($communicationProfileForBankFileProcessingProcess) && empty($communicationProfileForBankFileProcessingProcess))) {
            unset($this->CommunicationProfileForBankFileProcessingProcess);
        } else {
            $this->CommunicationProfileForBankFileProcessingProcess = $communicationProfileForBankFileProcessingProcess;
        }
        return $this;
    }
    /**
     * Get CommunicationProfileForBarcodeImportProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationProfileForBarcodeImportProcess()
    {
        return isset($this->CommunicationProfileForBarcodeImportProcess) ? $this->CommunicationProfileForBarcodeImportProcess : null;
    }
    /**
     * Set CommunicationProfileForBarcodeImportProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationProfileForBarcodeImportProcess
     * @return \patest\StructType\Security_CommunicationCompanyParameters
     */
    public function setCommunicationProfileForBarcodeImportProcess($communicationProfileForBarcodeImportProcess = null)
    {
        // validation for constraint: string
        if (!is_null($communicationProfileForBarcodeImportProcess) && !is_string($communicationProfileForBarcodeImportProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationProfileForBarcodeImportProcess, true), gettype($communicationProfileForBarcodeImportProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationProfileForBarcodeImportProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationProfileForBarcodeImportProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationProfileForBarcodeImportProcess, true)), __LINE__);
        }
        if (is_null($communicationProfileForBarcodeImportProcess) || (is_array($communicationProfileForBarcodeImportProcess) && empty($communicationProfileForBarcodeImportProcess))) {
            unset($this->CommunicationProfileForBarcodeImportProcess);
        } else {
            $this->CommunicationProfileForBarcodeImportProcess = $communicationProfileForBarcodeImportProcess;
        }
        return $this;
    }
    /**
     * Get CommunicationProfileForClientPasswordNotificationProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationProfileForClientPasswordNotificationProcess()
    {
        return isset($this->CommunicationProfileForClientPasswordNotificationProcess) ? $this->CommunicationProfileForClientPasswordNotificationProcess : null;
    }
    /**
     * Set CommunicationProfileForClientPasswordNotificationProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationProfileForClientPasswordNotificationProcess
     * @return \patest\StructType\Security_CommunicationCompanyParameters
     */
    public function setCommunicationProfileForClientPasswordNotificationProcess($communicationProfileForClientPasswordNotificationProcess = null)
    {
        // validation for constraint: string
        if (!is_null($communicationProfileForClientPasswordNotificationProcess) && !is_string($communicationProfileForClientPasswordNotificationProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationProfileForClientPasswordNotificationProcess, true), gettype($communicationProfileForClientPasswordNotificationProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationProfileForClientPasswordNotificationProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationProfileForClientPasswordNotificationProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationProfileForClientPasswordNotificationProcess, true)), __LINE__);
        }
        if (is_null($communicationProfileForClientPasswordNotificationProcess) || (is_array($communicationProfileForClientPasswordNotificationProcess) && empty($communicationProfileForClientPasswordNotificationProcess))) {
            unset($this->CommunicationProfileForClientPasswordNotificationProcess);
        } else {
            $this->CommunicationProfileForClientPasswordNotificationProcess = $communicationProfileForClientPasswordNotificationProcess;
        }
        return $this;
    }
    /**
     * Get CommunicationProfileForGroupSalesProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationProfileForGroupSalesProcess()
    {
        return isset($this->CommunicationProfileForGroupSalesProcess) ? $this->CommunicationProfileForGroupSalesProcess : null;
    }
    /**
     * Set CommunicationProfileForGroupSalesProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationProfileForGroupSalesProcess
     * @return \patest\StructType\Security_CommunicationCompanyParameters
     */
    public function setCommunicationProfileForGroupSalesProcess($communicationProfileForGroupSalesProcess = null)
    {
        // validation for constraint: string
        if (!is_null($communicationProfileForGroupSalesProcess) && !is_string($communicationProfileForGroupSalesProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationProfileForGroupSalesProcess, true), gettype($communicationProfileForGroupSalesProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationProfileForGroupSalesProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationProfileForGroupSalesProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationProfileForGroupSalesProcess, true)), __LINE__);
        }
        if (is_null($communicationProfileForGroupSalesProcess) || (is_array($communicationProfileForGroupSalesProcess) && empty($communicationProfileForGroupSalesProcess))) {
            unset($this->CommunicationProfileForGroupSalesProcess);
        } else {
            $this->CommunicationProfileForGroupSalesProcess = $communicationProfileForGroupSalesProcess;
        }
        return $this;
    }
    /**
     * Get CommunicationProfileForMarketingProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationProfileForMarketingProcess()
    {
        return isset($this->CommunicationProfileForMarketingProcess) ? $this->CommunicationProfileForMarketingProcess : null;
    }
    /**
     * Set CommunicationProfileForMarketingProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationProfileForMarketingProcess
     * @return \patest\StructType\Security_CommunicationCompanyParameters
     */
    public function setCommunicationProfileForMarketingProcess($communicationProfileForMarketingProcess = null)
    {
        // validation for constraint: string
        if (!is_null($communicationProfileForMarketingProcess) && !is_string($communicationProfileForMarketingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationProfileForMarketingProcess, true), gettype($communicationProfileForMarketingProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationProfileForMarketingProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationProfileForMarketingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationProfileForMarketingProcess, true)), __LINE__);
        }
        if (is_null($communicationProfileForMarketingProcess) || (is_array($communicationProfileForMarketingProcess) && empty($communicationProfileForMarketingProcess))) {
            unset($this->CommunicationProfileForMarketingProcess);
        } else {
            $this->CommunicationProfileForMarketingProcess = $communicationProfileForMarketingProcess;
        }
        return $this;
    }
    /**
     * Get CommunicationProfileForPrinterErrorProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationProfileForPrinterErrorProcess()
    {
        return isset($this->CommunicationProfileForPrinterErrorProcess) ? $this->CommunicationProfileForPrinterErrorProcess : null;
    }
    /**
     * Set CommunicationProfileForPrinterErrorProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationProfileForPrinterErrorProcess
     * @return \patest\StructType\Security_CommunicationCompanyParameters
     */
    public function setCommunicationProfileForPrinterErrorProcess($communicationProfileForPrinterErrorProcess = null)
    {
        // validation for constraint: string
        if (!is_null($communicationProfileForPrinterErrorProcess) && !is_string($communicationProfileForPrinterErrorProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationProfileForPrinterErrorProcess, true), gettype($communicationProfileForPrinterErrorProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationProfileForPrinterErrorProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationProfileForPrinterErrorProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationProfileForPrinterErrorProcess, true)), __LINE__);
        }
        if (is_null($communicationProfileForPrinterErrorProcess) || (is_array($communicationProfileForPrinterErrorProcess) && empty($communicationProfileForPrinterErrorProcess))) {
            unset($this->CommunicationProfileForPrinterErrorProcess);
        } else {
            $this->CommunicationProfileForPrinterErrorProcess = $communicationProfileForPrinterErrorProcess;
        }
        return $this;
    }
    /**
     * Get CommunicationProfileForPrintingProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationProfileForPrintingProcess()
    {
        return isset($this->CommunicationProfileForPrintingProcess) ? $this->CommunicationProfileForPrintingProcess : null;
    }
    /**
     * Set CommunicationProfileForPrintingProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationProfileForPrintingProcess
     * @return \patest\StructType\Security_CommunicationCompanyParameters
     */
    public function setCommunicationProfileForPrintingProcess($communicationProfileForPrintingProcess = null)
    {
        // validation for constraint: string
        if (!is_null($communicationProfileForPrintingProcess) && !is_string($communicationProfileForPrintingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationProfileForPrintingProcess, true), gettype($communicationProfileForPrintingProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationProfileForPrintingProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationProfileForPrintingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationProfileForPrintingProcess, true)), __LINE__);
        }
        if (is_null($communicationProfileForPrintingProcess) || (is_array($communicationProfileForPrintingProcess) && empty($communicationProfileForPrintingProcess))) {
            unset($this->CommunicationProfileForPrintingProcess);
        } else {
            $this->CommunicationProfileForPrintingProcess = $communicationProfileForPrintingProcess;
        }
        return $this;
    }
    /**
     * Get CommunicationProfileForReportSendingProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommunicationProfileForReportSendingProcess()
    {
        return isset($this->CommunicationProfileForReportSendingProcess) ? $this->CommunicationProfileForReportSendingProcess : null;
    }
    /**
     * Set CommunicationProfileForReportSendingProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $communicationProfileForReportSendingProcess
     * @return \patest\StructType\Security_CommunicationCompanyParameters
     */
    public function setCommunicationProfileForReportSendingProcess($communicationProfileForReportSendingProcess = null)
    {
        // validation for constraint: string
        if (!is_null($communicationProfileForReportSendingProcess) && !is_string($communicationProfileForReportSendingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communicationProfileForReportSendingProcess, true), gettype($communicationProfileForReportSendingProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($communicationProfileForReportSendingProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $communicationProfileForReportSendingProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($communicationProfileForReportSendingProcess, true)), __LINE__);
        }
        if (is_null($communicationProfileForReportSendingProcess) || (is_array($communicationProfileForReportSendingProcess) && empty($communicationProfileForReportSendingProcess))) {
            unset($this->CommunicationProfileForReportSendingProcess);
        } else {
            $this->CommunicationProfileForReportSendingProcess = $communicationProfileForReportSendingProcess;
        }
        return $this;
    }
}
