<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.ApprovalRequest StructType
 * @subpackage Structs
 */
class Security_ApprovalRequest extends PersistableEntity
{
    /**
     * The AdminUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AdminUserId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comment;
    /**
     * The ExecutionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionStatus;
    /**
     * The ExecutionStatusEx
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionStatusEx;
    /**
     * The HandleDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandleDate;
    /**
     * The HandledByName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HandledByName;
    /**
     * The Info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Info;
    /**
     * The OperationForApproval
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $OperationForApproval;
    /**
     * The RequestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDate;
    /**
     * The RequestingUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestingUserId;
    /**
     * The RequestingUserName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestingUserName;
    /**
     * The SiteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SiteId;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SiteName;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Tag
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Tag;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Security.ApprovalRequest
     * @uses Security_ApprovalRequest::setAdminUserId()
     * @uses Security_ApprovalRequest::setClientId()
     * @uses Security_ApprovalRequest::setClientName()
     * @uses Security_ApprovalRequest::setComment()
     * @uses Security_ApprovalRequest::setExecutionStatus()
     * @uses Security_ApprovalRequest::setExecutionStatusEx()
     * @uses Security_ApprovalRequest::setHandleDate()
     * @uses Security_ApprovalRequest::setHandledByName()
     * @uses Security_ApprovalRequest::setInfo()
     * @uses Security_ApprovalRequest::setOperationForApproval()
     * @uses Security_ApprovalRequest::setRequestDate()
     * @uses Security_ApprovalRequest::setRequestingUserId()
     * @uses Security_ApprovalRequest::setRequestingUserName()
     * @uses Security_ApprovalRequest::setSiteId()
     * @uses Security_ApprovalRequest::setSiteName()
     * @uses Security_ApprovalRequest::setStatus()
     * @uses Security_ApprovalRequest::setTag()
     * @uses Security_ApprovalRequest::setTransactionId()
     * @uses Security_ApprovalRequest::setTransactionNumber()
     * @param string $adminUserId
     * @param string $clientId
     * @param string $clientName
     * @param string $comment
     * @param string $executionStatus
     * @param string $executionStatusEx
     * @param string $handleDate
     * @param string $handledByName
     * @param string $info
     * @param string[] $operationForApproval
     * @param string $requestDate
     * @param string $requestingUserId
     * @param string $requestingUserName
     * @param string $siteId
     * @param \patest\StructType\GlobalString $siteName
     * @param string $status
     * @param string $tag
     * @param string $transactionId
     * @param int $transactionNumber
     */
    public function __construct($adminUserId = null, $clientId = null, $clientName = null, $comment = null, $executionStatus = null, $executionStatusEx = null, $handleDate = null, $handledByName = null, $info = null, array $operationForApproval = array(), $requestDate = null, $requestingUserId = null, $requestingUserName = null, $siteId = null, \patest\StructType\GlobalString $siteName = null, $status = null, $tag = null, $transactionId = null, $transactionNumber = null)
    {
        $this
            ->setAdminUserId($adminUserId)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setComment($comment)
            ->setExecutionStatus($executionStatus)
            ->setExecutionStatusEx($executionStatusEx)
            ->setHandleDate($handleDate)
            ->setHandledByName($handledByName)
            ->setInfo($info)
            ->setOperationForApproval($operationForApproval)
            ->setRequestDate($requestDate)
            ->setRequestingUserId($requestingUserId)
            ->setRequestingUserName($requestingUserName)
            ->setSiteId($siteId)
            ->setSiteName($siteName)
            ->setStatus($status)
            ->setTag($tag)
            ->setTransactionId($transactionId)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AdminUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdminUserId()
    {
        return isset($this->AdminUserId) ? $this->AdminUserId : null;
    }
    /**
     * Set AdminUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adminUserId
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setAdminUserId($adminUserId = null)
    {
        // validation for constraint: string
        if (!is_null($adminUserId) && !is_string($adminUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adminUserId, true), gettype($adminUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($adminUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $adminUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($adminUserId, true)), __LINE__);
        }
        if (is_null($adminUserId) || (is_array($adminUserId) && empty($adminUserId))) {
            unset($this->AdminUserId);
        } else {
            $this->AdminUserId = $adminUserId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comment
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get ExecutionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionStatus()
    {
        return isset($this->ExecutionStatus) ? $this->ExecutionStatus : null;
    }
    /**
     * Set ExecutionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestExecutionStatus::valueIsValid()
     * @uses \patest\EnumType\RequestExecutionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $executionStatus
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setExecutionStatus($executionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestExecutionStatus::valueIsValid($executionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestExecutionStatus', is_array($executionStatus) ? implode(', ', $executionStatus) : var_export($executionStatus, true), implode(', ', \patest\EnumType\RequestExecutionStatus::getValidValues())), __LINE__);
        }
        if (is_null($executionStatus) || (is_array($executionStatus) && empty($executionStatus))) {
            unset($this->ExecutionStatus);
        } else {
            $this->ExecutionStatus = $executionStatus;
        }
        return $this;
    }
    /**
     * Get ExecutionStatusEx value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionStatusEx()
    {
        return isset($this->ExecutionStatusEx) ? $this->ExecutionStatusEx : null;
    }
    /**
     * Set ExecutionStatusEx value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestExecutionStatus::valueIsValid()
     * @uses \patest\EnumType\RequestExecutionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $executionStatusEx
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setExecutionStatusEx($executionStatusEx = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestExecutionStatus::valueIsValid($executionStatusEx)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestExecutionStatus', is_array($executionStatusEx) ? implode(', ', $executionStatusEx) : var_export($executionStatusEx, true), implode(', ', \patest\EnumType\RequestExecutionStatus::getValidValues())), __LINE__);
        }
        if (is_null($executionStatusEx) || (is_array($executionStatusEx) && empty($executionStatusEx))) {
            unset($this->ExecutionStatusEx);
        } else {
            $this->ExecutionStatusEx = $executionStatusEx;
        }
        return $this;
    }
    /**
     * Get HandleDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandleDate()
    {
        return isset($this->HandleDate) ? $this->HandleDate : null;
    }
    /**
     * Set HandleDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handleDate
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setHandleDate($handleDate = null)
    {
        // validation for constraint: string
        if (!is_null($handleDate) && !is_string($handleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handleDate, true), gettype($handleDate)), __LINE__);
        }
        if (is_null($handleDate) || (is_array($handleDate) && empty($handleDate))) {
            unset($this->HandleDate);
        } else {
            $this->HandleDate = $handleDate;
        }
        return $this;
    }
    /**
     * Get HandledByName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHandledByName()
    {
        return isset($this->HandledByName) ? $this->HandledByName : null;
    }
    /**
     * Set HandledByName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $handledByName
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setHandledByName($handledByName = null)
    {
        // validation for constraint: string
        if (!is_null($handledByName) && !is_string($handledByName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handledByName, true), gettype($handledByName)), __LINE__);
        }
        if (is_null($handledByName) || (is_array($handledByName) && empty($handledByName))) {
            unset($this->HandledByName);
        } else {
            $this->HandledByName = $handledByName;
        }
        return $this;
    }
    /**
     * Get Info value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfo()
    {
        return isset($this->Info) ? $this->Info : null;
    }
    /**
     * Set Info value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $info
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        if (is_null($info) || (is_array($info) && empty($info))) {
            unset($this->Info);
        } else {
            $this->Info = $info;
        }
        return $this;
    }
    /**
     * Get OperationForApproval value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOperationForApproval()
    {
        return isset($this->OperationForApproval) ? $this->OperationForApproval : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationForApproval method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationForApproval method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationForApprovalForArrayConstraintsFromSetOperationForApproval(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $security_ApprovalRequestOperationForApprovalItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OperationForApprovalType::valueIsValid($security_ApprovalRequestOperationForApprovalItem)) {
                $invalidValues[] = is_object($security_ApprovalRequestOperationForApprovalItem) ? get_class($security_ApprovalRequestOperationForApprovalItem) : sprintf('%s(%s)', gettype($security_ApprovalRequestOperationForApprovalItem), var_export($security_ApprovalRequestOperationForApprovalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperationForApprovalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OperationForApprovalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationForApproval value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperationForApprovalType::valueIsValid()
     * @uses \patest\EnumType\OperationForApprovalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $operationForApproval
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setOperationForApproval(array $operationForApproval = array())
    {
        // validation for constraint: list
        if ('' !== ($operationForApprovalArrayErrorMessage = self::validateOperationForApprovalForArrayConstraintsFromSetOperationForApproval($operationForApproval))) {
            throw new \InvalidArgumentException($operationForApprovalArrayErrorMessage, __LINE__);
        }
        if (is_null($operationForApproval) || (is_array($operationForApproval) && empty($operationForApproval))) {
            unset($this->OperationForApproval);
        } else {
            $this->OperationForApproval = is_array($operationForApproval) ? implode(' ', $operationForApproval) : null;
        }
        return $this;
    }
    /**
     * Get RequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDate()
    {
        return isset($this->RequestDate) ? $this->RequestDate : null;
    }
    /**
     * Set RequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDate
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDate, true), gettype($requestDate)), __LINE__);
        }
        if (is_null($requestDate) || (is_array($requestDate) && empty($requestDate))) {
            unset($this->RequestDate);
        } else {
            $this->RequestDate = $requestDate;
        }
        return $this;
    }
    /**
     * Get RequestingUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestingUserId()
    {
        return isset($this->RequestingUserId) ? $this->RequestingUserId : null;
    }
    /**
     * Set RequestingUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestingUserId
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setRequestingUserId($requestingUserId = null)
    {
        // validation for constraint: string
        if (!is_null($requestingUserId) && !is_string($requestingUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestingUserId, true), gettype($requestingUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestingUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestingUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestingUserId, true)), __LINE__);
        }
        if (is_null($requestingUserId) || (is_array($requestingUserId) && empty($requestingUserId))) {
            unset($this->RequestingUserId);
        } else {
            $this->RequestingUserId = $requestingUserId;
        }
        return $this;
    }
    /**
     * Get RequestingUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestingUserName()
    {
        return isset($this->RequestingUserName) ? $this->RequestingUserName : null;
    }
    /**
     * Set RequestingUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestingUserName
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setRequestingUserName($requestingUserName = null)
    {
        // validation for constraint: string
        if (!is_null($requestingUserName) && !is_string($requestingUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestingUserName, true), gettype($requestingUserName)), __LINE__);
        }
        if (is_null($requestingUserName) || (is_array($requestingUserName) && empty($requestingUserName))) {
            unset($this->RequestingUserName);
        } else {
            $this->RequestingUserName = $requestingUserName;
        }
        return $this;
    }
    /**
     * Get SiteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteId()
    {
        return isset($this->SiteId) ? $this->SiteId : null;
    }
    /**
     * Set SiteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteId
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setSiteId($siteId = null)
    {
        // validation for constraint: string
        if (!is_null($siteId) && !is_string($siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteId, true), gettype($siteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($siteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $siteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($siteId, true)), __LINE__);
        }
        if (is_null($siteId) || (is_array($siteId) && empty($siteId))) {
            unset($this->SiteId);
        } else {
            $this->SiteId = $siteId;
        }
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $siteName
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setSiteName(\patest\StructType\GlobalString $siteName = null)
    {
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ApprovalDecisionType::valueIsValid()
     * @uses \patest\EnumType\ApprovalDecisionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ApprovalDecisionType::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ApprovalDecisionType', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\ApprovalDecisionType::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Tag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTag()
    {
        return isset($this->Tag) ? $this->Tag : null;
    }
    /**
     * Set Tag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tag
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setTag($tag = null)
    {
        // validation for constraint: string
        if (!is_null($tag) && !is_string($tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tag, true), gettype($tag)), __LINE__);
        }
        if (is_null($tag) || (is_array($tag) && empty($tag))) {
            unset($this->Tag);
        } else {
            $this->Tag = $tag;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Security_ApprovalRequest
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
