<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.AccountingCompanyParameters StructType
 * @subpackage Structs
 */
class Security_AccountingCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AllowPartialConfirmReservations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowPartialConfirmReservations;
    /**
     * The DefaultPaymentTerms
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultPaymentTerms;
    /**
     * The DraftInvoiceDepositCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DraftInvoiceDepositCategories;
    /**
     * The GroupByFullPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GroupByFullPrice;
    /**
     * The InvoiceTransactionsFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceTransactionsFromDate;
    /**
     * The LiaPaymentsAllocPolicy2StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LiaPaymentsAllocPolicy2StartDate;
    /**
     * The SaleModeForConfirmationReservationItemsSimulation
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeForConfirmationReservationItemsSimulation;
    /**
     * The SaleModeForDraftInvoicePaymentApplying
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeForDraftInvoicePaymentApplying;
    /**
     * Constructor method for Security.AccountingCompanyParameters
     * @uses Security_AccountingCompanyParameters::setAllowPartialConfirmReservations()
     * @uses Security_AccountingCompanyParameters::setDefaultPaymentTerms()
     * @uses Security_AccountingCompanyParameters::setDraftInvoiceDepositCategories()
     * @uses Security_AccountingCompanyParameters::setGroupByFullPrice()
     * @uses Security_AccountingCompanyParameters::setInvoiceTransactionsFromDate()
     * @uses Security_AccountingCompanyParameters::setLiaPaymentsAllocPolicy2StartDate()
     * @uses Security_AccountingCompanyParameters::setSaleModeForConfirmationReservationItemsSimulation()
     * @uses Security_AccountingCompanyParameters::setSaleModeForDraftInvoicePaymentApplying()
     * @param bool $allowPartialConfirmReservations
     * @param string $defaultPaymentTerms
     * @param string $draftInvoiceDepositCategories
     * @param bool $groupByFullPrice
     * @param string $invoiceTransactionsFromDate
     * @param string $liaPaymentsAllocPolicy2StartDate
     * @param string $saleModeForConfirmationReservationItemsSimulation
     * @param string $saleModeForDraftInvoicePaymentApplying
     */
    public function __construct($allowPartialConfirmReservations = null, $defaultPaymentTerms = null, $draftInvoiceDepositCategories = null, $groupByFullPrice = null, $invoiceTransactionsFromDate = null, $liaPaymentsAllocPolicy2StartDate = null, $saleModeForConfirmationReservationItemsSimulation = null, $saleModeForDraftInvoicePaymentApplying = null)
    {
        $this
            ->setAllowPartialConfirmReservations($allowPartialConfirmReservations)
            ->setDefaultPaymentTerms($defaultPaymentTerms)
            ->setDraftInvoiceDepositCategories($draftInvoiceDepositCategories)
            ->setGroupByFullPrice($groupByFullPrice)
            ->setInvoiceTransactionsFromDate($invoiceTransactionsFromDate)
            ->setLiaPaymentsAllocPolicy2StartDate($liaPaymentsAllocPolicy2StartDate)
            ->setSaleModeForConfirmationReservationItemsSimulation($saleModeForConfirmationReservationItemsSimulation)
            ->setSaleModeForDraftInvoicePaymentApplying($saleModeForDraftInvoicePaymentApplying);
    }
    /**
     * Get AllowPartialConfirmReservations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowPartialConfirmReservations()
    {
        return isset($this->AllowPartialConfirmReservations) ? $this->AllowPartialConfirmReservations : null;
    }
    /**
     * Set AllowPartialConfirmReservations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowPartialConfirmReservations
     * @return \patest\StructType\Security_AccountingCompanyParameters
     */
    public function setAllowPartialConfirmReservations($allowPartialConfirmReservations = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPartialConfirmReservations) && !is_bool($allowPartialConfirmReservations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowPartialConfirmReservations, true), gettype($allowPartialConfirmReservations)), __LINE__);
        }
        if (is_null($allowPartialConfirmReservations) || (is_array($allowPartialConfirmReservations) && empty($allowPartialConfirmReservations))) {
            unset($this->AllowPartialConfirmReservations);
        } else {
            $this->AllowPartialConfirmReservations = $allowPartialConfirmReservations;
        }
        return $this;
    }
    /**
     * Get DefaultPaymentTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultPaymentTerms()
    {
        return isset($this->DefaultPaymentTerms) ? $this->DefaultPaymentTerms : null;
    }
    /**
     * Set DefaultPaymentTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultPaymentTerms
     * @return \patest\StructType\Security_AccountingCompanyParameters
     */
    public function setDefaultPaymentTerms($defaultPaymentTerms = null)
    {
        // validation for constraint: string
        if (!is_null($defaultPaymentTerms) && !is_string($defaultPaymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultPaymentTerms, true), gettype($defaultPaymentTerms)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultPaymentTerms) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultPaymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultPaymentTerms, true)), __LINE__);
        }
        if (is_null($defaultPaymentTerms) || (is_array($defaultPaymentTerms) && empty($defaultPaymentTerms))) {
            unset($this->DefaultPaymentTerms);
        } else {
            $this->DefaultPaymentTerms = $defaultPaymentTerms;
        }
        return $this;
    }
    /**
     * Get DraftInvoiceDepositCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDraftInvoiceDepositCategories()
    {
        return isset($this->DraftInvoiceDepositCategories) ? $this->DraftInvoiceDepositCategories : null;
    }
    /**
     * Set DraftInvoiceDepositCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $draftInvoiceDepositCategories
     * @return \patest\StructType\Security_AccountingCompanyParameters
     */
    public function setDraftInvoiceDepositCategories($draftInvoiceDepositCategories = null)
    {
        // validation for constraint: string
        if (!is_null($draftInvoiceDepositCategories) && !is_string($draftInvoiceDepositCategories)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($draftInvoiceDepositCategories, true), gettype($draftInvoiceDepositCategories)), __LINE__);
        }
        if (is_null($draftInvoiceDepositCategories) || (is_array($draftInvoiceDepositCategories) && empty($draftInvoiceDepositCategories))) {
            unset($this->DraftInvoiceDepositCategories);
        } else {
            $this->DraftInvoiceDepositCategories = $draftInvoiceDepositCategories;
        }
        return $this;
    }
    /**
     * Get GroupByFullPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGroupByFullPrice()
    {
        return isset($this->GroupByFullPrice) ? $this->GroupByFullPrice : null;
    }
    /**
     * Set GroupByFullPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $groupByFullPrice
     * @return \patest\StructType\Security_AccountingCompanyParameters
     */
    public function setGroupByFullPrice($groupByFullPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupByFullPrice) && !is_bool($groupByFullPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupByFullPrice, true), gettype($groupByFullPrice)), __LINE__);
        }
        if (is_null($groupByFullPrice) || (is_array($groupByFullPrice) && empty($groupByFullPrice))) {
            unset($this->GroupByFullPrice);
        } else {
            $this->GroupByFullPrice = $groupByFullPrice;
        }
        return $this;
    }
    /**
     * Get InvoiceTransactionsFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceTransactionsFromDate()
    {
        return isset($this->InvoiceTransactionsFromDate) ? $this->InvoiceTransactionsFromDate : null;
    }
    /**
     * Set InvoiceTransactionsFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceTransactionsFromDate
     * @return \patest\StructType\Security_AccountingCompanyParameters
     */
    public function setInvoiceTransactionsFromDate($invoiceTransactionsFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceTransactionsFromDate) && !is_string($invoiceTransactionsFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceTransactionsFromDate, true), gettype($invoiceTransactionsFromDate)), __LINE__);
        }
        if (is_null($invoiceTransactionsFromDate) || (is_array($invoiceTransactionsFromDate) && empty($invoiceTransactionsFromDate))) {
            unset($this->InvoiceTransactionsFromDate);
        } else {
            $this->InvoiceTransactionsFromDate = $invoiceTransactionsFromDate;
        }
        return $this;
    }
    /**
     * Get LiaPaymentsAllocPolicy2StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLiaPaymentsAllocPolicy2StartDate()
    {
        return isset($this->LiaPaymentsAllocPolicy2StartDate) ? $this->LiaPaymentsAllocPolicy2StartDate : null;
    }
    /**
     * Set LiaPaymentsAllocPolicy2StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $liaPaymentsAllocPolicy2StartDate
     * @return \patest\StructType\Security_AccountingCompanyParameters
     */
    public function setLiaPaymentsAllocPolicy2StartDate($liaPaymentsAllocPolicy2StartDate = null)
    {
        // validation for constraint: string
        if (!is_null($liaPaymentsAllocPolicy2StartDate) && !is_string($liaPaymentsAllocPolicy2StartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($liaPaymentsAllocPolicy2StartDate, true), gettype($liaPaymentsAllocPolicy2StartDate)), __LINE__);
        }
        if (is_null($liaPaymentsAllocPolicy2StartDate) || (is_array($liaPaymentsAllocPolicy2StartDate) && empty($liaPaymentsAllocPolicy2StartDate))) {
            unset($this->LiaPaymentsAllocPolicy2StartDate);
        } else {
            $this->LiaPaymentsAllocPolicy2StartDate = $liaPaymentsAllocPolicy2StartDate;
        }
        return $this;
    }
    /**
     * Get SaleModeForConfirmationReservationItemsSimulation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeForConfirmationReservationItemsSimulation()
    {
        return isset($this->SaleModeForConfirmationReservationItemsSimulation) ? $this->SaleModeForConfirmationReservationItemsSimulation : null;
    }
    /**
     * Set SaleModeForConfirmationReservationItemsSimulation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeForConfirmationReservationItemsSimulation
     * @return \patest\StructType\Security_AccountingCompanyParameters
     */
    public function setSaleModeForConfirmationReservationItemsSimulation($saleModeForConfirmationReservationItemsSimulation = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeForConfirmationReservationItemsSimulation) && !is_string($saleModeForConfirmationReservationItemsSimulation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeForConfirmationReservationItemsSimulation, true), gettype($saleModeForConfirmationReservationItemsSimulation)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeForConfirmationReservationItemsSimulation) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeForConfirmationReservationItemsSimulation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeForConfirmationReservationItemsSimulation, true)), __LINE__);
        }
        if (is_null($saleModeForConfirmationReservationItemsSimulation) || (is_array($saleModeForConfirmationReservationItemsSimulation) && empty($saleModeForConfirmationReservationItemsSimulation))) {
            unset($this->SaleModeForConfirmationReservationItemsSimulation);
        } else {
            $this->SaleModeForConfirmationReservationItemsSimulation = $saleModeForConfirmationReservationItemsSimulation;
        }
        return $this;
    }
    /**
     * Get SaleModeForDraftInvoicePaymentApplying value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeForDraftInvoicePaymentApplying()
    {
        return isset($this->SaleModeForDraftInvoicePaymentApplying) ? $this->SaleModeForDraftInvoicePaymentApplying : null;
    }
    /**
     * Set SaleModeForDraftInvoicePaymentApplying value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeForDraftInvoicePaymentApplying
     * @return \patest\StructType\Security_AccountingCompanyParameters
     */
    public function setSaleModeForDraftInvoicePaymentApplying($saleModeForDraftInvoicePaymentApplying = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeForDraftInvoicePaymentApplying) && !is_string($saleModeForDraftInvoicePaymentApplying)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeForDraftInvoicePaymentApplying, true), gettype($saleModeForDraftInvoicePaymentApplying)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeForDraftInvoicePaymentApplying) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeForDraftInvoicePaymentApplying)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeForDraftInvoicePaymentApplying, true)), __LINE__);
        }
        if (is_null($saleModeForDraftInvoicePaymentApplying) || (is_array($saleModeForDraftInvoicePaymentApplying) && empty($saleModeForDraftInvoicePaymentApplying))) {
            unset($this->SaleModeForDraftInvoicePaymentApplying);
        } else {
            $this->SaleModeForDraftInvoicePaymentApplying = $saleModeForDraftInvoicePaymentApplying;
        }
        return $this;
    }
}
