<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SectorDesign StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SectorDesign
 * @subpackage Structs
 */
class SectorDesign extends AbstractStructBase
{
    /**
     * The ForcePrioritizationOnSave
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ForcePrioritizationOnSave;
    /**
     * The MaxUnreservedSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxUnreservedSeats;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NumbersOfSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumbersOfSeats;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The ParentAreaMapGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentAreaMapGuid;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The Rows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfRowDesign
     */
    public $Rows;
    /**
     * The SectorGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorGuid;
    /**
     * The ViewXaml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewXaml;
    /**
     * The ContinuedBySectorGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContinuedBySectorGuid;
    /**
     * The GlobalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GlobalName;
    /**
     * Constructor method for SectorDesign
     * @uses SectorDesign::setForcePrioritizationOnSave()
     * @uses SectorDesign::setMaxUnreservedSeats()
     * @uses SectorDesign::setName()
     * @uses SectorDesign::setNumbersOfSeats()
     * @uses SectorDesign::setOrdinal()
     * @uses SectorDesign::setParentAreaMapGuid()
     * @uses SectorDesign::setPriority()
     * @uses SectorDesign::setRows()
     * @uses SectorDesign::setSectorGuid()
     * @uses SectorDesign::setViewXaml()
     * @uses SectorDesign::setContinuedBySectorGuid()
     * @uses SectorDesign::setGlobalName()
     * @param bool $forcePrioritizationOnSave
     * @param int $maxUnreservedSeats
     * @param string $name
     * @param int $numbersOfSeats
     * @param int $ordinal
     * @param string $parentAreaMapGuid
     * @param int $priority
     * @param \patest\ArrayType\ArrayOfRowDesign $rows
     * @param string $sectorGuid
     * @param string $viewXaml
     * @param string $continuedBySectorGuid
     * @param \patest\StructType\GlobalString $globalName
     */
    public function __construct($forcePrioritizationOnSave = null, $maxUnreservedSeats = null, $name = null, $numbersOfSeats = null, $ordinal = null, $parentAreaMapGuid = null, $priority = null, \patest\ArrayType\ArrayOfRowDesign $rows = null, $sectorGuid = null, $viewXaml = null, $continuedBySectorGuid = null, \patest\StructType\GlobalString $globalName = null)
    {
        $this
            ->setForcePrioritizationOnSave($forcePrioritizationOnSave)
            ->setMaxUnreservedSeats($maxUnreservedSeats)
            ->setName($name)
            ->setNumbersOfSeats($numbersOfSeats)
            ->setOrdinal($ordinal)
            ->setParentAreaMapGuid($parentAreaMapGuid)
            ->setPriority($priority)
            ->setRows($rows)
            ->setSectorGuid($sectorGuid)
            ->setViewXaml($viewXaml)
            ->setContinuedBySectorGuid($continuedBySectorGuid)
            ->setGlobalName($globalName);
    }
    /**
     * Get ForcePrioritizationOnSave value
     * @return bool|null
     */
    public function getForcePrioritizationOnSave()
    {
        return $this->ForcePrioritizationOnSave;
    }
    /**
     * Set ForcePrioritizationOnSave value
     * @param bool $forcePrioritizationOnSave
     * @return \patest\StructType\SectorDesign
     */
    public function setForcePrioritizationOnSave($forcePrioritizationOnSave = null)
    {
        // validation for constraint: boolean
        if (!is_null($forcePrioritizationOnSave) && !is_bool($forcePrioritizationOnSave)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forcePrioritizationOnSave, true), gettype($forcePrioritizationOnSave)), __LINE__);
        }
        $this->ForcePrioritizationOnSave = $forcePrioritizationOnSave;
        return $this;
    }
    /**
     * Get MaxUnreservedSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxUnreservedSeats()
    {
        return isset($this->MaxUnreservedSeats) ? $this->MaxUnreservedSeats : null;
    }
    /**
     * Set MaxUnreservedSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxUnreservedSeats
     * @return \patest\StructType\SectorDesign
     */
    public function setMaxUnreservedSeats($maxUnreservedSeats = null)
    {
        // validation for constraint: int
        if (!is_null($maxUnreservedSeats) && !(is_int($maxUnreservedSeats) || ctype_digit($maxUnreservedSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxUnreservedSeats, true), gettype($maxUnreservedSeats)), __LINE__);
        }
        if (is_null($maxUnreservedSeats) || (is_array($maxUnreservedSeats) && empty($maxUnreservedSeats))) {
            unset($this->MaxUnreservedSeats);
        } else {
            $this->MaxUnreservedSeats = $maxUnreservedSeats;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\SectorDesign
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NumbersOfSeats value
     * @return int|null
     */
    public function getNumbersOfSeats()
    {
        return $this->NumbersOfSeats;
    }
    /**
     * Set NumbersOfSeats value
     * @param int $numbersOfSeats
     * @return \patest\StructType\SectorDesign
     */
    public function setNumbersOfSeats($numbersOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($numbersOfSeats) && !(is_int($numbersOfSeats) || ctype_digit($numbersOfSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numbersOfSeats, true), gettype($numbersOfSeats)), __LINE__);
        }
        $this->NumbersOfSeats = $numbersOfSeats;
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\SectorDesign
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get ParentAreaMapGuid value
     * @return string|null
     */
    public function getParentAreaMapGuid()
    {
        return $this->ParentAreaMapGuid;
    }
    /**
     * Set ParentAreaMapGuid value
     * @param string $parentAreaMapGuid
     * @return \patest\StructType\SectorDesign
     */
    public function setParentAreaMapGuid($parentAreaMapGuid = null)
    {
        // validation for constraint: string
        if (!is_null($parentAreaMapGuid) && !is_string($parentAreaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentAreaMapGuid, true), gettype($parentAreaMapGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentAreaMapGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentAreaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentAreaMapGuid, true)), __LINE__);
        }
        $this->ParentAreaMapGuid = $parentAreaMapGuid;
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\SectorDesign
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get Rows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfRowDesign|null
     */
    public function getRows()
    {
        return isset($this->Rows) ? $this->Rows : null;
    }
    /**
     * Set Rows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfRowDesign $rows
     * @return \patest\StructType\SectorDesign
     */
    public function setRows(\patest\ArrayType\ArrayOfRowDesign $rows = null)
    {
        if (is_null($rows) || (is_array($rows) && empty($rows))) {
            unset($this->Rows);
        } else {
            $this->Rows = $rows;
        }
        return $this;
    }
    /**
     * Get SectorGuid value
     * @return string|null
     */
    public function getSectorGuid()
    {
        return $this->SectorGuid;
    }
    /**
     * Set SectorGuid value
     * @param string $sectorGuid
     * @return \patest\StructType\SectorDesign
     */
    public function setSectorGuid($sectorGuid = null)
    {
        // validation for constraint: string
        if (!is_null($sectorGuid) && !is_string($sectorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorGuid, true), gettype($sectorGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorGuid, true)), __LINE__);
        }
        $this->SectorGuid = $sectorGuid;
        return $this;
    }
    /**
     * Get ViewXaml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewXaml()
    {
        return isset($this->ViewXaml) ? $this->ViewXaml : null;
    }
    /**
     * Set ViewXaml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewXaml
     * @return \patest\StructType\SectorDesign
     */
    public function setViewXaml($viewXaml = null)
    {
        // validation for constraint: string
        if (!is_null($viewXaml) && !is_string($viewXaml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewXaml, true), gettype($viewXaml)), __LINE__);
        }
        if (is_null($viewXaml) || (is_array($viewXaml) && empty($viewXaml))) {
            unset($this->ViewXaml);
        } else {
            $this->ViewXaml = $viewXaml;
        }
        return $this;
    }
    /**
     * Get ContinuedBySectorGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContinuedBySectorGuid()
    {
        return isset($this->ContinuedBySectorGuid) ? $this->ContinuedBySectorGuid : null;
    }
    /**
     * Set ContinuedBySectorGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $continuedBySectorGuid
     * @return \patest\StructType\SectorDesign
     */
    public function setContinuedBySectorGuid($continuedBySectorGuid = null)
    {
        // validation for constraint: string
        if (!is_null($continuedBySectorGuid) && !is_string($continuedBySectorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($continuedBySectorGuid, true), gettype($continuedBySectorGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($continuedBySectorGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $continuedBySectorGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($continuedBySectorGuid, true)), __LINE__);
        }
        if (is_null($continuedBySectorGuid) || (is_array($continuedBySectorGuid) && empty($continuedBySectorGuid))) {
            unset($this->ContinuedBySectorGuid);
        } else {
            $this->ContinuedBySectorGuid = $continuedBySectorGuid;
        }
        return $this;
    }
    /**
     * Get GlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGlobalName()
    {
        return isset($this->GlobalName) ? $this->GlobalName : null;
    }
    /**
     * Set GlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $globalName
     * @return \patest\StructType\SectorDesign
     */
    public function setGlobalName(\patest\StructType\GlobalString $globalName = null)
    {
        if (is_null($globalName) || (is_array($globalName) && empty($globalName))) {
            unset($this->GlobalName);
        } else {
            $this->GlobalName = $globalName;
        }
        return $this;
    }
}
