<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatTooltipSessionInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatTooltipSessionInfo
 * @subpackage Structs
 */
class SeatTooltipSessionInfo extends AbstractStructBase
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The CreatedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedAt;
    /**
     * The HeldSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HeldSeatCount;
    /**
     * The LastActivityAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastActivityAt;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointName;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SessionId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The IsSessionOnHold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSessionOnHold;
    /**
     * The RelatedTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedTransactionGuid;
    /**
     * The SellerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerId;
    /**
     * Constructor method for SeatTooltipSessionInfo
     * @uses SeatTooltipSessionInfo::setApplicationChannel()
     * @uses SeatTooltipSessionInfo::setCreatedAt()
     * @uses SeatTooltipSessionInfo::setHeldSeatCount()
     * @uses SeatTooltipSessionInfo::setLastActivityAt()
     * @uses SeatTooltipSessionInfo::setSalePointName()
     * @uses SeatTooltipSessionInfo::setSessionId()
     * @uses SeatTooltipSessionInfo::setUserName()
     * @uses SeatTooltipSessionInfo::setIsSessionOnHold()
     * @uses SeatTooltipSessionInfo::setRelatedTransactionGuid()
     * @uses SeatTooltipSessionInfo::setSellerId()
     * @param string $applicationChannel
     * @param string $createdAt
     * @param int $heldSeatCount
     * @param string $lastActivityAt
     * @param string $salePointName
     * @param string $sessionId
     * @param string $userName
     * @param bool $isSessionOnHold
     * @param string $relatedTransactionGuid
     * @param string $sellerId
     */
    public function __construct($applicationChannel = null, $createdAt = null, $heldSeatCount = null, $lastActivityAt = null, $salePointName = null, $sessionId = null, $userName = null, $isSessionOnHold = null, $relatedTransactionGuid = null, $sellerId = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setCreatedAt($createdAt)
            ->setHeldSeatCount($heldSeatCount)
            ->setLastActivityAt($lastActivityAt)
            ->setSalePointName($salePointName)
            ->setSessionId($sessionId)
            ->setUserName($userName)
            ->setIsSessionOnHold($isSessionOnHold)
            ->setRelatedTransactionGuid($relatedTransactionGuid)
            ->setSellerId($sellerId);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get CreatedAt value
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->CreatedAt;
    }
    /**
     * Set CreatedAt value
     * @param string $createdAt
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setCreatedAt($createdAt = null)
    {
        // validation for constraint: string
        if (!is_null($createdAt) && !is_string($createdAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAt, true), gettype($createdAt)), __LINE__);
        }
        $this->CreatedAt = $createdAt;
        return $this;
    }
    /**
     * Get HeldSeatCount value
     * @return int|null
     */
    public function getHeldSeatCount()
    {
        return $this->HeldSeatCount;
    }
    /**
     * Set HeldSeatCount value
     * @param int $heldSeatCount
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setHeldSeatCount($heldSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($heldSeatCount) && !(is_int($heldSeatCount) || ctype_digit($heldSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($heldSeatCount, true), gettype($heldSeatCount)), __LINE__);
        }
        $this->HeldSeatCount = $heldSeatCount;
        return $this;
    }
    /**
     * Get LastActivityAt value
     * @return string|null
     */
    public function getLastActivityAt()
    {
        return $this->LastActivityAt;
    }
    /**
     * Set LastActivityAt value
     * @param string $lastActivityAt
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setLastActivityAt($lastActivityAt = null)
    {
        // validation for constraint: string
        if (!is_null($lastActivityAt) && !is_string($lastActivityAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActivityAt, true), gettype($lastActivityAt)), __LINE__);
        }
        $this->LastActivityAt = $lastActivityAt;
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointName
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setSalePointName($salePointName = null)
    {
        // validation for constraint: string
        if (!is_null($salePointName) && !is_string($salePointName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointName, true), gettype($salePointName)), __LINE__);
        }
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SessionId value
     * @return string|null
     */
    public function getSessionId()
    {
        return $this->SessionId;
    }
    /**
     * Set SessionId value
     * @param string $sessionId
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sessionId, true)), __LINE__);
        }
        $this->SessionId = $sessionId;
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get IsSessionOnHold value
     * @return bool|null
     */
    public function getIsSessionOnHold()
    {
        return $this->IsSessionOnHold;
    }
    /**
     * Set IsSessionOnHold value
     * @param bool $isSessionOnHold
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setIsSessionOnHold($isSessionOnHold = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSessionOnHold) && !is_bool($isSessionOnHold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSessionOnHold, true), gettype($isSessionOnHold)), __LINE__);
        }
        $this->IsSessionOnHold = $isSessionOnHold;
        return $this;
    }
    /**
     * Get RelatedTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedTransactionGuid()
    {
        return isset($this->RelatedTransactionGuid) ? $this->RelatedTransactionGuid : null;
    }
    /**
     * Set RelatedTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedTransactionGuid
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setRelatedTransactionGuid($relatedTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($relatedTransactionGuid) && !is_string($relatedTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedTransactionGuid, true), gettype($relatedTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedTransactionGuid, true)), __LINE__);
        }
        if (is_null($relatedTransactionGuid) || (is_array($relatedTransactionGuid) && empty($relatedTransactionGuid))) {
            unset($this->RelatedTransactionGuid);
        } else {
            $this->RelatedTransactionGuid = $relatedTransactionGuid;
        }
        return $this;
    }
    /**
     * Get SellerId value
     * @return string|null
     */
    public function getSellerId()
    {
        return $this->SellerId;
    }
    /**
     * Set SellerId value
     * @param string $sellerId
     * @return \patest\StructType\SeatTooltipSessionInfo
     */
    public function setSellerId($sellerId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerId) && !is_string($sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerId, true), gettype($sellerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerId, true)), __LINE__);
        }
        $this->SellerId = $sellerId;
        return $this;
    }
}
