<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeatLimitationFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SeatLimitationFault
 * @subpackage Structs
 */
class SeatLimitationFault extends BasicFault
{
    /**
     * The Available
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Available;
    /**
     * The PriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceType;
    /**
     * Constructor method for SeatLimitationFault
     * @uses SeatLimitationFault::setAvailable()
     * @uses SeatLimitationFault::setPriceType()
     * @param int $available
     * @param string $priceType
     */
    public function __construct($available = null, $priceType = null)
    {
        $this
            ->setAvailable($available)
            ->setPriceType($priceType);
    }
    /**
     * Get Available value
     * @return int|null
     */
    public function getAvailable()
    {
        return $this->Available;
    }
    /**
     * Set Available value
     * @param int $available
     * @return \patest\StructType\SeatLimitationFault
     */
    public function setAvailable($available = null)
    {
        // validation for constraint: int
        if (!is_null($available) && !(is_int($available) || ctype_digit($available))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($available, true), gettype($available)), __LINE__);
        }
        $this->Available = $available;
        return $this;
    }
    /**
     * Get PriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceType()
    {
        return isset($this->PriceType) ? $this->PriceType : null;
    }
    /**
     * Set PriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceType
     * @return \patest\StructType\SeatLimitationFault
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: string
        if (!is_null($priceType) && !is_string($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceType, true), gettype($priceType)), __LINE__);
        }
        if (is_null($priceType) || (is_array($priceType) && empty($priceType))) {
            unset($this->PriceType);
        } else {
            $this->PriceType = $priceType;
        }
        return $this;
    }
}
