<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.UpdateSalesRepOnCommitedItems.Request StructType
 * @subpackage Structs
 */
class Sales_UpdateSalesRepOnCommitedItems_Request extends AnyEntity
{
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The ServiceSpecificIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ServiceSpecificIds
     */
    public $ServiceSpecificIds;
    /**
     * Constructor method for Sales.UpdateSalesRepOnCommitedItems.Request
     * @uses Sales_UpdateSalesRepOnCommitedItems_Request::setSalesRepId()
     * @uses Sales_UpdateSalesRepOnCommitedItems_Request::setServiceSpecificIds()
     * @param string $salesRepId
     * @param \patest\StructType\ServiceSpecificIds $serviceSpecificIds
     */
    public function __construct($salesRepId = null, \patest\StructType\ServiceSpecificIds $serviceSpecificIds = null)
    {
        $this
            ->setSalesRepId($salesRepId)
            ->setServiceSpecificIds($serviceSpecificIds);
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\Sales_UpdateSalesRepOnCommitedItems_Request
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ServiceSpecificIds|null
     */
    public function getServiceSpecificIds()
    {
        return isset($this->ServiceSpecificIds) ? $this->ServiceSpecificIds : null;
    }
    /**
     * Set ServiceSpecificIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ServiceSpecificIds $serviceSpecificIds
     * @return \patest\StructType\Sales_UpdateSalesRepOnCommitedItems_Request
     */
    public function setServiceSpecificIds(\patest\StructType\ServiceSpecificIds $serviceSpecificIds = null)
    {
        if (is_null($serviceSpecificIds) || (is_array($serviceSpecificIds) && empty($serviceSpecificIds))) {
            unset($this->ServiceSpecificIds);
        } else {
            $this->ServiceSpecificIds = $serviceSpecificIds;
        }
        return $this;
    }
}
