<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.UpdateInvoiceTransaction StructType
 * @subpackage Structs
 */
class Sales_UpdateInvoiceTransaction extends DistributableEntity
{
    /**
     * The CreditNoteId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditNoteId;
    /**
     * The CreditNoteNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreditNoteNumber;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceId;
    /**
     * The InvoiceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The InvoiceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceType;
    /**
     * Constructor method for Sales.UpdateInvoiceTransaction
     * @uses Sales_UpdateInvoiceTransaction::setCreditNoteId()
     * @uses Sales_UpdateInvoiceTransaction::setCreditNoteNumber()
     * @uses Sales_UpdateInvoiceTransaction::setInvoiceId()
     * @uses Sales_UpdateInvoiceTransaction::setInvoiceNumber()
     * @uses Sales_UpdateInvoiceTransaction::setInvoiceType()
     * @param string $creditNoteId
     * @param int $creditNoteNumber
     * @param string $invoiceId
     * @param int $invoiceNumber
     * @param string $invoiceType
     */
    public function __construct($creditNoteId = null, $creditNoteNumber = null, $invoiceId = null, $invoiceNumber = null, $invoiceType = null)
    {
        $this
            ->setCreditNoteId($creditNoteId)
            ->setCreditNoteNumber($creditNoteNumber)
            ->setInvoiceId($invoiceId)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceType($invoiceType);
    }
    /**
     * Get CreditNoteId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreditNoteId()
    {
        return isset($this->CreditNoteId) ? $this->CreditNoteId : null;
    }
    /**
     * Set CreditNoteId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creditNoteId
     * @return \patest\StructType\Sales_UpdateInvoiceTransaction
     */
    public function setCreditNoteId($creditNoteId = null)
    {
        // validation for constraint: string
        if (!is_null($creditNoteId) && !is_string($creditNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditNoteId, true), gettype($creditNoteId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditNoteId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditNoteId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditNoteId, true)), __LINE__);
        }
        if (is_null($creditNoteId) || (is_array($creditNoteId) && empty($creditNoteId))) {
            unset($this->CreditNoteId);
        } else {
            $this->CreditNoteId = $creditNoteId;
        }
        return $this;
    }
    /**
     * Get CreditNoteNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreditNoteNumber()
    {
        return isset($this->CreditNoteNumber) ? $this->CreditNoteNumber : null;
    }
    /**
     * Set CreditNoteNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creditNoteNumber
     * @return \patest\StructType\Sales_UpdateInvoiceTransaction
     */
    public function setCreditNoteNumber($creditNoteNumber = null)
    {
        // validation for constraint: int
        if (!is_null($creditNoteNumber) && !(is_int($creditNoteNumber) || ctype_digit($creditNoteNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditNoteNumber, true), gettype($creditNoteNumber)), __LINE__);
        }
        if (is_null($creditNoteNumber) || (is_array($creditNoteNumber) && empty($creditNoteNumber))) {
            unset($this->CreditNoteNumber);
        } else {
            $this->CreditNoteNumber = $creditNoteNumber;
        }
        return $this;
    }
    /**
     * Get InvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceId()
    {
        return isset($this->InvoiceId) ? $this->InvoiceId : null;
    }
    /**
     * Set InvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceId
     * @return \patest\StructType\Sales_UpdateInvoiceTransaction
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceId, true)), __LINE__);
        }
        if (is_null($invoiceId) || (is_array($invoiceId) && empty($invoiceId))) {
            unset($this->InvoiceId);
        } else {
            $this->InvoiceId = $invoiceId;
        }
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $invoiceNumber
     * @return \patest\StructType\Sales_UpdateInvoiceTransaction
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !(is_int($invoiceNumber) || ctype_digit($invoiceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get InvoiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceType()
    {
        return isset($this->InvoiceType) ? $this->InvoiceType : null;
    }
    /**
     * Set InvoiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccountingDocumentType::valueIsValid()
     * @uses \patest\EnumType\AccountingDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $invoiceType
     * @return \patest\StructType\Sales_UpdateInvoiceTransaction
     */
    public function setInvoiceType($invoiceType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccountingDocumentType::valueIsValid($invoiceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccountingDocumentType', is_array($invoiceType) ? implode(', ', $invoiceType) : var_export($invoiceType, true), implode(', ', \patest\EnumType\AccountingDocumentType::getValidValues())), __LINE__);
        }
        if (is_null($invoiceType) || (is_array($invoiceType) && empty($invoiceType))) {
            unset($this->InvoiceType);
        } else {
            $this->InvoiceType = $invoiceType;
        }
        return $this;
    }
}
