<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.TransactionOnHold StructType
 * @subpackage Structs
 */
class Sales_TransactionOnHold extends PersistableEntity
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The BasketContent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BasketContent;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The HoldDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HoldDateTime;
    /**
     * The OwnedByOrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnedByOrganizationUnitId;
    /**
     * The OwnedBySalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnedBySalePointId;
    /**
     * The OwnedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnedByUserId;
    /**
     * The ProductItemCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProductItemCount;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The SaleModeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeId;
    /**
     * The SerializedTranState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerializedTranState;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Sales.TransactionOnHold
     * @uses Sales_TransactionOnHold::setApplicationChannel()
     * @uses Sales_TransactionOnHold::setBasketContent()
     * @uses Sales_TransactionOnHold::setClientId()
     * @uses Sales_TransactionOnHold::setClientName()
     * @uses Sales_TransactionOnHold::setHoldDateTime()
     * @uses Sales_TransactionOnHold::setOwnedByOrganizationUnitId()
     * @uses Sales_TransactionOnHold::setOwnedBySalePointId()
     * @uses Sales_TransactionOnHold::setOwnedByUserId()
     * @uses Sales_TransactionOnHold::setProductItemCount()
     * @uses Sales_TransactionOnHold::setReferenceNumber()
     * @uses Sales_TransactionOnHold::setSaleModeId()
     * @uses Sales_TransactionOnHold::setSerializedTranState()
     * @uses Sales_TransactionOnHold::setTotalAmount()
     * @uses Sales_TransactionOnHold::setTransactionGuid()
     * @param string $applicationChannel
     * @param string $basketContent
     * @param string $clientId
     * @param string $clientName
     * @param string $holdDateTime
     * @param string $ownedByOrganizationUnitId
     * @param string $ownedBySalePointId
     * @param string $ownedByUserId
     * @param int $productItemCount
     * @param int $referenceNumber
     * @param string $saleModeId
     * @param string $serializedTranState
     * @param \patest\StructType\Money $totalAmount
     * @param string $transactionGuid
     */
    public function __construct($applicationChannel = null, $basketContent = null, $clientId = null, $clientName = null, $holdDateTime = null, $ownedByOrganizationUnitId = null, $ownedBySalePointId = null, $ownedByUserId = null, $productItemCount = null, $referenceNumber = null, $saleModeId = null, $serializedTranState = null, \patest\StructType\Money $totalAmount = null, $transactionGuid = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setBasketContent($basketContent)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setHoldDateTime($holdDateTime)
            ->setOwnedByOrganizationUnitId($ownedByOrganizationUnitId)
            ->setOwnedBySalePointId($ownedBySalePointId)
            ->setOwnedByUserId($ownedByUserId)
            ->setProductItemCount($productItemCount)
            ->setReferenceNumber($referenceNumber)
            ->setSaleModeId($saleModeId)
            ->setSerializedTranState($serializedTranState)
            ->setTotalAmount($totalAmount)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get BasketContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasketContent()
    {
        return isset($this->BasketContent) ? $this->BasketContent : null;
    }
    /**
     * Set BasketContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $basketContent
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setBasketContent($basketContent = null)
    {
        // validation for constraint: string
        if (!is_null($basketContent) && !is_string($basketContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basketContent, true), gettype($basketContent)), __LINE__);
        }
        if (is_null($basketContent) || (is_array($basketContent) && empty($basketContent))) {
            unset($this->BasketContent);
        } else {
            $this->BasketContent = $basketContent;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get HoldDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHoldDateTime()
    {
        return isset($this->HoldDateTime) ? $this->HoldDateTime : null;
    }
    /**
     * Set HoldDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $holdDateTime
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setHoldDateTime($holdDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($holdDateTime) && !is_string($holdDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($holdDateTime, true), gettype($holdDateTime)), __LINE__);
        }
        if (is_null($holdDateTime) || (is_array($holdDateTime) && empty($holdDateTime))) {
            unset($this->HoldDateTime);
        } else {
            $this->HoldDateTime = $holdDateTime;
        }
        return $this;
    }
    /**
     * Get OwnedByOrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnedByOrganizationUnitId()
    {
        return isset($this->OwnedByOrganizationUnitId) ? $this->OwnedByOrganizationUnitId : null;
    }
    /**
     * Set OwnedByOrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownedByOrganizationUnitId
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setOwnedByOrganizationUnitId($ownedByOrganizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($ownedByOrganizationUnitId) && !is_string($ownedByOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownedByOrganizationUnitId, true), gettype($ownedByOrganizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownedByOrganizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownedByOrganizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownedByOrganizationUnitId, true)), __LINE__);
        }
        if (is_null($ownedByOrganizationUnitId) || (is_array($ownedByOrganizationUnitId) && empty($ownedByOrganizationUnitId))) {
            unset($this->OwnedByOrganizationUnitId);
        } else {
            $this->OwnedByOrganizationUnitId = $ownedByOrganizationUnitId;
        }
        return $this;
    }
    /**
     * Get OwnedBySalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnedBySalePointId()
    {
        return isset($this->OwnedBySalePointId) ? $this->OwnedBySalePointId : null;
    }
    /**
     * Set OwnedBySalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownedBySalePointId
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setOwnedBySalePointId($ownedBySalePointId = null)
    {
        // validation for constraint: string
        if (!is_null($ownedBySalePointId) && !is_string($ownedBySalePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownedBySalePointId, true), gettype($ownedBySalePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownedBySalePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownedBySalePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownedBySalePointId, true)), __LINE__);
        }
        if (is_null($ownedBySalePointId) || (is_array($ownedBySalePointId) && empty($ownedBySalePointId))) {
            unset($this->OwnedBySalePointId);
        } else {
            $this->OwnedBySalePointId = $ownedBySalePointId;
        }
        return $this;
    }
    /**
     * Get OwnedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnedByUserId()
    {
        return isset($this->OwnedByUserId) ? $this->OwnedByUserId : null;
    }
    /**
     * Set OwnedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownedByUserId
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setOwnedByUserId($ownedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($ownedByUserId) && !is_string($ownedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownedByUserId, true), gettype($ownedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownedByUserId, true)), __LINE__);
        }
        if (is_null($ownedByUserId) || (is_array($ownedByUserId) && empty($ownedByUserId))) {
            unset($this->OwnedByUserId);
        } else {
            $this->OwnedByUserId = $ownedByUserId;
        }
        return $this;
    }
    /**
     * Get ProductItemCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProductItemCount()
    {
        return isset($this->ProductItemCount) ? $this->ProductItemCount : null;
    }
    /**
     * Set ProductItemCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $productItemCount
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setProductItemCount($productItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($productItemCount) && !(is_int($productItemCount) || ctype_digit($productItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productItemCount, true), gettype($productItemCount)), __LINE__);
        }
        if (is_null($productItemCount) || (is_array($productItemCount) && empty($productItemCount))) {
            unset($this->ProductItemCount);
        } else {
            $this->ProductItemCount = $productItemCount;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $referenceNumber
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get SaleModeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeId()
    {
        return isset($this->SaleModeId) ? $this->SaleModeId : null;
    }
    /**
     * Set SaleModeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeId
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setSaleModeId($saleModeId = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeId) && !is_string($saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeId, true), gettype($saleModeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeId, true)), __LINE__);
        }
        if (is_null($saleModeId) || (is_array($saleModeId) && empty($saleModeId))) {
            unset($this->SaleModeId);
        } else {
            $this->SaleModeId = $saleModeId;
        }
        return $this;
    }
    /**
     * Get SerializedTranState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerializedTranState()
    {
        return isset($this->SerializedTranState) ? $this->SerializedTranState : null;
    }
    /**
     * Set SerializedTranState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serializedTranState
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setSerializedTranState($serializedTranState = null)
    {
        // validation for constraint: string
        if (!is_null($serializedTranState) && !is_string($serializedTranState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serializedTranState, true), gettype($serializedTranState)), __LINE__);
        }
        if (is_null($serializedTranState) || (is_array($serializedTranState) && empty($serializedTranState))) {
            unset($this->SerializedTranState);
        } else {
            $this->SerializedTranState = $serializedTranState;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Sales_TransactionOnHold
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
