<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.PriceListPriceLevel StructType
 * @subpackage Structs
 */
class Sales_PriceListPriceLevel extends PersistableEntity
{
    /**
     * The AxisNames
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AxisNames;
    /**
     * The AxisNamesWithPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AxisNamesWithPrice;
    /**
     * The IsComputed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComputed;
    /**
     * The IsDisabled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDisabled;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Price;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceListPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListPriceTypeId;
    /**
     * Constructor method for Sales.PriceListPriceLevel
     * @uses Sales_PriceListPriceLevel::setAxisNames()
     * @uses Sales_PriceListPriceLevel::setAxisNamesWithPrice()
     * @uses Sales_PriceListPriceLevel::setIsComputed()
     * @uses Sales_PriceListPriceLevel::setIsDisabled()
     * @uses Sales_PriceListPriceLevel::setOrdinal()
     * @uses Sales_PriceListPriceLevel::setPrice()
     * @uses Sales_PriceListPriceLevel::setPriceLevelId()
     * @uses Sales_PriceListPriceLevel::setPriceListPriceTypeId()
     * @param string $axisNames
     * @param string $axisNamesWithPrice
     * @param bool $isComputed
     * @param bool $isDisabled
     * @param int $ordinal
     * @param float $price
     * @param string $priceLevelId
     * @param string $priceListPriceTypeId
     */
    public function __construct($axisNames = null, $axisNamesWithPrice = null, $isComputed = null, $isDisabled = null, $ordinal = null, $price = null, $priceLevelId = null, $priceListPriceTypeId = null)
    {
        $this
            ->setAxisNames($axisNames)
            ->setAxisNamesWithPrice($axisNamesWithPrice)
            ->setIsComputed($isComputed)
            ->setIsDisabled($isDisabled)
            ->setOrdinal($ordinal)
            ->setPrice($price)
            ->setPriceLevelId($priceLevelId)
            ->setPriceListPriceTypeId($priceListPriceTypeId);
    }
    /**
     * Get AxisNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxisNames()
    {
        return isset($this->AxisNames) ? $this->AxisNames : null;
    }
    /**
     * Set AxisNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axisNames
     * @return \patest\StructType\Sales_PriceListPriceLevel
     */
    public function setAxisNames($axisNames = null)
    {
        // validation for constraint: string
        if (!is_null($axisNames) && !is_string($axisNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axisNames, true), gettype($axisNames)), __LINE__);
        }
        if (is_null($axisNames) || (is_array($axisNames) && empty($axisNames))) {
            unset($this->AxisNames);
        } else {
            $this->AxisNames = $axisNames;
        }
        return $this;
    }
    /**
     * Get AxisNamesWithPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxisNamesWithPrice()
    {
        return isset($this->AxisNamesWithPrice) ? $this->AxisNamesWithPrice : null;
    }
    /**
     * Set AxisNamesWithPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axisNamesWithPrice
     * @return \patest\StructType\Sales_PriceListPriceLevel
     */
    public function setAxisNamesWithPrice($axisNamesWithPrice = null)
    {
        // validation for constraint: string
        if (!is_null($axisNamesWithPrice) && !is_string($axisNamesWithPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axisNamesWithPrice, true), gettype($axisNamesWithPrice)), __LINE__);
        }
        if (is_null($axisNamesWithPrice) || (is_array($axisNamesWithPrice) && empty($axisNamesWithPrice))) {
            unset($this->AxisNamesWithPrice);
        } else {
            $this->AxisNamesWithPrice = $axisNamesWithPrice;
        }
        return $this;
    }
    /**
     * Get IsComputed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComputed()
    {
        return isset($this->IsComputed) ? $this->IsComputed : null;
    }
    /**
     * Set IsComputed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComputed
     * @return \patest\StructType\Sales_PriceListPriceLevel
     */
    public function setIsComputed($isComputed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComputed) && !is_bool($isComputed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComputed, true), gettype($isComputed)), __LINE__);
        }
        if (is_null($isComputed) || (is_array($isComputed) && empty($isComputed))) {
            unset($this->IsComputed);
        } else {
            $this->IsComputed = $isComputed;
        }
        return $this;
    }
    /**
     * Get IsDisabled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDisabled()
    {
        return isset($this->IsDisabled) ? $this->IsDisabled : null;
    }
    /**
     * Set IsDisabled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDisabled
     * @return \patest\StructType\Sales_PriceListPriceLevel
     */
    public function setIsDisabled($isDisabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDisabled) && !is_bool($isDisabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDisabled, true), gettype($isDisabled)), __LINE__);
        }
        if (is_null($isDisabled) || (is_array($isDisabled) && empty($isDisabled))) {
            unset($this->IsDisabled);
        } else {
            $this->IsDisabled = $isDisabled;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Sales_PriceListPriceLevel
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price
     * @return \patest\StructType\Sales_PriceListPriceLevel
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Sales_PriceListPriceLevel
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceListPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListPriceTypeId()
    {
        return isset($this->PriceListPriceTypeId) ? $this->PriceListPriceTypeId : null;
    }
    /**
     * Set PriceListPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListPriceTypeId
     * @return \patest\StructType\Sales_PriceListPriceLevel
     */
    public function setPriceListPriceTypeId($priceListPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListPriceTypeId) && !is_string($priceListPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListPriceTypeId, true), gettype($priceListPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListPriceTypeId, true)), __LINE__);
        }
        if (is_null($priceListPriceTypeId) || (is_array($priceListPriceTypeId) && empty($priceListPriceTypeId))) {
            unset($this->PriceListPriceTypeId);
        } else {
            $this->PriceListPriceTypeId = $priceListPriceTypeId;
        }
        return $this;
    }
}
