<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.Item StructType
 * @subpackage Structs
 */
class Sales_Item extends PersistableEntity
{
    /**
     * The BackwardTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransactionId;
    /**
     * The BusinessFlow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessFlow;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CommissionsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CommissionsAmount;
    /**
     * The DeliveryItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DeliveryItemId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ECardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ECardId;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraFields;
    /**
     * The ExtraProductElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtraProductElementId;
    /**
     * The ForwardTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForwardTransactionId;
    /**
     * The IdInBackwardTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInBackwardTransaction;
    /**
     * The IdInForwardTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInForwardTransaction;
    /**
     * The IdInSupplierTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInSupplierTransaction;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The InvoiceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceId;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsExchangeable
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExchangeable;
    /**
     * The IsExtraProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExtraProduct;
    /**
     * The IsFictivePayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFictivePayment;
    /**
     * The IsRequiredByBasketContent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRequiredByBasketContent;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ListPrice;
    /**
     * The OrderIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_ItemOrder
     */
    public $OrderIdentity;
    /**
     * The OriginalPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalPriceTypeId;
    /**
     * The OriginSaleItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginSaleItemId;
    /**
     * The PaidPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidPrice;
    /**
     * The PartOfPromptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartOfPromptId;
    /**
     * The PriceEffectiveness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceEffectiveness;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_ItemPriceModifier
     */
    public $PriceModifiers;
    /**
     * The PriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceType;
    /**
     * The PricingVariationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PricingVariationId;
    /**
     * The RegularPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RegularPrice;
    /**
     * The RelatedPackageItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_PackageItemRelation
     */
    public $RelatedPackageItems;
    /**
     * The RequestedAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedAction;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The SalesRepresentativeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepresentativeId;
    /**
     * The SellerBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerBranchId;
    /**
     * The ServiceSpecificExtraField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceSpecificExtraField;
    /**
     * The ServiceSpecificHandle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ServiceSpecificHandle;
    /**
     * The ServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceSpecificId;
    /**
     * The SubsidizedByAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizedByAccountId;
    /**
     * The SubstitutedForItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_ExchangeAndUpdateItemRelation
     */
    public $SubstitutedForItemId;
    /**
     * The SupplierBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierBranchId;
    /**
     * The SupplierCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SupplierCompanyId;
    /**
     * The SupplierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierId;
    /**
     * The SupplierTransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierTransactionId;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TaxAmount;
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalPrice;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_ItemTotals
     */
    public $Totals;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionId;
    /**
     * Constructor method for Sales.Item
     * @uses Sales_Item::setBackwardTransactionId()
     * @uses Sales_Item::setBusinessFlow()
     * @uses Sales_Item::setClientId()
     * @uses Sales_Item::setCommissionsAmount()
     * @uses Sales_Item::setDeliveryItemId()
     * @uses Sales_Item::setDescription()
     * @uses Sales_Item::setECardId()
     * @uses Sales_Item::setExtraFields()
     * @uses Sales_Item::setExtraProductElementId()
     * @uses Sales_Item::setForwardTransactionId()
     * @uses Sales_Item::setIdInBackwardTransaction()
     * @uses Sales_Item::setIdInForwardTransaction()
     * @uses Sales_Item::setIdInSupplierTransaction()
     * @uses Sales_Item::setInsertionMode()
     * @uses Sales_Item::setInvoiceId()
     * @uses Sales_Item::setIsComplimentary()
     * @uses Sales_Item::setIsExchangeable()
     * @uses Sales_Item::setIsExtraProduct()
     * @uses Sales_Item::setIsFictivePayment()
     * @uses Sales_Item::setIsRequiredByBasketContent()
     * @uses Sales_Item::setItemId()
     * @uses Sales_Item::setItemType()
     * @uses Sales_Item::setListPrice()
     * @uses Sales_Item::setOrderIdentity()
     * @uses Sales_Item::setOriginalPriceTypeId()
     * @uses Sales_Item::setOriginSaleItemId()
     * @uses Sales_Item::setPaidPrice()
     * @uses Sales_Item::setPartOfPromptId()
     * @uses Sales_Item::setPriceEffectiveness()
     * @uses Sales_Item::setPriceModifiers()
     * @uses Sales_Item::setPriceType()
     * @uses Sales_Item::setPricingVariationId()
     * @uses Sales_Item::setRegularPrice()
     * @uses Sales_Item::setRelatedPackageItems()
     * @uses Sales_Item::setRequestedAction()
     * @uses Sales_Item::setReservationExpiryDate()
     * @uses Sales_Item::setSalesRepresentativeId()
     * @uses Sales_Item::setSellerBranchId()
     * @uses Sales_Item::setServiceSpecificExtraField()
     * @uses Sales_Item::setServiceSpecificHandle()
     * @uses Sales_Item::setServiceSpecificId()
     * @uses Sales_Item::setSubsidizedByAccountId()
     * @uses Sales_Item::setSubstitutedForItemId()
     * @uses Sales_Item::setSupplierBranchId()
     * @uses Sales_Item::setSupplierCompanyId()
     * @uses Sales_Item::setSupplierId()
     * @uses Sales_Item::setSupplierTransactionId()
     * @uses Sales_Item::setTaxAmount()
     * @uses Sales_Item::setTotalPrice()
     * @uses Sales_Item::setTotals()
     * @uses Sales_Item::setTransactionId()
     * @param string $backwardTransactionId
     * @param string $businessFlow
     * @param string $clientId
     * @param \patest\StructType\Money $commissionsAmount
     * @param int $deliveryItemId
     * @param string $description
     * @param string $eCardId
     * @param string $extraFields
     * @param string $extraProductElementId
     * @param string $forwardTransactionId
     * @param int $idInBackwardTransaction
     * @param int $idInForwardTransaction
     * @param int $idInSupplierTransaction
     * @param string $insertionMode
     * @param string $invoiceId
     * @param bool $isComplimentary
     * @param bool $isExchangeable
     * @param bool $isExtraProduct
     * @param bool $isFictivePayment
     * @param bool $isRequiredByBasketContent
     * @param int $itemId
     * @param int $itemType
     * @param \patest\StructType\Money $listPrice
     * @param \patest\StructType\Sales_ItemOrder $orderIdentity
     * @param string $originalPriceTypeId
     * @param string $originSaleItemId
     * @param \patest\StructType\Money $paidPrice
     * @param string $partOfPromptId
     * @param string $priceEffectiveness
     * @param \patest\StructType\RecordSetOfSales_ItemPriceModifier $priceModifiers
     * @param string $priceType
     * @param int $pricingVariationId
     * @param \patest\StructType\Money $regularPrice
     * @param \patest\StructType\RecordSetOfSales_PackageItemRelation $relatedPackageItems
     * @param string $requestedAction
     * @param string $reservationExpiryDate
     * @param string $salesRepresentativeId
     * @param string $sellerBranchId
     * @param string $serviceSpecificExtraField
     * @param int $serviceSpecificHandle
     * @param string $serviceSpecificId
     * @param string $subsidizedByAccountId
     * @param \patest\StructType\Sales_ExchangeAndUpdateItemRelation $substitutedForItemId
     * @param string $supplierBranchId
     * @param int $supplierCompanyId
     * @param string $supplierId
     * @param string $supplierTransactionId
     * @param \patest\StructType\Money $taxAmount
     * @param \patest\StructType\Money $totalPrice
     * @param \patest\StructType\Sales_ItemTotals $totals
     * @param int $transactionId
     */
    public function __construct($backwardTransactionId = null, $businessFlow = null, $clientId = null, \patest\StructType\Money $commissionsAmount = null, $deliveryItemId = null, $description = null, $eCardId = null, $extraFields = null, $extraProductElementId = null, $forwardTransactionId = null, $idInBackwardTransaction = null, $idInForwardTransaction = null, $idInSupplierTransaction = null, $insertionMode = null, $invoiceId = null, $isComplimentary = null, $isExchangeable = null, $isExtraProduct = null, $isFictivePayment = null, $isRequiredByBasketContent = null, $itemId = null, $itemType = null, \patest\StructType\Money $listPrice = null, \patest\StructType\Sales_ItemOrder $orderIdentity = null, $originalPriceTypeId = null, $originSaleItemId = null, \patest\StructType\Money $paidPrice = null, $partOfPromptId = null, $priceEffectiveness = null, \patest\StructType\RecordSetOfSales_ItemPriceModifier $priceModifiers = null, $priceType = null, $pricingVariationId = null, \patest\StructType\Money $regularPrice = null, \patest\StructType\RecordSetOfSales_PackageItemRelation $relatedPackageItems = null, $requestedAction = null, $reservationExpiryDate = null, $salesRepresentativeId = null, $sellerBranchId = null, $serviceSpecificExtraField = null, $serviceSpecificHandle = null, $serviceSpecificId = null, $subsidizedByAccountId = null, \patest\StructType\Sales_ExchangeAndUpdateItemRelation $substitutedForItemId = null, $supplierBranchId = null, $supplierCompanyId = null, $supplierId = null, $supplierTransactionId = null, \patest\StructType\Money $taxAmount = null, \patest\StructType\Money $totalPrice = null, \patest\StructType\Sales_ItemTotals $totals = null, $transactionId = null)
    {
        $this
            ->setBackwardTransactionId($backwardTransactionId)
            ->setBusinessFlow($businessFlow)
            ->setClientId($clientId)
            ->setCommissionsAmount($commissionsAmount)
            ->setDeliveryItemId($deliveryItemId)
            ->setDescription($description)
            ->setECardId($eCardId)
            ->setExtraFields($extraFields)
            ->setExtraProductElementId($extraProductElementId)
            ->setForwardTransactionId($forwardTransactionId)
            ->setIdInBackwardTransaction($idInBackwardTransaction)
            ->setIdInForwardTransaction($idInForwardTransaction)
            ->setIdInSupplierTransaction($idInSupplierTransaction)
            ->setInsertionMode($insertionMode)
            ->setInvoiceId($invoiceId)
            ->setIsComplimentary($isComplimentary)
            ->setIsExchangeable($isExchangeable)
            ->setIsExtraProduct($isExtraProduct)
            ->setIsFictivePayment($isFictivePayment)
            ->setIsRequiredByBasketContent($isRequiredByBasketContent)
            ->setItemId($itemId)
            ->setItemType($itemType)
            ->setListPrice($listPrice)
            ->setOrderIdentity($orderIdentity)
            ->setOriginalPriceTypeId($originalPriceTypeId)
            ->setOriginSaleItemId($originSaleItemId)
            ->setPaidPrice($paidPrice)
            ->setPartOfPromptId($partOfPromptId)
            ->setPriceEffectiveness($priceEffectiveness)
            ->setPriceModifiers($priceModifiers)
            ->setPriceType($priceType)
            ->setPricingVariationId($pricingVariationId)
            ->setRegularPrice($regularPrice)
            ->setRelatedPackageItems($relatedPackageItems)
            ->setRequestedAction($requestedAction)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setSalesRepresentativeId($salesRepresentativeId)
            ->setSellerBranchId($sellerBranchId)
            ->setServiceSpecificExtraField($serviceSpecificExtraField)
            ->setServiceSpecificHandle($serviceSpecificHandle)
            ->setServiceSpecificId($serviceSpecificId)
            ->setSubsidizedByAccountId($subsidizedByAccountId)
            ->setSubstitutedForItemId($substitutedForItemId)
            ->setSupplierBranchId($supplierBranchId)
            ->setSupplierCompanyId($supplierCompanyId)
            ->setSupplierId($supplierId)
            ->setSupplierTransactionId($supplierTransactionId)
            ->setTaxAmount($taxAmount)
            ->setTotalPrice($totalPrice)
            ->setTotals($totals)
            ->setTransactionId($transactionId);
    }
    /**
     * Get BackwardTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransactionId()
    {
        return isset($this->BackwardTransactionId) ? $this->BackwardTransactionId : null;
    }
    /**
     * Set BackwardTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransactionId
     * @return \patest\StructType\Sales_Item
     */
    public function setBackwardTransactionId($backwardTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransactionId) && !is_string($backwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransactionId, true), gettype($backwardTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransactionId, true)), __LINE__);
        }
        if (is_null($backwardTransactionId) || (is_array($backwardTransactionId) && empty($backwardTransactionId))) {
            unset($this->BackwardTransactionId);
        } else {
            $this->BackwardTransactionId = $backwardTransactionId;
        }
        return $this;
    }
    /**
     * Get BusinessFlow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessFlow()
    {
        return isset($this->BusinessFlow) ? $this->BusinessFlow : null;
    }
    /**
     * Set BusinessFlow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessFlow
     * @return \patest\StructType\Sales_Item
     */
    public function setBusinessFlow($businessFlow = null)
    {
        // validation for constraint: string
        if (!is_null($businessFlow) && !is_string($businessFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessFlow, true), gettype($businessFlow)), __LINE__);
        }
        if (is_null($businessFlow) || (is_array($businessFlow) && empty($businessFlow))) {
            unset($this->BusinessFlow);
        } else {
            $this->BusinessFlow = $businessFlow;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_Item
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CommissionsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCommissionsAmount()
    {
        return isset($this->CommissionsAmount) ? $this->CommissionsAmount : null;
    }
    /**
     * Set CommissionsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $commissionsAmount
     * @return \patest\StructType\Sales_Item
     */
    public function setCommissionsAmount(\patest\StructType\Money $commissionsAmount = null)
    {
        if (is_null($commissionsAmount) || (is_array($commissionsAmount) && empty($commissionsAmount))) {
            unset($this->CommissionsAmount);
        } else {
            $this->CommissionsAmount = $commissionsAmount;
        }
        return $this;
    }
    /**
     * Get DeliveryItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDeliveryItemId()
    {
        return isset($this->DeliveryItemId) ? $this->DeliveryItemId : null;
    }
    /**
     * Set DeliveryItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $deliveryItemId
     * @return \patest\StructType\Sales_Item
     */
    public function setDeliveryItemId($deliveryItemId = null)
    {
        // validation for constraint: int
        if (!is_null($deliveryItemId) && !(is_int($deliveryItemId) || ctype_digit($deliveryItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($deliveryItemId, true), gettype($deliveryItemId)), __LINE__);
        }
        if (is_null($deliveryItemId) || (is_array($deliveryItemId) && empty($deliveryItemId))) {
            unset($this->DeliveryItemId);
        } else {
            $this->DeliveryItemId = $deliveryItemId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Sales_Item
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ECardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECardId()
    {
        return isset($this->ECardId) ? $this->ECardId : null;
    }
    /**
     * Set ECardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCardId
     * @return \patest\StructType\Sales_Item
     */
    public function setECardId($eCardId = null)
    {
        // validation for constraint: string
        if (!is_null($eCardId) && !is_string($eCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCardId, true), gettype($eCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eCardId, true)), __LINE__);
        }
        if (is_null($eCardId) || (is_array($eCardId) && empty($eCardId))) {
            unset($this->ECardId);
        } else {
            $this->ECardId = $eCardId;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraFields
     * @return \patest\StructType\Sales_Item
     */
    public function setExtraFields($extraFields = null)
    {
        // validation for constraint: string
        if (!is_null($extraFields) && !is_string($extraFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraFields, true), gettype($extraFields)), __LINE__);
        }
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get ExtraProductElementId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraProductElementId()
    {
        return isset($this->ExtraProductElementId) ? $this->ExtraProductElementId : null;
    }
    /**
     * Set ExtraProductElementId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraProductElementId
     * @return \patest\StructType\Sales_Item
     */
    public function setExtraProductElementId($extraProductElementId = null)
    {
        // validation for constraint: string
        if (!is_null($extraProductElementId) && !is_string($extraProductElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraProductElementId, true), gettype($extraProductElementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extraProductElementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extraProductElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extraProductElementId, true)), __LINE__);
        }
        if (is_null($extraProductElementId) || (is_array($extraProductElementId) && empty($extraProductElementId))) {
            unset($this->ExtraProductElementId);
        } else {
            $this->ExtraProductElementId = $extraProductElementId;
        }
        return $this;
    }
    /**
     * Get ForwardTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForwardTransactionId()
    {
        return isset($this->ForwardTransactionId) ? $this->ForwardTransactionId : null;
    }
    /**
     * Set ForwardTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forwardTransactionId
     * @return \patest\StructType\Sales_Item
     */
    public function setForwardTransactionId($forwardTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($forwardTransactionId) && !is_string($forwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardTransactionId, true), gettype($forwardTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($forwardTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $forwardTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($forwardTransactionId, true)), __LINE__);
        }
        if (is_null($forwardTransactionId) || (is_array($forwardTransactionId) && empty($forwardTransactionId))) {
            unset($this->ForwardTransactionId);
        } else {
            $this->ForwardTransactionId = $forwardTransactionId;
        }
        return $this;
    }
    /**
     * Get IdInBackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInBackwardTransaction()
    {
        return isset($this->IdInBackwardTransaction) ? $this->IdInBackwardTransaction : null;
    }
    /**
     * Set IdInBackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInBackwardTransaction
     * @return \patest\StructType\Sales_Item
     */
    public function setIdInBackwardTransaction($idInBackwardTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInBackwardTransaction) && !(is_int($idInBackwardTransaction) || ctype_digit($idInBackwardTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInBackwardTransaction, true), gettype($idInBackwardTransaction)), __LINE__);
        }
        if (is_null($idInBackwardTransaction) || (is_array($idInBackwardTransaction) && empty($idInBackwardTransaction))) {
            unset($this->IdInBackwardTransaction);
        } else {
            $this->IdInBackwardTransaction = $idInBackwardTransaction;
        }
        return $this;
    }
    /**
     * Get IdInForwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInForwardTransaction()
    {
        return isset($this->IdInForwardTransaction) ? $this->IdInForwardTransaction : null;
    }
    /**
     * Set IdInForwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInForwardTransaction
     * @return \patest\StructType\Sales_Item
     */
    public function setIdInForwardTransaction($idInForwardTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInForwardTransaction) && !(is_int($idInForwardTransaction) || ctype_digit($idInForwardTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInForwardTransaction, true), gettype($idInForwardTransaction)), __LINE__);
        }
        if (is_null($idInForwardTransaction) || (is_array($idInForwardTransaction) && empty($idInForwardTransaction))) {
            unset($this->IdInForwardTransaction);
        } else {
            $this->IdInForwardTransaction = $idInForwardTransaction;
        }
        return $this;
    }
    /**
     * Get IdInSupplierTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInSupplierTransaction()
    {
        return isset($this->IdInSupplierTransaction) ? $this->IdInSupplierTransaction : null;
    }
    /**
     * Set IdInSupplierTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInSupplierTransaction
     * @return \patest\StructType\Sales_Item
     */
    public function setIdInSupplierTransaction($idInSupplierTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInSupplierTransaction) && !(is_int($idInSupplierTransaction) || ctype_digit($idInSupplierTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInSupplierTransaction, true), gettype($idInSupplierTransaction)), __LINE__);
        }
        if (is_null($idInSupplierTransaction) || (is_array($idInSupplierTransaction) && empty($idInSupplierTransaction))) {
            unset($this->IdInSupplierTransaction);
        } else {
            $this->IdInSupplierTransaction = $idInSupplierTransaction;
        }
        return $this;
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Sales_Item
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get InvoiceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceId()
    {
        return isset($this->InvoiceId) ? $this->InvoiceId : null;
    }
    /**
     * Set InvoiceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceId
     * @return \patest\StructType\Sales_Item
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceId, true), gettype($invoiceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceId, true)), __LINE__);
        }
        if (is_null($invoiceId) || (is_array($invoiceId) && empty($invoiceId))) {
            unset($this->InvoiceId);
        } else {
            $this->InvoiceId = $invoiceId;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Sales_Item
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsExchangeable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExchangeable()
    {
        return isset($this->IsExchangeable) ? $this->IsExchangeable : null;
    }
    /**
     * Set IsExchangeable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExchangeable
     * @return \patest\StructType\Sales_Item
     */
    public function setIsExchangeable($isExchangeable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExchangeable) && !is_bool($isExchangeable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExchangeable, true), gettype($isExchangeable)), __LINE__);
        }
        if (is_null($isExchangeable) || (is_array($isExchangeable) && empty($isExchangeable))) {
            unset($this->IsExchangeable);
        } else {
            $this->IsExchangeable = $isExchangeable;
        }
        return $this;
    }
    /**
     * Get IsExtraProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExtraProduct()
    {
        return isset($this->IsExtraProduct) ? $this->IsExtraProduct : null;
    }
    /**
     * Set IsExtraProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExtraProduct
     * @return \patest\StructType\Sales_Item
     */
    public function setIsExtraProduct($isExtraProduct = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtraProduct) && !is_bool($isExtraProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtraProduct, true), gettype($isExtraProduct)), __LINE__);
        }
        if (is_null($isExtraProduct) || (is_array($isExtraProduct) && empty($isExtraProduct))) {
            unset($this->IsExtraProduct);
        } else {
            $this->IsExtraProduct = $isExtraProduct;
        }
        return $this;
    }
    /**
     * Get IsFictivePayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFictivePayment()
    {
        return isset($this->IsFictivePayment) ? $this->IsFictivePayment : null;
    }
    /**
     * Set IsFictivePayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFictivePayment
     * @return \patest\StructType\Sales_Item
     */
    public function setIsFictivePayment($isFictivePayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFictivePayment) && !is_bool($isFictivePayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFictivePayment, true), gettype($isFictivePayment)), __LINE__);
        }
        if (is_null($isFictivePayment) || (is_array($isFictivePayment) && empty($isFictivePayment))) {
            unset($this->IsFictivePayment);
        } else {
            $this->IsFictivePayment = $isFictivePayment;
        }
        return $this;
    }
    /**
     * Get IsRequiredByBasketContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRequiredByBasketContent()
    {
        return isset($this->IsRequiredByBasketContent) ? $this->IsRequiredByBasketContent : null;
    }
    /**
     * Set IsRequiredByBasketContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRequiredByBasketContent
     * @return \patest\StructType\Sales_Item
     */
    public function setIsRequiredByBasketContent($isRequiredByBasketContent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRequiredByBasketContent) && !is_bool($isRequiredByBasketContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRequiredByBasketContent, true), gettype($isRequiredByBasketContent)), __LINE__);
        }
        if (is_null($isRequiredByBasketContent) || (is_array($isRequiredByBasketContent) && empty($isRequiredByBasketContent))) {
            unset($this->IsRequiredByBasketContent);
        } else {
            $this->IsRequiredByBasketContent = $isRequiredByBasketContent;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Sales_Item
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Sales_Item
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get ListPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getListPrice()
    {
        return isset($this->ListPrice) ? $this->ListPrice : null;
    }
    /**
     * Set ListPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $listPrice
     * @return \patest\StructType\Sales_Item
     */
    public function setListPrice(\patest\StructType\Money $listPrice = null)
    {
        if (is_null($listPrice) || (is_array($listPrice) && empty($listPrice))) {
            unset($this->ListPrice);
        } else {
            $this->ListPrice = $listPrice;
        }
        return $this;
    }
    /**
     * Get OrderIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_ItemOrder|null
     */
    public function getOrderIdentity()
    {
        return isset($this->OrderIdentity) ? $this->OrderIdentity : null;
    }
    /**
     * Set OrderIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_ItemOrder $orderIdentity
     * @return \patest\StructType\Sales_Item
     */
    public function setOrderIdentity(\patest\StructType\Sales_ItemOrder $orderIdentity = null)
    {
        if (is_null($orderIdentity) || (is_array($orderIdentity) && empty($orderIdentity))) {
            unset($this->OrderIdentity);
        } else {
            $this->OrderIdentity = $orderIdentity;
        }
        return $this;
    }
    /**
     * Get OriginalPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPriceTypeId()
    {
        return isset($this->OriginalPriceTypeId) ? $this->OriginalPriceTypeId : null;
    }
    /**
     * Set OriginalPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPriceTypeId
     * @return \patest\StructType\Sales_Item
     */
    public function setOriginalPriceTypeId($originalPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($originalPriceTypeId) && !is_string($originalPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPriceTypeId, true), gettype($originalPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalPriceTypeId, true)), __LINE__);
        }
        if (is_null($originalPriceTypeId) || (is_array($originalPriceTypeId) && empty($originalPriceTypeId))) {
            unset($this->OriginalPriceTypeId);
        } else {
            $this->OriginalPriceTypeId = $originalPriceTypeId;
        }
        return $this;
    }
    /**
     * Get OriginSaleItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginSaleItemId()
    {
        return isset($this->OriginSaleItemId) ? $this->OriginSaleItemId : null;
    }
    /**
     * Set OriginSaleItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originSaleItemId
     * @return \patest\StructType\Sales_Item
     */
    public function setOriginSaleItemId($originSaleItemId = null)
    {
        // validation for constraint: string
        if (!is_null($originSaleItemId) && !is_string($originSaleItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originSaleItemId, true), gettype($originSaleItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originSaleItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originSaleItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originSaleItemId, true)), __LINE__);
        }
        if (is_null($originSaleItemId) || (is_array($originSaleItemId) && empty($originSaleItemId))) {
            unset($this->OriginSaleItemId);
        } else {
            $this->OriginSaleItemId = $originSaleItemId;
        }
        return $this;
    }
    /**
     * Get PaidPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidPrice()
    {
        return isset($this->PaidPrice) ? $this->PaidPrice : null;
    }
    /**
     * Set PaidPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidPrice
     * @return \patest\StructType\Sales_Item
     */
    public function setPaidPrice(\patest\StructType\Money $paidPrice = null)
    {
        if (is_null($paidPrice) || (is_array($paidPrice) && empty($paidPrice))) {
            unset($this->PaidPrice);
        } else {
            $this->PaidPrice = $paidPrice;
        }
        return $this;
    }
    /**
     * Get PartOfPromptId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartOfPromptId()
    {
        return isset($this->PartOfPromptId) ? $this->PartOfPromptId : null;
    }
    /**
     * Set PartOfPromptId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partOfPromptId
     * @return \patest\StructType\Sales_Item
     */
    public function setPartOfPromptId($partOfPromptId = null)
    {
        // validation for constraint: string
        if (!is_null($partOfPromptId) && !is_string($partOfPromptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partOfPromptId, true), gettype($partOfPromptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partOfPromptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partOfPromptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partOfPromptId, true)), __LINE__);
        }
        if (is_null($partOfPromptId) || (is_array($partOfPromptId) && empty($partOfPromptId))) {
            unset($this->PartOfPromptId);
        } else {
            $this->PartOfPromptId = $partOfPromptId;
        }
        return $this;
    }
    /**
     * Get PriceEffectiveness value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceEffectiveness()
    {
        return isset($this->PriceEffectiveness) ? $this->PriceEffectiveness : null;
    }
    /**
     * Set PriceEffectiveness value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ProductItemPriceEffectiveness::valueIsValid()
     * @uses \patest\EnumType\ProductItemPriceEffectiveness::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $priceEffectiveness
     * @return \patest\StructType\Sales_Item
     */
    public function setPriceEffectiveness($priceEffectiveness = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProductItemPriceEffectiveness::valueIsValid($priceEffectiveness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProductItemPriceEffectiveness', is_array($priceEffectiveness) ? implode(', ', $priceEffectiveness) : var_export($priceEffectiveness, true), implode(', ', \patest\EnumType\ProductItemPriceEffectiveness::getValidValues())), __LINE__);
        }
        if (is_null($priceEffectiveness) || (is_array($priceEffectiveness) && empty($priceEffectiveness))) {
            unset($this->PriceEffectiveness);
        } else {
            $this->PriceEffectiveness = $priceEffectiveness;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_ItemPriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_ItemPriceModifier $priceModifiers
     * @return \patest\StructType\Sales_Item
     */
    public function setPriceModifiers(\patest\StructType\RecordSetOfSales_ItemPriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get PriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceType()
    {
        return isset($this->PriceType) ? $this->PriceType : null;
    }
    /**
     * Set PriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceType
     * @return \patest\StructType\Sales_Item
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: string
        if (!is_null($priceType) && !is_string($priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceType, true), gettype($priceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceType, true)), __LINE__);
        }
        if (is_null($priceType) || (is_array($priceType) && empty($priceType))) {
            unset($this->PriceType);
        } else {
            $this->PriceType = $priceType;
        }
        return $this;
    }
    /**
     * Get PricingVariationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPricingVariationId()
    {
        return isset($this->PricingVariationId) ? $this->PricingVariationId : null;
    }
    /**
     * Set PricingVariationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pricingVariationId
     * @return \patest\StructType\Sales_Item
     */
    public function setPricingVariationId($pricingVariationId = null)
    {
        // validation for constraint: int
        if (!is_null($pricingVariationId) && !(is_int($pricingVariationId) || ctype_digit($pricingVariationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingVariationId, true), gettype($pricingVariationId)), __LINE__);
        }
        if (is_null($pricingVariationId) || (is_array($pricingVariationId) && empty($pricingVariationId))) {
            unset($this->PricingVariationId);
        } else {
            $this->PricingVariationId = $pricingVariationId;
        }
        return $this;
    }
    /**
     * Get RegularPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRegularPrice()
    {
        return isset($this->RegularPrice) ? $this->RegularPrice : null;
    }
    /**
     * Set RegularPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $regularPrice
     * @return \patest\StructType\Sales_Item
     */
    public function setRegularPrice(\patest\StructType\Money $regularPrice = null)
    {
        if (is_null($regularPrice) || (is_array($regularPrice) && empty($regularPrice))) {
            unset($this->RegularPrice);
        } else {
            $this->RegularPrice = $regularPrice;
        }
        return $this;
    }
    /**
     * Get RelatedPackageItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_PackageItemRelation|null
     */
    public function getRelatedPackageItems()
    {
        return isset($this->RelatedPackageItems) ? $this->RelatedPackageItems : null;
    }
    /**
     * Set RelatedPackageItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_PackageItemRelation $relatedPackageItems
     * @return \patest\StructType\Sales_Item
     */
    public function setRelatedPackageItems(\patest\StructType\RecordSetOfSales_PackageItemRelation $relatedPackageItems = null)
    {
        if (is_null($relatedPackageItems) || (is_array($relatedPackageItems) && empty($relatedPackageItems))) {
            unset($this->RelatedPackageItems);
        } else {
            $this->RelatedPackageItems = $relatedPackageItems;
        }
        return $this;
    }
    /**
     * Get RequestedAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedAction()
    {
        return isset($this->RequestedAction) ? $this->RequestedAction : null;
    }
    /**
     * Set RequestedAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemRequestedAction::valueIsValid()
     * @uses \patest\EnumType\ItemRequestedAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedAction
     * @return \patest\StructType\Sales_Item
     */
    public function setRequestedAction($requestedAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemRequestedAction::valueIsValid($requestedAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemRequestedAction', is_array($requestedAction) ? implode(', ', $requestedAction) : var_export($requestedAction, true), implode(', ', \patest\EnumType\ItemRequestedAction::getValidValues())), __LINE__);
        }
        if (is_null($requestedAction) || (is_array($requestedAction) && empty($requestedAction))) {
            unset($this->RequestedAction);
        } else {
            $this->RequestedAction = $requestedAction;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\Sales_Item
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get SalesRepresentativeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepresentativeId()
    {
        return isset($this->SalesRepresentativeId) ? $this->SalesRepresentativeId : null;
    }
    /**
     * Set SalesRepresentativeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepresentativeId
     * @return \patest\StructType\Sales_Item
     */
    public function setSalesRepresentativeId($salesRepresentativeId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepresentativeId) && !is_string($salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepresentativeId, true), gettype($salesRepresentativeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepresentativeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepresentativeId, true)), __LINE__);
        }
        if (is_null($salesRepresentativeId) || (is_array($salesRepresentativeId) && empty($salesRepresentativeId))) {
            unset($this->SalesRepresentativeId);
        } else {
            $this->SalesRepresentativeId = $salesRepresentativeId;
        }
        return $this;
    }
    /**
     * Get SellerBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerBranchId()
    {
        return isset($this->SellerBranchId) ? $this->SellerBranchId : null;
    }
    /**
     * Set SellerBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerBranchId
     * @return \patest\StructType\Sales_Item
     */
    public function setSellerBranchId($sellerBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerBranchId) && !is_string($sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerBranchId, true), gettype($sellerBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerBranchId, true)), __LINE__);
        }
        if (is_null($sellerBranchId) || (is_array($sellerBranchId) && empty($sellerBranchId))) {
            unset($this->SellerBranchId);
        } else {
            $this->SellerBranchId = $sellerBranchId;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificExtraField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificExtraField()
    {
        return isset($this->ServiceSpecificExtraField) ? $this->ServiceSpecificExtraField : null;
    }
    /**
     * Set ServiceSpecificExtraField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificExtraField
     * @return \patest\StructType\Sales_Item
     */
    public function setServiceSpecificExtraField($serviceSpecificExtraField = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificExtraField) && !is_string($serviceSpecificExtraField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificExtraField, true), gettype($serviceSpecificExtraField)), __LINE__);
        }
        if (is_null($serviceSpecificExtraField) || (is_array($serviceSpecificExtraField) && empty($serviceSpecificExtraField))) {
            unset($this->ServiceSpecificExtraField);
        } else {
            $this->ServiceSpecificExtraField = $serviceSpecificExtraField;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificHandle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getServiceSpecificHandle()
    {
        return isset($this->ServiceSpecificHandle) ? $this->ServiceSpecificHandle : null;
    }
    /**
     * Set ServiceSpecificHandle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $serviceSpecificHandle
     * @return \patest\StructType\Sales_Item
     */
    public function setServiceSpecificHandle($serviceSpecificHandle = null)
    {
        // validation for constraint: int
        if (!is_null($serviceSpecificHandle) && !(is_int($serviceSpecificHandle) || ctype_digit($serviceSpecificHandle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($serviceSpecificHandle, true), gettype($serviceSpecificHandle)), __LINE__);
        }
        if (is_null($serviceSpecificHandle) || (is_array($serviceSpecificHandle) && empty($serviceSpecificHandle))) {
            unset($this->ServiceSpecificHandle);
        } else {
            $this->ServiceSpecificHandle = $serviceSpecificHandle;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceSpecificId()
    {
        return isset($this->ServiceSpecificId) ? $this->ServiceSpecificId : null;
    }
    /**
     * Set ServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceSpecificId
     * @return \patest\StructType\Sales_Item
     */
    public function setServiceSpecificId($serviceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceSpecificId) && !is_string($serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceSpecificId, true), gettype($serviceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceSpecificId, true)), __LINE__);
        }
        if (is_null($serviceSpecificId) || (is_array($serviceSpecificId) && empty($serviceSpecificId))) {
            unset($this->ServiceSpecificId);
        } else {
            $this->ServiceSpecificId = $serviceSpecificId;
        }
        return $this;
    }
    /**
     * Get SubsidizedByAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizedByAccountId()
    {
        return isset($this->SubsidizedByAccountId) ? $this->SubsidizedByAccountId : null;
    }
    /**
     * Set SubsidizedByAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizedByAccountId
     * @return \patest\StructType\Sales_Item
     */
    public function setSubsidizedByAccountId($subsidizedByAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizedByAccountId) && !is_string($subsidizedByAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizedByAccountId, true), gettype($subsidizedByAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizedByAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizedByAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizedByAccountId, true)), __LINE__);
        }
        if (is_null($subsidizedByAccountId) || (is_array($subsidizedByAccountId) && empty($subsidizedByAccountId))) {
            unset($this->SubsidizedByAccountId);
        } else {
            $this->SubsidizedByAccountId = $subsidizedByAccountId;
        }
        return $this;
    }
    /**
     * Get SubstitutedForItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_ExchangeAndUpdateItemRelation|null
     */
    public function getSubstitutedForItemId()
    {
        return isset($this->SubstitutedForItemId) ? $this->SubstitutedForItemId : null;
    }
    /**
     * Set SubstitutedForItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_ExchangeAndUpdateItemRelation $substitutedForItemId
     * @return \patest\StructType\Sales_Item
     */
    public function setSubstitutedForItemId(\patest\StructType\Sales_ExchangeAndUpdateItemRelation $substitutedForItemId = null)
    {
        if (is_null($substitutedForItemId) || (is_array($substitutedForItemId) && empty($substitutedForItemId))) {
            unset($this->SubstitutedForItemId);
        } else {
            $this->SubstitutedForItemId = $substitutedForItemId;
        }
        return $this;
    }
    /**
     * Get SupplierBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierBranchId()
    {
        return isset($this->SupplierBranchId) ? $this->SupplierBranchId : null;
    }
    /**
     * Set SupplierBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierBranchId
     * @return \patest\StructType\Sales_Item
     */
    public function setSupplierBranchId($supplierBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierBranchId) && !is_string($supplierBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierBranchId, true), gettype($supplierBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierBranchId, true)), __LINE__);
        }
        if (is_null($supplierBranchId) || (is_array($supplierBranchId) && empty($supplierBranchId))) {
            unset($this->SupplierBranchId);
        } else {
            $this->SupplierBranchId = $supplierBranchId;
        }
        return $this;
    }
    /**
     * Get SupplierCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSupplierCompanyId()
    {
        return isset($this->SupplierCompanyId) ? $this->SupplierCompanyId : null;
    }
    /**
     * Set SupplierCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $supplierCompanyId
     * @return \patest\StructType\Sales_Item
     */
    public function setSupplierCompanyId($supplierCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($supplierCompanyId) && !(is_int($supplierCompanyId) || ctype_digit($supplierCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($supplierCompanyId, true), gettype($supplierCompanyId)), __LINE__);
        }
        if (is_null($supplierCompanyId) || (is_array($supplierCompanyId) && empty($supplierCompanyId))) {
            unset($this->SupplierCompanyId);
        } else {
            $this->SupplierCompanyId = $supplierCompanyId;
        }
        return $this;
    }
    /**
     * Get SupplierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierId()
    {
        return isset($this->SupplierId) ? $this->SupplierId : null;
    }
    /**
     * Set SupplierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierId
     * @return \patest\StructType\Sales_Item
     */
    public function setSupplierId($supplierId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierId) && !is_string($supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierId, true), gettype($supplierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierId, true)), __LINE__);
        }
        if (is_null($supplierId) || (is_array($supplierId) && empty($supplierId))) {
            unset($this->SupplierId);
        } else {
            $this->SupplierId = $supplierId;
        }
        return $this;
    }
    /**
     * Get SupplierTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierTransactionId()
    {
        return isset($this->SupplierTransactionId) ? $this->SupplierTransactionId : null;
    }
    /**
     * Set SupplierTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierTransactionId
     * @return \patest\StructType\Sales_Item
     */
    public function setSupplierTransactionId($supplierTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierTransactionId) && !is_string($supplierTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierTransactionId, true), gettype($supplierTransactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierTransactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierTransactionId, true)), __LINE__);
        }
        if (is_null($supplierTransactionId) || (is_array($supplierTransactionId) && empty($supplierTransactionId))) {
            unset($this->SupplierTransactionId);
        } else {
            $this->SupplierTransactionId = $supplierTransactionId;
        }
        return $this;
    }
    /**
     * Get TaxAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTaxAmount()
    {
        return isset($this->TaxAmount) ? $this->TaxAmount : null;
    }
    /**
     * Set TaxAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $taxAmount
     * @return \patest\StructType\Sales_Item
     */
    public function setTaxAmount(\patest\StructType\Money $taxAmount = null)
    {
        if (is_null($taxAmount) || (is_array($taxAmount) && empty($taxAmount))) {
            unset($this->TaxAmount);
        } else {
            $this->TaxAmount = $taxAmount;
        }
        return $this;
    }
    /**
     * Get TotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalPrice()
    {
        return isset($this->TotalPrice) ? $this->TotalPrice : null;
    }
    /**
     * Set TotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalPrice
     * @return \patest\StructType\Sales_Item
     */
    public function setTotalPrice(\patest\StructType\Money $totalPrice = null)
    {
        if (is_null($totalPrice) || (is_array($totalPrice) && empty($totalPrice))) {
            unset($this->TotalPrice);
        } else {
            $this->TotalPrice = $totalPrice;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_ItemTotals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_ItemTotals $totals
     * @return \patest\StructType\Sales_Item
     */
    public function setTotals(\patest\StructType\Sales_ItemTotals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionId
     * @return \patest\StructType\Sales_Item
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionId) && !(is_int($transactionId) || ctype_digit($transactionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
