<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.Invoice StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Sales.Invoice
 * @subpackage Structs
 */
class Sales_Invoice extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CoveredByReturnsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CoveredByReturnsAmount;
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The CurrentPaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CurrentPaidAmount;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentType;
    /**
     * The GlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalNumber;
    /**
     * The IsFinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFinal;
    /**
     * The IsFullDeducted
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFullDeducted;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinted;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_InvoiceItemRecord
     */
    public $Items;
    /**
     * The ItemsGroupRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_InvoiceItemsGroupRecord
     */
    public $ItemsGroupRecords;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The PayDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayDate;
    /**
     * The PaymentTermId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTermId;
    /**
     * The PaymentTermName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentTermName;
    /**
     * The PrintedDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedDateTime;
    /**
     * The RefundDueAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RefundDueAmount;
    /**
     * The RefundPaidAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RefundPaidAmount;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RemainingAmount;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The TotalAmountNeto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmountNeto;
    /**
     * The TotalInsideCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalInsideCommissionAmount;
    /**
     * The TotalInsuranceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalInsuranceAmount;
    /**
     * The TotalTransactionCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTransactionCommissionAmount;
    /**
     * The TotalVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalVatAmount;
    /**
     * The TransactionCommissions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_InvoiceTransactionCommission
     */
    public $TransactionCommissions;
    /**
     * Constructor method for Sales.Invoice
     * @uses Sales_Invoice::setClientId()
     * @uses Sales_Invoice::setCoveredByReturnsAmount()
     * @uses Sales_Invoice::setCreationAuditId()
     * @uses Sales_Invoice::setCreationDateTime()
     * @uses Sales_Invoice::setCurrentPaidAmount()
     * @uses Sales_Invoice::setDocumentType()
     * @uses Sales_Invoice::setGlobalNumber()
     * @uses Sales_Invoice::setIsFinal()
     * @uses Sales_Invoice::setIsFullDeducted()
     * @uses Sales_Invoice::setIsPrinted()
     * @uses Sales_Invoice::setItems()
     * @uses Sales_Invoice::setItemsGroupRecords()
     * @uses Sales_Invoice::setPaidAmount()
     * @uses Sales_Invoice::setPayDate()
     * @uses Sales_Invoice::setPaymentTermId()
     * @uses Sales_Invoice::setPaymentTermName()
     * @uses Sales_Invoice::setPrintedDateTime()
     * @uses Sales_Invoice::setRefundDueAmount()
     * @uses Sales_Invoice::setRefundPaidAmount()
     * @uses Sales_Invoice::setRemainingAmount()
     * @uses Sales_Invoice::setRemark()
     * @uses Sales_Invoice::setTotalAmount()
     * @uses Sales_Invoice::setTotalAmountNeto()
     * @uses Sales_Invoice::setTotalInsideCommissionAmount()
     * @uses Sales_Invoice::setTotalInsuranceAmount()
     * @uses Sales_Invoice::setTotalTransactionCommissionAmount()
     * @uses Sales_Invoice::setTotalVatAmount()
     * @uses Sales_Invoice::setTransactionCommissions()
     * @param string $clientId
     * @param \patest\StructType\Money $coveredByReturnsAmount
     * @param int $creationAuditId
     * @param string $creationDateTime
     * @param \patest\StructType\Money $currentPaidAmount
     * @param string $documentType
     * @param int $globalNumber
     * @param bool $isFinal
     * @param bool $isFullDeducted
     * @param bool $isPrinted
     * @param \patest\StructType\RecordSetOfSales_InvoiceItemRecord $items
     * @param \patest\StructType\RecordSetOfSales_InvoiceItemsGroupRecord $itemsGroupRecords
     * @param \patest\StructType\Money $paidAmount
     * @param string $payDate
     * @param string $paymentTermId
     * @param \patest\StructType\GlobalString $paymentTermName
     * @param string $printedDateTime
     * @param \patest\StructType\Money $refundDueAmount
     * @param \patest\StructType\Money $refundPaidAmount
     * @param \patest\StructType\Money $remainingAmount
     * @param string $remark
     * @param \patest\StructType\Money $totalAmount
     * @param \patest\StructType\Money $totalAmountNeto
     * @param \patest\StructType\Money $totalInsideCommissionAmount
     * @param \patest\StructType\Money $totalInsuranceAmount
     * @param \patest\StructType\Money $totalTransactionCommissionAmount
     * @param \patest\StructType\Money $totalVatAmount
     * @param \patest\StructType\RecordSetOfSales_InvoiceTransactionCommission $transactionCommissions
     */
    public function __construct($clientId = null, \patest\StructType\Money $coveredByReturnsAmount = null, $creationAuditId = null, $creationDateTime = null, \patest\StructType\Money $currentPaidAmount = null, $documentType = null, $globalNumber = null, $isFinal = null, $isFullDeducted = null, $isPrinted = null, \patest\StructType\RecordSetOfSales_InvoiceItemRecord $items = null, \patest\StructType\RecordSetOfSales_InvoiceItemsGroupRecord $itemsGroupRecords = null, \patest\StructType\Money $paidAmount = null, $payDate = null, $paymentTermId = null, \patest\StructType\GlobalString $paymentTermName = null, $printedDateTime = null, \patest\StructType\Money $refundDueAmount = null, \patest\StructType\Money $refundPaidAmount = null, \patest\StructType\Money $remainingAmount = null, $remark = null, \patest\StructType\Money $totalAmount = null, \patest\StructType\Money $totalAmountNeto = null, \patest\StructType\Money $totalInsideCommissionAmount = null, \patest\StructType\Money $totalInsuranceAmount = null, \patest\StructType\Money $totalTransactionCommissionAmount = null, \patest\StructType\Money $totalVatAmount = null, \patest\StructType\RecordSetOfSales_InvoiceTransactionCommission $transactionCommissions = null)
    {
        $this
            ->setClientId($clientId)
            ->setCoveredByReturnsAmount($coveredByReturnsAmount)
            ->setCreationAuditId($creationAuditId)
            ->setCreationDateTime($creationDateTime)
            ->setCurrentPaidAmount($currentPaidAmount)
            ->setDocumentType($documentType)
            ->setGlobalNumber($globalNumber)
            ->setIsFinal($isFinal)
            ->setIsFullDeducted($isFullDeducted)
            ->setIsPrinted($isPrinted)
            ->setItems($items)
            ->setItemsGroupRecords($itemsGroupRecords)
            ->setPaidAmount($paidAmount)
            ->setPayDate($payDate)
            ->setPaymentTermId($paymentTermId)
            ->setPaymentTermName($paymentTermName)
            ->setPrintedDateTime($printedDateTime)
            ->setRefundDueAmount($refundDueAmount)
            ->setRefundPaidAmount($refundPaidAmount)
            ->setRemainingAmount($remainingAmount)
            ->setRemark($remark)
            ->setTotalAmount($totalAmount)
            ->setTotalAmountNeto($totalAmountNeto)
            ->setTotalInsideCommissionAmount($totalInsideCommissionAmount)
            ->setTotalInsuranceAmount($totalInsuranceAmount)
            ->setTotalTransactionCommissionAmount($totalTransactionCommissionAmount)
            ->setTotalVatAmount($totalVatAmount)
            ->setTransactionCommissions($transactionCommissions);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_Invoice
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CoveredByReturnsAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCoveredByReturnsAmount()
    {
        return isset($this->CoveredByReturnsAmount) ? $this->CoveredByReturnsAmount : null;
    }
    /**
     * Set CoveredByReturnsAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $coveredByReturnsAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setCoveredByReturnsAmount(\patest\StructType\Money $coveredByReturnsAmount = null)
    {
        if (is_null($coveredByReturnsAmount) || (is_array($coveredByReturnsAmount) && empty($coveredByReturnsAmount))) {
            unset($this->CoveredByReturnsAmount);
        } else {
            $this->CoveredByReturnsAmount = $coveredByReturnsAmount;
        }
        return $this;
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Sales_Invoice
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Sales_Invoice
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get CurrentPaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCurrentPaidAmount()
    {
        return isset($this->CurrentPaidAmount) ? $this->CurrentPaidAmount : null;
    }
    /**
     * Set CurrentPaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $currentPaidAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setCurrentPaidAmount(\patest\StructType\Money $currentPaidAmount = null)
    {
        if (is_null($currentPaidAmount) || (is_array($currentPaidAmount) && empty($currentPaidAmount))) {
            unset($this->CurrentPaidAmount);
        } else {
            $this->CurrentPaidAmount = $currentPaidAmount;
        }
        return $this;
    }
    /**
     * Get DocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentType()
    {
        return isset($this->DocumentType) ? $this->DocumentType : null;
    }
    /**
     * Set DocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccountingDocumentType::valueIsValid()
     * @uses \patest\EnumType\AccountingDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $documentType
     * @return \patest\StructType\Sales_Invoice
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccountingDocumentType::valueIsValid($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccountingDocumentType', is_array($documentType) ? implode(', ', $documentType) : var_export($documentType, true), implode(', ', \patest\EnumType\AccountingDocumentType::getValidValues())), __LINE__);
        }
        if (is_null($documentType) || (is_array($documentType) && empty($documentType))) {
            unset($this->DocumentType);
        } else {
            $this->DocumentType = $documentType;
        }
        return $this;
    }
    /**
     * Get GlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalNumber()
    {
        return isset($this->GlobalNumber) ? $this->GlobalNumber : null;
    }
    /**
     * Set GlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalNumber
     * @return \patest\StructType\Sales_Invoice
     */
    public function setGlobalNumber($globalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($globalNumber) && !(is_int($globalNumber) || ctype_digit($globalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalNumber, true), gettype($globalNumber)), __LINE__);
        }
        if (is_null($globalNumber) || (is_array($globalNumber) && empty($globalNumber))) {
            unset($this->GlobalNumber);
        } else {
            $this->GlobalNumber = $globalNumber;
        }
        return $this;
    }
    /**
     * Get IsFinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFinal()
    {
        return isset($this->IsFinal) ? $this->IsFinal : null;
    }
    /**
     * Set IsFinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFinal
     * @return \patest\StructType\Sales_Invoice
     */
    public function setIsFinal($isFinal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFinal) && !is_bool($isFinal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFinal, true), gettype($isFinal)), __LINE__);
        }
        if (is_null($isFinal) || (is_array($isFinal) && empty($isFinal))) {
            unset($this->IsFinal);
        } else {
            $this->IsFinal = $isFinal;
        }
        return $this;
    }
    /**
     * Get IsFullDeducted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFullDeducted()
    {
        return isset($this->IsFullDeducted) ? $this->IsFullDeducted : null;
    }
    /**
     * Set IsFullDeducted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFullDeducted
     * @return \patest\StructType\Sales_Invoice
     */
    public function setIsFullDeducted($isFullDeducted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFullDeducted) && !is_bool($isFullDeducted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFullDeducted, true), gettype($isFullDeducted)), __LINE__);
        }
        if (is_null($isFullDeducted) || (is_array($isFullDeducted) && empty($isFullDeducted))) {
            unset($this->IsFullDeducted);
        } else {
            $this->IsFullDeducted = $isFullDeducted;
        }
        return $this;
    }
    /**
     * Get IsPrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinted()
    {
        return isset($this->IsPrinted) ? $this->IsPrinted : null;
    }
    /**
     * Set IsPrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinted
     * @return \patest\StructType\Sales_Invoice
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        if (is_null($isPrinted) || (is_array($isPrinted) && empty($isPrinted))) {
            unset($this->IsPrinted);
        } else {
            $this->IsPrinted = $isPrinted;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_InvoiceItemRecord|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_InvoiceItemRecord $items
     * @return \patest\StructType\Sales_Invoice
     */
    public function setItems(\patest\StructType\RecordSetOfSales_InvoiceItemRecord $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get ItemsGroupRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_InvoiceItemsGroupRecord|null
     */
    public function getItemsGroupRecords()
    {
        return isset($this->ItemsGroupRecords) ? $this->ItemsGroupRecords : null;
    }
    /**
     * Set ItemsGroupRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_InvoiceItemsGroupRecord $itemsGroupRecords
     * @return \patest\StructType\Sales_Invoice
     */
    public function setItemsGroupRecords(\patest\StructType\RecordSetOfSales_InvoiceItemsGroupRecord $itemsGroupRecords = null)
    {
        if (is_null($itemsGroupRecords) || (is_array($itemsGroupRecords) && empty($itemsGroupRecords))) {
            unset($this->ItemsGroupRecords);
        } else {
            $this->ItemsGroupRecords = $itemsGroupRecords;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get PayDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayDate()
    {
        return isset($this->PayDate) ? $this->PayDate : null;
    }
    /**
     * Set PayDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payDate
     * @return \patest\StructType\Sales_Invoice
     */
    public function setPayDate($payDate = null)
    {
        // validation for constraint: string
        if (!is_null($payDate) && !is_string($payDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payDate, true), gettype($payDate)), __LINE__);
        }
        if (is_null($payDate) || (is_array($payDate) && empty($payDate))) {
            unset($this->PayDate);
        } else {
            $this->PayDate = $payDate;
        }
        return $this;
    }
    /**
     * Get PaymentTermId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTermId()
    {
        return isset($this->PaymentTermId) ? $this->PaymentTermId : null;
    }
    /**
     * Set PaymentTermId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTermId
     * @return \patest\StructType\Sales_Invoice
     */
    public function setPaymentTermId($paymentTermId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermId) && !is_string($paymentTermId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTermId, true), gettype($paymentTermId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTermId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTermId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTermId, true)), __LINE__);
        }
        if (is_null($paymentTermId) || (is_array($paymentTermId) && empty($paymentTermId))) {
            unset($this->PaymentTermId);
        } else {
            $this->PaymentTermId = $paymentTermId;
        }
        return $this;
    }
    /**
     * Get PaymentTermName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentTermName()
    {
        return isset($this->PaymentTermName) ? $this->PaymentTermName : null;
    }
    /**
     * Set PaymentTermName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentTermName
     * @return \patest\StructType\Sales_Invoice
     */
    public function setPaymentTermName(\patest\StructType\GlobalString $paymentTermName = null)
    {
        if (is_null($paymentTermName) || (is_array($paymentTermName) && empty($paymentTermName))) {
            unset($this->PaymentTermName);
        } else {
            $this->PaymentTermName = $paymentTermName;
        }
        return $this;
    }
    /**
     * Get PrintedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedDateTime()
    {
        return isset($this->PrintedDateTime) ? $this->PrintedDateTime : null;
    }
    /**
     * Set PrintedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedDateTime
     * @return \patest\StructType\Sales_Invoice
     */
    public function setPrintedDateTime($printedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($printedDateTime) && !is_string($printedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedDateTime, true), gettype($printedDateTime)), __LINE__);
        }
        if (is_null($printedDateTime) || (is_array($printedDateTime) && empty($printedDateTime))) {
            unset($this->PrintedDateTime);
        } else {
            $this->PrintedDateTime = $printedDateTime;
        }
        return $this;
    }
    /**
     * Get RefundDueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRefundDueAmount()
    {
        return isset($this->RefundDueAmount) ? $this->RefundDueAmount : null;
    }
    /**
     * Set RefundDueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $refundDueAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setRefundDueAmount(\patest\StructType\Money $refundDueAmount = null)
    {
        if (is_null($refundDueAmount) || (is_array($refundDueAmount) && empty($refundDueAmount))) {
            unset($this->RefundDueAmount);
        } else {
            $this->RefundDueAmount = $refundDueAmount;
        }
        return $this;
    }
    /**
     * Get RefundPaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRefundPaidAmount()
    {
        return isset($this->RefundPaidAmount) ? $this->RefundPaidAmount : null;
    }
    /**
     * Set RefundPaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $refundPaidAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setRefundPaidAmount(\patest\StructType\Money $refundPaidAmount = null)
    {
        if (is_null($refundPaidAmount) || (is_array($refundPaidAmount) && empty($refundPaidAmount))) {
            unset($this->RefundPaidAmount);
        } else {
            $this->RefundPaidAmount = $refundPaidAmount;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmount()
    {
        return isset($this->RemainingAmount) ? $this->RemainingAmount : null;
    }
    /**
     * Set RemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $remainingAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setRemainingAmount(\patest\StructType\Money $remainingAmount = null)
    {
        if (is_null($remainingAmount) || (is_array($remainingAmount) && empty($remainingAmount))) {
            unset($this->RemainingAmount);
        } else {
            $this->RemainingAmount = $remainingAmount;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\Sales_Invoice
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TotalAmountNeto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmountNeto()
    {
        return isset($this->TotalAmountNeto) ? $this->TotalAmountNeto : null;
    }
    /**
     * Set TotalAmountNeto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmountNeto
     * @return \patest\StructType\Sales_Invoice
     */
    public function setTotalAmountNeto(\patest\StructType\Money $totalAmountNeto = null)
    {
        if (is_null($totalAmountNeto) || (is_array($totalAmountNeto) && empty($totalAmountNeto))) {
            unset($this->TotalAmountNeto);
        } else {
            $this->TotalAmountNeto = $totalAmountNeto;
        }
        return $this;
    }
    /**
     * Get TotalInsideCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalInsideCommissionAmount()
    {
        return isset($this->TotalInsideCommissionAmount) ? $this->TotalInsideCommissionAmount : null;
    }
    /**
     * Set TotalInsideCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalInsideCommissionAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setTotalInsideCommissionAmount(\patest\StructType\Money $totalInsideCommissionAmount = null)
    {
        if (is_null($totalInsideCommissionAmount) || (is_array($totalInsideCommissionAmount) && empty($totalInsideCommissionAmount))) {
            unset($this->TotalInsideCommissionAmount);
        } else {
            $this->TotalInsideCommissionAmount = $totalInsideCommissionAmount;
        }
        return $this;
    }
    /**
     * Get TotalInsuranceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalInsuranceAmount()
    {
        return isset($this->TotalInsuranceAmount) ? $this->TotalInsuranceAmount : null;
    }
    /**
     * Set TotalInsuranceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalInsuranceAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setTotalInsuranceAmount(\patest\StructType\Money $totalInsuranceAmount = null)
    {
        if (is_null($totalInsuranceAmount) || (is_array($totalInsuranceAmount) && empty($totalInsuranceAmount))) {
            unset($this->TotalInsuranceAmount);
        } else {
            $this->TotalInsuranceAmount = $totalInsuranceAmount;
        }
        return $this;
    }
    /**
     * Get TotalTransactionCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTransactionCommissionAmount()
    {
        return isset($this->TotalTransactionCommissionAmount) ? $this->TotalTransactionCommissionAmount : null;
    }
    /**
     * Set TotalTransactionCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTransactionCommissionAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setTotalTransactionCommissionAmount(\patest\StructType\Money $totalTransactionCommissionAmount = null)
    {
        if (is_null($totalTransactionCommissionAmount) || (is_array($totalTransactionCommissionAmount) && empty($totalTransactionCommissionAmount))) {
            unset($this->TotalTransactionCommissionAmount);
        } else {
            $this->TotalTransactionCommissionAmount = $totalTransactionCommissionAmount;
        }
        return $this;
    }
    /**
     * Get TotalVatAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalVatAmount()
    {
        return isset($this->TotalVatAmount) ? $this->TotalVatAmount : null;
    }
    /**
     * Set TotalVatAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalVatAmount
     * @return \patest\StructType\Sales_Invoice
     */
    public function setTotalVatAmount(\patest\StructType\Money $totalVatAmount = null)
    {
        if (is_null($totalVatAmount) || (is_array($totalVatAmount) && empty($totalVatAmount))) {
            unset($this->TotalVatAmount);
        } else {
            $this->TotalVatAmount = $totalVatAmount;
        }
        return $this;
    }
    /**
     * Get TransactionCommissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_InvoiceTransactionCommission|null
     */
    public function getTransactionCommissions()
    {
        return isset($this->TransactionCommissions) ? $this->TransactionCommissions : null;
    }
    /**
     * Set TransactionCommissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_InvoiceTransactionCommission $transactionCommissions
     * @return \patest\StructType\Sales_Invoice
     */
    public function setTransactionCommissions(\patest\StructType\RecordSetOfSales_InvoiceTransactionCommission $transactionCommissions = null)
    {
        if (is_null($transactionCommissions) || (is_array($transactionCommissions) && empty($transactionCommissions))) {
            unset($this->TransactionCommissions);
        } else {
            $this->TransactionCommissions = $transactionCommissions;
        }
        return $this;
    }
}
