<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.GiftCardItemDetails StructType
 * @subpackage Structs
 */
class Sales_GiftCardItemDetails extends Sales_AbstractItemDetails
{
    /**
     * The CardLoadingName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardLoadingName;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * Constructor method for Sales.GiftCardItemDetails
     * @uses Sales_GiftCardItemDetails::setCardLoadingName()
     * @uses Sales_GiftCardItemDetails::setCardNumber()
     * @param string $cardLoadingName
     * @param string $cardNumber
     */
    public function __construct($cardLoadingName = null, $cardNumber = null)
    {
        $this
            ->setCardLoadingName($cardLoadingName)
            ->setCardNumber($cardNumber);
    }
    /**
     * Get CardLoadingName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardLoadingName()
    {
        return isset($this->CardLoadingName) ? $this->CardLoadingName : null;
    }
    /**
     * Set CardLoadingName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardLoadingName
     * @return \patest\StructType\Sales_GiftCardItemDetails
     */
    public function setCardLoadingName($cardLoadingName = null)
    {
        // validation for constraint: string
        if (!is_null($cardLoadingName) && !is_string($cardLoadingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardLoadingName, true), gettype($cardLoadingName)), __LINE__);
        }
        if (is_null($cardLoadingName) || (is_array($cardLoadingName) && empty($cardLoadingName))) {
            unset($this->CardLoadingName);
        } else {
            $this->CardLoadingName = $cardLoadingName;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\Sales_GiftCardItemDetails
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
}
